"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClusterSubnetGroup = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("aws-cdk-lib/aws-ec2");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_redshift_1 = require("aws-cdk-lib/aws-redshift");
/**
 * Class for creating a Redshift cluster subnet group
 *
 * @resource AWS::Redshift::ClusterSubnetGroup
 */
class ClusterSubnetGroup extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_redshift_alpha_ClusterSubnetGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const { subnetIds } = props.vpc.selectSubnets((_b = props.vpcSubnets) !== null && _b !== void 0 ? _b : { subnetType: ec2.SubnetType.PRIVATE_WITH_NAT });
        const subnetGroup = new aws_redshift_1.CfnClusterSubnetGroup(this, 'Default', {
            description: props.description,
            subnetIds,
        });
        subnetGroup.applyRemovalPolicy((_c = props.removalPolicy) !== null && _c !== void 0 ? _c : aws_cdk_lib_1.RemovalPolicy.RETAIN, {
            applyToUpdateReplacePolicy: true,
        });
        this.clusterSubnetGroupName = subnetGroup.ref;
    }
    /**
     * Imports an existing subnet group by name.
     */
    static fromClusterSubnetGroupName(scope, id, clusterSubnetGroupName) {
        return new class extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.clusterSubnetGroupName = clusterSubnetGroupName;
            }
        }(scope, id);
    }
}
exports.ClusterSubnetGroup = ClusterSubnetGroup;
_a = JSII_RTTI_SYMBOL_1;
ClusterSubnetGroup[_a] = { fqn: "@aws-cdk/aws-redshift-alpha.ClusterSubnetGroup", version: "2.26.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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