"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamicInput = exports.PipeVariable = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/** Reserved pipe variables
 * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-input-transformation.html#input-transform-reserved
 */
var PipeVariable;
(function (PipeVariable) {
    /**
     * The Amazon Resource Name (ARN) of the pipe.
     */
    PipeVariable["ARN"] = "<aws.pipes.pipe-arn>";
    /**
     * The name of the pipe.
     */
    PipeVariable["NAME"] = "<aws.pipes.pipe-name>";
    /**
     * The ARN of the event source of the pipe.
     */
    PipeVariable["SOURCE_ARN"] = "<aws.pipes.source-arn>";
    /**
     * The ARN of the enrichment of the pipe.
     */
    PipeVariable["ENRICHMENT_ARN"] = "<aws.pipes.enrichment-arn>";
    /**
     * The ARN of the target of the pipe.
     */
    PipeVariable["TARGET_ARN"] = "<aws.pipes.target-arn>";
    /**
     * The time at which the event was received by the input transformer. This is an ISO 8601 timestamp. This time is different for the enrichment input transformer and the target input transformer, depending on when the enrichment completed processing the event.
     */
    PipeVariable["EVENT_INGESTION_TIME"] = "<aws.pipes.event.ingestion-time>";
    /**
     * The event as received by the input transformer.
     */
    PipeVariable["EVENT"] = "<aws.pipes.event>";
    /**
     * The same as aws.pipes.event, but the variable only has a value if the original payload, either from the source or returned by the enrichment, is JSON. If the pipe has an encoded field, such as the Amazon SQS body field or the Kinesis data, those fields are decoded and turned into valid JSON. Because it isn't escaped, the variable can only be used as a value for a JSON field. For more information, see Implicit body data parsing.
     */
    PipeVariable["EVENT_JSON"] = "<aws.pipes.event.json>";
})(PipeVariable || (exports.PipeVariable = PipeVariable = {}));
/**
 * Dynamic variables that can be used in the input transformation.
 */
class DynamicInput {
    /**
     * Value from the event payload at jsonPath.
     */
    static fromEventPath(path) {
        if (!path.startsWith('$.')) {
            throw new Error('jsonPathExpression start with "$."');
        }
        return new DynamicInput(`<${path}>`);
    }
    /**
     * The Amazon Resource Name (ARN) of the pipe.
     */
    static get pipeArn() {
        return this.fromPipeVariable(PipeVariable.ARN);
    }
    /**
     * The name of the pipe.
     */
    static get pipeName() {
        return this.fromPipeVariable(PipeVariable.NAME);
    }
    /**
     * The ARN of the event source of the pipe.
     */
    static get sourceArn() {
        return this.fromPipeVariable(PipeVariable.SOURCE_ARN);
    }
    /**
     * The ARN of the enrichment of the pipe.
     */
    static get enrichmentArn() {
        return this.fromPipeVariable(PipeVariable.ENRICHMENT_ARN);
    }
    /**
     * The ARN of the target of the pipe.
     */
    static get targetArn() {
        return this.fromPipeVariable(PipeVariable.TARGET_ARN);
    }
    /**
     * The time at which the event was received by the input transformer. This is an ISO 8601 timestamp. This time is different for the enrichment input transformer and the target input transformer, depending on when the enrichment completed processing the event.
     */
    static get eventIngestionTime() {
        return this.fromPipeVariable(PipeVariable.EVENT_INGESTION_TIME);
    }
    /**
     * The event as received by the input transformer.
     */
    static get event() {
        return this.fromPipeVariable(PipeVariable.EVENT);
    }
    /**
     * The same as aws.pipes.event, but the variable only has a value if the original payload, either from the source or returned by the enrichment, is JSON. If the pipe has an encoded field, such as the Amazon SQS body field or the Kinesis data, those fields are decoded and turned into valid JSON. Because it isn't escaped, the variable can only be used as a value for a JSON field. For more information, see Implicit body data parsing.
     */
    static get eventJson() {
        return this.fromPipeVariable(PipeVariable.EVENT_JSON);
    }
    /**
     * Value from one of the provided Pipe variables.
     */
    static fromPipeVariable(variable) {
        return new DynamicInput(variable);
    }
    constructor(value) {
        this.value = value;
        this.displayHint = value.toString();
        this.creationStack = (0, aws_cdk_lib_1.captureStackTrace)();
        this.value = value;
    }
    resolve(_context) {
        return this.value;
    }
    /**
     * Return a string representation of a dynamic input.
     */
    toString() {
        return this.value.toString();
    }
    /**
     * Return a JSON representation of a dynamic input.
     */
    toJSON() {
        return this.value.toString();
    }
}
exports.DynamicInput = DynamicInput;
_a = JSII_RTTI_SYMBOL_1;
DynamicInput[_a] = { fqn: "@aws-cdk/aws-pipes-alpha.DynamicInput", version: "2.218.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGlwZVZhcmlhYmxlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsicGlwZVZhcmlhYmxlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNkNBQThFO0FBRTlFOztHQUVHO0FBQ0gsSUFBWSxZQWtDWDtBQWxDRCxXQUFZLFlBQVk7SUFDdEI7O09BRUc7SUFDSCw0Q0FBNEIsQ0FBQTtJQUM1Qjs7T0FFRztJQUNILDhDQUE4QixDQUFBO0lBQzlCOztPQUVHO0lBQ0gscURBQXFDLENBQUE7SUFDckM7O09BRUc7SUFDSCw2REFBNkMsQ0FBQTtJQUM3Qzs7T0FFRztJQUNILHFEQUFxQyxDQUFBO0lBQ3JDOztPQUVHO0lBQ0gseUVBQXlELENBQUE7SUFDekQ7O09BRUc7SUFDSCwyQ0FBMkIsQ0FBQTtJQUMzQjs7T0FFRztJQUNILHFEQUFxQyxDQUFBO0FBRXZDLENBQUMsRUFsQ1csWUFBWSw0QkFBWixZQUFZLFFBa0N2QjtBQUVEOztHQUVHO0FBQ0gsTUFBYSxZQUFZO0lBQ3ZCOztPQUVHO0lBQ0gsTUFBTSxDQUFDLGFBQWEsQ0FBQyxJQUFZO1FBQy9CLElBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUM7WUFDM0IsTUFBTSxJQUFJLEtBQUssQ0FBQyxvQ0FBb0MsQ0FBQyxDQUFDO1FBQ3hELENBQUM7UUFDRCxPQUFPLElBQUksWUFBWSxDQUFDLElBQUksSUFBSSxHQUFHLENBQUMsQ0FBQztLQUN0QztJQUVEOztPQUVHO0lBQ0ksTUFBTSxLQUFLLE9BQU87UUFDdkIsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsWUFBWSxDQUFDLEdBQUcsQ0FBQyxDQUFDO0tBQ2hEO0lBRUQ7O09BRUc7SUFDSSxNQUFNLEtBQUssUUFBUTtRQUN4QixPQUFPLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLENBQUM7S0FDakQ7SUFFRDs7T0FFRztJQUNJLE1BQU0sS0FBSyxTQUFTO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLGdCQUFnQixDQUFDLFlBQVksQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUN2RDtJQUVEOztPQUVHO0lBQ0ksTUFBTSxLQUFLLGFBQWE7UUFDN0IsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsWUFBWSxDQUFDLGNBQWMsQ0FBQyxDQUFDO0tBQzNEO0lBRUQ7O09BRUc7SUFDSSxNQUFNLEtBQUssU0FBUztRQUN6QixPQUFPLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxZQUFZLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDdkQ7SUFFRDs7T0FFRztJQUNJLE1BQU0sS0FBSyxrQkFBa0I7UUFDbEMsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsWUFBWSxDQUFDLG9CQUFvQixDQUFDLENBQUM7S0FDakU7SUFFRDs7T0FFRztJQUVJLE1BQU0sS0FBSyxLQUFLO1FBQ3JCLE9BQU8sSUFBSSxDQUFDLGdCQUFnQixDQUFDLFlBQVksQ0FBQyxLQUFLLENBQUMsQ0FBQztLQUNsRDtJQUVEOztPQUVHO0lBQ0ksTUFBTSxLQUFLLFNBQVM7UUFDekIsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsWUFBWSxDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQ3ZEO0lBRUQ7O09BRUc7SUFDSyxNQUFNLENBQUMsZ0JBQWdCLENBQUMsUUFBc0I7UUFDcEQsT0FBTyxJQUFJLFlBQVksQ0FBQyxRQUFRLENBQUMsQ0FBQztLQUNuQztJQVFELFlBQTRCLEtBQWE7UUFBYixVQUFLLEdBQUwsS0FBSyxDQUFRO1FBQ3ZDLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDLFFBQVEsRUFBRSxDQUFDO1FBQ3BDLElBQUksQ0FBQyxhQUFhLEdBQUcsSUFBQSwrQkFBaUIsR0FBRSxDQUFDO1FBQ3pDLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO0tBQ3BCO0lBRUQsT0FBTyxDQUFDLFFBQXlCO1FBQy9CLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztLQUNuQjtJQUVEOztPQUVHO0lBQ0gsUUFBUTtRQUNOLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQyxRQUFRLEVBQUUsQ0FBQztLQUM5QjtJQUVEOztPQUVHO0lBQ0gsTUFBTTtRQUNKLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQyxRQUFRLEVBQUUsQ0FBQztLQUM5Qjs7QUF2R0gsb0NBd0dDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSVJlc29sdmFibGUsIElSZXNvbHZlQ29udGV4dCwgY2FwdHVyZVN0YWNrVHJhY2UgfSBmcm9tICdhd3MtY2RrLWxpYic7XG5cbi8qKiBSZXNlcnZlZCBwaXBlIHZhcmlhYmxlc1xuICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZXZlbnRicmlkZ2UvbGF0ZXN0L3VzZXJndWlkZS9lYi1waXBlcy1pbnB1dC10cmFuc2Zvcm1hdGlvbi5odG1sI2lucHV0LXRyYW5zZm9ybS1yZXNlcnZlZFxuICovXG5leHBvcnQgZW51bSBQaXBlVmFyaWFibGUge1xuICAvKipcbiAgICogVGhlIEFtYXpvbiBSZXNvdXJjZSBOYW1lIChBUk4pIG9mIHRoZSBwaXBlLlxuICAgKi9cbiAgQVJOID0gJzxhd3MucGlwZXMucGlwZS1hcm4+JyxcbiAgLyoqXG4gICAqIFRoZSBuYW1lIG9mIHRoZSBwaXBlLlxuICAgKi9cbiAgTkFNRSA9ICc8YXdzLnBpcGVzLnBpcGUtbmFtZT4nLFxuICAvKipcbiAgICogVGhlIEFSTiBvZiB0aGUgZXZlbnQgc291cmNlIG9mIHRoZSBwaXBlLlxuICAgKi9cbiAgU09VUkNFX0FSTiA9ICc8YXdzLnBpcGVzLnNvdXJjZS1hcm4+JyxcbiAgLyoqXG4gICAqIFRoZSBBUk4gb2YgdGhlIGVucmljaG1lbnQgb2YgdGhlIHBpcGUuXG4gICAqL1xuICBFTlJJQ0hNRU5UX0FSTiA9ICc8YXdzLnBpcGVzLmVucmljaG1lbnQtYXJuPicsXG4gIC8qKlxuICAgKiBUaGUgQVJOIG9mIHRoZSB0YXJnZXQgb2YgdGhlIHBpcGUuXG4gICAqL1xuICBUQVJHRVRfQVJOID0gJzxhd3MucGlwZXMudGFyZ2V0LWFybj4nLFxuICAvKipcbiAgICogVGhlIHRpbWUgYXQgd2hpY2ggdGhlIGV2ZW50IHdhcyByZWNlaXZlZCBieSB0aGUgaW5wdXQgdHJhbnNmb3JtZXIuIFRoaXMgaXMgYW4gSVNPIDg2MDEgdGltZXN0YW1wLiBUaGlzIHRpbWUgaXMgZGlmZmVyZW50IGZvciB0aGUgZW5yaWNobWVudCBpbnB1dCB0cmFuc2Zvcm1lciBhbmQgdGhlIHRhcmdldCBpbnB1dCB0cmFuc2Zvcm1lciwgZGVwZW5kaW5nIG9uIHdoZW4gdGhlIGVucmljaG1lbnQgY29tcGxldGVkIHByb2Nlc3NpbmcgdGhlIGV2ZW50LlxuICAgKi9cbiAgRVZFTlRfSU5HRVNUSU9OX1RJTUUgPSAnPGF3cy5waXBlcy5ldmVudC5pbmdlc3Rpb24tdGltZT4nLFxuICAvKipcbiAgICogVGhlIGV2ZW50IGFzIHJlY2VpdmVkIGJ5IHRoZSBpbnB1dCB0cmFuc2Zvcm1lci5cbiAgICovXG4gIEVWRU5UID0gJzxhd3MucGlwZXMuZXZlbnQ+JyxcbiAgLyoqXG4gICAqIFRoZSBzYW1lIGFzIGF3cy5waXBlcy5ldmVudCwgYnV0IHRoZSB2YXJpYWJsZSBvbmx5IGhhcyBhIHZhbHVlIGlmIHRoZSBvcmlnaW5hbCBwYXlsb2FkLCBlaXRoZXIgZnJvbSB0aGUgc291cmNlIG9yIHJldHVybmVkIGJ5IHRoZSBlbnJpY2htZW50LCBpcyBKU09OLiBJZiB0aGUgcGlwZSBoYXMgYW4gZW5jb2RlZCBmaWVsZCwgc3VjaCBhcyB0aGUgQW1hem9uIFNRUyBib2R5IGZpZWxkIG9yIHRoZSBLaW5lc2lzIGRhdGEsIHRob3NlIGZpZWxkcyBhcmUgZGVjb2RlZCBhbmQgdHVybmVkIGludG8gdmFsaWQgSlNPTi4gQmVjYXVzZSBpdCBpc24ndCBlc2NhcGVkLCB0aGUgdmFyaWFibGUgY2FuIG9ubHkgYmUgdXNlZCBhcyBhIHZhbHVlIGZvciBhIEpTT04gZmllbGQuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgSW1wbGljaXQgYm9keSBkYXRhIHBhcnNpbmcuXG4gICAqL1xuICBFVkVOVF9KU09OID0gJzxhd3MucGlwZXMuZXZlbnQuanNvbj4nLFxuXG59XG5cbi8qKlxuICogRHluYW1pYyB2YXJpYWJsZXMgdGhhdCBjYW4gYmUgdXNlZCBpbiB0aGUgaW5wdXQgdHJhbnNmb3JtYXRpb24uXG4gKi9cbmV4cG9ydCBjbGFzcyBEeW5hbWljSW5wdXQgaW1wbGVtZW50cyBJUmVzb2x2YWJsZSB7XG4gIC8qKlxuICAgKiBWYWx1ZSBmcm9tIHRoZSBldmVudCBwYXlsb2FkIGF0IGpzb25QYXRoLlxuICAgKi9cbiAgc3RhdGljIGZyb21FdmVudFBhdGgocGF0aDogc3RyaW5nKTogRHluYW1pY0lucHV0IHtcbiAgICBpZiAoIXBhdGguc3RhcnRzV2l0aCgnJC4nKSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdqc29uUGF0aEV4cHJlc3Npb24gc3RhcnQgd2l0aCBcIiQuXCInKTtcbiAgICB9XG4gICAgcmV0dXJuIG5ldyBEeW5hbWljSW5wdXQoYDwke3BhdGh9PmApO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZSAoQVJOKSBvZiB0aGUgcGlwZS5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZ2V0IHBpcGVBcm4gKCk6IER5bmFtaWNJbnB1dCB7XG4gICAgcmV0dXJuIHRoaXMuZnJvbVBpcGVWYXJpYWJsZShQaXBlVmFyaWFibGUuQVJOKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBUaGUgbmFtZSBvZiB0aGUgcGlwZS5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZ2V0IHBpcGVOYW1lICgpOiBEeW5hbWljSW5wdXQge1xuICAgIHJldHVybiB0aGlzLmZyb21QaXBlVmFyaWFibGUoUGlwZVZhcmlhYmxlLk5BTUUpO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBBUk4gb2YgdGhlIGV2ZW50IHNvdXJjZSBvZiB0aGUgcGlwZS5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZ2V0IHNvdXJjZUFybiAoKTogRHluYW1pY0lucHV0IHtcbiAgICByZXR1cm4gdGhpcy5mcm9tUGlwZVZhcmlhYmxlKFBpcGVWYXJpYWJsZS5TT1VSQ0VfQVJOKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBUaGUgQVJOIG9mIHRoZSBlbnJpY2htZW50IG9mIHRoZSBwaXBlLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBnZXQgZW5yaWNobWVudEFybiAoKTogRHluYW1pY0lucHV0IHtcbiAgICByZXR1cm4gdGhpcy5mcm9tUGlwZVZhcmlhYmxlKFBpcGVWYXJpYWJsZS5FTlJJQ0hNRU5UX0FSTik7XG4gIH1cblxuICAvKipcbiAgICogVGhlIEFSTiBvZiB0aGUgdGFyZ2V0IG9mIHRoZSBwaXBlLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBnZXQgdGFyZ2V0QXJuICgpOiBEeW5hbWljSW5wdXQge1xuICAgIHJldHVybiB0aGlzLmZyb21QaXBlVmFyaWFibGUoUGlwZVZhcmlhYmxlLlRBUkdFVF9BUk4pO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSB0aW1lIGF0IHdoaWNoIHRoZSBldmVudCB3YXMgcmVjZWl2ZWQgYnkgdGhlIGlucHV0IHRyYW5zZm9ybWVyLiBUaGlzIGlzIGFuIElTTyA4NjAxIHRpbWVzdGFtcC4gVGhpcyB0aW1lIGlzIGRpZmZlcmVudCBmb3IgdGhlIGVucmljaG1lbnQgaW5wdXQgdHJhbnNmb3JtZXIgYW5kIHRoZSB0YXJnZXQgaW5wdXQgdHJhbnNmb3JtZXIsIGRlcGVuZGluZyBvbiB3aGVuIHRoZSBlbnJpY2htZW50IGNvbXBsZXRlZCBwcm9jZXNzaW5nIHRoZSBldmVudC5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZ2V0IGV2ZW50SW5nZXN0aW9uVGltZSAoKTogRHluYW1pY0lucHV0IHtcbiAgICByZXR1cm4gdGhpcy5mcm9tUGlwZVZhcmlhYmxlKFBpcGVWYXJpYWJsZS5FVkVOVF9JTkdFU1RJT05fVElNRSk7XG4gIH1cblxuICAvKipcbiAgICogVGhlIGV2ZW50IGFzIHJlY2VpdmVkIGJ5IHRoZSBpbnB1dCB0cmFuc2Zvcm1lci5cbiAgICovXG5cbiAgcHVibGljIHN0YXRpYyBnZXQgZXZlbnQgKCk6IER5bmFtaWNJbnB1dCB7XG4gICAgcmV0dXJuIHRoaXMuZnJvbVBpcGVWYXJpYWJsZShQaXBlVmFyaWFibGUuRVZFTlQpO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBzYW1lIGFzIGF3cy5waXBlcy5ldmVudCwgYnV0IHRoZSB2YXJpYWJsZSBvbmx5IGhhcyBhIHZhbHVlIGlmIHRoZSBvcmlnaW5hbCBwYXlsb2FkLCBlaXRoZXIgZnJvbSB0aGUgc291cmNlIG9yIHJldHVybmVkIGJ5IHRoZSBlbnJpY2htZW50LCBpcyBKU09OLiBJZiB0aGUgcGlwZSBoYXMgYW4gZW5jb2RlZCBmaWVsZCwgc3VjaCBhcyB0aGUgQW1hem9uIFNRUyBib2R5IGZpZWxkIG9yIHRoZSBLaW5lc2lzIGRhdGEsIHRob3NlIGZpZWxkcyBhcmUgZGVjb2RlZCBhbmQgdHVybmVkIGludG8gdmFsaWQgSlNPTi4gQmVjYXVzZSBpdCBpc24ndCBlc2NhcGVkLCB0aGUgdmFyaWFibGUgY2FuIG9ubHkgYmUgdXNlZCBhcyBhIHZhbHVlIGZvciBhIEpTT04gZmllbGQuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgSW1wbGljaXQgYm9keSBkYXRhIHBhcnNpbmcuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGdldCBldmVudEpzb24gKCk6IER5bmFtaWNJbnB1dCB7XG4gICAgcmV0dXJuIHRoaXMuZnJvbVBpcGVWYXJpYWJsZShQaXBlVmFyaWFibGUuRVZFTlRfSlNPTik7XG4gIH1cblxuICAvKipcbiAgICogVmFsdWUgZnJvbSBvbmUgb2YgdGhlIHByb3ZpZGVkIFBpcGUgdmFyaWFibGVzLlxuICAgKi9cbiAgcHJpdmF0ZSBzdGF0aWMgZnJvbVBpcGVWYXJpYWJsZSh2YXJpYWJsZTogUGlwZVZhcmlhYmxlKTogRHluYW1pY0lucHV0IHtcbiAgICByZXR1cm4gbmV3IER5bmFtaWNJbnB1dCh2YXJpYWJsZSk7XG4gIH1cblxuICAvKipcbiAgICogSHVtYW4gcmVhZGFibGUgZGlzcGxheSBoaW50IGFib3V0IHRoZSBldmVudCBwYXR0ZXJuXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgZGlzcGxheUhpbnQ6IHN0cmluZztcbiAgcHVibGljIHJlYWRvbmx5IGNyZWF0aW9uU3RhY2s6IHN0cmluZ1tdO1xuXG4gIHByaXZhdGUgY29uc3RydWN0b3IocHJpdmF0ZSB2YWx1ZSA6c3RyaW5nKSB7XG4gICAgdGhpcy5kaXNwbGF5SGludCA9IHZhbHVlLnRvU3RyaW5nKCk7XG4gICAgdGhpcy5jcmVhdGlvblN0YWNrID0gY2FwdHVyZVN0YWNrVHJhY2UoKTtcbiAgICB0aGlzLnZhbHVlID0gdmFsdWU7XG4gIH1cblxuICByZXNvbHZlKF9jb250ZXh0OiBJUmVzb2x2ZUNvbnRleHQpOiBhbnkge1xuICAgIHJldHVybiB0aGlzLnZhbHVlO1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybiBhIHN0cmluZyByZXByZXNlbnRhdGlvbiBvZiBhIGR5bmFtaWMgaW5wdXQuXG4gICAqL1xuICB0b1N0cmluZygpOiBzdHJpbmcge1xuICAgIHJldHVybiB0aGlzLnZhbHVlLnRvU3RyaW5nKCk7XG4gIH1cblxuICAvKipcbiAgICogUmV0dXJuIGEgSlNPTiByZXByZXNlbnRhdGlvbiBvZiBhIGR5bmFtaWMgaW5wdXQuXG4gICAqL1xuICB0b0pTT04oKTogc3RyaW5nIHtcbiAgICByZXR1cm4gdGhpcy52YWx1ZS50b1N0cmluZygpO1xuICB9XG59XG4iXX0=