"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Pipe = exports.DesiredState = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_pipes_1 = require("aws-cdk-lib/aws-pipes");
const metadata_resource_1 = require("aws-cdk-lib/core/lib/metadata-resource");
const prop_injectable_1 = require("aws-cdk-lib/core/lib/prop-injectable");
const logs_1 = require("./logs");
const source_1 = require("./source");
/**
 * The state the pipe should be in.
 */
var DesiredState;
(function (DesiredState) {
    /**
     * The pipe should be running.
     */
    DesiredState["RUNNING"] = "RUNNING";
    /**
     * The pipe should be stopped.
     * */
    DesiredState["STOPPED"] = "STOPPED";
})(DesiredState || (exports.DesiredState = DesiredState = {}));
class PipeBase extends aws_cdk_lib_1.Resource {
}
/**
 * An imported pipe.
 */
let ImportedPipe = class ImportedPipe extends PipeBase {
    constructor(scope, id, pipeName) {
        super(scope, id);
        // Enhanced CDK Analytics Telemetry
        (0, metadata_resource_1.addConstructMetadata)(this, { pipeName: pipeName });
        this.pipeName = pipeName;
        this.pipeArn = aws_cdk_lib_1.Stack.of(this).formatArn({
            service: 'pipes',
            partition: 'aws',
            resource: 'pipe',
            resourceName: this.pipeName,
        });
        this.pipeRole = aws_iam_1.Role.fromRoleName(this, 'Role', this.pipeName);
    }
};
/** Uniquely identifies this class. */
ImportedPipe.PROPERTY_INJECTION_ID = '@aws-cdk.aws-pipes-alpha.ImportedPipe';
ImportedPipe = __decorate([
    prop_injectable_1.propertyInjectable
], ImportedPipe);
/**
 * Amazon EventBridge Pipes connects sources to targets.
 *
 * Pipes are intended for point-to-point integrations between supported sources and targets,
 * with support for advanced transformations and enrichment.
 *
 * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html
 */
let Pipe = class Pipe extends PipeBase {
    /**
     * Creates a pipe from the name of a pipe.
     */
    static fromPipeName(scope, id, pipeName) {
        return new ImportedPipe(scope, id, pipeName);
    }
    constructor(scope, id, props) {
        super(scope, id, { physicalName: props.pipeName });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_pipes_alpha_PipeProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Pipe);
            }
            throw error;
        }
        // Enhanced CDK Analytics Telemetry
        (0, metadata_resource_1.addConstructMetadata)(this, props);
        /**
         * Role setup
         */
        this.pipeRole =
            props.role ||
                new aws_iam_1.Role(this, 'Role', {
                    assumedBy: new aws_iam_1.ServicePrincipal('pipes.amazonaws.com'),
                });
        /**
         * Source / Filter setup
         */
        const source = props.source.bind(this);
        props.source.grantRead(this.pipeRole);
        /**
         * An optional dead-letter queue stores any events that are not successfully delivered to
         * a target after all retry attempts are exhausted. The IAM role needs permission to write
         * events to the dead-letter queue, either an SQS queue or SNS topic.
         */
        if (source_1.SourceWithDeadLetterTarget.isSourceWithDeadLetterTarget(props.source)) {
            props.source.grantPush(this.pipeRole, props.source.deadLetterTarget);
        }
        // Add the filter criteria to the source parameters
        const sourceParameters = {
            ...source.sourceParameters,
            filterCriteria: props.filter,
        };
        /**
         * Enrichment setup
         */
        const enrichment = props.enrichment?.bind(this);
        props.enrichment?.grantInvoke(this.pipeRole);
        /**
         * Target setup
         */
        const target = props.target.bind(this);
        props.target.grantPush(this.pipeRole);
        /**
         * Logs setup
         */
        const initialLogConfiguration = {
            level: props.logLevel || logs_1.LogLevel.ERROR,
            includeExecutionData: props.logIncludeExecutionData || undefined,
        };
        // Iterate over all the log destinations and add them to the log configuration
        const logConfiguration = props.logDestinations?.reduce((currentLogConfiguration, destination) => {
            const logDestinationConfig = destination.bind(this);
            destination.grantPush(this.pipeRole);
            const additionalLogConfiguration = logDestinationConfig.parameters;
            return { ...currentLogConfiguration, ...additionalLogConfiguration };
        }, initialLogConfiguration);
        if (props.kmsKey) {
            if (!props.pipeName) {
                throw new aws_cdk_lib_1.ValidationError('`pipeName` is required when specifying a `kmsKey` prop.', this);
            }
            // Add permissions to the KMS key
            // see https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-encryption-pipes-cmkey.html#eb-encryption-key-policy-pipe
            props.kmsKey.addToResourcePolicy(new aws_iam_1.PolicyStatement({
                actions: ['kms:Decrypt', 'kms:DescribeKey', 'kms:GenerateDataKey'],
                resources: ['*'],
                principals: [new aws_iam_1.ArnPrincipal(this.pipeRole.roleArn)],
                conditions: {
                    'ArnLike': {
                        'kms:EncryptionContext:aws:pipe:arn': aws_cdk_lib_1.Stack.of(this).formatArn({
                            service: 'pipes',
                            resource: 'pipe',
                            resourceName: props.pipeName,
                        }),
                    },
                    'ForAnyValue:StringEquals': {
                        'kms:EncryptionContextKeys': [
                            'aws:pipe:arn',
                        ],
                    },
                },
            }));
        }
        /**
         * Pipe resource
         */
        const resource = new aws_pipes_1.CfnPipe(this, 'Resource', {
            name: props.pipeName,
            description: props.description,
            roleArn: this.pipeRole.roleArn,
            source: props.source.sourceArn,
            sourceParameters: sourceParameters,
            enrichment: props.enrichment?.enrichmentArn,
            enrichmentParameters: enrichment?.enrichmentParameters,
            target: props.target.targetArn,
            targetParameters: target.targetParameters,
            desiredState: props.desiredState,
            logConfiguration: logConfiguration,
            kmsKeyIdentifier: props.kmsKey?.keyArn,
            tags: props.tags,
        });
        this.pipeName = resource.ref;
        this.pipeArn = resource.attrArn;
    }
};
exports.Pipe = Pipe;
_a = JSII_RTTI_SYMBOL_1;
Pipe[_a] = { fqn: "@aws-cdk/aws-pipes-alpha.Pipe", version: "2.218.0-alpha.0" };
/** Uniquely identifies this class. */
Pipe.PROPERTY_INJECTION_ID = '@aws-cdk.aws-pipes-alpha.Pipe';
exports.Pipe = Pipe = __decorate([
    prop_injectable_1.propertyInjectable
], Pipe);
//# sourceMappingURL=data:application/json;base64,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