/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as api from '@aws-cdk/aws-apigateway';
import * as iam from '@aws-cdk/aws-iam';
import * as logs from '@aws-cdk/aws-logs';
import { Construct } from '@aws-cdk/core';
/**
 * The properties for the ApiGatewayIot class.
 */
export interface ApiGatewayToIotProps {
    /**
     * The AWS IoT endpoint subdomain to integrate the API Gateway with (e.g ab123cdefghij4l-ats). Added as AWS Subdomain to the Integration Request.
     *
     * @default - None.
     */
    readonly iotEndpoint: string;
    /**
     * Creates an api key and associates to usage plan if set to true.
     *
     * @default - false
     */
    readonly apiGatewayCreateApiKey?: boolean;
    /**
     * The IAM role that is used by API Gateway to publish messages to IoT topics and Thing shadows.
     *
     * @default - An IAM role with iot:Publish access to all topics (topic/*) and iot:UpdateThingShadow access to all things (thing/*) is created.
     */
    readonly apiGatewayExecutionRole?: iam.IRole;
    /**
     * Optional user-provided props to override the default props for the API.
     *
     * @default - Default props are used.
     */
    readonly apiGatewayProps?: api.RestApiProps;
    /**
     * User provided props to override the default props for the CloudWatchLogs LogGroup.
     *
     * @default - Default props are used
     */
    readonly logGroupProps?: logs.LogGroupProps;
}
/**
 * @summary The ApiGatewayIot class.
 */
export declare class ApiGatewayToIot extends Construct {
    readonly apiGateway: api.RestApi;
    readonly apiGatewayCloudWatchRole: iam.Role;
    readonly apiGatewayLogGroup: logs.LogGroup;
    readonly apiGatewayRole: iam.IRole;
    private readonly iotEndpoint;
    private readonly requestValidator;
    private readonly topicNestingLevel;
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of the ApiGatewayIot class.
     * @since 0.8.0
     * @access public
     */
    constructor(scope: Construct, id: string, props: ApiGatewayToIotProps);
    /**
     * Adds a method to specified resource
     * @param resource API Gateway resource to which this method is added
     * @param resourcePath path of resource from root
     * @param integReqParams request paramters for the Integration method
     * @param methodReqParams request parameters at Method level
     */
    private addResourceMethod;
}
