# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 10
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from isi_sdk_9_0_0.models.worm_domain import WormDomain  # noqa: F401,E501
from isi_sdk_9_0_0.models.worm_domain_exclusion import WormDomainExclusion  # noqa: F401,E501


class WormDomainExtended(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'autocommit_offset': 'int',
        'default_retention': 'str',
        'exclusions': 'list[WormDomainExclusion]',
        'max_retention': 'str',
        'min_retention': 'str',
        'override_date': 'int',
        'privileged_delete': 'str',
        'set_pending_delete': 'bool',
        'type': 'str',
        'id': 'int',
        'incomplete': 'bool',
        'lin': 'int',
        'max_modifies': 'int',
        'path': 'str',
        'total_modifies': 'int'
    }

    attribute_map = {
        'autocommit_offset': 'autocommit_offset',
        'default_retention': 'default_retention',
        'exclusions': 'exclusions',
        'max_retention': 'max_retention',
        'min_retention': 'min_retention',
        'override_date': 'override_date',
        'privileged_delete': 'privileged_delete',
        'set_pending_delete': 'set_pending_delete',
        'type': 'type',
        'id': 'id',
        'incomplete': 'incomplete',
        'lin': 'lin',
        'max_modifies': 'max_modifies',
        'path': 'path',
        'total_modifies': 'total_modifies'
    }

    def __init__(self, autocommit_offset=None, default_retention=None, exclusions=None, max_retention=None, min_retention=None, override_date=None, privileged_delete=None, set_pending_delete=None, type=None, id=None, incomplete=None, lin=None, max_modifies=None, path=None, total_modifies=None):  # noqa: E501
        """WormDomainExtended - a model defined in Swagger"""  # noqa: E501

        self._autocommit_offset = None
        self._default_retention = None
        self._exclusions = None
        self._max_retention = None
        self._min_retention = None
        self._override_date = None
        self._privileged_delete = None
        self._set_pending_delete = None
        self._type = None
        self._id = None
        self._incomplete = None
        self._lin = None
        self._max_modifies = None
        self._path = None
        self._total_modifies = None
        self.discriminator = None

        if autocommit_offset is not None:
            self.autocommit_offset = autocommit_offset
        if default_retention is not None:
            self.default_retention = default_retention
        self.exclusions = exclusions
        if max_retention is not None:
            self.max_retention = max_retention
        if min_retention is not None:
            self.min_retention = min_retention
        if override_date is not None:
            self.override_date = override_date
        self.privileged_delete = privileged_delete
        self.set_pending_delete = set_pending_delete
        self.type = type
        self.id = id
        self.incomplete = incomplete
        self.lin = lin
        self.max_modifies = max_modifies
        self.path = path
        self.total_modifies = total_modifies

    @property
    def autocommit_offset(self):
        """Gets the autocommit_offset of this WormDomainExtended.  # noqa: E501

        Specifies the autocommit time period for the domain in seconds.  After a file is in the domain without being modified for the specified time period, the file is automatically committed. If this parameter is set to null, there is no autocommit time, and files must be committed manually.  # noqa: E501

        :return: The autocommit_offset of this WormDomainExtended.  # noqa: E501
        :rtype: int
        """
        return self._autocommit_offset

    @autocommit_offset.setter
    def autocommit_offset(self, autocommit_offset):
        """Sets the autocommit_offset of this WormDomainExtended.

        Specifies the autocommit time period for the domain in seconds.  After a file is in the domain without being modified for the specified time period, the file is automatically committed. If this parameter is set to null, there is no autocommit time, and files must be committed manually.  # noqa: E501

        :param autocommit_offset: The autocommit_offset of this WormDomainExtended.  # noqa: E501
        :type: int
        """
        if autocommit_offset is not None and autocommit_offset > 9223372036854775807:  # noqa: E501
            raise ValueError("Invalid value for `autocommit_offset`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if autocommit_offset is not None and autocommit_offset < 0:  # noqa: E501
            raise ValueError("Invalid value for `autocommit_offset`, must be a value greater than or equal to `0`")  # noqa: E501

        self._autocommit_offset = autocommit_offset

    @property
    def default_retention(self):
        """Gets the default_retention of this WormDomainExtended.  # noqa: E501


        :return: The default_retention of this WormDomainExtended.  # noqa: E501
        :rtype: str
        """
        return self._default_retention

    @default_retention.setter
    def default_retention(self, default_retention):
        """Sets the default_retention of this WormDomainExtended.


        :param default_retention: The default_retention of this WormDomainExtended.  # noqa: E501
        :type: str
        """

        self._default_retention = default_retention

    @property
    def exclusions(self):
        """Gets the exclusions of this WormDomainExtended.  # noqa: E501

        A list of directories excluded from WORM protection. In a POST/PUT request this collection specifies the directories that the user wishes to create SmartLock exclusion directories on underneath this SmartLock directory. In a GET request this collection specifies all of the exclusion directories that exist underneath this SmartLock directory.  # noqa: E501

        :return: The exclusions of this WormDomainExtended.  # noqa: E501
        :rtype: list[WormDomainExclusion]
        """
        return self._exclusions

    @exclusions.setter
    def exclusions(self, exclusions):
        """Sets the exclusions of this WormDomainExtended.

        A list of directories excluded from WORM protection. In a POST/PUT request this collection specifies the directories that the user wishes to create SmartLock exclusion directories on underneath this SmartLock directory. In a GET request this collection specifies all of the exclusion directories that exist underneath this SmartLock directory.  # noqa: E501

        :param exclusions: The exclusions of this WormDomainExtended.  # noqa: E501
        :type: list[WormDomainExclusion]
        """
        if exclusions is None:
            raise ValueError("Invalid value for `exclusions`, must not be `None`")  # noqa: E501

        self._exclusions = exclusions

    @property
    def max_retention(self):
        """Gets the max_retention of this WormDomainExtended.  # noqa: E501


        :return: The max_retention of this WormDomainExtended.  # noqa: E501
        :rtype: str
        """
        return self._max_retention

    @max_retention.setter
    def max_retention(self, max_retention):
        """Sets the max_retention of this WormDomainExtended.


        :param max_retention: The max_retention of this WormDomainExtended.  # noqa: E501
        :type: str
        """

        self._max_retention = max_retention

    @property
    def min_retention(self):
        """Gets the min_retention of this WormDomainExtended.  # noqa: E501


        :return: The min_retention of this WormDomainExtended.  # noqa: E501
        :rtype: str
        """
        return self._min_retention

    @min_retention.setter
    def min_retention(self, min_retention):
        """Sets the min_retention of this WormDomainExtended.


        :param min_retention: The min_retention of this WormDomainExtended.  # noqa: E501
        :type: str
        """

        self._min_retention = min_retention

    @property
    def override_date(self):
        """Gets the override_date of this WormDomainExtended.  # noqa: E501

        Specifies the override retention date for the domain. If this date is later than the retention date for any committed file, the file will remain protected until the override retention date.  # noqa: E501

        :return: The override_date of this WormDomainExtended.  # noqa: E501
        :rtype: int
        """
        return self._override_date

    @override_date.setter
    def override_date(self, override_date):
        """Sets the override_date of this WormDomainExtended.

        Specifies the override retention date for the domain. If this date is later than the retention date for any committed file, the file will remain protected until the override retention date.  # noqa: E501

        :param override_date: The override_date of this WormDomainExtended.  # noqa: E501
        :type: int
        """
        if override_date is not None and override_date > 9223372036854775807:  # noqa: E501
            raise ValueError("Invalid value for `override_date`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if override_date is not None and override_date < 0:  # noqa: E501
            raise ValueError("Invalid value for `override_date`, must be a value greater than or equal to `0`")  # noqa: E501

        self._override_date = override_date

    @property
    def privileged_delete(self):
        """Gets the privileged_delete of this WormDomainExtended.  # noqa: E501

        When this value is set to 'on', files in this domain can be deleted through the privileged delete feature. If this value is set to 'disabled', privileged file deletes are permanently disabled and cannot be turned on again.  # noqa: E501

        :return: The privileged_delete of this WormDomainExtended.  # noqa: E501
        :rtype: str
        """
        return self._privileged_delete

    @privileged_delete.setter
    def privileged_delete(self, privileged_delete):
        """Sets the privileged_delete of this WormDomainExtended.

        When this value is set to 'on', files in this domain can be deleted through the privileged delete feature. If this value is set to 'disabled', privileged file deletes are permanently disabled and cannot be turned on again.  # noqa: E501

        :param privileged_delete: The privileged_delete of this WormDomainExtended.  # noqa: E501
        :type: str
        """
        if privileged_delete is None:
            raise ValueError("Invalid value for `privileged_delete`, must not be `None`")  # noqa: E501
        allowed_values = ["on", "off", "disabled"]  # noqa: E501
        if privileged_delete not in allowed_values:
            raise ValueError(
                "Invalid value for `privileged_delete` ({0}), must be one of {1}"  # noqa: E501
                .format(privileged_delete, allowed_values)
            )

        self._privileged_delete = privileged_delete

    @property
    def set_pending_delete(self):
        """Gets the set_pending_delete of this WormDomainExtended.  # noqa: E501

        If true, the domain is irreversibly marked for deletion. This is used for compliance domains and allows compliance store directories to be deleted, while disallowing the creation or committing of new/existing files.  # noqa: E501

        :return: The set_pending_delete of this WormDomainExtended.  # noqa: E501
        :rtype: bool
        """
        return self._set_pending_delete

    @set_pending_delete.setter
    def set_pending_delete(self, set_pending_delete):
        """Sets the set_pending_delete of this WormDomainExtended.

        If true, the domain is irreversibly marked for deletion. This is used for compliance domains and allows compliance store directories to be deleted, while disallowing the creation or committing of new/existing files.  # noqa: E501

        :param set_pending_delete: The set_pending_delete of this WormDomainExtended.  # noqa: E501
        :type: bool
        """
        if set_pending_delete is None:
            raise ValueError("Invalid value for `set_pending_delete`, must not be `None`")  # noqa: E501

        self._set_pending_delete = set_pending_delete

    @property
    def type(self):
        """Gets the type of this WormDomainExtended.  # noqa: E501

        Specifies whether the domain is an enterprise domain or a compliance domain. Compliance domains can not be created on enterprise clusters. Enterprise and compliance domains can be created on compliance clusters.  # noqa: E501

        :return: The type of this WormDomainExtended.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this WormDomainExtended.

        Specifies whether the domain is an enterprise domain or a compliance domain. Compliance domains can not be created on enterprise clusters. Enterprise and compliance domains can be created on compliance clusters.  # noqa: E501

        :param type: The type of this WormDomainExtended.  # noqa: E501
        :type: str
        """
        if type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501
        allowed_values = ["enterprise", "compliance", "compliance (legacy)"]  # noqa: E501
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def id(self):
        """Gets the id of this WormDomainExtended.  # noqa: E501

        Specifies the system-assigned ID for the protection domain.  # noqa: E501

        :return: The id of this WormDomainExtended.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this WormDomainExtended.

        Specifies the system-assigned ID for the protection domain.  # noqa: E501

        :param id: The id of this WormDomainExtended.  # noqa: E501
        :type: int
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501
        if id is not None and id > 9223372036854775807:  # noqa: E501
            raise ValueError("Invalid value for `id`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if id is not None and id < 0:  # noqa: E501
            raise ValueError("Invalid value for `id`, must be a value greater than or equal to `0`")  # noqa: E501

        self._id = id

    @property
    def incomplete(self):
        """Gets the incomplete of this WormDomainExtended.  # noqa: E501

        True if OneFS is still in the process of creating this domain and is unable to prevent files from being modified or deleted. If false, indicates that the domain is fully created and is able to prevent files from being modified or deleted.  # noqa: E501

        :return: The incomplete of this WormDomainExtended.  # noqa: E501
        :rtype: bool
        """
        return self._incomplete

    @incomplete.setter
    def incomplete(self, incomplete):
        """Sets the incomplete of this WormDomainExtended.

        True if OneFS is still in the process of creating this domain and is unable to prevent files from being modified or deleted. If false, indicates that the domain is fully created and is able to prevent files from being modified or deleted.  # noqa: E501

        :param incomplete: The incomplete of this WormDomainExtended.  # noqa: E501
        :type: bool
        """
        if incomplete is None:
            raise ValueError("Invalid value for `incomplete`, must not be `None`")  # noqa: E501

        self._incomplete = incomplete

    @property
    def lin(self):
        """Gets the lin of this WormDomainExtended.  # noqa: E501

        Specifies the logical inode number (LIN) for the root of this domain.  # noqa: E501

        :return: The lin of this WormDomainExtended.  # noqa: E501
        :rtype: int
        """
        return self._lin

    @lin.setter
    def lin(self, lin):
        """Sets the lin of this WormDomainExtended.

        Specifies the logical inode number (LIN) for the root of this domain.  # noqa: E501

        :param lin: The lin of this WormDomainExtended.  # noqa: E501
        :type: int
        """
        if lin is None:
            raise ValueError("Invalid value for `lin`, must not be `None`")  # noqa: E501
        if lin is not None and lin > 9223372036854775807:  # noqa: E501
            raise ValueError("Invalid value for `lin`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if lin is not None and lin < 0:  # noqa: E501
            raise ValueError("Invalid value for `lin`, must be a value greater than or equal to `0`")  # noqa: E501

        self._lin = lin

    @property
    def max_modifies(self):
        """Gets the max_modifies of this WormDomainExtended.  # noqa: E501

        Specifies the maximum amount of time, in seconds, that a file in this domain will be protected. This setting will override the retention period of any file committed with a longer retention period. If this parameter is set to null, an infinite length retention period is set.  # noqa: E501

        :return: The max_modifies of this WormDomainExtended.  # noqa: E501
        :rtype: int
        """
        return self._max_modifies

    @max_modifies.setter
    def max_modifies(self, max_modifies):
        """Sets the max_modifies of this WormDomainExtended.

        Specifies the maximum amount of time, in seconds, that a file in this domain will be protected. This setting will override the retention period of any file committed with a longer retention period. If this parameter is set to null, an infinite length retention period is set.  # noqa: E501

        :param max_modifies: The max_modifies of this WormDomainExtended.  # noqa: E501
        :type: int
        """
        if max_modifies is None:
            raise ValueError("Invalid value for `max_modifies`, must not be `None`")  # noqa: E501
        if max_modifies is not None and max_modifies > 9223372036854775807:  # noqa: E501
            raise ValueError("Invalid value for `max_modifies`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if max_modifies is not None and max_modifies < 0:  # noqa: E501
            raise ValueError("Invalid value for `max_modifies`, must be a value greater than or equal to `0`")  # noqa: E501

        self._max_modifies = max_modifies

    @property
    def path(self):
        """Gets the path of this WormDomainExtended.  # noqa: E501

        Specifies the root path of this domain. Files in this directory and all sub-directories will be protected.  # noqa: E501

        :return: The path of this WormDomainExtended.  # noqa: E501
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this WormDomainExtended.

        Specifies the root path of this domain. Files in this directory and all sub-directories will be protected.  # noqa: E501

        :param path: The path of this WormDomainExtended.  # noqa: E501
        :type: str
        """
        if path is None:
            raise ValueError("Invalid value for `path`, must not be `None`")  # noqa: E501
        if path is not None and len(path) > 4096:
            raise ValueError("Invalid value for `path`, length must be less than or equal to `4096`")  # noqa: E501
        if path is not None and len(path) < 1:
            raise ValueError("Invalid value for `path`, length must be greater than or equal to `1`")  # noqa: E501

        self._path = path

    @property
    def total_modifies(self):
        """Gets the total_modifies of this WormDomainExtended.  # noqa: E501

        Specifies the number of times this domain has been modified and the number of times the attributes for the domain have changed. A SmartLock domain can be modified a fixed number of times as defined by the 'max_modifies' parameter.  # noqa: E501

        :return: The total_modifies of this WormDomainExtended.  # noqa: E501
        :rtype: int
        """
        return self._total_modifies

    @total_modifies.setter
    def total_modifies(self, total_modifies):
        """Sets the total_modifies of this WormDomainExtended.

        Specifies the number of times this domain has been modified and the number of times the attributes for the domain have changed. A SmartLock domain can be modified a fixed number of times as defined by the 'max_modifies' parameter.  # noqa: E501

        :param total_modifies: The total_modifies of this WormDomainExtended.  # noqa: E501
        :type: int
        """
        if total_modifies is None:
            raise ValueError("Invalid value for `total_modifies`, must not be `None`")  # noqa: E501
        if total_modifies is not None and total_modifies > 9223372036854775807:  # noqa: E501
            raise ValueError("Invalid value for `total_modifies`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if total_modifies is not None and total_modifies < 0:  # noqa: E501
            raise ValueError("Invalid value for `total_modifies`, must be a value greater than or equal to `0`")  # noqa: E501

        self._total_modifies = total_modifies

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, WormDomainExtended):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
