# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 10
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from isi_sdk_9_0_0.models.sync_policy_source_network import SyncPolicySourceNetwork  # noqa: F401,E501


class ServicePolicyCreateParams(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'accelerated_failback': 'bool',
        'bandwidth_reservation': 'int',
        'check_integrity': 'bool',
        'description': 'str',
        'disable_file_split': 'bool',
        'disable_fofb': 'bool',
        'disable_quota_tmp_dir': 'bool',
        'enabled': 'bool',
        'encryption_cipher_list': 'str',
        'expected_dataloss': 'bool',
        'force_interface': 'bool',
        'linked_data_policies': 'list[str]',
        'log_level': 'str',
        'name': 'str',
        'ocsp_address': 'str',
        'ocsp_issuer_certificate_id': 'str',
        'password': 'str',
        'priority': 'int',
        'replicated_services': 'list[str]',
        'report_max_age': 'int',
        'report_max_count': 'int',
        'restrict_target_network': 'bool',
        'rpo_alert': 'int',
        'schedule': 'str',
        'service_history_max_age': 'int',
        'service_history_max_count': 'int',
        'skip_lookup': 'bool',
        'snapshot_sync_existing': 'bool',
        'snapshot_sync_pattern': 'str',
        'source_network': 'SyncPolicySourceNetwork',
        'source_snapshot_expiration': 'int',
        'source_snapshot_pattern': 'str',
        'target_certificate_id': 'str',
        'target_host': 'str',
        'target_snapshot_alias': 'str',
        'target_snapshot_expiration': 'int',
        'target_snapshot_pattern': 'str',
        'workers_per_node': 'int'
    }

    attribute_map = {
        'accelerated_failback': 'accelerated_failback',
        'bandwidth_reservation': 'bandwidth_reservation',
        'check_integrity': 'check_integrity',
        'description': 'description',
        'disable_file_split': 'disable_file_split',
        'disable_fofb': 'disable_fofb',
        'disable_quota_tmp_dir': 'disable_quota_tmp_dir',
        'enabled': 'enabled',
        'encryption_cipher_list': 'encryption_cipher_list',
        'expected_dataloss': 'expected_dataloss',
        'force_interface': 'force_interface',
        'linked_data_policies': 'linked_data_policies',
        'log_level': 'log_level',
        'name': 'name',
        'ocsp_address': 'ocsp_address',
        'ocsp_issuer_certificate_id': 'ocsp_issuer_certificate_id',
        'password': 'password',
        'priority': 'priority',
        'replicated_services': 'replicated_services',
        'report_max_age': 'report_max_age',
        'report_max_count': 'report_max_count',
        'restrict_target_network': 'restrict_target_network',
        'rpo_alert': 'rpo_alert',
        'schedule': 'schedule',
        'service_history_max_age': 'service_history_max_age',
        'service_history_max_count': 'service_history_max_count',
        'skip_lookup': 'skip_lookup',
        'snapshot_sync_existing': 'snapshot_sync_existing',
        'snapshot_sync_pattern': 'snapshot_sync_pattern',
        'source_network': 'source_network',
        'source_snapshot_expiration': 'source_snapshot_expiration',
        'source_snapshot_pattern': 'source_snapshot_pattern',
        'target_certificate_id': 'target_certificate_id',
        'target_host': 'target_host',
        'target_snapshot_alias': 'target_snapshot_alias',
        'target_snapshot_expiration': 'target_snapshot_expiration',
        'target_snapshot_pattern': 'target_snapshot_pattern',
        'workers_per_node': 'workers_per_node'
    }

    def __init__(self, accelerated_failback=None, bandwidth_reservation=None, check_integrity=None, description=None, disable_file_split=None, disable_fofb=None, disable_quota_tmp_dir=None, enabled=None, encryption_cipher_list=None, expected_dataloss=None, force_interface=None, linked_data_policies=None, log_level=None, name=None, ocsp_address=None, ocsp_issuer_certificate_id=None, password=None, priority=None, replicated_services=None, report_max_age=None, report_max_count=None, restrict_target_network=None, rpo_alert=None, schedule=None, service_history_max_age=None, service_history_max_count=None, skip_lookup=None, snapshot_sync_existing=None, snapshot_sync_pattern=None, source_network=None, source_snapshot_expiration=None, source_snapshot_pattern=None, target_certificate_id=None, target_host=None, target_snapshot_alias=None, target_snapshot_expiration=None, target_snapshot_pattern=None, workers_per_node=None):  # noqa: E501
        """ServicePolicyCreateParams - a model defined in Swagger"""  # noqa: E501

        self._accelerated_failback = None
        self._bandwidth_reservation = None
        self._check_integrity = None
        self._description = None
        self._disable_file_split = None
        self._disable_fofb = None
        self._disable_quota_tmp_dir = None
        self._enabled = None
        self._encryption_cipher_list = None
        self._expected_dataloss = None
        self._force_interface = None
        self._linked_data_policies = None
        self._log_level = None
        self._name = None
        self._ocsp_address = None
        self._ocsp_issuer_certificate_id = None
        self._password = None
        self._priority = None
        self._replicated_services = None
        self._report_max_age = None
        self._report_max_count = None
        self._restrict_target_network = None
        self._rpo_alert = None
        self._schedule = None
        self._service_history_max_age = None
        self._service_history_max_count = None
        self._skip_lookup = None
        self._snapshot_sync_existing = None
        self._snapshot_sync_pattern = None
        self._source_network = None
        self._source_snapshot_expiration = None
        self._source_snapshot_pattern = None
        self._target_certificate_id = None
        self._target_host = None
        self._target_snapshot_alias = None
        self._target_snapshot_expiration = None
        self._target_snapshot_pattern = None
        self._workers_per_node = None
        self.discriminator = None

        if accelerated_failback is not None:
            self.accelerated_failback = accelerated_failback
        if bandwidth_reservation is not None:
            self.bandwidth_reservation = bandwidth_reservation
        if check_integrity is not None:
            self.check_integrity = check_integrity
        if description is not None:
            self.description = description
        if disable_file_split is not None:
            self.disable_file_split = disable_file_split
        if disable_fofb is not None:
            self.disable_fofb = disable_fofb
        if disable_quota_tmp_dir is not None:
            self.disable_quota_tmp_dir = disable_quota_tmp_dir
        if enabled is not None:
            self.enabled = enabled
        if encryption_cipher_list is not None:
            self.encryption_cipher_list = encryption_cipher_list
        if expected_dataloss is not None:
            self.expected_dataloss = expected_dataloss
        if force_interface is not None:
            self.force_interface = force_interface
        if linked_data_policies is not None:
            self.linked_data_policies = linked_data_policies
        if log_level is not None:
            self.log_level = log_level
        self.name = name
        if ocsp_address is not None:
            self.ocsp_address = ocsp_address
        if ocsp_issuer_certificate_id is not None:
            self.ocsp_issuer_certificate_id = ocsp_issuer_certificate_id
        if password is not None:
            self.password = password
        if priority is not None:
            self.priority = priority
        if replicated_services is not None:
            self.replicated_services = replicated_services
        if report_max_age is not None:
            self.report_max_age = report_max_age
        if report_max_count is not None:
            self.report_max_count = report_max_count
        if restrict_target_network is not None:
            self.restrict_target_network = restrict_target_network
        if rpo_alert is not None:
            self.rpo_alert = rpo_alert
        if schedule is not None:
            self.schedule = schedule
        if service_history_max_age is not None:
            self.service_history_max_age = service_history_max_age
        if service_history_max_count is not None:
            self.service_history_max_count = service_history_max_count
        if skip_lookup is not None:
            self.skip_lookup = skip_lookup
        if snapshot_sync_existing is not None:
            self.snapshot_sync_existing = snapshot_sync_existing
        if snapshot_sync_pattern is not None:
            self.snapshot_sync_pattern = snapshot_sync_pattern
        if source_network is not None:
            self.source_network = source_network
        if source_snapshot_expiration is not None:
            self.source_snapshot_expiration = source_snapshot_expiration
        if source_snapshot_pattern is not None:
            self.source_snapshot_pattern = source_snapshot_pattern
        if target_certificate_id is not None:
            self.target_certificate_id = target_certificate_id
        self.target_host = target_host
        if target_snapshot_alias is not None:
            self.target_snapshot_alias = target_snapshot_alias
        if target_snapshot_expiration is not None:
            self.target_snapshot_expiration = target_snapshot_expiration
        if target_snapshot_pattern is not None:
            self.target_snapshot_pattern = target_snapshot_pattern
        if workers_per_node is not None:
            self.workers_per_node = workers_per_node

    @property
    def accelerated_failback(self):
        """Gets the accelerated_failback of this ServicePolicyCreateParams.  # noqa: E501

        If set to true, SyncIQ will perform failback configuration tasks during the next job run, rather than waiting to perform those tasks during the failback process. Performing these tasks ahead of time will increase the speed of failback operations.  # noqa: E501

        :return: The accelerated_failback of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: bool
        """
        return self._accelerated_failback

    @accelerated_failback.setter
    def accelerated_failback(self, accelerated_failback):
        """Sets the accelerated_failback of this ServicePolicyCreateParams.

        If set to true, SyncIQ will perform failback configuration tasks during the next job run, rather than waiting to perform those tasks during the failback process. Performing these tasks ahead of time will increase the speed of failback operations.  # noqa: E501

        :param accelerated_failback: The accelerated_failback of this ServicePolicyCreateParams.  # noqa: E501
        :type: bool
        """

        self._accelerated_failback = accelerated_failback

    @property
    def bandwidth_reservation(self):
        """Gets the bandwidth_reservation of this ServicePolicyCreateParams.  # noqa: E501

        The desired bandwidth reservation for this policy in kb/s. This feature will not activate unless a SyncIQ bandwidth rule is in effect.  # noqa: E501

        :return: The bandwidth_reservation of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: int
        """
        return self._bandwidth_reservation

    @bandwidth_reservation.setter
    def bandwidth_reservation(self, bandwidth_reservation):
        """Sets the bandwidth_reservation of this ServicePolicyCreateParams.

        The desired bandwidth reservation for this policy in kb/s. This feature will not activate unless a SyncIQ bandwidth rule is in effect.  # noqa: E501

        :param bandwidth_reservation: The bandwidth_reservation of this ServicePolicyCreateParams.  # noqa: E501
        :type: int
        """
        if bandwidth_reservation is not None and bandwidth_reservation > 9223372036854775807:  # noqa: E501
            raise ValueError("Invalid value for `bandwidth_reservation`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if bandwidth_reservation is not None and bandwidth_reservation < 0:  # noqa: E501
            raise ValueError("Invalid value for `bandwidth_reservation`, must be a value greater than or equal to `0`")  # noqa: E501

        self._bandwidth_reservation = bandwidth_reservation

    @property
    def check_integrity(self):
        """Gets the check_integrity of this ServicePolicyCreateParams.  # noqa: E501

        If true, the sync target performs cyclic redundancy checks (CRC) on the data as it is received.  # noqa: E501

        :return: The check_integrity of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: bool
        """
        return self._check_integrity

    @check_integrity.setter
    def check_integrity(self, check_integrity):
        """Sets the check_integrity of this ServicePolicyCreateParams.

        If true, the sync target performs cyclic redundancy checks (CRC) on the data as it is received.  # noqa: E501

        :param check_integrity: The check_integrity of this ServicePolicyCreateParams.  # noqa: E501
        :type: bool
        """

        self._check_integrity = check_integrity

    @property
    def description(self):
        """Gets the description of this ServicePolicyCreateParams.  # noqa: E501

        User-assigned description of this sync policy.  # noqa: E501

        :return: The description of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this ServicePolicyCreateParams.

        User-assigned description of this sync policy.  # noqa: E501

        :param description: The description of this ServicePolicyCreateParams.  # noqa: E501
        :type: str
        """
        if description is not None and len(description) > 255:
            raise ValueError("Invalid value for `description`, length must be less than or equal to `255`")  # noqa: E501
        if description is not None and len(description) < 0:
            raise ValueError("Invalid value for `description`, length must be greater than or equal to `0`")  # noqa: E501

        self._description = description

    @property
    def disable_file_split(self):
        """Gets the disable_file_split of this ServicePolicyCreateParams.  # noqa: E501

        NOTE: This field should not be changed without the help of PowerScale support.  If true, the 7.2+ file splitting capability will be disabled.  # noqa: E501

        :return: The disable_file_split of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: bool
        """
        return self._disable_file_split

    @disable_file_split.setter
    def disable_file_split(self, disable_file_split):
        """Sets the disable_file_split of this ServicePolicyCreateParams.

        NOTE: This field should not be changed without the help of PowerScale support.  If true, the 7.2+ file splitting capability will be disabled.  # noqa: E501

        :param disable_file_split: The disable_file_split of this ServicePolicyCreateParams.  # noqa: E501
        :type: bool
        """

        self._disable_file_split = disable_file_split

    @property
    def disable_fofb(self):
        """Gets the disable_fofb of this ServicePolicyCreateParams.  # noqa: E501

        NOTE: This field should not be changed without the help of PowerScale support.  Enable/disable sync failover/failback.  # noqa: E501

        :return: The disable_fofb of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: bool
        """
        return self._disable_fofb

    @disable_fofb.setter
    def disable_fofb(self, disable_fofb):
        """Sets the disable_fofb of this ServicePolicyCreateParams.

        NOTE: This field should not be changed without the help of PowerScale support.  Enable/disable sync failover/failback.  # noqa: E501

        :param disable_fofb: The disable_fofb of this ServicePolicyCreateParams.  # noqa: E501
        :type: bool
        """

        self._disable_fofb = disable_fofb

    @property
    def disable_quota_tmp_dir(self):
        """Gets the disable_quota_tmp_dir of this ServicePolicyCreateParams.  # noqa: E501

        If set to true, SyncIQ will not create temporary quota directories to aid in replication to target paths which contain quotas.  # noqa: E501

        :return: The disable_quota_tmp_dir of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: bool
        """
        return self._disable_quota_tmp_dir

    @disable_quota_tmp_dir.setter
    def disable_quota_tmp_dir(self, disable_quota_tmp_dir):
        """Sets the disable_quota_tmp_dir of this ServicePolicyCreateParams.

        If set to true, SyncIQ will not create temporary quota directories to aid in replication to target paths which contain quotas.  # noqa: E501

        :param disable_quota_tmp_dir: The disable_quota_tmp_dir of this ServicePolicyCreateParams.  # noqa: E501
        :type: bool
        """

        self._disable_quota_tmp_dir = disable_quota_tmp_dir

    @property
    def enabled(self):
        """Gets the enabled of this ServicePolicyCreateParams.  # noqa: E501

        If true, jobs will be automatically run based on this policy, according to its schedule.  # noqa: E501

        :return: The enabled of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """Sets the enabled of this ServicePolicyCreateParams.

        If true, jobs will be automatically run based on this policy, according to its schedule.  # noqa: E501

        :param enabled: The enabled of this ServicePolicyCreateParams.  # noqa: E501
        :type: bool
        """

        self._enabled = enabled

    @property
    def encryption_cipher_list(self):
        """Gets the encryption_cipher_list of this ServicePolicyCreateParams.  # noqa: E501

        The cipher list being used with encryption. For SyncIQ targets, this list serves as a list of supported ciphers. For SyncIQ sources, the list of ciphers will be attempted to be used in order.  # noqa: E501

        :return: The encryption_cipher_list of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._encryption_cipher_list

    @encryption_cipher_list.setter
    def encryption_cipher_list(self, encryption_cipher_list):
        """Sets the encryption_cipher_list of this ServicePolicyCreateParams.

        The cipher list being used with encryption. For SyncIQ targets, this list serves as a list of supported ciphers. For SyncIQ sources, the list of ciphers will be attempted to be used in order.  # noqa: E501

        :param encryption_cipher_list: The encryption_cipher_list of this ServicePolicyCreateParams.  # noqa: E501
        :type: str
        """
        if encryption_cipher_list is not None and len(encryption_cipher_list) > 255:
            raise ValueError("Invalid value for `encryption_cipher_list`, length must be less than or equal to `255`")  # noqa: E501
        if encryption_cipher_list is not None and len(encryption_cipher_list) < 0:
            raise ValueError("Invalid value for `encryption_cipher_list`, length must be greater than or equal to `0`")  # noqa: E501

        self._encryption_cipher_list = encryption_cipher_list

    @property
    def expected_dataloss(self):
        """Gets the expected_dataloss of this ServicePolicyCreateParams.  # noqa: E501

        NOTE: This field should not be changed without the help of PowerScale support.  Continue sending files even with the corrupted filesystem.  # noqa: E501

        :return: The expected_dataloss of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: bool
        """
        return self._expected_dataloss

    @expected_dataloss.setter
    def expected_dataloss(self, expected_dataloss):
        """Sets the expected_dataloss of this ServicePolicyCreateParams.

        NOTE: This field should not be changed without the help of PowerScale support.  Continue sending files even with the corrupted filesystem.  # noqa: E501

        :param expected_dataloss: The expected_dataloss of this ServicePolicyCreateParams.  # noqa: E501
        :type: bool
        """

        self._expected_dataloss = expected_dataloss

    @property
    def force_interface(self):
        """Gets the force_interface of this ServicePolicyCreateParams.  # noqa: E501

        NOTE: This field should not be changed without the help of PowerScale support.  Determines whether data is sent only through the subnet and pool specified in the \"source_network\" field. This option can be useful if there are multiple interfaces for the given source subnet.  If you enable this option, the net.inet.ip.choose_ifa_by_ipsrc sysctl should be set.  # noqa: E501

        :return: The force_interface of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: bool
        """
        return self._force_interface

    @force_interface.setter
    def force_interface(self, force_interface):
        """Sets the force_interface of this ServicePolicyCreateParams.

        NOTE: This field should not be changed without the help of PowerScale support.  Determines whether data is sent only through the subnet and pool specified in the \"source_network\" field. This option can be useful if there are multiple interfaces for the given source subnet.  If you enable this option, the net.inet.ip.choose_ifa_by_ipsrc sysctl should be set.  # noqa: E501

        :param force_interface: The force_interface of this ServicePolicyCreateParams.  # noqa: E501
        :type: bool
        """

        self._force_interface = force_interface

    @property
    def linked_data_policies(self):
        """Gets the linked_data_policies of this ServicePolicyCreateParams.  # noqa: E501

        A list of SyncIQ policy names/IDs whose source root directories will be used to filter service replication.  # noqa: E501

        :return: The linked_data_policies of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._linked_data_policies

    @linked_data_policies.setter
    def linked_data_policies(self, linked_data_policies):
        """Sets the linked_data_policies of this ServicePolicyCreateParams.

        A list of SyncIQ policy names/IDs whose source root directories will be used to filter service replication.  # noqa: E501

        :param linked_data_policies: The linked_data_policies of this ServicePolicyCreateParams.  # noqa: E501
        :type: list[str]
        """

        self._linked_data_policies = linked_data_policies

    @property
    def log_level(self):
        """Gets the log_level of this ServicePolicyCreateParams.  # noqa: E501

        Severity an event must reach before it is logged.  # noqa: E501

        :return: The log_level of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._log_level

    @log_level.setter
    def log_level(self, log_level):
        """Sets the log_level of this ServicePolicyCreateParams.

        Severity an event must reach before it is logged.  # noqa: E501

        :param log_level: The log_level of this ServicePolicyCreateParams.  # noqa: E501
        :type: str
        """
        allowed_values = ["fatal", "error", "notice", "info", "copy", "debug", "trace"]  # noqa: E501
        if log_level not in allowed_values:
            raise ValueError(
                "Invalid value for `log_level` ({0}), must be one of {1}"  # noqa: E501
                .format(log_level, allowed_values)
            )

        self._log_level = log_level

    @property
    def name(self):
        """Gets the name of this ServicePolicyCreateParams.  # noqa: E501

        User-assigned name of this sync policy.  # noqa: E501

        :return: The name of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ServicePolicyCreateParams.

        User-assigned name of this sync policy.  # noqa: E501

        :param name: The name of this ServicePolicyCreateParams.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if name is not None and len(name) > 255:
            raise ValueError("Invalid value for `name`, length must be less than or equal to `255`")  # noqa: E501
        if name is not None and len(name) < 1:
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501

        self._name = name

    @property
    def ocsp_address(self):
        """Gets the ocsp_address of this ServicePolicyCreateParams.  # noqa: E501

        The address of the OCSP responder to which to connect.  # noqa: E501

        :return: The ocsp_address of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._ocsp_address

    @ocsp_address.setter
    def ocsp_address(self, ocsp_address):
        """Sets the ocsp_address of this ServicePolicyCreateParams.

        The address of the OCSP responder to which to connect.  # noqa: E501

        :param ocsp_address: The ocsp_address of this ServicePolicyCreateParams.  # noqa: E501
        :type: str
        """
        if ocsp_address is not None and len(ocsp_address) > 255:
            raise ValueError("Invalid value for `ocsp_address`, length must be less than or equal to `255`")  # noqa: E501
        if ocsp_address is not None and len(ocsp_address) < 0:
            raise ValueError("Invalid value for `ocsp_address`, length must be greater than or equal to `0`")  # noqa: E501

        self._ocsp_address = ocsp_address

    @property
    def ocsp_issuer_certificate_id(self):
        """Gets the ocsp_issuer_certificate_id of this ServicePolicyCreateParams.  # noqa: E501

        The ID of the certificate authority that issued the certificate whose revocation status is being checked.  # noqa: E501

        :return: The ocsp_issuer_certificate_id of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._ocsp_issuer_certificate_id

    @ocsp_issuer_certificate_id.setter
    def ocsp_issuer_certificate_id(self, ocsp_issuer_certificate_id):
        """Sets the ocsp_issuer_certificate_id of this ServicePolicyCreateParams.

        The ID of the certificate authority that issued the certificate whose revocation status is being checked.  # noqa: E501

        :param ocsp_issuer_certificate_id: The ocsp_issuer_certificate_id of this ServicePolicyCreateParams.  # noqa: E501
        :type: str
        """
        if ocsp_issuer_certificate_id is not None and len(ocsp_issuer_certificate_id) > 255:
            raise ValueError("Invalid value for `ocsp_issuer_certificate_id`, length must be less than or equal to `255`")  # noqa: E501
        if ocsp_issuer_certificate_id is not None and len(ocsp_issuer_certificate_id) < 0:
            raise ValueError("Invalid value for `ocsp_issuer_certificate_id`, length must be greater than or equal to `0`")  # noqa: E501

        self._ocsp_issuer_certificate_id = ocsp_issuer_certificate_id

    @property
    def password(self):
        """Gets the password of this ServicePolicyCreateParams.  # noqa: E501

        The password for the target cluster.  This field is not readable.  # noqa: E501

        :return: The password of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """Sets the password of this ServicePolicyCreateParams.

        The password for the target cluster.  This field is not readable.  # noqa: E501

        :param password: The password of this ServicePolicyCreateParams.  # noqa: E501
        :type: str
        """
        if password is not None and len(password) > 255:
            raise ValueError("Invalid value for `password`, length must be less than or equal to `255`")  # noqa: E501
        if password is not None and len(password) < 1:
            raise ValueError("Invalid value for `password`, length must be greater than or equal to `1`")  # noqa: E501

        self._password = password

    @property
    def priority(self):
        """Gets the priority of this ServicePolicyCreateParams.  # noqa: E501

        Determines the priority level of a policy. Policies with higher priority will have precedence to run over lower priority policies. Valid range is [0, 1]. Default is 0.  # noqa: E501

        :return: The priority of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: int
        """
        return self._priority

    @priority.setter
    def priority(self, priority):
        """Sets the priority of this ServicePolicyCreateParams.

        Determines the priority level of a policy. Policies with higher priority will have precedence to run over lower priority policies. Valid range is [0, 1]. Default is 0.  # noqa: E501

        :param priority: The priority of this ServicePolicyCreateParams.  # noqa: E501
        :type: int
        """
        if priority is not None and priority > 1:  # noqa: E501
            raise ValueError("Invalid value for `priority`, must be a value less than or equal to `1`")  # noqa: E501
        if priority is not None and priority < 0:  # noqa: E501
            raise ValueError("Invalid value for `priority`, must be a value greater than or equal to `0`")  # noqa: E501

        self._priority = priority

    @property
    def replicated_services(self):
        """Gets the replicated_services of this ServicePolicyCreateParams.  # noqa: E501

        A list of services to replicate.  # noqa: E501

        :return: The replicated_services of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._replicated_services

    @replicated_services.setter
    def replicated_services(self, replicated_services):
        """Sets the replicated_services of this ServicePolicyCreateParams.

        A list of services to replicate.  # noqa: E501

        :param replicated_services: The replicated_services of this ServicePolicyCreateParams.  # noqa: E501
        :type: list[str]
        """
        allowed_values = ["quotas"]  # noqa: E501
        if not set(replicated_services).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `replicated_services` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(replicated_services) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._replicated_services = replicated_services

    @property
    def report_max_age(self):
        """Gets the report_max_age of this ServicePolicyCreateParams.  # noqa: E501

        Length of time (in seconds) a policy report will be stored.  # noqa: E501

        :return: The report_max_age of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: int
        """
        return self._report_max_age

    @report_max_age.setter
    def report_max_age(self, report_max_age):
        """Sets the report_max_age of this ServicePolicyCreateParams.

        Length of time (in seconds) a policy report will be stored.  # noqa: E501

        :param report_max_age: The report_max_age of this ServicePolicyCreateParams.  # noqa: E501
        :type: int
        """
        if report_max_age is not None and report_max_age > 9223372036854775807:  # noqa: E501
            raise ValueError("Invalid value for `report_max_age`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if report_max_age is not None and report_max_age < 0:  # noqa: E501
            raise ValueError("Invalid value for `report_max_age`, must be a value greater than or equal to `0`")  # noqa: E501

        self._report_max_age = report_max_age

    @property
    def report_max_count(self):
        """Gets the report_max_count of this ServicePolicyCreateParams.  # noqa: E501

        Maximum number of policy reports that will be stored on the system.  # noqa: E501

        :return: The report_max_count of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: int
        """
        return self._report_max_count

    @report_max_count.setter
    def report_max_count(self, report_max_count):
        """Sets the report_max_count of this ServicePolicyCreateParams.

        Maximum number of policy reports that will be stored on the system.  # noqa: E501

        :param report_max_count: The report_max_count of this ServicePolicyCreateParams.  # noqa: E501
        :type: int
        """
        if report_max_count is not None and report_max_count > 2000:  # noqa: E501
            raise ValueError("Invalid value for `report_max_count`, must be a value less than or equal to `2000`")  # noqa: E501
        if report_max_count is not None and report_max_count < 1:  # noqa: E501
            raise ValueError("Invalid value for `report_max_count`, must be a value greater than or equal to `1`")  # noqa: E501

        self._report_max_count = report_max_count

    @property
    def restrict_target_network(self):
        """Gets the restrict_target_network of this ServicePolicyCreateParams.  # noqa: E501

        If you specify true, and you specify a SmartConnect zone in the \"target_host\" field, replication policies will connect only to nodes in the specified SmartConnect zone.  If you specify false, replication policies are not restricted to specific nodes on the target cluster.  # noqa: E501

        :return: The restrict_target_network of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: bool
        """
        return self._restrict_target_network

    @restrict_target_network.setter
    def restrict_target_network(self, restrict_target_network):
        """Sets the restrict_target_network of this ServicePolicyCreateParams.

        If you specify true, and you specify a SmartConnect zone in the \"target_host\" field, replication policies will connect only to nodes in the specified SmartConnect zone.  If you specify false, replication policies are not restricted to specific nodes on the target cluster.  # noqa: E501

        :param restrict_target_network: The restrict_target_network of this ServicePolicyCreateParams.  # noqa: E501
        :type: bool
        """

        self._restrict_target_network = restrict_target_network

    @property
    def rpo_alert(self):
        """Gets the rpo_alert of this ServicePolicyCreateParams.  # noqa: E501

        If --schedule is set to a time/date, an alert is created if the specified RPO for this policy is exceeded. The default value is 0, which will not generate RPO alerts.  # noqa: E501

        :return: The rpo_alert of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: int
        """
        return self._rpo_alert

    @rpo_alert.setter
    def rpo_alert(self, rpo_alert):
        """Sets the rpo_alert of this ServicePolicyCreateParams.

        If --schedule is set to a time/date, an alert is created if the specified RPO for this policy is exceeded. The default value is 0, which will not generate RPO alerts.  # noqa: E501

        :param rpo_alert: The rpo_alert of this ServicePolicyCreateParams.  # noqa: E501
        :type: int
        """
        if rpo_alert is not None and rpo_alert > 9223372036854775807:  # noqa: E501
            raise ValueError("Invalid value for `rpo_alert`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if rpo_alert is not None and rpo_alert < 0:  # noqa: E501
            raise ValueError("Invalid value for `rpo_alert`, must be a value greater than or equal to `0`")  # noqa: E501

        self._rpo_alert = rpo_alert

    @property
    def schedule(self):
        """Gets the schedule of this ServicePolicyCreateParams.  # noqa: E501

        The schedule on which new jobs will be run for this policy.  # noqa: E501

        :return: The schedule of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._schedule

    @schedule.setter
    def schedule(self, schedule):
        """Sets the schedule of this ServicePolicyCreateParams.

        The schedule on which new jobs will be run for this policy.  # noqa: E501

        :param schedule: The schedule of this ServicePolicyCreateParams.  # noqa: E501
        :type: str
        """
        if schedule is not None and len(schedule) > 255:
            raise ValueError("Invalid value for `schedule`, length must be less than or equal to `255`")  # noqa: E501
        if schedule is not None and len(schedule) < 0:
            raise ValueError("Invalid value for `schedule`, length must be greater than or equal to `0`")  # noqa: E501

        self._schedule = schedule

    @property
    def service_history_max_age(self):
        """Gets the service_history_max_age of this ServicePolicyCreateParams.  # noqa: E501

        Maximum age of service information to maintain, in seconds.  # noqa: E501

        :return: The service_history_max_age of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: int
        """
        return self._service_history_max_age

    @service_history_max_age.setter
    def service_history_max_age(self, service_history_max_age):
        """Sets the service_history_max_age of this ServicePolicyCreateParams.

        Maximum age of service information to maintain, in seconds.  # noqa: E501

        :param service_history_max_age: The service_history_max_age of this ServicePolicyCreateParams.  # noqa: E501
        :type: int
        """
        if service_history_max_age is not None and service_history_max_age > 9223372036854775807:  # noqa: E501
            raise ValueError("Invalid value for `service_history_max_age`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if service_history_max_age is not None and service_history_max_age < 0:  # noqa: E501
            raise ValueError("Invalid value for `service_history_max_age`, must be a value greater than or equal to `0`")  # noqa: E501

        self._service_history_max_age = service_history_max_age

    @property
    def service_history_max_count(self):
        """Gets the service_history_max_count of this ServicePolicyCreateParams.  # noqa: E501

        Maximum number of historical service information records to maintain.  # noqa: E501

        :return: The service_history_max_count of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: int
        """
        return self._service_history_max_count

    @service_history_max_count.setter
    def service_history_max_count(self, service_history_max_count):
        """Sets the service_history_max_count of this ServicePolicyCreateParams.

        Maximum number of historical service information records to maintain.  # noqa: E501

        :param service_history_max_count: The service_history_max_count of this ServicePolicyCreateParams.  # noqa: E501
        :type: int
        """
        if service_history_max_count is not None and service_history_max_count > 2000:  # noqa: E501
            raise ValueError("Invalid value for `service_history_max_count`, must be a value less than or equal to `2000`")  # noqa: E501
        if service_history_max_count is not None and service_history_max_count < 1:  # noqa: E501
            raise ValueError("Invalid value for `service_history_max_count`, must be a value greater than or equal to `1`")  # noqa: E501

        self._service_history_max_count = service_history_max_count

    @property
    def skip_lookup(self):
        """Gets the skip_lookup of this ServicePolicyCreateParams.  # noqa: E501

        Skip DNS lookup of target IPs.  # noqa: E501

        :return: The skip_lookup of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: bool
        """
        return self._skip_lookup

    @skip_lookup.setter
    def skip_lookup(self, skip_lookup):
        """Sets the skip_lookup of this ServicePolicyCreateParams.

        Skip DNS lookup of target IPs.  # noqa: E501

        :param skip_lookup: The skip_lookup of this ServicePolicyCreateParams.  # noqa: E501
        :type: bool
        """

        self._skip_lookup = skip_lookup

    @property
    def snapshot_sync_existing(self):
        """Gets the snapshot_sync_existing of this ServicePolicyCreateParams.  # noqa: E501

        If true, snapshot-triggered syncs will include snapshots taken before policy creation time (requires --schedule when-snapshot-taken).  # noqa: E501

        :return: The snapshot_sync_existing of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: bool
        """
        return self._snapshot_sync_existing

    @snapshot_sync_existing.setter
    def snapshot_sync_existing(self, snapshot_sync_existing):
        """Sets the snapshot_sync_existing of this ServicePolicyCreateParams.

        If true, snapshot-triggered syncs will include snapshots taken before policy creation time (requires --schedule when-snapshot-taken).  # noqa: E501

        :param snapshot_sync_existing: The snapshot_sync_existing of this ServicePolicyCreateParams.  # noqa: E501
        :type: bool
        """

        self._snapshot_sync_existing = snapshot_sync_existing

    @property
    def snapshot_sync_pattern(self):
        """Gets the snapshot_sync_pattern of this ServicePolicyCreateParams.  # noqa: E501

        The naming pattern that a snapshot must match to trigger a sync when the schedule is when-snapshot-taken (default is \"*\").  # noqa: E501

        :return: The snapshot_sync_pattern of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._snapshot_sync_pattern

    @snapshot_sync_pattern.setter
    def snapshot_sync_pattern(self, snapshot_sync_pattern):
        """Sets the snapshot_sync_pattern of this ServicePolicyCreateParams.

        The naming pattern that a snapshot must match to trigger a sync when the schedule is when-snapshot-taken (default is \"*\").  # noqa: E501

        :param snapshot_sync_pattern: The snapshot_sync_pattern of this ServicePolicyCreateParams.  # noqa: E501
        :type: str
        """
        if snapshot_sync_pattern is not None and len(snapshot_sync_pattern) > 255:
            raise ValueError("Invalid value for `snapshot_sync_pattern`, length must be less than or equal to `255`")  # noqa: E501
        if snapshot_sync_pattern is not None and len(snapshot_sync_pattern) < 1:
            raise ValueError("Invalid value for `snapshot_sync_pattern`, length must be greater than or equal to `1`")  # noqa: E501

        self._snapshot_sync_pattern = snapshot_sync_pattern

    @property
    def source_network(self):
        """Gets the source_network of this ServicePolicyCreateParams.  # noqa: E501

        Restricts replication policies on the local cluster to running on the specified subnet and pool.  # noqa: E501

        :return: The source_network of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: SyncPolicySourceNetwork
        """
        return self._source_network

    @source_network.setter
    def source_network(self, source_network):
        """Sets the source_network of this ServicePolicyCreateParams.

        Restricts replication policies on the local cluster to running on the specified subnet and pool.  # noqa: E501

        :param source_network: The source_network of this ServicePolicyCreateParams.  # noqa: E501
        :type: SyncPolicySourceNetwork
        """

        self._source_network = source_network

    @property
    def source_snapshot_expiration(self):
        """Gets the source_snapshot_expiration of this ServicePolicyCreateParams.  # noqa: E501

        The length of time in seconds to keep snapshots on the source cluster.  # noqa: E501

        :return: The source_snapshot_expiration of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: int
        """
        return self._source_snapshot_expiration

    @source_snapshot_expiration.setter
    def source_snapshot_expiration(self, source_snapshot_expiration):
        """Sets the source_snapshot_expiration of this ServicePolicyCreateParams.

        The length of time in seconds to keep snapshots on the source cluster.  # noqa: E501

        :param source_snapshot_expiration: The source_snapshot_expiration of this ServicePolicyCreateParams.  # noqa: E501
        :type: int
        """
        if source_snapshot_expiration is not None and source_snapshot_expiration > 9223372036854775807:  # noqa: E501
            raise ValueError("Invalid value for `source_snapshot_expiration`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if source_snapshot_expiration is not None and source_snapshot_expiration < 0:  # noqa: E501
            raise ValueError("Invalid value for `source_snapshot_expiration`, must be a value greater than or equal to `0`")  # noqa: E501

        self._source_snapshot_expiration = source_snapshot_expiration

    @property
    def source_snapshot_pattern(self):
        """Gets the source_snapshot_pattern of this ServicePolicyCreateParams.  # noqa: E501

        The name pattern for snapshots taken on the source cluster before a sync.  # noqa: E501

        :return: The source_snapshot_pattern of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._source_snapshot_pattern

    @source_snapshot_pattern.setter
    def source_snapshot_pattern(self, source_snapshot_pattern):
        """Sets the source_snapshot_pattern of this ServicePolicyCreateParams.

        The name pattern for snapshots taken on the source cluster before a sync.  # noqa: E501

        :param source_snapshot_pattern: The source_snapshot_pattern of this ServicePolicyCreateParams.  # noqa: E501
        :type: str
        """
        if source_snapshot_pattern is not None and len(source_snapshot_pattern) > 255:
            raise ValueError("Invalid value for `source_snapshot_pattern`, length must be less than or equal to `255`")  # noqa: E501
        if source_snapshot_pattern is not None and len(source_snapshot_pattern) < 0:
            raise ValueError("Invalid value for `source_snapshot_pattern`, length must be greater than or equal to `0`")  # noqa: E501

        self._source_snapshot_pattern = source_snapshot_pattern

    @property
    def target_certificate_id(self):
        """Gets the target_certificate_id of this ServicePolicyCreateParams.  # noqa: E501

        The ID of the target cluster certificate being used for encryption.  # noqa: E501

        :return: The target_certificate_id of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._target_certificate_id

    @target_certificate_id.setter
    def target_certificate_id(self, target_certificate_id):
        """Sets the target_certificate_id of this ServicePolicyCreateParams.

        The ID of the target cluster certificate being used for encryption.  # noqa: E501

        :param target_certificate_id: The target_certificate_id of this ServicePolicyCreateParams.  # noqa: E501
        :type: str
        """
        if target_certificate_id is not None and len(target_certificate_id) > 255:
            raise ValueError("Invalid value for `target_certificate_id`, length must be less than or equal to `255`")  # noqa: E501
        if target_certificate_id is not None and len(target_certificate_id) < 0:
            raise ValueError("Invalid value for `target_certificate_id`, length must be greater than or equal to `0`")  # noqa: E501

        self._target_certificate_id = target_certificate_id

    @property
    def target_host(self):
        """Gets the target_host of this ServicePolicyCreateParams.  # noqa: E501

        Hostname or IP address of sync target cluster.  Modifying the target cluster host can result in the policy being unrunnable if the new target does not match the current target association.  # noqa: E501

        :return: The target_host of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._target_host

    @target_host.setter
    def target_host(self, target_host):
        """Sets the target_host of this ServicePolicyCreateParams.

        Hostname or IP address of sync target cluster.  Modifying the target cluster host can result in the policy being unrunnable if the new target does not match the current target association.  # noqa: E501

        :param target_host: The target_host of this ServicePolicyCreateParams.  # noqa: E501
        :type: str
        """
        if target_host is None:
            raise ValueError("Invalid value for `target_host`, must not be `None`")  # noqa: E501
        if target_host is not None and len(target_host) > 255:
            raise ValueError("Invalid value for `target_host`, length must be less than or equal to `255`")  # noqa: E501
        if target_host is not None and len(target_host) < 1:
            raise ValueError("Invalid value for `target_host`, length must be greater than or equal to `1`")  # noqa: E501

        self._target_host = target_host

    @property
    def target_snapshot_alias(self):
        """Gets the target_snapshot_alias of this ServicePolicyCreateParams.  # noqa: E501

        The alias of the snapshot taken on the target cluster after the sync completes. A value of @DEFAULT will reset this field to the default creation value.  # noqa: E501

        :return: The target_snapshot_alias of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._target_snapshot_alias

    @target_snapshot_alias.setter
    def target_snapshot_alias(self, target_snapshot_alias):
        """Sets the target_snapshot_alias of this ServicePolicyCreateParams.

        The alias of the snapshot taken on the target cluster after the sync completes. A value of @DEFAULT will reset this field to the default creation value.  # noqa: E501

        :param target_snapshot_alias: The target_snapshot_alias of this ServicePolicyCreateParams.  # noqa: E501
        :type: str
        """
        if target_snapshot_alias is not None and len(target_snapshot_alias) > 255:
            raise ValueError("Invalid value for `target_snapshot_alias`, length must be less than or equal to `255`")  # noqa: E501
        if target_snapshot_alias is not None and len(target_snapshot_alias) < 0:
            raise ValueError("Invalid value for `target_snapshot_alias`, length must be greater than or equal to `0`")  # noqa: E501

        self._target_snapshot_alias = target_snapshot_alias

    @property
    def target_snapshot_expiration(self):
        """Gets the target_snapshot_expiration of this ServicePolicyCreateParams.  # noqa: E501

        The length of time in seconds to keep snapshots on the target cluster.  # noqa: E501

        :return: The target_snapshot_expiration of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: int
        """
        return self._target_snapshot_expiration

    @target_snapshot_expiration.setter
    def target_snapshot_expiration(self, target_snapshot_expiration):
        """Sets the target_snapshot_expiration of this ServicePolicyCreateParams.

        The length of time in seconds to keep snapshots on the target cluster.  # noqa: E501

        :param target_snapshot_expiration: The target_snapshot_expiration of this ServicePolicyCreateParams.  # noqa: E501
        :type: int
        """
        if target_snapshot_expiration is not None and target_snapshot_expiration > 9223372036854775807:  # noqa: E501
            raise ValueError("Invalid value for `target_snapshot_expiration`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if target_snapshot_expiration is not None and target_snapshot_expiration < 0:  # noqa: E501
            raise ValueError("Invalid value for `target_snapshot_expiration`, must be a value greater than or equal to `0`")  # noqa: E501

        self._target_snapshot_expiration = target_snapshot_expiration

    @property
    def target_snapshot_pattern(self):
        """Gets the target_snapshot_pattern of this ServicePolicyCreateParams.  # noqa: E501

        The name pattern for snapshots taken on the target cluster after the sync completes.  A value of @DEFAULT will reset this field to the default creation value.  # noqa: E501

        :return: The target_snapshot_pattern of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._target_snapshot_pattern

    @target_snapshot_pattern.setter
    def target_snapshot_pattern(self, target_snapshot_pattern):
        """Sets the target_snapshot_pattern of this ServicePolicyCreateParams.

        The name pattern for snapshots taken on the target cluster after the sync completes.  A value of @DEFAULT will reset this field to the default creation value.  # noqa: E501

        :param target_snapshot_pattern: The target_snapshot_pattern of this ServicePolicyCreateParams.  # noqa: E501
        :type: str
        """
        if target_snapshot_pattern is not None and len(target_snapshot_pattern) > 255:
            raise ValueError("Invalid value for `target_snapshot_pattern`, length must be less than or equal to `255`")  # noqa: E501
        if target_snapshot_pattern is not None and len(target_snapshot_pattern) < 0:
            raise ValueError("Invalid value for `target_snapshot_pattern`, length must be greater than or equal to `0`")  # noqa: E501

        self._target_snapshot_pattern = target_snapshot_pattern

    @property
    def workers_per_node(self):
        """Gets the workers_per_node of this ServicePolicyCreateParams.  # noqa: E501

        The number of worker threads on a node performing a sync.  # noqa: E501

        :return: The workers_per_node of this ServicePolicyCreateParams.  # noqa: E501
        :rtype: int
        """
        return self._workers_per_node

    @workers_per_node.setter
    def workers_per_node(self, workers_per_node):
        """Sets the workers_per_node of this ServicePolicyCreateParams.

        The number of worker threads on a node performing a sync.  # noqa: E501

        :param workers_per_node: The workers_per_node of this ServicePolicyCreateParams.  # noqa: E501
        :type: int
        """
        if workers_per_node is not None and workers_per_node > 20:  # noqa: E501
            raise ValueError("Invalid value for `workers_per_node`, must be a value less than or equal to `20`")  # noqa: E501
        if workers_per_node is not None and workers_per_node < 1:  # noqa: E501
            raise ValueError("Invalid value for `workers_per_node`, must be a value greater than or equal to `1`")  # noqa: E501

        self._workers_per_node = workers_per_node

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ServicePolicyCreateParams):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
