# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 10
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from isi_sdk_9_0_0.models.auth_access_access_item_file_group import AuthAccessAccessItemFileGroup  # noqa: F401,E501
from isi_sdk_9_0_0.models.quota_quota_thresholds_extended import QuotaQuotaThresholdsExtended  # noqa: F401,E501
from isi_sdk_9_0_0.models.quota_quota_usage import QuotaQuotaUsage  # noqa: F401,E501


class QuotaQuotaExtended(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'container': 'bool',
        'efficiency_ratio': 'float',
        'enforced': 'bool',
        'id': 'str',
        'include_snapshots': 'bool',
        'linked': 'bool',
        'notifications': 'str',
        'path': 'str',
        'persona': 'AuthAccessAccessItemFileGroup',
        'ready': 'bool',
        'thresholds': 'QuotaQuotaThresholdsExtended',
        'thresholds_on': 'str',
        'type': 'str',
        'usage': 'QuotaQuotaUsage'
    }

    attribute_map = {
        'container': 'container',
        'efficiency_ratio': 'efficiency_ratio',
        'enforced': 'enforced',
        'id': 'id',
        'include_snapshots': 'include_snapshots',
        'linked': 'linked',
        'notifications': 'notifications',
        'path': 'path',
        'persona': 'persona',
        'ready': 'ready',
        'thresholds': 'thresholds',
        'thresholds_on': 'thresholds_on',
        'type': 'type',
        'usage': 'usage'
    }

    def __init__(self, container=None, efficiency_ratio=None, enforced=None, id=None, include_snapshots=None, linked=None, notifications=None, path=None, persona=None, ready=None, thresholds=None, thresholds_on=None, type=None, usage=None):  # noqa: E501
        """QuotaQuotaExtended - a model defined in Swagger"""  # noqa: E501

        self._container = None
        self._efficiency_ratio = None
        self._enforced = None
        self._id = None
        self._include_snapshots = None
        self._linked = None
        self._notifications = None
        self._path = None
        self._persona = None
        self._ready = None
        self._thresholds = None
        self._thresholds_on = None
        self._type = None
        self._usage = None
        self.discriminator = None

        self.container = container
        if efficiency_ratio is not None:
            self.efficiency_ratio = efficiency_ratio
        self.enforced = enforced
        self.id = id
        self.include_snapshots = include_snapshots
        if linked is not None:
            self.linked = linked
        self.notifications = notifications
        if path is not None:
            self.path = path
        if persona is not None:
            self.persona = persona
        self.ready = ready
        self.thresholds = thresholds
        if thresholds_on is not None:
            self.thresholds_on = thresholds_on
        self.type = type
        self.usage = usage

    @property
    def container(self):
        """Gets the container of this QuotaQuotaExtended.  # noqa: E501

        If true, SMB shares using the quota directory see the quota thresholds as share size.  # noqa: E501

        :return: The container of this QuotaQuotaExtended.  # noqa: E501
        :rtype: bool
        """
        return self._container

    @container.setter
    def container(self, container):
        """Sets the container of this QuotaQuotaExtended.

        If true, SMB shares using the quota directory see the quota thresholds as share size.  # noqa: E501

        :param container: The container of this QuotaQuotaExtended.  # noqa: E501
        :type: bool
        """
        if container is None:
            raise ValueError("Invalid value for `container`, must not be `None`")  # noqa: E501

        self._container = container

    @property
    def efficiency_ratio(self):
        """Gets the efficiency_ratio of this QuotaQuotaExtended.  # noqa: E501

        Represents the ratio of logical space provided to physical space used. This accounts for protection overhead, metadata, and compression ratios for the data.  # noqa: E501

        :return: The efficiency_ratio of this QuotaQuotaExtended.  # noqa: E501
        :rtype: float
        """
        return self._efficiency_ratio

    @efficiency_ratio.setter
    def efficiency_ratio(self, efficiency_ratio):
        """Sets the efficiency_ratio of this QuotaQuotaExtended.

        Represents the ratio of logical space provided to physical space used. This accounts for protection overhead, metadata, and compression ratios for the data.  # noqa: E501

        :param efficiency_ratio: The efficiency_ratio of this QuotaQuotaExtended.  # noqa: E501
        :type: float
        """
        if efficiency_ratio is not None and efficiency_ratio > 1.79769E+308:  # noqa: E501
            raise ValueError("Invalid value for `efficiency_ratio`, must be a value less than or equal to `1.79769E+308`")  # noqa: E501
        if efficiency_ratio is not None and efficiency_ratio < 0.0:  # noqa: E501
            raise ValueError("Invalid value for `efficiency_ratio`, must be a value greater than or equal to `0.0`")  # noqa: E501

        self._efficiency_ratio = efficiency_ratio

    @property
    def enforced(self):
        """Gets the enforced of this QuotaQuotaExtended.  # noqa: E501

        True if the quota provides enforcement, otherwise a accounting quota.  # noqa: E501

        :return: The enforced of this QuotaQuotaExtended.  # noqa: E501
        :rtype: bool
        """
        return self._enforced

    @enforced.setter
    def enforced(self, enforced):
        """Sets the enforced of this QuotaQuotaExtended.

        True if the quota provides enforcement, otherwise a accounting quota.  # noqa: E501

        :param enforced: The enforced of this QuotaQuotaExtended.  # noqa: E501
        :type: bool
        """
        if enforced is None:
            raise ValueError("Invalid value for `enforced`, must not be `None`")  # noqa: E501

        self._enforced = enforced

    @property
    def id(self):
        """Gets the id of this QuotaQuotaExtended.  # noqa: E501

        The system ID given to the quota.  # noqa: E501

        :return: The id of this QuotaQuotaExtended.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this QuotaQuotaExtended.

        The system ID given to the quota.  # noqa: E501

        :param id: The id of this QuotaQuotaExtended.  # noqa: E501
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501
        if id is not None and len(id) > 32:
            raise ValueError("Invalid value for `id`, length must be less than or equal to `32`")  # noqa: E501
        if id is not None and len(id) < 32:
            raise ValueError("Invalid value for `id`, length must be greater than or equal to `32`")  # noqa: E501

        self._id = id

    @property
    def include_snapshots(self):
        """Gets the include_snapshots of this QuotaQuotaExtended.  # noqa: E501

        If true, quota governs snapshot data as well as head data.  # noqa: E501

        :return: The include_snapshots of this QuotaQuotaExtended.  # noqa: E501
        :rtype: bool
        """
        return self._include_snapshots

    @include_snapshots.setter
    def include_snapshots(self, include_snapshots):
        """Sets the include_snapshots of this QuotaQuotaExtended.

        If true, quota governs snapshot data as well as head data.  # noqa: E501

        :param include_snapshots: The include_snapshots of this QuotaQuotaExtended.  # noqa: E501
        :type: bool
        """
        if include_snapshots is None:
            raise ValueError("Invalid value for `include_snapshots`, must not be `None`")  # noqa: E501

        self._include_snapshots = include_snapshots

    @property
    def linked(self):
        """Gets the linked of this QuotaQuotaExtended.  # noqa: E501

        For user, group and directory quotas, true if the quota is linked and controlled by a parent default-* quota. Linked quotas cannot be modified until they are unlinked.  # noqa: E501

        :return: The linked of this QuotaQuotaExtended.  # noqa: E501
        :rtype: bool
        """
        return self._linked

    @linked.setter
    def linked(self, linked):
        """Sets the linked of this QuotaQuotaExtended.

        For user, group and directory quotas, true if the quota is linked and controlled by a parent default-* quota. Linked quotas cannot be modified until they are unlinked.  # noqa: E501

        :param linked: The linked of this QuotaQuotaExtended.  # noqa: E501
        :type: bool
        """

        self._linked = linked

    @property
    def notifications(self):
        """Gets the notifications of this QuotaQuotaExtended.  # noqa: E501

        Summary of notifications: 'custom' indicates one or more notification rules available from the notifications sub-resource; 'default' indicates system default rules are used; 'disabled' indicates that no notifications will be used for this quota.; 'badmap' indicates that notification rule has problem in rule map.  # noqa: E501

        :return: The notifications of this QuotaQuotaExtended.  # noqa: E501
        :rtype: str
        """
        return self._notifications

    @notifications.setter
    def notifications(self, notifications):
        """Sets the notifications of this QuotaQuotaExtended.

        Summary of notifications: 'custom' indicates one or more notification rules available from the notifications sub-resource; 'default' indicates system default rules are used; 'disabled' indicates that no notifications will be used for this quota.; 'badmap' indicates that notification rule has problem in rule map.  # noqa: E501

        :param notifications: The notifications of this QuotaQuotaExtended.  # noqa: E501
        :type: str
        """
        if notifications is None:
            raise ValueError("Invalid value for `notifications`, must not be `None`")  # noqa: E501
        allowed_values = ["custom", "default", "disabled", "badmap"]  # noqa: E501
        if notifications not in allowed_values:
            raise ValueError(
                "Invalid value for `notifications` ({0}), must be one of {1}"  # noqa: E501
                .format(notifications, allowed_values)
            )

        self._notifications = notifications

    @property
    def path(self):
        """Gets the path of this QuotaQuotaExtended.  # noqa: E501


        :return: The path of this QuotaQuotaExtended.  # noqa: E501
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this QuotaQuotaExtended.


        :param path: The path of this QuotaQuotaExtended.  # noqa: E501
        :type: str
        """
        if path is not None and len(path) > 4096:
            raise ValueError("Invalid value for `path`, length must be less than or equal to `4096`")  # noqa: E501
        if path is not None and len(path) < 4:
            raise ValueError("Invalid value for `path`, length must be greater than or equal to `4`")  # noqa: E501
        if path is not None and not re.search('^\/ifs|^\/ifs\/.*', path):  # noqa: E501
            raise ValueError("Invalid value for `path`, must be a follow pattern or equal to `/^\/ifs|^\/ifs\/.*/`")  # noqa: E501

        self._path = path

    @property
    def persona(self):
        """Gets the persona of this QuotaQuotaExtended.  # noqa: E501

        Specifies properties for a persona, which consists of either a 'type' and a 'name' or an 'ID'.  # noqa: E501

        :return: The persona of this QuotaQuotaExtended.  # noqa: E501
        :rtype: AuthAccessAccessItemFileGroup
        """
        return self._persona

    @persona.setter
    def persona(self, persona):
        """Sets the persona of this QuotaQuotaExtended.

        Specifies properties for a persona, which consists of either a 'type' and a 'name' or an 'ID'.  # noqa: E501

        :param persona: The persona of this QuotaQuotaExtended.  # noqa: E501
        :type: AuthAccessAccessItemFileGroup
        """

        self._persona = persona

    @property
    def ready(self):
        """Gets the ready of this QuotaQuotaExtended.  # noqa: E501

        True if the default resource accounting is accurate on the quota. If false, this quota is waiting on completion of a QuotaScan job.  # noqa: E501

        :return: The ready of this QuotaQuotaExtended.  # noqa: E501
        :rtype: bool
        """
        return self._ready

    @ready.setter
    def ready(self, ready):
        """Sets the ready of this QuotaQuotaExtended.

        True if the default resource accounting is accurate on the quota. If false, this quota is waiting on completion of a QuotaScan job.  # noqa: E501

        :param ready: The ready of this QuotaQuotaExtended.  # noqa: E501
        :type: bool
        """
        if ready is None:
            raise ValueError("Invalid value for `ready`, must not be `None`")  # noqa: E501

        self._ready = ready

    @property
    def thresholds(self):
        """Gets the thresholds of this QuotaQuotaExtended.  # noqa: E501

          # noqa: E501

        :return: The thresholds of this QuotaQuotaExtended.  # noqa: E501
        :rtype: QuotaQuotaThresholdsExtended
        """
        return self._thresholds

    @thresholds.setter
    def thresholds(self, thresholds):
        """Sets the thresholds of this QuotaQuotaExtended.

          # noqa: E501

        :param thresholds: The thresholds of this QuotaQuotaExtended.  # noqa: E501
        :type: QuotaQuotaThresholdsExtended
        """
        if thresholds is None:
            raise ValueError("Invalid value for `thresholds`, must not be `None`")  # noqa: E501

        self._thresholds = thresholds

    @property
    def thresholds_on(self):
        """Gets the thresholds_on of this QuotaQuotaExtended.  # noqa: E501

        Thresholds apply on quota accounting metric.  # noqa: E501

        :return: The thresholds_on of this QuotaQuotaExtended.  # noqa: E501
        :rtype: str
        """
        return self._thresholds_on

    @thresholds_on.setter
    def thresholds_on(self, thresholds_on):
        """Sets the thresholds_on of this QuotaQuotaExtended.

        Thresholds apply on quota accounting metric.  # noqa: E501

        :param thresholds_on: The thresholds_on of this QuotaQuotaExtended.  # noqa: E501
        :type: str
        """
        allowed_values = ["applogicalsize", "fslogicalsize", "physicalsize"]  # noqa: E501
        if thresholds_on not in allowed_values:
            raise ValueError(
                "Invalid value for `thresholds_on` ({0}), must be one of {1}"  # noqa: E501
                .format(thresholds_on, allowed_values)
            )

        self._thresholds_on = thresholds_on

    @property
    def type(self):
        """Gets the type of this QuotaQuotaExtended.  # noqa: E501

        The type of quota.  # noqa: E501

        :return: The type of this QuotaQuotaExtended.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this QuotaQuotaExtended.

        The type of quota.  # noqa: E501

        :param type: The type of this QuotaQuotaExtended.  # noqa: E501
        :type: str
        """
        if type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501
        allowed_values = ["directory", "user", "group", "default-directory", "default-user", "default-group"]  # noqa: E501
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def usage(self):
        """Gets the usage of this QuotaQuotaExtended.  # noqa: E501

          # noqa: E501

        :return: The usage of this QuotaQuotaExtended.  # noqa: E501
        :rtype: QuotaQuotaUsage
        """
        return self._usage

    @usage.setter
    def usage(self, usage):
        """Sets the usage of this QuotaQuotaExtended.

          # noqa: E501

        :param usage: The usage of this QuotaQuotaExtended.  # noqa: E501
        :type: QuotaQuotaUsage
        """
        if usage is None:
            raise ValueError("Invalid value for `usage`, must not be `None`")  # noqa: E501

        self._usage = usage

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QuotaQuotaExtended):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
