# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 10
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from isi_sdk_9_0_0.models.nfs_settings_export_settings_map_all import NfsSettingsExportSettingsMapAll  # noqa: F401,E501


class NfsSettingsExportSettings(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'all_dirs': 'bool',
        'block_size': 'int',
        'can_set_time': 'bool',
        'case_insensitive': 'bool',
        'case_preserving': 'bool',
        'chown_restricted': 'bool',
        'commit_asynchronous': 'bool',
        'directory_transfer_size': 'int',
        'encoding': 'str',
        'link_max': 'int',
        'map_all': 'NfsSettingsExportSettingsMapAll',
        'map_failure': 'NfsSettingsExportSettingsMapAll',
        'map_full': 'bool',
        'map_lookup_uid': 'bool',
        'map_non_root': 'NfsSettingsExportSettingsMapAll',
        'map_retry': 'bool',
        'map_root': 'NfsSettingsExportSettingsMapAll',
        'max_file_size': 'int',
        'name_max_size': 'int',
        'no_truncate': 'bool',
        'read_only': 'bool',
        'read_transfer_max_size': 'int',
        'read_transfer_multiple': 'int',
        'read_transfer_size': 'int',
        'readdirplus': 'bool',
        'readdirplus_prefetch': 'int',
        'return_32bit_file_ids': 'bool',
        'security_flavors': 'list[str]',
        'setattr_asynchronous': 'bool',
        'snapshot': 'str',
        'symlinks': 'bool',
        'time_delta': 'float',
        'write_datasync_action': 'str',
        'write_datasync_reply': 'str',
        'write_filesync_action': 'str',
        'write_filesync_reply': 'str',
        'write_transfer_max_size': 'int',
        'write_transfer_multiple': 'int',
        'write_transfer_size': 'int',
        'write_unstable_action': 'str',
        'write_unstable_reply': 'str',
        'zone': 'str'
    }

    attribute_map = {
        'all_dirs': 'all_dirs',
        'block_size': 'block_size',
        'can_set_time': 'can_set_time',
        'case_insensitive': 'case_insensitive',
        'case_preserving': 'case_preserving',
        'chown_restricted': 'chown_restricted',
        'commit_asynchronous': 'commit_asynchronous',
        'directory_transfer_size': 'directory_transfer_size',
        'encoding': 'encoding',
        'link_max': 'link_max',
        'map_all': 'map_all',
        'map_failure': 'map_failure',
        'map_full': 'map_full',
        'map_lookup_uid': 'map_lookup_uid',
        'map_non_root': 'map_non_root',
        'map_retry': 'map_retry',
        'map_root': 'map_root',
        'max_file_size': 'max_file_size',
        'name_max_size': 'name_max_size',
        'no_truncate': 'no_truncate',
        'read_only': 'read_only',
        'read_transfer_max_size': 'read_transfer_max_size',
        'read_transfer_multiple': 'read_transfer_multiple',
        'read_transfer_size': 'read_transfer_size',
        'readdirplus': 'readdirplus',
        'readdirplus_prefetch': 'readdirplus_prefetch',
        'return_32bit_file_ids': 'return_32bit_file_ids',
        'security_flavors': 'security_flavors',
        'setattr_asynchronous': 'setattr_asynchronous',
        'snapshot': 'snapshot',
        'symlinks': 'symlinks',
        'time_delta': 'time_delta',
        'write_datasync_action': 'write_datasync_action',
        'write_datasync_reply': 'write_datasync_reply',
        'write_filesync_action': 'write_filesync_action',
        'write_filesync_reply': 'write_filesync_reply',
        'write_transfer_max_size': 'write_transfer_max_size',
        'write_transfer_multiple': 'write_transfer_multiple',
        'write_transfer_size': 'write_transfer_size',
        'write_unstable_action': 'write_unstable_action',
        'write_unstable_reply': 'write_unstable_reply',
        'zone': 'zone'
    }

    def __init__(self, all_dirs=None, block_size=None, can_set_time=None, case_insensitive=None, case_preserving=None, chown_restricted=None, commit_asynchronous=None, directory_transfer_size=None, encoding=None, link_max=None, map_all=None, map_failure=None, map_full=None, map_lookup_uid=None, map_non_root=None, map_retry=None, map_root=None, max_file_size=None, name_max_size=None, no_truncate=None, read_only=None, read_transfer_max_size=None, read_transfer_multiple=None, read_transfer_size=None, readdirplus=None, readdirplus_prefetch=None, return_32bit_file_ids=None, security_flavors=None, setattr_asynchronous=None, snapshot=None, symlinks=None, time_delta=None, write_datasync_action=None, write_datasync_reply=None, write_filesync_action=None, write_filesync_reply=None, write_transfer_max_size=None, write_transfer_multiple=None, write_transfer_size=None, write_unstable_action=None, write_unstable_reply=None, zone=None):  # noqa: E501
        """NfsSettingsExportSettings - a model defined in Swagger"""  # noqa: E501

        self._all_dirs = None
        self._block_size = None
        self._can_set_time = None
        self._case_insensitive = None
        self._case_preserving = None
        self._chown_restricted = None
        self._commit_asynchronous = None
        self._directory_transfer_size = None
        self._encoding = None
        self._link_max = None
        self._map_all = None
        self._map_failure = None
        self._map_full = None
        self._map_lookup_uid = None
        self._map_non_root = None
        self._map_retry = None
        self._map_root = None
        self._max_file_size = None
        self._name_max_size = None
        self._no_truncate = None
        self._read_only = None
        self._read_transfer_max_size = None
        self._read_transfer_multiple = None
        self._read_transfer_size = None
        self._readdirplus = None
        self._readdirplus_prefetch = None
        self._return_32bit_file_ids = None
        self._security_flavors = None
        self._setattr_asynchronous = None
        self._snapshot = None
        self._symlinks = None
        self._time_delta = None
        self._write_datasync_action = None
        self._write_datasync_reply = None
        self._write_filesync_action = None
        self._write_filesync_reply = None
        self._write_transfer_max_size = None
        self._write_transfer_multiple = None
        self._write_transfer_size = None
        self._write_unstable_action = None
        self._write_unstable_reply = None
        self._zone = None
        self.discriminator = None

        if all_dirs is not None:
            self.all_dirs = all_dirs
        if block_size is not None:
            self.block_size = block_size
        if can_set_time is not None:
            self.can_set_time = can_set_time
        if case_insensitive is not None:
            self.case_insensitive = case_insensitive
        if case_preserving is not None:
            self.case_preserving = case_preserving
        if chown_restricted is not None:
            self.chown_restricted = chown_restricted
        if commit_asynchronous is not None:
            self.commit_asynchronous = commit_asynchronous
        if directory_transfer_size is not None:
            self.directory_transfer_size = directory_transfer_size
        if encoding is not None:
            self.encoding = encoding
        if link_max is not None:
            self.link_max = link_max
        if map_all is not None:
            self.map_all = map_all
        if map_failure is not None:
            self.map_failure = map_failure
        if map_full is not None:
            self.map_full = map_full
        if map_lookup_uid is not None:
            self.map_lookup_uid = map_lookup_uid
        if map_non_root is not None:
            self.map_non_root = map_non_root
        if map_retry is not None:
            self.map_retry = map_retry
        if map_root is not None:
            self.map_root = map_root
        if max_file_size is not None:
            self.max_file_size = max_file_size
        if name_max_size is not None:
            self.name_max_size = name_max_size
        if no_truncate is not None:
            self.no_truncate = no_truncate
        if read_only is not None:
            self.read_only = read_only
        if read_transfer_max_size is not None:
            self.read_transfer_max_size = read_transfer_max_size
        if read_transfer_multiple is not None:
            self.read_transfer_multiple = read_transfer_multiple
        if read_transfer_size is not None:
            self.read_transfer_size = read_transfer_size
        if readdirplus is not None:
            self.readdirplus = readdirplus
        if readdirplus_prefetch is not None:
            self.readdirplus_prefetch = readdirplus_prefetch
        if return_32bit_file_ids is not None:
            self.return_32bit_file_ids = return_32bit_file_ids
        if security_flavors is not None:
            self.security_flavors = security_flavors
        if setattr_asynchronous is not None:
            self.setattr_asynchronous = setattr_asynchronous
        if snapshot is not None:
            self.snapshot = snapshot
        if symlinks is not None:
            self.symlinks = symlinks
        if time_delta is not None:
            self.time_delta = time_delta
        if write_datasync_action is not None:
            self.write_datasync_action = write_datasync_action
        if write_datasync_reply is not None:
            self.write_datasync_reply = write_datasync_reply
        if write_filesync_action is not None:
            self.write_filesync_action = write_filesync_action
        if write_filesync_reply is not None:
            self.write_filesync_reply = write_filesync_reply
        if write_transfer_max_size is not None:
            self.write_transfer_max_size = write_transfer_max_size
        if write_transfer_multiple is not None:
            self.write_transfer_multiple = write_transfer_multiple
        if write_transfer_size is not None:
            self.write_transfer_size = write_transfer_size
        if write_unstable_action is not None:
            self.write_unstable_action = write_unstable_action
        if write_unstable_reply is not None:
            self.write_unstable_reply = write_unstable_reply
        if zone is not None:
            self.zone = zone

    @property
    def all_dirs(self):
        """Gets the all_dirs of this NfsSettingsExportSettings.  # noqa: E501

        True if all directories under the specified paths are mountable.  # noqa: E501

        :return: The all_dirs of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: bool
        """
        return self._all_dirs

    @all_dirs.setter
    def all_dirs(self, all_dirs):
        """Sets the all_dirs of this NfsSettingsExportSettings.

        True if all directories under the specified paths are mountable.  # noqa: E501

        :param all_dirs: The all_dirs of this NfsSettingsExportSettings.  # noqa: E501
        :type: bool
        """

        self._all_dirs = all_dirs

    @property
    def block_size(self):
        """Gets the block_size of this NfsSettingsExportSettings.  # noqa: E501

        Specifies the block size returned by the NFS statfs procedure.  # noqa: E501

        :return: The block_size of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: int
        """
        return self._block_size

    @block_size.setter
    def block_size(self, block_size):
        """Sets the block_size of this NfsSettingsExportSettings.

        Specifies the block size returned by the NFS statfs procedure.  # noqa: E501

        :param block_size: The block_size of this NfsSettingsExportSettings.  # noqa: E501
        :type: int
        """
        if block_size is not None and block_size > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for `block_size`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if block_size is not None and block_size < 0:  # noqa: E501
            raise ValueError("Invalid value for `block_size`, must be a value greater than or equal to `0`")  # noqa: E501

        self._block_size = block_size

    @property
    def can_set_time(self):
        """Gets the can_set_time of this NfsSettingsExportSettings.  # noqa: E501

        True if the client can set file times through the NFS set attribute request. This parameter does not affect server behavior, but is included to accommodate legacy client requirements.  # noqa: E501

        :return: The can_set_time of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: bool
        """
        return self._can_set_time

    @can_set_time.setter
    def can_set_time(self, can_set_time):
        """Sets the can_set_time of this NfsSettingsExportSettings.

        True if the client can set file times through the NFS set attribute request. This parameter does not affect server behavior, but is included to accommodate legacy client requirements.  # noqa: E501

        :param can_set_time: The can_set_time of this NfsSettingsExportSettings.  # noqa: E501
        :type: bool
        """

        self._can_set_time = can_set_time

    @property
    def case_insensitive(self):
        """Gets the case_insensitive of this NfsSettingsExportSettings.  # noqa: E501

        True if the case is ignored for file names. This parameter does not affect server behavior, but is included to accommodate legacy client requirements.  # noqa: E501

        :return: The case_insensitive of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: bool
        """
        return self._case_insensitive

    @case_insensitive.setter
    def case_insensitive(self, case_insensitive):
        """Sets the case_insensitive of this NfsSettingsExportSettings.

        True if the case is ignored for file names. This parameter does not affect server behavior, but is included to accommodate legacy client requirements.  # noqa: E501

        :param case_insensitive: The case_insensitive of this NfsSettingsExportSettings.  # noqa: E501
        :type: bool
        """

        self._case_insensitive = case_insensitive

    @property
    def case_preserving(self):
        """Gets the case_preserving of this NfsSettingsExportSettings.  # noqa: E501

        True if the case is preserved for file names. This parameter does not affect server behavior, but is included to accommodate legacy client requirements.  # noqa: E501

        :return: The case_preserving of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: bool
        """
        return self._case_preserving

    @case_preserving.setter
    def case_preserving(self, case_preserving):
        """Sets the case_preserving of this NfsSettingsExportSettings.

        True if the case is preserved for file names. This parameter does not affect server behavior, but is included to accommodate legacy client requirements.  # noqa: E501

        :param case_preserving: The case_preserving of this NfsSettingsExportSettings.  # noqa: E501
        :type: bool
        """

        self._case_preserving = case_preserving

    @property
    def chown_restricted(self):
        """Gets the chown_restricted of this NfsSettingsExportSettings.  # noqa: E501

        True if the superuser can change file ownership. This parameter does not affect server behavior, but is included to accommodate legacy client requirements.  # noqa: E501

        :return: The chown_restricted of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: bool
        """
        return self._chown_restricted

    @chown_restricted.setter
    def chown_restricted(self, chown_restricted):
        """Sets the chown_restricted of this NfsSettingsExportSettings.

        True if the superuser can change file ownership. This parameter does not affect server behavior, but is included to accommodate legacy client requirements.  # noqa: E501

        :param chown_restricted: The chown_restricted of this NfsSettingsExportSettings.  # noqa: E501
        :type: bool
        """

        self._chown_restricted = chown_restricted

    @property
    def commit_asynchronous(self):
        """Gets the commit_asynchronous of this NfsSettingsExportSettings.  # noqa: E501

        True if NFS  commit  requests execute asynchronously.  # noqa: E501

        :return: The commit_asynchronous of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: bool
        """
        return self._commit_asynchronous

    @commit_asynchronous.setter
    def commit_asynchronous(self, commit_asynchronous):
        """Sets the commit_asynchronous of this NfsSettingsExportSettings.

        True if NFS  commit  requests execute asynchronously.  # noqa: E501

        :param commit_asynchronous: The commit_asynchronous of this NfsSettingsExportSettings.  # noqa: E501
        :type: bool
        """

        self._commit_asynchronous = commit_asynchronous

    @property
    def directory_transfer_size(self):
        """Gets the directory_transfer_size of this NfsSettingsExportSettings.  # noqa: E501

        Specifies the preferred size for directory read operations. This value is used to advise the client of optimal settings for the server, but is not enforced.  # noqa: E501

        :return: The directory_transfer_size of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: int
        """
        return self._directory_transfer_size

    @directory_transfer_size.setter
    def directory_transfer_size(self, directory_transfer_size):
        """Sets the directory_transfer_size of this NfsSettingsExportSettings.

        Specifies the preferred size for directory read operations. This value is used to advise the client of optimal settings for the server, but is not enforced.  # noqa: E501

        :param directory_transfer_size: The directory_transfer_size of this NfsSettingsExportSettings.  # noqa: E501
        :type: int
        """
        if directory_transfer_size is not None and directory_transfer_size > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for `directory_transfer_size`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if directory_transfer_size is not None and directory_transfer_size < 0:  # noqa: E501
            raise ValueError("Invalid value for `directory_transfer_size`, must be a value greater than or equal to `0`")  # noqa: E501

        self._directory_transfer_size = directory_transfer_size

    @property
    def encoding(self):
        """Gets the encoding of this NfsSettingsExportSettings.  # noqa: E501

        Specifies the default character set encoding of the clients connecting to the export, unless otherwise specified.  # noqa: E501

        :return: The encoding of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: str
        """
        return self._encoding

    @encoding.setter
    def encoding(self, encoding):
        """Sets the encoding of this NfsSettingsExportSettings.

        Specifies the default character set encoding of the clients connecting to the export, unless otherwise specified.  # noqa: E501

        :param encoding: The encoding of this NfsSettingsExportSettings.  # noqa: E501
        :type: str
        """

        self._encoding = encoding

    @property
    def link_max(self):
        """Gets the link_max of this NfsSettingsExportSettings.  # noqa: E501

        Specifies the reported maximum number of links to a file. This parameter does not affect server behavior, but is included to accommodate legacy client requirements.  # noqa: E501

        :return: The link_max of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: int
        """
        return self._link_max

    @link_max.setter
    def link_max(self, link_max):
        """Sets the link_max of this NfsSettingsExportSettings.

        Specifies the reported maximum number of links to a file. This parameter does not affect server behavior, but is included to accommodate legacy client requirements.  # noqa: E501

        :param link_max: The link_max of this NfsSettingsExportSettings.  # noqa: E501
        :type: int
        """
        if link_max is not None and link_max > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for `link_max`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if link_max is not None and link_max < 0:  # noqa: E501
            raise ValueError("Invalid value for `link_max`, must be a value greater than or equal to `0`")  # noqa: E501

        self._link_max = link_max

    @property
    def map_all(self):
        """Gets the map_all of this NfsSettingsExportSettings.  # noqa: E501

        User and group mapping.  # noqa: E501

        :return: The map_all of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: NfsSettingsExportSettingsMapAll
        """
        return self._map_all

    @map_all.setter
    def map_all(self, map_all):
        """Sets the map_all of this NfsSettingsExportSettings.

        User and group mapping.  # noqa: E501

        :param map_all: The map_all of this NfsSettingsExportSettings.  # noqa: E501
        :type: NfsSettingsExportSettingsMapAll
        """

        self._map_all = map_all

    @property
    def map_failure(self):
        """Gets the map_failure of this NfsSettingsExportSettings.  # noqa: E501

        User and group mapping.  # noqa: E501

        :return: The map_failure of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: NfsSettingsExportSettingsMapAll
        """
        return self._map_failure

    @map_failure.setter
    def map_failure(self, map_failure):
        """Sets the map_failure of this NfsSettingsExportSettings.

        User and group mapping.  # noqa: E501

        :param map_failure: The map_failure of this NfsSettingsExportSettings.  # noqa: E501
        :type: NfsSettingsExportSettingsMapAll
        """

        self._map_failure = map_failure

    @property
    def map_full(self):
        """Gets the map_full of this NfsSettingsExportSettings.  # noqa: E501

        True if user mappings query the OneFS user database. When set to false, user mappings only query local authentication.  # noqa: E501

        :return: The map_full of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: bool
        """
        return self._map_full

    @map_full.setter
    def map_full(self, map_full):
        """Sets the map_full of this NfsSettingsExportSettings.

        True if user mappings query the OneFS user database. When set to false, user mappings only query local authentication.  # noqa: E501

        :param map_full: The map_full of this NfsSettingsExportSettings.  # noqa: E501
        :type: bool
        """

        self._map_full = map_full

    @property
    def map_lookup_uid(self):
        """Gets the map_lookup_uid of this NfsSettingsExportSettings.  # noqa: E501

        True if incoming user IDs (UIDs) are mapped to users in the OneFS user database. When set to false, incoming UIDs are applied directly to file operations.  # noqa: E501

        :return: The map_lookup_uid of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: bool
        """
        return self._map_lookup_uid

    @map_lookup_uid.setter
    def map_lookup_uid(self, map_lookup_uid):
        """Sets the map_lookup_uid of this NfsSettingsExportSettings.

        True if incoming user IDs (UIDs) are mapped to users in the OneFS user database. When set to false, incoming UIDs are applied directly to file operations.  # noqa: E501

        :param map_lookup_uid: The map_lookup_uid of this NfsSettingsExportSettings.  # noqa: E501
        :type: bool
        """

        self._map_lookup_uid = map_lookup_uid

    @property
    def map_non_root(self):
        """Gets the map_non_root of this NfsSettingsExportSettings.  # noqa: E501

        User and group mapping.  # noqa: E501

        :return: The map_non_root of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: NfsSettingsExportSettingsMapAll
        """
        return self._map_non_root

    @map_non_root.setter
    def map_non_root(self, map_non_root):
        """Sets the map_non_root of this NfsSettingsExportSettings.

        User and group mapping.  # noqa: E501

        :param map_non_root: The map_non_root of this NfsSettingsExportSettings.  # noqa: E501
        :type: NfsSettingsExportSettingsMapAll
        """

        self._map_non_root = map_non_root

    @property
    def map_retry(self):
        """Gets the map_retry of this NfsSettingsExportSettings.  # noqa: E501

        Determines whether searches for users specified in 'map_all', 'map_root' or 'map_nonroot' are retried if the search fails.  # noqa: E501

        :return: The map_retry of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: bool
        """
        return self._map_retry

    @map_retry.setter
    def map_retry(self, map_retry):
        """Sets the map_retry of this NfsSettingsExportSettings.

        Determines whether searches for users specified in 'map_all', 'map_root' or 'map_nonroot' are retried if the search fails.  # noqa: E501

        :param map_retry: The map_retry of this NfsSettingsExportSettings.  # noqa: E501
        :type: bool
        """

        self._map_retry = map_retry

    @property
    def map_root(self):
        """Gets the map_root of this NfsSettingsExportSettings.  # noqa: E501

        User and group mapping.  # noqa: E501

        :return: The map_root of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: NfsSettingsExportSettingsMapAll
        """
        return self._map_root

    @map_root.setter
    def map_root(self, map_root):
        """Sets the map_root of this NfsSettingsExportSettings.

        User and group mapping.  # noqa: E501

        :param map_root: The map_root of this NfsSettingsExportSettings.  # noqa: E501
        :type: NfsSettingsExportSettingsMapAll
        """

        self._map_root = map_root

    @property
    def max_file_size(self):
        """Gets the max_file_size of this NfsSettingsExportSettings.  # noqa: E501

        Specifies the maximum file size for any file accessed from the export. This parameter does not affect server behavior, but is included to accommodate legacy client requirements.  # noqa: E501

        :return: The max_file_size of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: int
        """
        return self._max_file_size

    @max_file_size.setter
    def max_file_size(self, max_file_size):
        """Sets the max_file_size of this NfsSettingsExportSettings.

        Specifies the maximum file size for any file accessed from the export. This parameter does not affect server behavior, but is included to accommodate legacy client requirements.  # noqa: E501

        :param max_file_size: The max_file_size of this NfsSettingsExportSettings.  # noqa: E501
        :type: int
        """

        self._max_file_size = max_file_size

    @property
    def name_max_size(self):
        """Gets the name_max_size of this NfsSettingsExportSettings.  # noqa: E501

        Specifies the reported maximum length of a file name. This parameter does not affect server behavior, but is included to accommodate legacy client requirements.  # noqa: E501

        :return: The name_max_size of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: int
        """
        return self._name_max_size

    @name_max_size.setter
    def name_max_size(self, name_max_size):
        """Sets the name_max_size of this NfsSettingsExportSettings.

        Specifies the reported maximum length of a file name. This parameter does not affect server behavior, but is included to accommodate legacy client requirements.  # noqa: E501

        :param name_max_size: The name_max_size of this NfsSettingsExportSettings.  # noqa: E501
        :type: int
        """
        if name_max_size is not None and name_max_size > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for `name_max_size`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if name_max_size is not None and name_max_size < 0:  # noqa: E501
            raise ValueError("Invalid value for `name_max_size`, must be a value greater than or equal to `0`")  # noqa: E501

        self._name_max_size = name_max_size

    @property
    def no_truncate(self):
        """Gets the no_truncate of this NfsSettingsExportSettings.  # noqa: E501

        True if long file names result in an error. This parameter does not affect server behavior, but is included to accommodate legacy client requirements.  # noqa: E501

        :return: The no_truncate of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: bool
        """
        return self._no_truncate

    @no_truncate.setter
    def no_truncate(self, no_truncate):
        """Sets the no_truncate of this NfsSettingsExportSettings.

        True if long file names result in an error. This parameter does not affect server behavior, but is included to accommodate legacy client requirements.  # noqa: E501

        :param no_truncate: The no_truncate of this NfsSettingsExportSettings.  # noqa: E501
        :type: bool
        """

        self._no_truncate = no_truncate

    @property
    def read_only(self):
        """Gets the read_only of this NfsSettingsExportSettings.  # noqa: E501

        True if the export is set to read-only.  # noqa: E501

        :return: The read_only of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: bool
        """
        return self._read_only

    @read_only.setter
    def read_only(self, read_only):
        """Sets the read_only of this NfsSettingsExportSettings.

        True if the export is set to read-only.  # noqa: E501

        :param read_only: The read_only of this NfsSettingsExportSettings.  # noqa: E501
        :type: bool
        """

        self._read_only = read_only

    @property
    def read_transfer_max_size(self):
        """Gets the read_transfer_max_size of this NfsSettingsExportSettings.  # noqa: E501

        Specifies the maximum buffer size that clients should use on NFS read requests. This value is used to advise the client of optimal settings for the server, but is not enforced.  # noqa: E501

        :return: The read_transfer_max_size of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: int
        """
        return self._read_transfer_max_size

    @read_transfer_max_size.setter
    def read_transfer_max_size(self, read_transfer_max_size):
        """Sets the read_transfer_max_size of this NfsSettingsExportSettings.

        Specifies the maximum buffer size that clients should use on NFS read requests. This value is used to advise the client of optimal settings for the server, but is not enforced.  # noqa: E501

        :param read_transfer_max_size: The read_transfer_max_size of this NfsSettingsExportSettings.  # noqa: E501
        :type: int
        """
        if read_transfer_max_size is not None and read_transfer_max_size > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for `read_transfer_max_size`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if read_transfer_max_size is not None and read_transfer_max_size < 0:  # noqa: E501
            raise ValueError("Invalid value for `read_transfer_max_size`, must be a value greater than or equal to `0`")  # noqa: E501

        self._read_transfer_max_size = read_transfer_max_size

    @property
    def read_transfer_multiple(self):
        """Gets the read_transfer_multiple of this NfsSettingsExportSettings.  # noqa: E501

        Specifies the preferred multiple size for NFS read requests. This value is used to advise the client of optimal settings for the server, but is not enforced.  # noqa: E501

        :return: The read_transfer_multiple of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: int
        """
        return self._read_transfer_multiple

    @read_transfer_multiple.setter
    def read_transfer_multiple(self, read_transfer_multiple):
        """Sets the read_transfer_multiple of this NfsSettingsExportSettings.

        Specifies the preferred multiple size for NFS read requests. This value is used to advise the client of optimal settings for the server, but is not enforced.  # noqa: E501

        :param read_transfer_multiple: The read_transfer_multiple of this NfsSettingsExportSettings.  # noqa: E501
        :type: int
        """
        if read_transfer_multiple is not None and read_transfer_multiple > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for `read_transfer_multiple`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if read_transfer_multiple is not None and read_transfer_multiple < 0:  # noqa: E501
            raise ValueError("Invalid value for `read_transfer_multiple`, must be a value greater than or equal to `0`")  # noqa: E501

        self._read_transfer_multiple = read_transfer_multiple

    @property
    def read_transfer_size(self):
        """Gets the read_transfer_size of this NfsSettingsExportSettings.  # noqa: E501

        Specifies the preferred size for NFS read requests. This value is used to advise the client of optimal settings for the server, but is not enforced.  # noqa: E501

        :return: The read_transfer_size of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: int
        """
        return self._read_transfer_size

    @read_transfer_size.setter
    def read_transfer_size(self, read_transfer_size):
        """Sets the read_transfer_size of this NfsSettingsExportSettings.

        Specifies the preferred size for NFS read requests. This value is used to advise the client of optimal settings for the server, but is not enforced.  # noqa: E501

        :param read_transfer_size: The read_transfer_size of this NfsSettingsExportSettings.  # noqa: E501
        :type: int
        """
        if read_transfer_size is not None and read_transfer_size > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for `read_transfer_size`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if read_transfer_size is not None and read_transfer_size < 0:  # noqa: E501
            raise ValueError("Invalid value for `read_transfer_size`, must be a value greater than or equal to `0`")  # noqa: E501

        self._read_transfer_size = read_transfer_size

    @property
    def readdirplus(self):
        """Gets the readdirplus of this NfsSettingsExportSettings.  # noqa: E501

        True if 'readdirplus' requests are enabled. Enabling this property might improve network performance and is only available for NFSv3.  # noqa: E501

        :return: The readdirplus of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: bool
        """
        return self._readdirplus

    @readdirplus.setter
    def readdirplus(self, readdirplus):
        """Sets the readdirplus of this NfsSettingsExportSettings.

        True if 'readdirplus' requests are enabled. Enabling this property might improve network performance and is only available for NFSv3.  # noqa: E501

        :param readdirplus: The readdirplus of this NfsSettingsExportSettings.  # noqa: E501
        :type: bool
        """

        self._readdirplus = readdirplus

    @property
    def readdirplus_prefetch(self):
        """Gets the readdirplus_prefetch of this NfsSettingsExportSettings.  # noqa: E501

        Sets the number of directory entries that are prefetched when a 'readdirplus' request is processed. (Deprecated.)  # noqa: E501

        :return: The readdirplus_prefetch of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: int
        """
        return self._readdirplus_prefetch

    @readdirplus_prefetch.setter
    def readdirplus_prefetch(self, readdirplus_prefetch):
        """Sets the readdirplus_prefetch of this NfsSettingsExportSettings.

        Sets the number of directory entries that are prefetched when a 'readdirplus' request is processed. (Deprecated.)  # noqa: E501

        :param readdirplus_prefetch: The readdirplus_prefetch of this NfsSettingsExportSettings.  # noqa: E501
        :type: int
        """
        if readdirplus_prefetch is not None and readdirplus_prefetch > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for `readdirplus_prefetch`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if readdirplus_prefetch is not None and readdirplus_prefetch < 0:  # noqa: E501
            raise ValueError("Invalid value for `readdirplus_prefetch`, must be a value greater than or equal to `0`")  # noqa: E501

        self._readdirplus_prefetch = readdirplus_prefetch

    @property
    def return_32bit_file_ids(self):
        """Gets the return_32bit_file_ids of this NfsSettingsExportSettings.  # noqa: E501

        Limits the size of file identifiers returned by NFSv3+ to 32-bit values (may require remount).  # noqa: E501

        :return: The return_32bit_file_ids of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: bool
        """
        return self._return_32bit_file_ids

    @return_32bit_file_ids.setter
    def return_32bit_file_ids(self, return_32bit_file_ids):
        """Sets the return_32bit_file_ids of this NfsSettingsExportSettings.

        Limits the size of file identifiers returned by NFSv3+ to 32-bit values (may require remount).  # noqa: E501

        :param return_32bit_file_ids: The return_32bit_file_ids of this NfsSettingsExportSettings.  # noqa: E501
        :type: bool
        """

        self._return_32bit_file_ids = return_32bit_file_ids

    @property
    def security_flavors(self):
        """Gets the security_flavors of this NfsSettingsExportSettings.  # noqa: E501

        Specifies the authentication types that are supported for this export.  # noqa: E501

        :return: The security_flavors of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: list[str]
        """
        return self._security_flavors

    @security_flavors.setter
    def security_flavors(self, security_flavors):
        """Sets the security_flavors of this NfsSettingsExportSettings.

        Specifies the authentication types that are supported for this export.  # noqa: E501

        :param security_flavors: The security_flavors of this NfsSettingsExportSettings.  # noqa: E501
        :type: list[str]
        """
        allowed_values = ["unix", "krb5", "krb5i", "krb5p"]  # noqa: E501
        if not set(security_flavors).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `security_flavors` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(security_flavors) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._security_flavors = security_flavors

    @property
    def setattr_asynchronous(self):
        """Gets the setattr_asynchronous of this NfsSettingsExportSettings.  # noqa: E501

        True if set attribute operations execute asynchronously.  # noqa: E501

        :return: The setattr_asynchronous of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: bool
        """
        return self._setattr_asynchronous

    @setattr_asynchronous.setter
    def setattr_asynchronous(self, setattr_asynchronous):
        """Sets the setattr_asynchronous of this NfsSettingsExportSettings.

        True if set attribute operations execute asynchronously.  # noqa: E501

        :param setattr_asynchronous: The setattr_asynchronous of this NfsSettingsExportSettings.  # noqa: E501
        :type: bool
        """

        self._setattr_asynchronous = setattr_asynchronous

    @property
    def snapshot(self):
        """Gets the snapshot of this NfsSettingsExportSettings.  # noqa: E501

        Specifies the snapshot for all mounts.  # noqa: E501

        :return: The snapshot of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: str
        """
        return self._snapshot

    @snapshot.setter
    def snapshot(self, snapshot):
        """Sets the snapshot of this NfsSettingsExportSettings.

        Specifies the snapshot for all mounts.  # noqa: E501

        :param snapshot: The snapshot of this NfsSettingsExportSettings.  # noqa: E501
        :type: str
        """

        self._snapshot = snapshot

    @property
    def symlinks(self):
        """Gets the symlinks of this NfsSettingsExportSettings.  # noqa: E501

        True if symlinks are supported. This value is used to advise the client of optimal settings for the server, but is not enforced.  # noqa: E501

        :return: The symlinks of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: bool
        """
        return self._symlinks

    @symlinks.setter
    def symlinks(self, symlinks):
        """Sets the symlinks of this NfsSettingsExportSettings.

        True if symlinks are supported. This value is used to advise the client of optimal settings for the server, but is not enforced.  # noqa: E501

        :param symlinks: The symlinks of this NfsSettingsExportSettings.  # noqa: E501
        :type: bool
        """

        self._symlinks = symlinks

    @property
    def time_delta(self):
        """Gets the time_delta of this NfsSettingsExportSettings.  # noqa: E501

        Specifies the resolution of all time values that are returned to the clients  # noqa: E501

        :return: The time_delta of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: float
        """
        return self._time_delta

    @time_delta.setter
    def time_delta(self, time_delta):
        """Sets the time_delta of this NfsSettingsExportSettings.

        Specifies the resolution of all time values that are returned to the clients  # noqa: E501

        :param time_delta: The time_delta of this NfsSettingsExportSettings.  # noqa: E501
        :type: float
        """

        self._time_delta = time_delta

    @property
    def write_datasync_action(self):
        """Gets the write_datasync_action of this NfsSettingsExportSettings.  # noqa: E501

        Specifies the synchronization type.  # noqa: E501

        :return: The write_datasync_action of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: str
        """
        return self._write_datasync_action

    @write_datasync_action.setter
    def write_datasync_action(self, write_datasync_action):
        """Sets the write_datasync_action of this NfsSettingsExportSettings.

        Specifies the synchronization type.  # noqa: E501

        :param write_datasync_action: The write_datasync_action of this NfsSettingsExportSettings.  # noqa: E501
        :type: str
        """

        self._write_datasync_action = write_datasync_action

    @property
    def write_datasync_reply(self):
        """Gets the write_datasync_reply of this NfsSettingsExportSettings.  # noqa: E501

        Specifies the synchronization type.  # noqa: E501

        :return: The write_datasync_reply of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: str
        """
        return self._write_datasync_reply

    @write_datasync_reply.setter
    def write_datasync_reply(self, write_datasync_reply):
        """Sets the write_datasync_reply of this NfsSettingsExportSettings.

        Specifies the synchronization type.  # noqa: E501

        :param write_datasync_reply: The write_datasync_reply of this NfsSettingsExportSettings.  # noqa: E501
        :type: str
        """

        self._write_datasync_reply = write_datasync_reply

    @property
    def write_filesync_action(self):
        """Gets the write_filesync_action of this NfsSettingsExportSettings.  # noqa: E501

        Specifies the synchronization type.  # noqa: E501

        :return: The write_filesync_action of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: str
        """
        return self._write_filesync_action

    @write_filesync_action.setter
    def write_filesync_action(self, write_filesync_action):
        """Sets the write_filesync_action of this NfsSettingsExportSettings.

        Specifies the synchronization type.  # noqa: E501

        :param write_filesync_action: The write_filesync_action of this NfsSettingsExportSettings.  # noqa: E501
        :type: str
        """

        self._write_filesync_action = write_filesync_action

    @property
    def write_filesync_reply(self):
        """Gets the write_filesync_reply of this NfsSettingsExportSettings.  # noqa: E501

        Specifies the synchronization type.  # noqa: E501

        :return: The write_filesync_reply of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: str
        """
        return self._write_filesync_reply

    @write_filesync_reply.setter
    def write_filesync_reply(self, write_filesync_reply):
        """Sets the write_filesync_reply of this NfsSettingsExportSettings.

        Specifies the synchronization type.  # noqa: E501

        :param write_filesync_reply: The write_filesync_reply of this NfsSettingsExportSettings.  # noqa: E501
        :type: str
        """

        self._write_filesync_reply = write_filesync_reply

    @property
    def write_transfer_max_size(self):
        """Gets the write_transfer_max_size of this NfsSettingsExportSettings.  # noqa: E501

        Specifies the maximum buffer size that clients should use on NFS write requests. This value is used to advise the client of optimal settings for the server, but is not enforced.  # noqa: E501

        :return: The write_transfer_max_size of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: int
        """
        return self._write_transfer_max_size

    @write_transfer_max_size.setter
    def write_transfer_max_size(self, write_transfer_max_size):
        """Sets the write_transfer_max_size of this NfsSettingsExportSettings.

        Specifies the maximum buffer size that clients should use on NFS write requests. This value is used to advise the client of optimal settings for the server, but is not enforced.  # noqa: E501

        :param write_transfer_max_size: The write_transfer_max_size of this NfsSettingsExportSettings.  # noqa: E501
        :type: int
        """
        if write_transfer_max_size is not None and write_transfer_max_size > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for `write_transfer_max_size`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if write_transfer_max_size is not None and write_transfer_max_size < 0:  # noqa: E501
            raise ValueError("Invalid value for `write_transfer_max_size`, must be a value greater than or equal to `0`")  # noqa: E501

        self._write_transfer_max_size = write_transfer_max_size

    @property
    def write_transfer_multiple(self):
        """Gets the write_transfer_multiple of this NfsSettingsExportSettings.  # noqa: E501

        Specifies the preferred multiple size for NFS write requests. This value is used to advise the client of optimal settings for the server, but is not enforced.  # noqa: E501

        :return: The write_transfer_multiple of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: int
        """
        return self._write_transfer_multiple

    @write_transfer_multiple.setter
    def write_transfer_multiple(self, write_transfer_multiple):
        """Sets the write_transfer_multiple of this NfsSettingsExportSettings.

        Specifies the preferred multiple size for NFS write requests. This value is used to advise the client of optimal settings for the server, but is not enforced.  # noqa: E501

        :param write_transfer_multiple: The write_transfer_multiple of this NfsSettingsExportSettings.  # noqa: E501
        :type: int
        """
        if write_transfer_multiple is not None and write_transfer_multiple > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for `write_transfer_multiple`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if write_transfer_multiple is not None and write_transfer_multiple < 0:  # noqa: E501
            raise ValueError("Invalid value for `write_transfer_multiple`, must be a value greater than or equal to `0`")  # noqa: E501

        self._write_transfer_multiple = write_transfer_multiple

    @property
    def write_transfer_size(self):
        """Gets the write_transfer_size of this NfsSettingsExportSettings.  # noqa: E501

        Specifies the preferred multiple size for NFS write requests. This value is used to advise the client of optimal settings for the server, but is not enforced.  # noqa: E501

        :return: The write_transfer_size of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: int
        """
        return self._write_transfer_size

    @write_transfer_size.setter
    def write_transfer_size(self, write_transfer_size):
        """Sets the write_transfer_size of this NfsSettingsExportSettings.

        Specifies the preferred multiple size for NFS write requests. This value is used to advise the client of optimal settings for the server, but is not enforced.  # noqa: E501

        :param write_transfer_size: The write_transfer_size of this NfsSettingsExportSettings.  # noqa: E501
        :type: int
        """
        if write_transfer_size is not None and write_transfer_size > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for `write_transfer_size`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if write_transfer_size is not None and write_transfer_size < 0:  # noqa: E501
            raise ValueError("Invalid value for `write_transfer_size`, must be a value greater than or equal to `0`")  # noqa: E501

        self._write_transfer_size = write_transfer_size

    @property
    def write_unstable_action(self):
        """Gets the write_unstable_action of this NfsSettingsExportSettings.  # noqa: E501

        Specifies the synchronization type.  # noqa: E501

        :return: The write_unstable_action of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: str
        """
        return self._write_unstable_action

    @write_unstable_action.setter
    def write_unstable_action(self, write_unstable_action):
        """Sets the write_unstable_action of this NfsSettingsExportSettings.

        Specifies the synchronization type.  # noqa: E501

        :param write_unstable_action: The write_unstable_action of this NfsSettingsExportSettings.  # noqa: E501
        :type: str
        """

        self._write_unstable_action = write_unstable_action

    @property
    def write_unstable_reply(self):
        """Gets the write_unstable_reply of this NfsSettingsExportSettings.  # noqa: E501

        Specifies the synchronization type.  # noqa: E501

        :return: The write_unstable_reply of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: str
        """
        return self._write_unstable_reply

    @write_unstable_reply.setter
    def write_unstable_reply(self, write_unstable_reply):
        """Sets the write_unstable_reply of this NfsSettingsExportSettings.

        Specifies the synchronization type.  # noqa: E501

        :param write_unstable_reply: The write_unstable_reply of this NfsSettingsExportSettings.  # noqa: E501
        :type: str
        """

        self._write_unstable_reply = write_unstable_reply

    @property
    def zone(self):
        """Gets the zone of this NfsSettingsExportSettings.  # noqa: E501

        Specifies the zone in which the export is valid.  # noqa: E501

        :return: The zone of this NfsSettingsExportSettings.  # noqa: E501
        :rtype: str
        """
        return self._zone

    @zone.setter
    def zone(self, zone):
        """Sets the zone of this NfsSettingsExportSettings.

        Specifies the zone in which the export is valid.  # noqa: E501

        :param zone: The zone of this NfsSettingsExportSettings.  # noqa: E501
        :type: str
        """

        self._zone = zone

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NfsSettingsExportSettings):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
