# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 10
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isi_sdk_9_0_0.api_client import ApiClient


class SyncApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_certificates_peer_item(self, certificates_peer_item, **kwargs):  # noqa: E501
        """create_certificates_peer_item  # noqa: E501

        Import a trusted SyncIQ TLS certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_certificates_peer_item(certificates_peer_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CertificateAuthorityItem certificates_peer_item: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_certificates_peer_item_with_http_info(certificates_peer_item, **kwargs)  # noqa: E501
        else:
            (data) = self.create_certificates_peer_item_with_http_info(certificates_peer_item, **kwargs)  # noqa: E501
            return data

    def create_certificates_peer_item_with_http_info(self, certificates_peer_item, **kwargs):  # noqa: E501
        """create_certificates_peer_item  # noqa: E501

        Import a trusted SyncIQ TLS certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_certificates_peer_item_with_http_info(certificates_peer_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CertificateAuthorityItem certificates_peer_item: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['certificates_peer_item']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_certificates_peer_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'certificates_peer_item' is set
        if ('certificates_peer_item' not in params or
                params['certificates_peer_item'] is None):
            raise ValueError("Missing the required parameter `certificates_peer_item` when calling `create_certificates_peer_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'certificates_peer_item' in params:
            body_params = params['certificates_peer_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/certificates/peer', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_certificates_server_item(self, certificates_server_item, **kwargs):  # noqa: E501
        """create_certificates_server_item  # noqa: E501

        Import a SyncIQ TLS server certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_certificates_server_item(certificates_server_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CertificateServerItem certificates_server_item: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_certificates_server_item_with_http_info(certificates_server_item, **kwargs)  # noqa: E501
        else:
            (data) = self.create_certificates_server_item_with_http_info(certificates_server_item, **kwargs)  # noqa: E501
            return data

    def create_certificates_server_item_with_http_info(self, certificates_server_item, **kwargs):  # noqa: E501
        """create_certificates_server_item  # noqa: E501

        Import a SyncIQ TLS server certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_certificates_server_item_with_http_info(certificates_server_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CertificateServerItem certificates_server_item: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['certificates_server_item']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_certificates_server_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'certificates_server_item' is set
        if ('certificates_server_item' not in params or
                params['certificates_server_item'] is None):
            raise ValueError("Missing the required parameter `certificates_server_item` when calling `create_certificates_server_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'certificates_server_item' in params:
            body_params = params['certificates_server_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/certificates/server', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_service_policy(self, service_policy, **kwargs):  # noqa: E501
        """create_service_policy  # noqa: E501

        Create a SyncIQ service replication policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_service_policy(service_policy, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ServicePolicyCreateParams service_policy: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_service_policy_with_http_info(service_policy, **kwargs)  # noqa: E501
        else:
            (data) = self.create_service_policy_with_http_info(service_policy, **kwargs)  # noqa: E501
            return data

    def create_service_policy_with_http_info(self, service_policy, **kwargs):  # noqa: E501
        """create_service_policy  # noqa: E501

        Create a SyncIQ service replication policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_service_policy_with_http_info(service_policy, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ServicePolicyCreateParams service_policy: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['service_policy']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_service_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'service_policy' is set
        if ('service_policy' not in params or
                params['service_policy'] is None):
            raise ValueError("Missing the required parameter `service_policy` when calling `create_service_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'service_policy' in params:
            body_params = params['service_policy']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/service/policies', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_sync_job(self, sync_job, **kwargs):  # noqa: E501
        """create_sync_job  # noqa: E501

        Start a SyncIQ job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_sync_job(sync_job, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SyncJobCreateParams sync_job: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_sync_job_with_http_info(sync_job, **kwargs)  # noqa: E501
        else:
            (data) = self.create_sync_job_with_http_info(sync_job, **kwargs)  # noqa: E501
            return data

    def create_sync_job_with_http_info(self, sync_job, **kwargs):  # noqa: E501
        """create_sync_job  # noqa: E501

        Start a SyncIQ job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_sync_job_with_http_info(sync_job, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SyncJobCreateParams sync_job: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sync_job']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_sync_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sync_job' is set
        if ('sync_job' not in params or
                params['sync_job'] is None):
            raise ValueError("Missing the required parameter `sync_job` when calling `create_sync_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'sync_job' in params:
            body_params = params['sync_job']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/jobs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_sync_policy(self, sync_policy, **kwargs):  # noqa: E501
        """create_sync_policy  # noqa: E501

        Create a SyncIQ policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_sync_policy(sync_policy, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SyncPolicyCreateParams sync_policy: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_sync_policy_with_http_info(sync_policy, **kwargs)  # noqa: E501
        else:
            (data) = self.create_sync_policy_with_http_info(sync_policy, **kwargs)  # noqa: E501
            return data

    def create_sync_policy_with_http_info(self, sync_policy, **kwargs):  # noqa: E501
        """create_sync_policy  # noqa: E501

        Create a SyncIQ policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_sync_policy_with_http_info(sync_policy, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SyncPolicyCreateParams sync_policy: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sync_policy']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_sync_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sync_policy' is set
        if ('sync_policy' not in params or
                params['sync_policy'] is None):
            raise ValueError("Missing the required parameter `sync_policy` when calling `create_sync_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'sync_policy' in params:
            body_params = params['sync_policy']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/policies', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_sync_reports_rotate_item(self, sync_reports_rotate_item, **kwargs):  # noqa: E501
        """create_sync_reports_rotate_item  # noqa: E501

        Rotate the records in the database(s).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_sync_reports_rotate_item(sync_reports_rotate_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty sync_reports_rotate_item: (required)
        :return: CreateSyncReportsRotateItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_sync_reports_rotate_item_with_http_info(sync_reports_rotate_item, **kwargs)  # noqa: E501
        else:
            (data) = self.create_sync_reports_rotate_item_with_http_info(sync_reports_rotate_item, **kwargs)  # noqa: E501
            return data

    def create_sync_reports_rotate_item_with_http_info(self, sync_reports_rotate_item, **kwargs):  # noqa: E501
        """create_sync_reports_rotate_item  # noqa: E501

        Rotate the records in the database(s).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_sync_reports_rotate_item_with_http_info(sync_reports_rotate_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty sync_reports_rotate_item: (required)
        :return: CreateSyncReportsRotateItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sync_reports_rotate_item']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_sync_reports_rotate_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sync_reports_rotate_item' is set
        if ('sync_reports_rotate_item' not in params or
                params['sync_reports_rotate_item'] is None):
            raise ValueError("Missing the required parameter `sync_reports_rotate_item` when calling `create_sync_reports_rotate_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'sync_reports_rotate_item' in params:
            body_params = params['sync_reports_rotate_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/reports-rotate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateSyncReportsRotateItemResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_sync_rule(self, sync_rule, **kwargs):  # noqa: E501
        """create_sync_rule  # noqa: E501

        Create a new SyncIQ performance rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_sync_rule(sync_rule, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SyncRuleCreateParams sync_rule: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_sync_rule_with_http_info(sync_rule, **kwargs)  # noqa: E501
        else:
            (data) = self.create_sync_rule_with_http_info(sync_rule, **kwargs)  # noqa: E501
            return data

    def create_sync_rule_with_http_info(self, sync_rule, **kwargs):  # noqa: E501
        """create_sync_rule  # noqa: E501

        Create a new SyncIQ performance rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_sync_rule_with_http_info(sync_rule, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SyncRuleCreateParams sync_rule: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sync_rule']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_sync_rule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sync_rule' is set
        if ('sync_rule' not in params or
                params['sync_rule'] is None):
            raise ValueError("Missing the required parameter `sync_rule` when calling `create_sync_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'sync_rule' in params:
            body_params = params['sync_rule']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/sync/rules', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_certificates_peer_by_id(self, certificates_peer_id, **kwargs):  # noqa: E501
        """delete_certificates_peer_by_id  # noqa: E501

        Delete a trusted SyncIQ TLS certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_certificates_peer_by_id(certificates_peer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str certificates_peer_id: Delete a trusted SyncIQ TLS certificate. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_certificates_peer_by_id_with_http_info(certificates_peer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_certificates_peer_by_id_with_http_info(certificates_peer_id, **kwargs)  # noqa: E501
            return data

    def delete_certificates_peer_by_id_with_http_info(self, certificates_peer_id, **kwargs):  # noqa: E501
        """delete_certificates_peer_by_id  # noqa: E501

        Delete a trusted SyncIQ TLS certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_certificates_peer_by_id_with_http_info(certificates_peer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str certificates_peer_id: Delete a trusted SyncIQ TLS certificate. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['certificates_peer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_certificates_peer_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'certificates_peer_id' is set
        if ('certificates_peer_id' not in params or
                params['certificates_peer_id'] is None):
            raise ValueError("Missing the required parameter `certificates_peer_id` when calling `delete_certificates_peer_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'certificates_peer_id' in params:
            path_params['CertificatesPeerId'] = params['certificates_peer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/certificates/peer/{CertificatesPeerId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_certificates_server_by_id(self, certificates_server_id, **kwargs):  # noqa: E501
        """delete_certificates_server_by_id  # noqa: E501

        Delete a SyncIQ TLS server certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_certificates_server_by_id(certificates_server_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str certificates_server_id: Delete a SyncIQ TLS server certificate. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_certificates_server_by_id_with_http_info(certificates_server_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_certificates_server_by_id_with_http_info(certificates_server_id, **kwargs)  # noqa: E501
            return data

    def delete_certificates_server_by_id_with_http_info(self, certificates_server_id, **kwargs):  # noqa: E501
        """delete_certificates_server_by_id  # noqa: E501

        Delete a SyncIQ TLS server certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_certificates_server_by_id_with_http_info(certificates_server_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str certificates_server_id: Delete a SyncIQ TLS server certificate. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['certificates_server_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_certificates_server_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'certificates_server_id' is set
        if ('certificates_server_id' not in params or
                params['certificates_server_id'] is None):
            raise ValueError("Missing the required parameter `certificates_server_id` when calling `delete_certificates_server_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'certificates_server_id' in params:
            path_params['CertificatesServerId'] = params['certificates_server_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/certificates/server/{CertificatesServerId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_service_policies(self, **kwargs):  # noqa: E501
        """delete_service_policies  # noqa: E501

        Delete all SyncIQ service replication policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_service_policies(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool local_only: Skip deleting the policy association on the target.
        :param bool force: Ignore any running jobs when preparing to delete a policy.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_service_policies_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_service_policies_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_service_policies_with_http_info(self, **kwargs):  # noqa: E501
        """delete_service_policies  # noqa: E501

        Delete all SyncIQ service replication policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_service_policies_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool local_only: Skip deleting the policy association on the target.
        :param bool force: Ignore any running jobs when preparing to delete a policy.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['local_only', 'force']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_service_policies" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'local_only' in params:
            query_params.append(('local_only', params['local_only']))  # noqa: E501
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/service/policies', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_service_policy(self, service_policy_id, **kwargs):  # noqa: E501
        """delete_service_policy  # noqa: E501

        Delete a single SyncIQ service replication policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_service_policy(service_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str service_policy_id: Delete a single SyncIQ service replication policy. (required)
        :param bool local_only: Skip deleting the policy association on the target.
        :param bool force: Ignore any running jobs when preparing to delete a policy.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_service_policy_with_http_info(service_policy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_service_policy_with_http_info(service_policy_id, **kwargs)  # noqa: E501
            return data

    def delete_service_policy_with_http_info(self, service_policy_id, **kwargs):  # noqa: E501
        """delete_service_policy  # noqa: E501

        Delete a single SyncIQ service replication policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_service_policy_with_http_info(service_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str service_policy_id: Delete a single SyncIQ service replication policy. (required)
        :param bool local_only: Skip deleting the policy association on the target.
        :param bool force: Ignore any running jobs when preparing to delete a policy.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['service_policy_id', 'local_only', 'force']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_service_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'service_policy_id' is set
        if ('service_policy_id' not in params or
                params['service_policy_id'] is None):
            raise ValueError("Missing the required parameter `service_policy_id` when calling `delete_service_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'service_policy_id' in params:
            path_params['ServicePolicyId'] = params['service_policy_id']  # noqa: E501

        query_params = []
        if 'local_only' in params:
            query_params.append(('local_only', params['local_only']))  # noqa: E501
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/service/policies/{ServicePolicyId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_service_target_policy(self, service_target_policy_id, **kwargs):  # noqa: E501
        """delete_service_target_policy  # noqa: E501

        Break the target association with this cluster for this policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_service_target_policy(service_target_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str service_target_policy_id: Break the target association with this cluster for this policy. (required)
        :param bool force: Ignore any running jobs when preparing to delete the policy target association.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_service_target_policy_with_http_info(service_target_policy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_service_target_policy_with_http_info(service_target_policy_id, **kwargs)  # noqa: E501
            return data

    def delete_service_target_policy_with_http_info(self, service_target_policy_id, **kwargs):  # noqa: E501
        """delete_service_target_policy  # noqa: E501

        Break the target association with this cluster for this policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_service_target_policy_with_http_info(service_target_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str service_target_policy_id: Break the target association with this cluster for this policy. (required)
        :param bool force: Ignore any running jobs when preparing to delete the policy target association.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['service_target_policy_id', 'force']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_service_target_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'service_target_policy_id' is set
        if ('service_target_policy_id' not in params or
                params['service_target_policy_id'] is None):
            raise ValueError("Missing the required parameter `service_target_policy_id` when calling `delete_service_target_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'service_target_policy_id' in params:
            path_params['ServiceTargetPolicyId'] = params['service_target_policy_id']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/service/target/policies/{ServiceTargetPolicyId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_sync_jobs(self, **kwargs):  # noqa: E501
        """delete_sync_jobs  # noqa: E501

        Cancel all SyncIQ jobs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_sync_jobs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_sync_jobs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_sync_jobs_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_sync_jobs_with_http_info(self, **kwargs):  # noqa: E501
        """delete_sync_jobs  # noqa: E501

        Cancel all SyncIQ jobs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_sync_jobs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_sync_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/jobs', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_sync_policies(self, **kwargs):  # noqa: E501
        """delete_sync_policies  # noqa: E501

        Delete all SyncIQ policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_sync_policies(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool local_only: Skip deleting the policy association on the target.
        :param bool force: Ignore any running jobs when preparing to delete a policy.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_sync_policies_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_sync_policies_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_sync_policies_with_http_info(self, **kwargs):  # noqa: E501
        """delete_sync_policies  # noqa: E501

        Delete all SyncIQ policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_sync_policies_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool local_only: Skip deleting the policy association on the target.
        :param bool force: Ignore any running jobs when preparing to delete a policy.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['local_only', 'force']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_sync_policies" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'local_only' in params:
            query_params.append(('local_only', params['local_only']))  # noqa: E501
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/policies', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_sync_policy(self, sync_policy_id, **kwargs):  # noqa: E501
        """delete_sync_policy  # noqa: E501

        Delete a single SyncIQ policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_sync_policy(sync_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sync_policy_id: Delete a single SyncIQ policy. (required)
        :param bool local_only: Skip deleting the policy association on the target.
        :param bool force: Ignore any running jobs when preparing to delete a policy.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_sync_policy_with_http_info(sync_policy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_sync_policy_with_http_info(sync_policy_id, **kwargs)  # noqa: E501
            return data

    def delete_sync_policy_with_http_info(self, sync_policy_id, **kwargs):  # noqa: E501
        """delete_sync_policy  # noqa: E501

        Delete a single SyncIQ policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_sync_policy_with_http_info(sync_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sync_policy_id: Delete a single SyncIQ policy. (required)
        :param bool local_only: Skip deleting the policy association on the target.
        :param bool force: Ignore any running jobs when preparing to delete a policy.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sync_policy_id', 'local_only', 'force']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_sync_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sync_policy_id' is set
        if ('sync_policy_id' not in params or
                params['sync_policy_id'] is None):
            raise ValueError("Missing the required parameter `sync_policy_id` when calling `delete_sync_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sync_policy_id' in params:
            path_params['SyncPolicyId'] = params['sync_policy_id']  # noqa: E501

        query_params = []
        if 'local_only' in params:
            query_params.append(('local_only', params['local_only']))  # noqa: E501
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/policies/{SyncPolicyId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_sync_rule(self, sync_rule_id, **kwargs):  # noqa: E501
        """delete_sync_rule  # noqa: E501

        Delete a single SyncIQ performance rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_sync_rule(sync_rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sync_rule_id: Delete a single SyncIQ performance rule. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_sync_rule_with_http_info(sync_rule_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_sync_rule_with_http_info(sync_rule_id, **kwargs)  # noqa: E501
            return data

    def delete_sync_rule_with_http_info(self, sync_rule_id, **kwargs):  # noqa: E501
        """delete_sync_rule  # noqa: E501

        Delete a single SyncIQ performance rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_sync_rule_with_http_info(sync_rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sync_rule_id: Delete a single SyncIQ performance rule. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sync_rule_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_sync_rule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sync_rule_id' is set
        if ('sync_rule_id' not in params or
                params['sync_rule_id'] is None):
            raise ValueError("Missing the required parameter `sync_rule_id` when calling `delete_sync_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sync_rule_id' in params:
            path_params['SyncRuleId'] = params['sync_rule_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/sync/rules/{SyncRuleId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_sync_rules(self, **kwargs):  # noqa: E501
        """delete_sync_rules  # noqa: E501

        Delete all SyncIQ performance rules or all rules of a specified type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_sync_rules(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: Delete all rules of the specified rule type only.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_sync_rules_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_sync_rules_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_sync_rules_with_http_info(self, **kwargs):  # noqa: E501
        """delete_sync_rules  # noqa: E501

        Delete all SyncIQ performance rules or all rules of a specified type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_sync_rules_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: Delete all rules of the specified rule type only.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_sync_rules" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/sync/rules', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_target_policy(self, target_policy_id, **kwargs):  # noqa: E501
        """delete_target_policy  # noqa: E501

        Break the target association with this cluster for this policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_target_policy(target_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str target_policy_id: Break the target association with this cluster for this policy. (required)
        :param bool force: Ignore any running jobs when preparing to delete the policy target association.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_target_policy_with_http_info(target_policy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_target_policy_with_http_info(target_policy_id, **kwargs)  # noqa: E501
            return data

    def delete_target_policy_with_http_info(self, target_policy_id, **kwargs):  # noqa: E501
        """delete_target_policy  # noqa: E501

        Break the target association with this cluster for this policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_target_policy_with_http_info(target_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str target_policy_id: Break the target association with this cluster for this policy. (required)
        :param bool force: Ignore any running jobs when preparing to delete the policy target association.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['target_policy_id', 'force']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_target_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'target_policy_id' is set
        if ('target_policy_id' not in params or
                params['target_policy_id'] is None):
            raise ValueError("Missing the required parameter `target_policy_id` when calling `delete_target_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'target_policy_id' in params:
            path_params['TargetPolicyId'] = params['target_policy_id']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/target/policies/{TargetPolicyId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_certificates_peer_by_id(self, certificates_peer_id, **kwargs):  # noqa: E501
        """get_certificates_peer_by_id  # noqa: E501

        Retrieve a single trusted SyncIQ TLS certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_certificates_peer_by_id(certificates_peer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str certificates_peer_id: Retrieve a single trusted SyncIQ TLS certificate. (required)
        :return: CertificateAuthority
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_certificates_peer_by_id_with_http_info(certificates_peer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_certificates_peer_by_id_with_http_info(certificates_peer_id, **kwargs)  # noqa: E501
            return data

    def get_certificates_peer_by_id_with_http_info(self, certificates_peer_id, **kwargs):  # noqa: E501
        """get_certificates_peer_by_id  # noqa: E501

        Retrieve a single trusted SyncIQ TLS certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_certificates_peer_by_id_with_http_info(certificates_peer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str certificates_peer_id: Retrieve a single trusted SyncIQ TLS certificate. (required)
        :return: CertificateAuthority
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['certificates_peer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_certificates_peer_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'certificates_peer_id' is set
        if ('certificates_peer_id' not in params or
                params['certificates_peer_id'] is None):
            raise ValueError("Missing the required parameter `certificates_peer_id` when calling `get_certificates_peer_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'certificates_peer_id' in params:
            path_params['CertificatesPeerId'] = params['certificates_peer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/certificates/peer/{CertificatesPeerId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CertificateAuthority',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_certificates_server_by_id(self, certificates_server_id, **kwargs):  # noqa: E501
        """get_certificates_server_by_id  # noqa: E501

        Retrieve a SyncIQ TLS server certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_certificates_server_by_id(certificates_server_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str certificates_server_id: Retrieve a SyncIQ TLS server certificate. (required)
        :return: CertificateServer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_certificates_server_by_id_with_http_info(certificates_server_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_certificates_server_by_id_with_http_info(certificates_server_id, **kwargs)  # noqa: E501
            return data

    def get_certificates_server_by_id_with_http_info(self, certificates_server_id, **kwargs):  # noqa: E501
        """get_certificates_server_by_id  # noqa: E501

        Retrieve a SyncIQ TLS server certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_certificates_server_by_id_with_http_info(certificates_server_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str certificates_server_id: Retrieve a SyncIQ TLS server certificate. (required)
        :return: CertificateServer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['certificates_server_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_certificates_server_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'certificates_server_id' is set
        if ('certificates_server_id' not in params or
                params['certificates_server_id'] is None):
            raise ValueError("Missing the required parameter `certificates_server_id` when calling `get_certificates_server_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'certificates_server_id' in params:
            path_params['CertificatesServerId'] = params['certificates_server_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/certificates/server/{CertificatesServerId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CertificateServer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_history_cpu(self, **kwargs):  # noqa: E501
        """get_history_cpu  # noqa: E501

        List cpu performance data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_history_cpu(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int begin: Begin timestamp for time-series report.
        :param int end: End timestamp for time-series report.
        :return: HistoryFile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_history_cpu_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_history_cpu_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_history_cpu_with_http_info(self, **kwargs):  # noqa: E501
        """get_history_cpu  # noqa: E501

        List cpu performance data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_history_cpu_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int begin: Begin timestamp for time-series report.
        :param int end: End timestamp for time-series report.
        :return: HistoryFile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['begin', 'end']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_history_cpu" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'begin' in params:
            query_params.append(('begin', params['begin']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/sync/history/cpu', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HistoryFile',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_history_file(self, **kwargs):  # noqa: E501
        """get_history_file  # noqa: E501

        List file operations performance data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_history_file(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int begin: Begin timestamp for time-series report.
        :param int end: End timestamp for time-series report.
        :return: HistoryFile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_history_file_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_history_file_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_history_file_with_http_info(self, **kwargs):  # noqa: E501
        """get_history_file  # noqa: E501

        List file operations performance data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_history_file_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int begin: Begin timestamp for time-series report.
        :param int end: End timestamp for time-series report.
        :return: HistoryFile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['begin', 'end']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_history_file" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'begin' in params:
            query_params.append(('begin', params['begin']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/history/file', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HistoryFile',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_history_network(self, **kwargs):  # noqa: E501
        """get_history_network  # noqa: E501

        List network operations performance data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_history_network(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool running_jobs: Receive network history for all currently running SyncIQ jobs.
        :param int end: End timestamp for time-series report.
        :param int start: Begin timestamp for time-series report.
        :param str policy_id: Receive network history for only the given policy.
        :return: HistoryFile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_history_network_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_history_network_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_history_network_with_http_info(self, **kwargs):  # noqa: E501
        """get_history_network  # noqa: E501

        List network operations performance data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_history_network_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool running_jobs: Receive network history for all currently running SyncIQ jobs.
        :param int end: End timestamp for time-series report.
        :param int start: Begin timestamp for time-series report.
        :param str policy_id: Receive network history for only the given policy.
        :return: HistoryFile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['running_jobs', 'end', 'start', 'policy_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_history_network" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'running_jobs' in params:
            query_params.append(('running_jobs', params['running_jobs']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'policy_id' in params:
            query_params.append(('policy_id', params['policy_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/history/network', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HistoryFile',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_history_worker(self, **kwargs):  # noqa: E501
        """get_history_worker  # noqa: E501

        List worker performance data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_history_worker(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int begin: Begin timestamp for time-series report.
        :param int end: End timestamp for time-series report.
        :return: HistoryFile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_history_worker_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_history_worker_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_history_worker_with_http_info(self, **kwargs):  # noqa: E501
        """get_history_worker  # noqa: E501

        List worker performance data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_history_worker_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int begin: Begin timestamp for time-series report.
        :param int end: End timestamp for time-series report.
        :return: HistoryFile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['begin', 'end']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_history_worker" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'begin' in params:
            query_params.append(('begin', params['begin']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/sync/history/worker', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HistoryFile',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_service_policy(self, service_policy_id, **kwargs):  # noqa: E501
        """get_service_policy  # noqa: E501

        View a single SyncIQ service replication policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_service_policy(service_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str service_policy_id: View a single SyncIQ service replication policy. (required)
        :return: ServicePolicies
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_service_policy_with_http_info(service_policy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_service_policy_with_http_info(service_policy_id, **kwargs)  # noqa: E501
            return data

    def get_service_policy_with_http_info(self, service_policy_id, **kwargs):  # noqa: E501
        """get_service_policy  # noqa: E501

        View a single SyncIQ service replication policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_service_policy_with_http_info(service_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str service_policy_id: View a single SyncIQ service replication policy. (required)
        :return: ServicePolicies
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['service_policy_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_service_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'service_policy_id' is set
        if ('service_policy_id' not in params or
                params['service_policy_id'] is None):
            raise ValueError("Missing the required parameter `service_policy_id` when calling `get_service_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'service_policy_id' in params:
            path_params['ServicePolicyId'] = params['service_policy_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/service/policies/{ServicePolicyId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ServicePolicies',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_service_target_policies(self, **kwargs):  # noqa: E501
        """get_service_target_policies  # noqa: E501

        List all SyncIQ target service replication policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_service_target_policies(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str target_path: Filter the returned policies to include only those with this target path.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: TargetPoliciesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_service_target_policies_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_service_target_policies_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_service_target_policies_with_http_info(self, **kwargs):  # noqa: E501
        """get_service_target_policies  # noqa: E501

        List all SyncIQ target service replication policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_service_target_policies_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str target_path: Filter the returned policies to include only those with this target path.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: TargetPoliciesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'target_path', 'limit', 'dir', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_service_target_policies" % key
                )
            params[key] = val
        del params['kwargs']

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `get_service_target_policies`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `get_service_target_policies`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_service_target_policies`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_service_target_policies`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `get_service_target_policies`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_service_target_policies`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_service_target_policies`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'target_path' in params:
            query_params.append(('target_path', params['target_path']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/service/target/policies', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TargetPoliciesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_service_target_policy(self, service_target_policy_id, **kwargs):  # noqa: E501
        """get_service_target_policy  # noqa: E501

        View a single SyncIQ target service replication policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_service_target_policy(service_target_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str service_target_policy_id: View a single SyncIQ target service replication policy. (required)
        :return: TargetPolicies
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_service_target_policy_with_http_info(service_target_policy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_service_target_policy_with_http_info(service_target_policy_id, **kwargs)  # noqa: E501
            return data

    def get_service_target_policy_with_http_info(self, service_target_policy_id, **kwargs):  # noqa: E501
        """get_service_target_policy  # noqa: E501

        View a single SyncIQ target service replication policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_service_target_policy_with_http_info(service_target_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str service_target_policy_id: View a single SyncIQ target service replication policy. (required)
        :return: TargetPolicies
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['service_target_policy_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_service_target_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'service_target_policy_id' is set
        if ('service_target_policy_id' not in params or
                params['service_target_policy_id'] is None):
            raise ValueError("Missing the required parameter `service_target_policy_id` when calling `get_service_target_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'service_target_policy_id' in params:
            path_params['ServiceTargetPolicyId'] = params['service_target_policy_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/service/target/policies/{ServiceTargetPolicyId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TargetPolicies',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sync_job(self, sync_job_id, **kwargs):  # noqa: E501
        """get_sync_job  # noqa: E501

        View a single SyncIQ job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sync_job(sync_job_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sync_job_id: View a single SyncIQ job. (required)
        :return: SyncJobs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_sync_job_with_http_info(sync_job_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_sync_job_with_http_info(sync_job_id, **kwargs)  # noqa: E501
            return data

    def get_sync_job_with_http_info(self, sync_job_id, **kwargs):  # noqa: E501
        """get_sync_job  # noqa: E501

        View a single SyncIQ job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sync_job_with_http_info(sync_job_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sync_job_id: View a single SyncIQ job. (required)
        :return: SyncJobs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sync_job_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sync_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sync_job_id' is set
        if ('sync_job_id' not in params or
                params['sync_job_id'] is None):
            raise ValueError("Missing the required parameter `sync_job_id` when calling `get_sync_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sync_job_id' in params:
            path_params['SyncJobId'] = params['sync_job_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/jobs/{SyncJobId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SyncJobs',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sync_license(self, **kwargs):  # noqa: E501
        """get_sync_license  # noqa: E501

        Retrieve license information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sync_license(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: LicenseLicense
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_sync_license_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_sync_license_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_sync_license_with_http_info(self, **kwargs):  # noqa: E501
        """get_sync_license  # noqa: E501

        Retrieve license information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sync_license_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: LicenseLicense
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sync_license" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/5/sync/license', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LicenseLicense',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sync_policy(self, sync_policy_id, **kwargs):  # noqa: E501
        """get_sync_policy  # noqa: E501

        View a single SyncIQ policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sync_policy(sync_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sync_policy_id: View a single SyncIQ policy. (required)
        :return: SyncPolicies
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_sync_policy_with_http_info(sync_policy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_sync_policy_with_http_info(sync_policy_id, **kwargs)  # noqa: E501
            return data

    def get_sync_policy_with_http_info(self, sync_policy_id, **kwargs):  # noqa: E501
        """get_sync_policy  # noqa: E501

        View a single SyncIQ policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sync_policy_with_http_info(sync_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sync_policy_id: View a single SyncIQ policy. (required)
        :return: SyncPolicies
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sync_policy_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sync_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sync_policy_id' is set
        if ('sync_policy_id' not in params or
                params['sync_policy_id'] is None):
            raise ValueError("Missing the required parameter `sync_policy_id` when calling `get_sync_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sync_policy_id' in params:
            path_params['SyncPolicyId'] = params['sync_policy_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/policies/{SyncPolicyId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SyncPolicies',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sync_report(self, sync_report_id, **kwargs):  # noqa: E501
        """get_sync_report  # noqa: E501

        View a single SyncIQ report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sync_report(sync_report_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sync_report_id: View a single SyncIQ report. (required)
        :return: SyncReports
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_sync_report_with_http_info(sync_report_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_sync_report_with_http_info(sync_report_id, **kwargs)  # noqa: E501
            return data

    def get_sync_report_with_http_info(self, sync_report_id, **kwargs):  # noqa: E501
        """get_sync_report  # noqa: E501

        View a single SyncIQ report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sync_report_with_http_info(sync_report_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sync_report_id: View a single SyncIQ report. (required)
        :return: SyncReports
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sync_report_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sync_report" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sync_report_id' is set
        if ('sync_report_id' not in params or
                params['sync_report_id'] is None):
            raise ValueError("Missing the required parameter `sync_report_id` when calling `get_sync_report`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sync_report_id' in params:
            path_params['SyncReportId'] = params['sync_report_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/reports/{SyncReportId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SyncReports',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sync_reports(self, **kwargs):  # noqa: E501
        """get_sync_reports  # noqa: E501

        Get a list of SyncIQ reports.  By default 1 report is returned per policy, unless otherwise specified by 'reports_per_policy'.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sync_reports(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param int newer_than: Filter the returned reports to include only those whose jobs started more recently than the specified number of days ago.
        :param str policy_name: Filter the returned reports to include only those with this policy name.
        :param str state: Filter the returned reports to include only those whose jobs are in this state.
        :param int limit: Return no more than this many results at once (see resume).
        :param int reports_per_policy: If specified, only the N most recent reports will be returned per policy.  If no other query args are present this argument defaults to 1. 
        :param bool summary: Return a summary rather than entire objects
        :param str dir: The direction of the sort.
        :return: SyncReportsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_sync_reports_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_sync_reports_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_sync_reports_with_http_info(self, **kwargs):  # noqa: E501
        """get_sync_reports  # noqa: E501

        Get a list of SyncIQ reports.  By default 1 report is returned per policy, unless otherwise specified by 'reports_per_policy'.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sync_reports_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param int newer_than: Filter the returned reports to include only those whose jobs started more recently than the specified number of days ago.
        :param str policy_name: Filter the returned reports to include only those with this policy name.
        :param str state: Filter the returned reports to include only those whose jobs are in this state.
        :param int limit: Return no more than this many results at once (see resume).
        :param int reports_per_policy: If specified, only the N most recent reports will be returned per policy.  If no other query args are present this argument defaults to 1. 
        :param bool summary: Return a summary rather than entire objects
        :param str dir: The direction of the sort.
        :return: SyncReportsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'resume', 'newer_than', 'policy_name', 'state', 'limit', 'reports_per_policy', 'summary', 'dir']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sync_reports" % key
                )
            params[key] = val
        del params['kwargs']

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `get_sync_reports`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `get_sync_reports`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_sync_reports`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_sync_reports`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_sync_reports`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_sync_reports`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `get_sync_reports`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'newer_than' in params:
            query_params.append(('newer_than', params['newer_than']))  # noqa: E501
        if 'policy_name' in params:
            query_params.append(('policy_name', params['policy_name']))  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'reports_per_policy' in params:
            query_params.append(('reports_per_policy', params['reports_per_policy']))  # noqa: E501
        if 'summary' in params:
            query_params.append(('summary', params['summary']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/reports', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SyncReportsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sync_rule(self, sync_rule_id, **kwargs):  # noqa: E501
        """get_sync_rule  # noqa: E501

        View a single SyncIQ performance rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sync_rule(sync_rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sync_rule_id: View a single SyncIQ performance rule. (required)
        :return: SyncRules
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_sync_rule_with_http_info(sync_rule_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_sync_rule_with_http_info(sync_rule_id, **kwargs)  # noqa: E501
            return data

    def get_sync_rule_with_http_info(self, sync_rule_id, **kwargs):  # noqa: E501
        """get_sync_rule  # noqa: E501

        View a single SyncIQ performance rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sync_rule_with_http_info(sync_rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sync_rule_id: View a single SyncIQ performance rule. (required)
        :return: SyncRules
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sync_rule_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sync_rule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sync_rule_id' is set
        if ('sync_rule_id' not in params or
                params['sync_rule_id'] is None):
            raise ValueError("Missing the required parameter `sync_rule_id` when calling `get_sync_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sync_rule_id' in params:
            path_params['SyncRuleId'] = params['sync_rule_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/sync/rules/{SyncRuleId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SyncRules',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sync_settings(self, **kwargs):  # noqa: E501
        """get_sync_settings  # noqa: E501

        Retrieve the global SyncIQ settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sync_settings(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SyncSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_sync_settings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_sync_settings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_sync_settings_with_http_info(self, **kwargs):  # noqa: E501
        """get_sync_settings  # noqa: E501

        Retrieve the global SyncIQ settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sync_settings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SyncSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sync_settings" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SyncSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_target_policies(self, **kwargs):  # noqa: E501
        """get_target_policies  # noqa: E501

        List all SyncIQ target policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_target_policies(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str target_path: Filter the returned policies to include only those with this target path.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: TargetPoliciesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_target_policies_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_target_policies_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_target_policies_with_http_info(self, **kwargs):  # noqa: E501
        """get_target_policies  # noqa: E501

        List all SyncIQ target policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_target_policies_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str target_path: Filter the returned policies to include only those with this target path.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: TargetPoliciesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'target_path', 'limit', 'dir', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_target_policies" % key
                )
            params[key] = val
        del params['kwargs']

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `get_target_policies`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `get_target_policies`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_target_policies`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_target_policies`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `get_target_policies`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_target_policies`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_target_policies`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'target_path' in params:
            query_params.append(('target_path', params['target_path']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/target/policies', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TargetPoliciesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_target_policy(self, target_policy_id, **kwargs):  # noqa: E501
        """get_target_policy  # noqa: E501

        View a single SyncIQ target policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_target_policy(target_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str target_policy_id: View a single SyncIQ target policy. (required)
        :return: TargetPolicies
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_target_policy_with_http_info(target_policy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_target_policy_with_http_info(target_policy_id, **kwargs)  # noqa: E501
            return data

    def get_target_policy_with_http_info(self, target_policy_id, **kwargs):  # noqa: E501
        """get_target_policy  # noqa: E501

        View a single SyncIQ target policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_target_policy_with_http_info(target_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str target_policy_id: View a single SyncIQ target policy. (required)
        :return: TargetPolicies
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['target_policy_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_target_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'target_policy_id' is set
        if ('target_policy_id' not in params or
                params['target_policy_id'] is None):
            raise ValueError("Missing the required parameter `target_policy_id` when calling `get_target_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'target_policy_id' in params:
            path_params['TargetPolicyId'] = params['target_policy_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/target/policies/{TargetPolicyId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TargetPolicies',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_target_report(self, target_report_id, **kwargs):  # noqa: E501
        """get_target_report  # noqa: E501

        View a single SyncIQ target report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_target_report(target_report_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str target_report_id: View a single SyncIQ target report. (required)
        :return: TargetReports
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_target_report_with_http_info(target_report_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_target_report_with_http_info(target_report_id, **kwargs)  # noqa: E501
            return data

    def get_target_report_with_http_info(self, target_report_id, **kwargs):  # noqa: E501
        """get_target_report  # noqa: E501

        View a single SyncIQ target report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_target_report_with_http_info(target_report_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str target_report_id: View a single SyncIQ target report. (required)
        :return: TargetReports
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['target_report_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_target_report" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'target_report_id' is set
        if ('target_report_id' not in params or
                params['target_report_id'] is None):
            raise ValueError("Missing the required parameter `target_report_id` when calling `get_target_report`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'target_report_id' in params:
            path_params['TargetReportId'] = params['target_report_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/target/reports/{TargetReportId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TargetReports',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_target_reports(self, **kwargs):  # noqa: E501
        """get_target_reports  # noqa: E501

        Get a list of SyncIQ target reports.  By default 1 report is returned per policy, unless otherwise specified by 'reports_per_policy'.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_target_reports(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param int newer_than: Filter the returned reports to include only those whose jobs started more recently than the specified number of days ago.
        :param str policy_name: Filter the returned reports to include only those with this policy name.
        :param str state: Filter the returned reports to include only those whose jobs are in this state.
        :param int limit: Return no more than this many results at once (see resume).
        :param int reports_per_policy: If specified, only the N most recent reports will be returned per policy.  If no other query args are present this argument defaults to 1. 
        :param bool summary: Return a summary rather than entire objects.
        :param str dir: The direction of the sort.
        :return: TargetReportsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_target_reports_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_target_reports_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_target_reports_with_http_info(self, **kwargs):  # noqa: E501
        """get_target_reports  # noqa: E501

        Get a list of SyncIQ target reports.  By default 1 report is returned per policy, unless otherwise specified by 'reports_per_policy'.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_target_reports_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param int newer_than: Filter the returned reports to include only those whose jobs started more recently than the specified number of days ago.
        :param str policy_name: Filter the returned reports to include only those with this policy name.
        :param str state: Filter the returned reports to include only those whose jobs are in this state.
        :param int limit: Return no more than this many results at once (see resume).
        :param int reports_per_policy: If specified, only the N most recent reports will be returned per policy.  If no other query args are present this argument defaults to 1. 
        :param bool summary: Return a summary rather than entire objects.
        :param str dir: The direction of the sort.
        :return: TargetReportsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'resume', 'newer_than', 'policy_name', 'state', 'limit', 'reports_per_policy', 'summary', 'dir']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_target_reports" % key
                )
            params[key] = val
        del params['kwargs']

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `get_target_reports`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `get_target_reports`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_target_reports`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_target_reports`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_target_reports`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_target_reports`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `get_target_reports`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'newer_than' in params:
            query_params.append(('newer_than', params['newer_than']))  # noqa: E501
        if 'policy_name' in params:
            query_params.append(('policy_name', params['policy_name']))  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'reports_per_policy' in params:
            query_params.append(('reports_per_policy', params['reports_per_policy']))  # noqa: E501
        if 'summary' in params:
            query_params.append(('summary', params['summary']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/target/reports', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TargetReportsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_certificates_peer(self, **kwargs):  # noqa: E501
        """list_certificates_peer  # noqa: E501

        Retrieve a list of all trusted SyncIQ peer TLS certificates.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_certificates_peer(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: CertificateAuthorityExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_certificates_peer_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_certificates_peer_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_certificates_peer_with_http_info(self, **kwargs):  # noqa: E501
        """list_certificates_peer  # noqa: E501

        Retrieve a list of all trusted SyncIQ peer TLS certificates.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_certificates_peer_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: CertificateAuthorityExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'limit', 'dir', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_certificates_peer" % key
                )
            params[key] = val
        del params['kwargs']

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_certificates_peer`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_certificates_peer`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_certificates_peer`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_certificates_peer`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_certificates_peer`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_certificates_peer`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_certificates_peer`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/certificates/peer', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CertificateAuthorityExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_certificates_server(self, **kwargs):  # noqa: E501
        """list_certificates_server  # noqa: E501

        Retrieve a list of all SyncIQ TLS server certificates.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_certificates_server(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: CertificateServerExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_certificates_server_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_certificates_server_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_certificates_server_with_http_info(self, **kwargs):  # noqa: E501
        """list_certificates_server  # noqa: E501

        Retrieve a list of all SyncIQ TLS server certificates.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_certificates_server_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: CertificateServerExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'limit', 'dir', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_certificates_server" % key
                )
            params[key] = val
        del params['kwargs']

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_certificates_server`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_certificates_server`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_certificates_server`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_certificates_server`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_certificates_server`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_certificates_server`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_certificates_server`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/certificates/server', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CertificateServerExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_service_policies(self, **kwargs):  # noqa: E501
        """list_service_policies  # noqa: E501

        List all SyncIQ service replication policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_service_policies(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param bool summary: Return a summary rather than entire objects.
        :param int limit: Return no more than this many results at once (see resume).
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :param str dir: The direction of the sort.
        :return: ServicePoliciesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_service_policies_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_service_policies_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_service_policies_with_http_info(self, **kwargs):  # noqa: E501
        """list_service_policies  # noqa: E501

        List all SyncIQ service replication policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_service_policies_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param bool summary: Return a summary rather than entire objects.
        :param int limit: Return no more than this many results at once (see resume).
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :param str dir: The direction of the sort.
        :return: ServicePoliciesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'resume', 'summary', 'limit', 'scope', 'dir']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_service_policies" % key
                )
            params[key] = val
        del params['kwargs']

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_service_policies`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_service_policies`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_service_policies`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_service_policies`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_service_policies`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_service_policies`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('scope' in params and
                len(params['scope']) > 255):
            raise ValueError("Invalid value for parameter `scope` when calling `list_service_policies`, length must be less than or equal to `255`")  # noqa: E501
        if ('scope' in params and
                len(params['scope']) < 0):
            raise ValueError("Invalid value for parameter `scope` when calling `list_service_policies`, length must be greater than or equal to `0`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_service_policies`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'summary' in params:
            query_params.append(('summary', params['summary']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/service/policies', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ServicePoliciesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_sync_jobs(self, **kwargs):  # noqa: E501
        """list_sync_jobs  # noqa: E501

        Get a list of SyncIQ jobs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_sync_jobs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str state: The state of the job.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: SyncJobsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_sync_jobs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_sync_jobs_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_sync_jobs_with_http_info(self, **kwargs):  # noqa: E501
        """list_sync_jobs  # noqa: E501

        Get a list of SyncIQ jobs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_sync_jobs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str state: The state of the job.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: SyncJobsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'state', 'limit', 'dir', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_sync_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_sync_jobs`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_sync_jobs`, length must be greater than or equal to `0`")  # noqa: E501
        if ('state' in params and
                len(params['state']) > 255):
            raise ValueError("Invalid value for parameter `state` when calling `list_sync_jobs`, length must be less than or equal to `255`")  # noqa: E501
        if ('state' in params and
                len(params['state']) < 0):
            raise ValueError("Invalid value for parameter `state` when calling `list_sync_jobs`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_sync_jobs`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_sync_jobs`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_sync_jobs`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_sync_jobs`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_sync_jobs`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/jobs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SyncJobsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_sync_policies(self, **kwargs):  # noqa: E501
        """list_sync_policies  # noqa: E501

        List all SyncIQ policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_sync_policies(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param bool summary: Return a summary rather than entire objects.
        :param int limit: Return no more than this many results at once (see resume).
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :param str dir: The direction of the sort.
        :return: SyncPoliciesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_sync_policies_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_sync_policies_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_sync_policies_with_http_info(self, **kwargs):  # noqa: E501
        """list_sync_policies  # noqa: E501

        List all SyncIQ policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_sync_policies_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param bool summary: Return a summary rather than entire objects.
        :param int limit: Return no more than this many results at once (see resume).
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :param str dir: The direction of the sort.
        :return: SyncPoliciesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'resume', 'summary', 'limit', 'scope', 'dir']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_sync_policies" % key
                )
            params[key] = val
        del params['kwargs']

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_sync_policies`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_sync_policies`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_sync_policies`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_sync_policies`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_sync_policies`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_sync_policies`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('scope' in params and
                len(params['scope']) > 255):
            raise ValueError("Invalid value for parameter `scope` when calling `list_sync_policies`, length must be less than or equal to `255`")  # noqa: E501
        if ('scope' in params and
                len(params['scope']) < 0):
            raise ValueError("Invalid value for parameter `scope` when calling `list_sync_policies`, length must be greater than or equal to `0`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_sync_policies`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'summary' in params:
            query_params.append(('summary', params['summary']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/policies', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SyncPoliciesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_sync_reports_rotate(self, **kwargs):  # noqa: E501
        """list_sync_reports_rotate  # noqa: E501

        Whether the rotation is still running or not.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_sync_reports_rotate(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SyncReportsRotate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_sync_reports_rotate_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_sync_reports_rotate_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_sync_reports_rotate_with_http_info(self, **kwargs):  # noqa: E501
        """list_sync_reports_rotate  # noqa: E501

        Whether the rotation is still running or not.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_sync_reports_rotate_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SyncReportsRotate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_sync_reports_rotate" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/sync/reports-rotate', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SyncReportsRotate',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_sync_rules(self, **kwargs):  # noqa: E501
        """list_sync_rules  # noqa: E501

        List all SyncIQ performance rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_sync_rules(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str type: Filter the returned rules to include only those with this rule type.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: SyncRulesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_sync_rules_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_sync_rules_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_sync_rules_with_http_info(self, **kwargs):  # noqa: E501
        """list_sync_rules  # noqa: E501

        List all SyncIQ performance rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_sync_rules_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str type: Filter the returned rules to include only those with this rule type.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: SyncRulesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'type', 'limit', 'dir', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_sync_rules" % key
                )
            params[key] = val
        del params['kwargs']

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_sync_rules`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_sync_rules`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_sync_rules`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_sync_rules`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_sync_rules`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_sync_rules`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_sync_rules`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/sync/rules', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SyncRulesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_certificates_peer_by_id(self, certificates_peer_id_params, certificates_peer_id, **kwargs):  # noqa: E501
        """update_certificates_peer_by_id  # noqa: E501

        Modify a trusted SyncIQ TLS certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_certificates_peer_by_id(certificates_peer_id_params, certificates_peer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CertificateServerIdParams certificates_peer_id_params: (required)
        :param str certificates_peer_id: Modify a trusted SyncIQ TLS certificate. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_certificates_peer_by_id_with_http_info(certificates_peer_id_params, certificates_peer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_certificates_peer_by_id_with_http_info(certificates_peer_id_params, certificates_peer_id, **kwargs)  # noqa: E501
            return data

    def update_certificates_peer_by_id_with_http_info(self, certificates_peer_id_params, certificates_peer_id, **kwargs):  # noqa: E501
        """update_certificates_peer_by_id  # noqa: E501

        Modify a trusted SyncIQ TLS certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_certificates_peer_by_id_with_http_info(certificates_peer_id_params, certificates_peer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CertificateServerIdParams certificates_peer_id_params: (required)
        :param str certificates_peer_id: Modify a trusted SyncIQ TLS certificate. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['certificates_peer_id_params', 'certificates_peer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_certificates_peer_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'certificates_peer_id_params' is set
        if ('certificates_peer_id_params' not in params or
                params['certificates_peer_id_params'] is None):
            raise ValueError("Missing the required parameter `certificates_peer_id_params` when calling `update_certificates_peer_by_id`")  # noqa: E501
        # verify the required parameter 'certificates_peer_id' is set
        if ('certificates_peer_id' not in params or
                params['certificates_peer_id'] is None):
            raise ValueError("Missing the required parameter `certificates_peer_id` when calling `update_certificates_peer_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'certificates_peer_id' in params:
            path_params['CertificatesPeerId'] = params['certificates_peer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'certificates_peer_id_params' in params:
            body_params = params['certificates_peer_id_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/certificates/peer/{CertificatesPeerId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_certificates_server_by_id(self, certificates_server_id_params, certificates_server_id, **kwargs):  # noqa: E501
        """update_certificates_server_by_id  # noqa: E501

        Modify a SyncIQ TLS server certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_certificates_server_by_id(certificates_server_id_params, certificates_server_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CertificateServerIdParams certificates_server_id_params: (required)
        :param str certificates_server_id: Modify a SyncIQ TLS server certificate. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_certificates_server_by_id_with_http_info(certificates_server_id_params, certificates_server_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_certificates_server_by_id_with_http_info(certificates_server_id_params, certificates_server_id, **kwargs)  # noqa: E501
            return data

    def update_certificates_server_by_id_with_http_info(self, certificates_server_id_params, certificates_server_id, **kwargs):  # noqa: E501
        """update_certificates_server_by_id  # noqa: E501

        Modify a SyncIQ TLS server certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_certificates_server_by_id_with_http_info(certificates_server_id_params, certificates_server_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CertificateServerIdParams certificates_server_id_params: (required)
        :param str certificates_server_id: Modify a SyncIQ TLS server certificate. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['certificates_server_id_params', 'certificates_server_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_certificates_server_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'certificates_server_id_params' is set
        if ('certificates_server_id_params' not in params or
                params['certificates_server_id_params'] is None):
            raise ValueError("Missing the required parameter `certificates_server_id_params` when calling `update_certificates_server_by_id`")  # noqa: E501
        # verify the required parameter 'certificates_server_id' is set
        if ('certificates_server_id' not in params or
                params['certificates_server_id'] is None):
            raise ValueError("Missing the required parameter `certificates_server_id` when calling `update_certificates_server_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'certificates_server_id' in params:
            path_params['CertificatesServerId'] = params['certificates_server_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'certificates_server_id_params' in params:
            body_params = params['certificates_server_id_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/certificates/server/{CertificatesServerId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_service_policy(self, service_policy, service_policy_id, **kwargs):  # noqa: E501
        """update_service_policy  # noqa: E501

        Modify a single SyncIQ service replication policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_service_policy(service_policy, service_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ServicePolicy service_policy: (required)
        :param str service_policy_id: Modify a single SyncIQ service replication policy. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_service_policy_with_http_info(service_policy, service_policy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_service_policy_with_http_info(service_policy, service_policy_id, **kwargs)  # noqa: E501
            return data

    def update_service_policy_with_http_info(self, service_policy, service_policy_id, **kwargs):  # noqa: E501
        """update_service_policy  # noqa: E501

        Modify a single SyncIQ service replication policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_service_policy_with_http_info(service_policy, service_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ServicePolicy service_policy: (required)
        :param str service_policy_id: Modify a single SyncIQ service replication policy. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['service_policy', 'service_policy_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_service_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'service_policy' is set
        if ('service_policy' not in params or
                params['service_policy'] is None):
            raise ValueError("Missing the required parameter `service_policy` when calling `update_service_policy`")  # noqa: E501
        # verify the required parameter 'service_policy_id' is set
        if ('service_policy_id' not in params or
                params['service_policy_id'] is None):
            raise ValueError("Missing the required parameter `service_policy_id` when calling `update_service_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'service_policy_id' in params:
            path_params['ServicePolicyId'] = params['service_policy_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'service_policy' in params:
            body_params = params['service_policy']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/service/policies/{ServicePolicyId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_sync_job(self, sync_job, sync_job_id, **kwargs):  # noqa: E501
        """update_sync_job  # noqa: E501

        Perform an action (pause, cancel, etc...) on a single job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_sync_job(sync_job, sync_job_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SyncJob sync_job: (required)
        :param str sync_job_id: Perform an action (pause, cancel, etc...) on a single job. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_sync_job_with_http_info(sync_job, sync_job_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_sync_job_with_http_info(sync_job, sync_job_id, **kwargs)  # noqa: E501
            return data

    def update_sync_job_with_http_info(self, sync_job, sync_job_id, **kwargs):  # noqa: E501
        """update_sync_job  # noqa: E501

        Perform an action (pause, cancel, etc...) on a single job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_sync_job_with_http_info(sync_job, sync_job_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SyncJob sync_job: (required)
        :param str sync_job_id: Perform an action (pause, cancel, etc...) on a single job. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sync_job', 'sync_job_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_sync_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sync_job' is set
        if ('sync_job' not in params or
                params['sync_job'] is None):
            raise ValueError("Missing the required parameter `sync_job` when calling `update_sync_job`")  # noqa: E501
        # verify the required parameter 'sync_job_id' is set
        if ('sync_job_id' not in params or
                params['sync_job_id'] is None):
            raise ValueError("Missing the required parameter `sync_job_id` when calling `update_sync_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sync_job_id' in params:
            path_params['SyncJobId'] = params['sync_job_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'sync_job' in params:
            body_params = params['sync_job']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/jobs/{SyncJobId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_sync_policy(self, sync_policy, sync_policy_id, **kwargs):  # noqa: E501
        """update_sync_policy  # noqa: E501

        Modify a single SyncIQ policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_sync_policy(sync_policy, sync_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SyncPolicy sync_policy: (required)
        :param str sync_policy_id: Modify a single SyncIQ policy. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_sync_policy_with_http_info(sync_policy, sync_policy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_sync_policy_with_http_info(sync_policy, sync_policy_id, **kwargs)  # noqa: E501
            return data

    def update_sync_policy_with_http_info(self, sync_policy, sync_policy_id, **kwargs):  # noqa: E501
        """update_sync_policy  # noqa: E501

        Modify a single SyncIQ policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_sync_policy_with_http_info(sync_policy, sync_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SyncPolicy sync_policy: (required)
        :param str sync_policy_id: Modify a single SyncIQ policy. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sync_policy', 'sync_policy_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_sync_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sync_policy' is set
        if ('sync_policy' not in params or
                params['sync_policy'] is None):
            raise ValueError("Missing the required parameter `sync_policy` when calling `update_sync_policy`")  # noqa: E501
        # verify the required parameter 'sync_policy_id' is set
        if ('sync_policy_id' not in params or
                params['sync_policy_id'] is None):
            raise ValueError("Missing the required parameter `sync_policy_id` when calling `update_sync_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sync_policy_id' in params:
            path_params['SyncPolicyId'] = params['sync_policy_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'sync_policy' in params:
            body_params = params['sync_policy']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/policies/{SyncPolicyId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_sync_rule(self, sync_rule, sync_rule_id, **kwargs):  # noqa: E501
        """update_sync_rule  # noqa: E501

        Modify a single SyncIQ performance rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_sync_rule(sync_rule, sync_rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SyncRule sync_rule: (required)
        :param str sync_rule_id: Modify a single SyncIQ performance rule. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_sync_rule_with_http_info(sync_rule, sync_rule_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_sync_rule_with_http_info(sync_rule, sync_rule_id, **kwargs)  # noqa: E501
            return data

    def update_sync_rule_with_http_info(self, sync_rule, sync_rule_id, **kwargs):  # noqa: E501
        """update_sync_rule  # noqa: E501

        Modify a single SyncIQ performance rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_sync_rule_with_http_info(sync_rule, sync_rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SyncRule sync_rule: (required)
        :param str sync_rule_id: Modify a single SyncIQ performance rule. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sync_rule', 'sync_rule_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_sync_rule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sync_rule' is set
        if ('sync_rule' not in params or
                params['sync_rule'] is None):
            raise ValueError("Missing the required parameter `sync_rule` when calling `update_sync_rule`")  # noqa: E501
        # verify the required parameter 'sync_rule_id' is set
        if ('sync_rule_id' not in params or
                params['sync_rule_id'] is None):
            raise ValueError("Missing the required parameter `sync_rule_id` when calling `update_sync_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sync_rule_id' in params:
            path_params['SyncRuleId'] = params['sync_rule_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'sync_rule' in params:
            body_params = params['sync_rule']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/sync/rules/{SyncRuleId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_sync_settings(self, sync_settings, **kwargs):  # noqa: E501
        """update_sync_settings  # noqa: E501

        Modify the global SyncIQ settings.  All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_sync_settings(sync_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SyncSettingsExtended sync_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_sync_settings_with_http_info(sync_settings, **kwargs)  # noqa: E501
        else:
            (data) = self.update_sync_settings_with_http_info(sync_settings, **kwargs)  # noqa: E501
            return data

    def update_sync_settings_with_http_info(self, sync_settings, **kwargs):  # noqa: E501
        """update_sync_settings  # noqa: E501

        Modify the global SyncIQ settings.  All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_sync_settings_with_http_info(sync_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SyncSettingsExtended sync_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sync_settings']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_sync_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sync_settings' is set
        if ('sync_settings' not in params or
                params['sync_settings'] is None):
            raise ValueError("Missing the required parameter `sync_settings` when calling `update_sync_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'sync_settings' in params:
            body_params = params['sync_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/sync/settings', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
