# -----------------------------------------------------------------------------
# System Imports
# -----------------------------------------------------------------------------

import re

# -----------------------------------------------------------------------------
# Exports
# -----------------------------------------------------------------------------

__all__ = ["make_domain_remover"]


# -----------------------------------------------------------------------------
#
#                              CODE BEGINS
#
# -----------------------------------------------------------------------------


def make_domain_remover(domain_names):
    any_domain = "|".join(map(re.escape, domain_names))
    sub = re.compile(any_domain).sub

    def remover(value):
        return sub(repl="", string=value)

    return remover
