"""
Parameers for Dubbeldam force field.
"""
Dub_atoms = {
        # epsilon /kB, sig /A, charge /a.u.
    "Zn"    :(    0.42  ,   2.7 ,  1.275),
    "Oa"    :(  700.0   ,   2.98, -1.5  ),
    "Ob"    :(   70.5   ,   3.11, -0.6  ),
    "Ca"    :(   47.0   ,   3.74,  0.475),
    "Cb"    :(   47.86  ,   3.47,  0.125),
    "Cc"    :(   47.86  ,   3.47, -0.15 ),
    "Cd"    :(   47.86  ,   3.47, -0.15 ),
    "Ce"    :(   47.86  ,   3.47,  0.0  ),
    "Cf"    :(   47.86  ,   3.47,  0.0  ),
    "Cf"    :(   47.86  ,   3.47, -0.15 ),
    "Ha"    :(    7.65  ,   2.85,  0.15 ),
    "Hb"    :(    7.65  ,   2.85,  0.15 ),
    "Hc"    :(    7.65  ,   2.85,  0.15 )
}


Dub_bonds = {
#FF_type    k /kB     r /A
    "Ob_Ca" :(   543840.0   ,   1.27 ),
    "Ca_Cb" :(   353750.0   ,   1.44 ),
    "Cb_Cc" :(   483414.0   ,   1.365),
    "Cc_Cc" :(   483414.0   ,   1.365),
    "Cc_Ha" :(   366000.0   ,   0.95 ),
    "Cc_Cd" :(   483414.0   ,   1.365),
    "Cd_Ce" :(   483414.0   ,   1.365),
    "Ce_Ce" :(   483414.0   ,   1.365),
    "Cd_Hb" :(   366000.0   ,   0.95 ),
    "Ce_Cf" :(   483414.0   ,   1.46 ),
    "Cc_Ha" :(   366000.0   ,   0.95 ),
    "Cg_Cg" :(   483414.0   ,   1.365),
    "Cg_Hc" :(   366000.0   ,   0.95 )
}

# FF_type   k /kB  theta0 /deg
Dub_angles = {
    "Ob_Ca_Ob" : (   135960.0    , 132),
    "Ob_Ca_Cb" : (   54882.0     , 114),
    "Ca_Cb_Cc" : (   34927.0     , 120),
    "Cc_Cb_Cc" : (   90640.0     , 120),
    "Cb_Cc_Cd" : (   90640.0     , 120),
    "Cc_Cc_Cb" : (   90640.0     , 120),
    "Cc_Cb_Cc" : (   90640.0     , 120),
    "Cc_Cd_Ce" : (   90640.0     , 120),
    "Cd_Ce_Cd" : (   90640.0     , 120),
    "Cd_Ce_Ce" : (   90640.0     , 120),
    "Cd_Ce_Cf" : (   90640.0     , 120),
    "Ce_Cf_Cg" : (   90640.0     , 120),
    "Cf_Cg_Cg" : (   90640.0     , 120),
    "Cg_Cf_Cg" : (   90640.0     , 120),
    "Cb_Cc_Ha" : (   37263.0     , 120),
    "Cc_Cc_Ha" : (   37263.0     , 120),
    "Cd_Cc_Ha" : (   37263.0     , 120),
    "Cc_Cd_Hb" : (   37263.0     , 120),
    "Ce_Cd_Hb" : (   37263.0     , 120),
    "Cf_Cg_Hc" : (   37263.0     , 120),
    "Cg_Cg_Hc" : (   37263.0     , 120)
}

Dub_dihedrals = {
    # k /kB, phi0 /deg, m(-)
    "Ob_Ca_Cb_Cc" : (   1258.9   , 180   , 2),
    "Ca_Cb_Cc_Cd" : (   1510.7   , 180   , 2),
    "Ca_Cb_Cc_Ha" : (   1510.7   , 180   , 2),
    "Cb_Cc_Cd_Hb" : (   1510.7   , 180   , 2),
    "Cb_Cc_Cd_Ce" : (   1510.7   , 180   , 2),
    "Cc_Cb_Cc_Cd" : (   1510.7   , 180   , 2),
    "Cc_Cb_Cc_Ha" : (   1510.7   , 180   , 2),
    "Cc_Cd_Ce_Cd" : (   1510.7   , 180   , 2),
    "Cc_Cd_Ce_Ce" : (   1510.7   , 180   , 2),
    "Cc_Cd_Ce_Cf" : (   1510.7   , 180   , 2),
    "Cd_Ce_Cd_Hb" : (   1510.7   , 180   , 2),
    "Cd_Ce_Ce_Cd" : (   1510.7   , 180   , 2),
    "Ce_Cd_Cc_Ha" : (   1510.7   , 180   , 2),
    "Ce_Ce_Cd_Hb" : (   1510.7   , 180   , 2),
    "Hb_Cd_Cc_Ha" : (   1510.7   , 180   , 2),
    "Ca_Cb_Cc_Cc" : (   1510.7   , 180   , 2),
    "Cb_Cc_Cc_Ha" : (   1510.7   , 180   , 2),
    "Cb_Cc_Cc_Cb" : (   1510.7   , 180   , 2),
    "Cc_Cb_Cc_Cc" : (   1510.7   , 180   , 2),
    "Ha_Cc_Cb_Cc" : (   1510.7   , 180   , 2),
    "Ha_Cc_Cc_Ha" : (   1510.7   , 180   , 2),
    "Ha_Cb_Cc_Ha" : (   1510.7   , 180   , 2),
    "Cd_Ce_Cf_Cg" : (   1510.7   , 180   , 2),
    "Ce_Cf_Cg_Hc" : (   1510.7   , 180   , 2),
    "Ce_Cf_Cg_Cg" : (   1510.7   , 180   , 2),
    "Cf_Ce_Cd_Hb" : (   1510.7   , 180   , 2),
    "Cf_Cg_Cg_Hc" : (   1510.7   , 180   , 2),
    "Cf_Cg_Cg_Cf" : (   1510.7   , 180   , 2),
    "Cg_Cf_Cg_Hc" : (   1510.7   , 180   , 2),
    "Cg_Cf_Cg_Cg" : (   1510.7   , 180   , 2),
    "Ha_Cc_Cd_Hb" : (   1510.7   , 180   , 2),
    "Hc_Cg_Cg_Hc" : (   1510.7   , 180   , 2)
}

Dub_impropers = {
    # k /kB, phi0 /deg, m(-)
    "Ca_Cb_Cc_Cc" : (   5035.6   , 180   , 2),
    "Cb_Ca_Ob_Ob" : (   5035.6   , 180   , 2), # I think there is a round-off for IRMOF-1 to 5036 vs IRMOF-10 and 16. I'll eat my shorts if the .4 difference is important.
    "Cc_Cb_Cc_Ca" : (   5037.0   , 180   , 2),
    "Cb_Cc_Cc_Ha" : (    186.3   , 180   , 2),
    "Cc_Cd_Ce_Hb" : (    186.3   , 180   , 2),
    "Cb_Cc_Cd_Ha" : (    186.3   , 180   , 2),
    "Cd_Ce_Cd_Ce" : (    186.3   , 180   , 2),
    "Cd_Ce_Cd_Cf" : (    186.3   , 180   , 2),
    "Ce_Cf_Cg_Cg" : (    186.3   , 180   , 2),
    "Cf_Cg_Cg_Hc" : (    186.3   , 180   , 2)
}
