# ahp_graph - Python Attributed Hierarchical Port Graph
AHP Graphs - https://arxiv.org/pdf/1802.06492.pdf

This "noTyping" branch works with older versions of Python (like 3.6)

### Ubuntu apt packages:
```Bash
apt install graphviz libgraphviz-dev
```
### RHEL/CentOS yum packages:
```Bash
yum install graphviz graphviz-devel
```
### Python3 packages:
```Bash
python3 -m pip install pygraphviz orjson
```

## Useful Tips
- Assembly names are automatically prefixed to the expanded devices names when the graph is flattened
- Besides graph construction, the main features that ahp_graph provides are several outputs
  - `SSTGraph.build()` will immediately turn your graph into SST components and begin a simulation
  - `SSTGraph.write_json()` will output the graph along with parameters in JSON format
  - `DeviceGraph.write_dot()` will output the graph in DOT format and optionally draw SVGs with them
- All output generated by ahp_graph goes into a folder called 'output'
  - This is for the `SSTGraph.write_json()` and `DeviceGraph.write_dot()` functions
- SST global parameters are set by adding things to the DeviceGraph attr field
- SST component parameters are set by adding things to the Device attr field
- You can still do normal SST Python things (examples below):
  - `sst.setProgramOption()`
  - `sst.setStatisticLoadLevel()`
  - `sst.setStatisticOutput()`
- `SSTGraph.build()` returns a dictionary of devices with their name as the key
  - You can use this to enable statistics for devices after they are created
- If you plan to build the graph with ahp_graph partitioning and run with MPI, remember to include the `--parallel-load=SINGLE` flag to sst
  - `--parallel-load` by default will work with multiple unique files
  - ahp_graph can generate the graph for each rank using a single file, so it needs the value 'SINGLE'
- By default sst grabs all command line parameters
  - You can pass parameters to the python script by putting `-- ` before your script parameters
