/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.types;

import com.jmatio.types.MLNumericArray;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MLSparse
extends MLNumericArray<Double> {
    int nzmax;
    private Set<IndexMN> indexSet;
    private Map<IndexMN, Double> real;
    private Map<IndexMN, Double> imaginary;

    public MLSparse(String name, int[] dims, int attributes, int nzmax) {
        super(name, dims, 5, attributes);
        this.nzmax = nzmax;
        this.real = new LinkedHashMap<IndexMN, Double>();
        this.imaginary = new LinkedHashMap<IndexMN, Double>();
        this.indexSet = new LinkedHashSet<IndexMN>();
    }

    public int getMaxNZ() {
        return this.nzmax;
    }

    public int[] getIR() {
        int[] ir = new int[this.nzmax];
        int i = 0;
        for (IndexMN index : this.indexSet) {
            ir[i++] = index.m;
        }
        return ir;
    }

    public int[] getJC() {
        int[] jc = new int[this.getN() + 1];
        int[] tmp = new int[this.nzmax];
        int i = 0;
        for (IndexMN index : this.indexSet) {
            tmp[i++] = index.n;
        }
        int c = 0;
        int k = 0;
        while (k < jc.length - 1) {
            if (k < tmp.length) {
                c = tmp[k];
            }
            jc[k] = c;
            ++k;
        }
        jc[jc.length - 1] = this.nzmax;
        return jc;
    }

    public Double[] createArray(int m, int n) {
        return null;
    }

    @Override
    public Double getReal(int m, int n) {
        IndexMN i = new IndexMN(m, n);
        if (this.real.containsKey(i)) {
            return this.real.get(i);
        }
        return new Double(0.0);
    }

    @Override
    public void setReal(Double value, int m, int n) {
        IndexMN i = new IndexMN(m, n);
        this.indexSet.add(i);
        this.real.put(i, value);
    }

    @Override
    public void setReal(Double value, int index) {
        throw new IllegalArgumentException("Can't set Sparse array elements by index. Please use setReal(Double value, int m, int n) instead.");
    }

    @Override
    public void setImaginary(Double value, int m, int n) {
        IndexMN i = new IndexMN(m, n);
        this.indexSet.add(i);
        this.imaginary.put(new IndexMN(m, n), value);
    }

    @Override
    public void setImaginary(Double value, int index) {
        throw new IllegalArgumentException("Can't set Sparse array elements by index. Please use setImaginary(Double value, int m, int n) instead.");
    }

    @Override
    public Double getImaginary(int m, int n) {
        IndexMN i = new IndexMN(m, n);
        if (this.imaginary.containsKey(i)) {
            return this.imaginary.get(i);
        }
        return new Double(0.0);
    }

    public Double[] exportReal() {
        Double[] ad = new Double[this.nzmax];
        int i = 0;
        for (Double d : this.real.values()) {
            ad[i++] = d;
        }
        return ad;
    }

    public Double[] exportImaginary() {
        Double[] ad = new Double[this.nzmax];
        int i = 0;
        for (Double d : this.imaginary.values()) {
            ad[i++] = d;
        }
        return ad;
    }

    @Override
    public String contentToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.name) + " = \n");
        for (IndexMN i : this.indexSet) {
            sb.append("\t(");
            sb.append(String.valueOf(i.m) + "," + i.n);
            sb.append(")");
            sb.append("\t" + this.getReal(i.m, i.n));
            if (this.isComplex()) {
                sb.append("+" + this.getImaginary(i.m, i.n));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private class IndexMN {
        int m;
        int n;

        public IndexMN(int m, int n) {
            this.m = m;
            this.n = n;
        }

        public int hashCode() {
            long l = Double.doubleToLongBits(this.m);
            return (int)(l ^= Double.doubleToLongBits(this.n) * 31L) ^ (int)(l >> 32);
        }

        public boolean equals(Object o) {
            if (o instanceof IndexMN) {
                return this.m == ((IndexMN)o).m && this.n == ((IndexMN)o).n;
            }
            return super.equals(o);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("{");
            sb.append("m=" + this.m);
            sb.append(", ");
            sb.append("n=" + this.n);
            sb.append("}");
            return sb.toString();
        }
    }
}

