/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.types;

import com.jmatio.types.GenericArrayCreator;
import com.jmatio.types.MLArray;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MLNumericArray<T extends Number>
extends MLArray
implements GenericArrayCreator<T> {
    private T[] real = (Number[])this.createArray(this.getM(), this.getN());
    private T[] imaginary = (Number[])this.createArray(this.getM(), this.getN());

    public MLNumericArray(String name, int[] dims, int type, int attributes) {
        super(name, dims, type, attributes);
    }

    public MLNumericArray(String name, int type, T[] vals, int m) {
        this(name, new int[]{m, vals.length / m}, type, 0);
        int i = 0;
        while (i < vals.length) {
            this.set(vals[i], i);
            ++i;
        }
    }

    public T getReal(int m, int n) {
        return this.real[this.getIndex(m, n)];
    }

    public void setReal(T value, int m, int n) {
        this.real[this.getIndex((int)m, (int)n)] = value;
    }

    public void setReal(T value, int index) {
        this.real[index] = value;
    }

    public void setReal(T[] vector) {
        if (vector.length != this.getSize()) {
            throw new IllegalArgumentException("Matrix dimensions do not match. " + this.getSize() + " not " + vector.length);
        }
        System.arraycopy(vector, 0, this.real, 0, vector.length);
    }

    public void setImaginary(T value, int m, int n) {
        this.imaginary[this.getIndex((int)m, (int)n)] = value;
    }

    public void setImaginary(T value, int index) {
        this.imaginary[index] = value;
    }

    public T getImaginary(int m, int n) {
        return this.imaginary[this.getIndex(m, n)];
    }

    public T[] exportReal() {
        return (Number[])this.real.clone();
    }

    public T[] exportImaginary() {
        return (Number[])this.imaginary.clone();
    }

    public void set(T value, int m, int n) {
        if (this.isComplex()) {
            throw new IllegalStateException("Cannot use this method for Complex matrices");
        }
        this.setReal(value, m, n);
    }

    public void set(T value, int index) {
        if (this.isComplex()) {
            throw new IllegalStateException("Cannot use this method for Complex matrices");
        }
        this.setReal(value, index);
    }

    public T get(int m, int n) {
        if (this.isComplex()) {
            throw new IllegalStateException("Cannot use this method for Complex matrices");
        }
        return this.getReal(m, n);
    }

    public T get(int index) {
        if (this.isComplex()) {
            throw new IllegalStateException("Cannot use this method for Complex matrices");
        }
        return this.real[index];
    }

    public void set(T[] vector) {
        if (this.isComplex()) {
            throw new IllegalStateException("Cannot use this method for Complex matrices");
        }
        this.setReal((Number[])vector);
    }

    @Override
    public String contentToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.name) + " = \n");
        if (this.getSize() > 1000) {
            sb.append("Cannot display variables with more than 1000 elements.");
            return sb.toString();
        }
        int m = 0;
        while (m < this.getM()) {
            sb.append("\t");
            int n = 0;
            while (n < this.getN()) {
                sb.append(this.getReal(m, n));
                if (this.isComplex()) {
                    sb.append("+" + this.getImaginary(m, n));
                }
                sb.append("\t");
                ++n;
            }
            sb.append("\n");
            ++m;
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof MLNumericArray) {
            return Arrays.equals(this.real, ((MLNumericArray)o).real) && Arrays.equals(this.imaginary, ((MLNumericArray)o).imaginary) && Arrays.equals(this.dims, ((MLNumericArray)o).dims);
        }
        return super.equals(o);
    }
}

