/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.map;

import ch.javasoft.util.map.AbstractMultiValueMap;
import ch.javasoft.util.map.DefaultMultiValueMap;
import ch.javasoft.util.map.MultiValueMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinedMultiValueMap<K, V>
extends AbstractMultiValueMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 7319560387222766983L;
    private final MultiValueMap<K, ?> one;
    private final MultiValueMap<?, V> many;

    public JoinedMultiValueMap(MultiValueMap<K, ?> one, MultiValueMap<?, V> many) {
        this.one = one;
        this.many = many;
    }

    public static <K, V> JoinedMultiValueMap<K, V> join(MultiValueMap<K, ?> one, MultiValueMap<?, V> many) {
        return new JoinedMultiValueMap<K, V>(one, many);
    }

    public static <K, V> JoinedMultiValueMap<K, V> join(MultiValueMap<K, ?> first, MultiValueMap<?, V> last, MultiValueMap<?, ?> ... intermediate) {
        int i = 0;
        while (i < intermediate.length) {
            first = JoinedMultiValueMap.join(first, intermediate[i]);
            ++i;
        }
        return JoinedMultiValueMap.join(first, last);
    }

    public MultiValueMap<K, V> flatten() {
        return new DefaultMultiValueMap(this);
    }

    @Override
    public boolean contains(Object key) {
        for (Object vk : this.one.get(key)) {
            if (!this.many.contains(vk)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object key, V value) {
        for (Object vk : this.one.get(key)) {
            if (!this.many.contains(vk, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int count(Object key) {
        int cnt = 0;
        for (Object vk : this.one.get(key)) {
            cnt += this.many.count(vk);
        }
        return cnt;
    }

    @Override
    public Collection<V> get(Object key) {
        Collection<V> coll = null;
        for (Object vk : this.one.get(key)) {
            if (coll == null) {
                coll = this.many.get(vk);
                continue;
            }
            coll = this.createCollection(coll);
            coll.addAll(this.many.get(vk));
        }
        if (coll == null) {
            coll = this.createCollection(null);
        }
        return coll;
    }

    @Override
    public V getFirst(Object key) {
        for (Object vk : this.one.get(key)) {
            V val = this.many.getFirst(vk);
            if (val == null) continue;
            return val;
        }
        return null;
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.one.keySet());
    }

    @Override
    public Iterable<V> values() {
        ArrayList<V> vals = new ArrayList<V>();
        for (K key : this.one.keySet()) {
            for (Object vk : this.one.get(key)) {
                vals.addAll(this.many.get(vk));
            }
        }
        return vals;
    }

    protected Collection<V> createCollection(Collection<V> values) {
        if (values == null) {
            return Collections.emptyList();
        }
        return new ArrayList<V>(values);
    }
}

