/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.map;

import ch.javasoft.util.map.DefaultMultiValueMap;
import ch.javasoft.util.map.MultiValueMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMultiValueMap<K, V>
implements MultiValueMap<K, V> {
    @Override
    public boolean add(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(K key, Collection<? extends V> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(K key, V ... values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(MultiValueMap<? extends K, ? extends V> mapping) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAllNested(Map<? extends K, ? extends Collection<? extends V>> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V getFirst(Object key) {
        Collection coll = this.get(key);
        return coll.isEmpty() ? null : (V)coll.iterator().next();
    }

    @Override
    public boolean contains(Object key) {
        return this.count(key) == 0;
    }

    @Override
    public Map<K, ? extends Collection<V>> asCollectionMap() {
        LinkedHashMap map = new LinkedHashMap();
        for (Object key : this.keySet()) {
            map.put(key, new ArrayList(this.get(key)));
        }
        return map;
    }

    @Override
    public Map<K, V> asSingleValueMap() {
        LinkedHashMap map = new LinkedHashMap();
        for (Object key : this.keySet()) {
            map.put(key, this.get(key).iterator().next());
        }
        return map;
    }

    @Override
    public MultiValueMap<V, K> invert() {
        DefaultMultiValueMap inv = new DefaultMultiValueMap();
        for (Object key : this.keySet()) {
            for (Object val : this.get(key)) {
                inv.add(val, key);
            }
        }
        return inv;
    }

    @Override
    public int keySize() {
        return this.keySet().size();
    }

    @Override
    public int valueSize() {
        int size = 0;
        for (Object key : this.keySet()) {
            size += this.get(key).size();
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        return this.keySize() == 0;
    }

    @Override
    public Iterable<V> values() {
        return new Iterable<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    private final Iterator<? extends Iterable<V>> mItIt;
                    private Iterator<V> mIt;
                    {
                        this.mItIt = AbstractMultiValueMap.this.asCollectionMap().values().iterator();
                        this.mIt = this.nextIterator();
                    }

                    private Iterator<V> nextIterator() {
                        Iterable itbl;
                        Iterable iterable = itbl = this.mItIt.hasNext() ? this.mItIt.next() : null;
                        if (itbl != null) {
                            Iterator it = itbl.iterator();
                            return it.hasNext() ? it : this.nextIterator();
                        }
                        return null;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.mIt == null) {
                            return false;
                        }
                        if (this.mIt.hasNext()) {
                            return true;
                        }
                        this.mIt = this.nextIterator();
                        return this.hasNext();
                    }

                    @Override
                    public V next() {
                        if (this.hasNext()) {
                            return this.mIt.next();
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        if (this.mIt == null) {
                            throw new NoSuchElementException();
                        }
                        this.mIt.remove();
                    }
                };
            }
        };
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == this.getClass()) {
            MultiValueMap other = (MultiValueMap)obj;
            if (this.keySet().equals(other.keySet())) {
                for (Object key : this.keySet()) {
                    if (this.get(key).equals(other.get(key))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        for (Object key : this.keySet()) {
            hash ^= key.hashCode();
            hash ^= this.get(key).hashCode();
        }
        return hash;
    }

    public String toString() {
        return this.asCollectionMap().toString();
    }
}

