/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.longs;

import ch.javasoft.util.Unsigned;
import ch.javasoft.util.longs.AbstractExactMembershipLongSet;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class ExactMembershipSkipCountLongSet
extends AbstractExactMembershipLongSet {
    private final StorageCharacteristics characteristics;
    private final AbstractExactMembershipLongSet.Storage storage;

    public ExactMembershipSkipCountLongSet(long[] values) {
        this(values, values.length);
    }

    public ExactMembershipSkipCountLongSet(long[] values, int n) {
        if (n < values.length) {
            throw new IllegalArgumentException("n must be at least the length of the values array: " + n + "<" + values.length);
        }
        int negStart = Unsigned.sort(values);
        this.characteristics = StorageCharacteristics.getStorageCharacteristics(n);
        this.storage = this.characteristics.createStorage(values, negStart);
    }

    private ExactMembershipSkipCountLongSet(AbstractExactMembershipLongSet.Storage storage) {
        this.characteristics = StorageCharacteristics.getStorageCharacteristics(storage);
        this.storage = storage;
    }

    public ExactMembershipSkipCountLongSet intersect(AbstractExactMembershipLongSet with) {
        AbstractExactMembershipLongSet.Storage storage = this.getStorage().intersect(with.getStorage());
        return new ExactMembershipSkipCountLongSet(storage);
    }

    protected AbstractExactMembershipLongSet.Storage getStorage() {
        return this.storage;
    }

    private static abstract class AbstractHighLowStorage
    extends AbstractExactMembershipLongSet.AbstractStorage {
        public AbstractHighLowStorage(int k, int negStart) {
            super(k, negStart);
        }

        public long get(int index) {
            return this.getHighOrderBits(index) | this.getLowOrderBits(index);
        }

        protected abstract long[] bitString();

        protected abstract CountSkipList getCountSkipList();

        protected abstract long getHighOrderBits(int var1);

        protected abstract long getLowOrderBits(int var1);

        protected long getHighOrderBitsUnshifted(int index) {
            int bitsToSee = index + 1;
            long[] z = this.bitString();
            int[] indexBits = this.getCountSkipList().find1(index);
            int zIndex = indexBits[0] - 1;
            int oneBits = indexBits[1];
            int curBits = 0;
            while (oneBits + curBits < bitsToSee && zIndex < z.length) {
                oneBits += curBits;
                curBits = Long.bitCount(z[++zIndex]);
            }
            if (curBits + oneBits < bitsToSee) {
                throw new NoSuchElementException("index=" + index);
            }
            int clearBits = bitsToSee - oneBits - 1;
            long cur = z[zIndex];
            int i = 0;
            while (i < clearBits) {
                cur ^= Long.lowestOneBit(cur);
                --curBits;
                ++i;
            }
            return 64L * (long)zIndex + (long)Long.numberOfTrailingZeros(cur) - (long)index;
        }

        public int indexOf(long value) {
            int low = 0;
            int high = this.size() - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                long midVal = this.get(mid);
                int cmp = Unsigned.compare(midVal, value);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(low + 1);
        }

        public AbstractExactMembershipLongSet.Storage intersect(AbstractExactMembershipLongSet.Storage with) {
            throw new UnsupportedOperationException("intersect not supported");
        }

        protected static class CountSkipList {
            private final int[] count1;

            public CountSkipList(long[] z) {
                int zlen = z.length;
                int clen = 1 + (zlen >>> 3);
                this.count1 = new int[clen];
                int cnt1 = 0;
                int i = 0;
                while (i < zlen) {
                    int cnt = Long.bitCount(z[i]);
                    cnt1 += cnt;
                    int next = i + 1;
                    if (next % 8 == 0 || next == zlen) {
                        int cindex = i >>> 3;
                        this.count1[cindex] = cnt1;
                    }
                    ++i;
                }
            }

            /*
             * Unable to fully structure code
             */
            public int[] find1(int value) {
                block1: {
                    index = Arrays.binarySearch(this.count1, value);
                    if (index >= 0) ** GOTO lbl6
                    index = -index - 1;
                    break block1;
lbl-1000:
                    // 1 sources

                    {
                        --index;
lbl6:
                        // 2 sources

                        ** while (index > 0 && this.count1[index - 1] >= value)
                    }
                }
                return new int[]{index << 3, index == 0 ? 0 : this.count1[index - 1]};
            }

            public long bytesSize() {
                return 4L * (long)this.count1.length;
            }
        }
    }

    private static class Storage32
    extends AbstractHighLowStorage {
        private final AbstractHighLowStorage.CountSkipList counts;
        private final long[] z;
        private final int[] y;

        public Storage32(long[] sorted, int negStart) {
            super(32, negStart);
            int len = sorted.length;
            long max = len > 0 ? sorted[len - 1] >>> 32 : 0L;
            long bits = (long)len + max;
            long zlen = 1L + (bits - 1L >> 6);
            this.z = new long[(int)zlen];
            this.y = new int[len];
            int i = 0;
            while (i < len) {
                long index = (sorted[i] >>> 32) + (long)i;
                int n = (int)(index >> 6);
                this.z[n] = this.z[n] | 1L << (int)(index & 0x7FL);
                this.y[i] = (int)sorted[i];
                ++i;
            }
            this.counts = new AbstractHighLowStorage.CountSkipList(this.z);
        }

        public AbstractHighLowStorage.CountSkipList getCountSkipList() {
            return this.counts;
        }

        public int size() {
            return this.y.length;
        }

        public long[] bitString() {
            return this.z;
        }

        protected long getHighOrderBits(int index) {
            return this.getHighOrderBitsUnshifted(index) << 32;
        }

        protected long getLowOrderBits(int index) {
            return 0xFFFFFFFFL & (long)this.y[index];
        }

        public long bytesSize() {
            return 8L * (long)this.z.length + 4L * (long)this.y.length + this.counts.bytesSize();
        }
    }

    private static class Storage40
    extends AbstractHighLowStorage {
        private final AbstractHighLowStorage.CountSkipList counts;
        private final long[] z;
        private final int[] y0to31;
        private final byte[] y32to39;

        public Storage40(long[] sorted, int negStart) {
            super(40, negStart);
            int len = sorted.length;
            long max = len > 0 ? sorted[len - 1] >>> 40 : 0L;
            long bits = (long)len + max;
            long zlen = 1L + (bits - 1L >> 6);
            this.z = new long[(int)zlen];
            this.y0to31 = new int[len];
            this.y32to39 = new byte[len];
            int i = 0;
            while (i < len) {
                long index = (sorted[i] >>> 40) + (long)i;
                int n = (int)(index >> 6);
                this.z[n] = this.z[n] | 1L << (int)(index & 0x7FL);
                this.y0to31[i] = (int)sorted[i];
                this.y32to39[i] = (byte)(sorted[i] >> 32);
                ++i;
            }
            this.counts = new AbstractHighLowStorage.CountSkipList(this.z);
        }

        public AbstractHighLowStorage.CountSkipList getCountSkipList() {
            return this.counts;
        }

        public long[] bitString() {
            return this.z;
        }

        public int size() {
            return this.y0to31.length;
        }

        protected long getHighOrderBits(int index) {
            return this.getHighOrderBitsUnshifted(index) << 40;
        }

        protected long getLowOrderBits(int index) {
            return 0xFFFFFFFFL & (long)this.y0to31[index] | (0xFFL & (long)this.y32to39[index]) << 32;
        }

        public long bytesSize() {
            return 8L * (long)this.z.length + 4L * (long)this.y0to31.length + (long)this.y32to39.length + this.counts.bytesSize();
        }
    }

    private static class Storage48
    extends AbstractHighLowStorage {
        private final AbstractHighLowStorage.CountSkipList counts;
        private final long[] z;
        private final int[] y0to31;
        private final short[] y32to47;

        public Storage48(long[] sorted, int negStart) {
            super(48, negStart);
            int len = sorted.length;
            long max = len > 0 ? sorted[len - 1] >>> 48 : 0L;
            long bits = (long)len + max;
            long zlen = 1L + (bits - 1L >> 6);
            this.z = new long[(int)zlen];
            this.y0to31 = new int[len];
            this.y32to47 = new short[len];
            int i = 0;
            while (i < len) {
                long index = (sorted[i] >>> 48) + (long)i;
                int n = (int)(index >> 6);
                this.z[n] = this.z[n] | 1L << (int)(index & 0x7FL);
                this.y0to31[i] = (int)sorted[i];
                this.y32to47[i] = (short)(sorted[i] >>> 32);
                ++i;
            }
            this.counts = new AbstractHighLowStorage.CountSkipList(this.z);
        }

        public AbstractHighLowStorage.CountSkipList getCountSkipList() {
            return this.counts;
        }

        public long[] bitString() {
            return this.z;
        }

        public int size() {
            return this.y0to31.length;
        }

        protected long getHighOrderBits(int index) {
            return this.getHighOrderBitsUnshifted(index) << 48;
        }

        protected long getLowOrderBits(int index) {
            return 0xFFFFFFFFL & (long)this.y0to31[index] | (0xFFFFL & (long)this.y32to47[index]) << 32;
        }

        public long bytesSize() {
            return 8L * (long)this.z.length + 4L * (long)this.y0to31.length + 2L * (long)this.y32to47.length + this.counts.bytesSize();
        }
    }

    private static class Storage56
    extends AbstractHighLowStorage {
        private final AbstractHighLowStorage.CountSkipList counts;
        private final long[] z;
        private final int[] y0to31;
        private final short[] y32to47;
        private final byte[] y48to55;

        public Storage56(long[] sorted, int negStart) {
            super(56, negStart);
            int len = sorted.length;
            long max = len > 0 ? sorted[len - 1] >>> 56 : 0L;
            long bits = (long)len + max;
            long zlen = 1L + (bits - 1L >> 6);
            this.z = new long[(int)zlen];
            this.y0to31 = new int[len];
            this.y32to47 = new short[len];
            this.y48to55 = new byte[len];
            int i = 0;
            while (i < len) {
                long index = (sorted[i] >>> 56) + (long)i;
                int n = (int)(index >> 6);
                this.z[n] = this.z[n] | 1L << (int)(index & 0x7FL);
                this.y0to31[i] = (int)sorted[i];
                this.y32to47[i] = (short)(sorted[i] >>> 32);
                this.y48to55[i] = (byte)(sorted[i] >>> 48);
                ++i;
            }
            this.counts = new AbstractHighLowStorage.CountSkipList(this.z);
        }

        public AbstractHighLowStorage.CountSkipList getCountSkipList() {
            return this.counts;
        }

        public long[] bitString() {
            return this.z;
        }

        public int size() {
            return this.y0to31.length;
        }

        protected long getLowOrderBits(int index) {
            return 0xFFFFFFFFL & (long)this.y0to31[index] | (0xFFFFL & (long)this.y32to47[index]) << 32 | (0xFFL & (long)this.y48to55[index]) << 48;
        }

        protected long getHighOrderBits(int index) {
            return this.getHighOrderBitsUnshifted(index) << 56;
        }

        public long bytesSize() {
            return 8L * (long)this.z.length + 4L * (long)this.y0to31.length + 2L * (long)this.y32to47.length + (long)this.y48to55.length + this.counts.bytesSize();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum StorageCharacteristics {
        K64(4, 64){

            public AbstractExactMembershipLongSet.Storage createStorage(long[] sorted, int negStart) {
                return new AbstractExactMembershipLongSet.Storage64(sorted, negStart);
            }
        }
        ,
        K56(12, 56){

            public AbstractExactMembershipLongSet.Storage createStorage(long[] sorted, int negStart) {
                return new Storage56(sorted, negStart);
            }
        }
        ,
        K48(20, 48){

            public AbstractExactMembershipLongSet.Storage createStorage(long[] sorted, int negStart) {
                return new Storage48(sorted, negStart);
            }
        }
        ,
        K40(28, 40){

            public AbstractExactMembershipLongSet.Storage createStorage(long[] sorted, int negStart) {
                return new Storage40(sorted, negStart);
            }
        }
        ,
        K32(36, 32){

            public AbstractExactMembershipLongSet.Storage createStorage(long[] sorted, int negStart) {
                return new Storage32(sorted, negStart);
            }
        };

        public final int upper;
        public final int k;

        private StorageCharacteristics(int upper, int k) {
            this.upper = upper;
            this.k = k;
        }

        public abstract AbstractExactMembershipLongSet.Storage createStorage(long[] var1, int var2);

        public static StorageCharacteristics getStorageCharacteristics(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("n must be non-negative: " + n);
            }
            StorageCharacteristics[] storageCharacteristicsArray = StorageCharacteristics.values();
            int n2 = storageCharacteristicsArray.length;
            int n3 = 0;
            while (n3 < n2) {
                StorageCharacteristics val = storageCharacteristicsArray[n3];
                if (1L << val.upper > (long)n) {
                    return val;
                }
                ++n3;
            }
            throw new RuntimeException("internal error: no characteristics found for " + n);
        }

        public static StorageCharacteristics getStorageCharacteristics(AbstractExactMembershipLongSet.Storage storage) {
            int k = storage.getK();
            StorageCharacteristics[] storageCharacteristicsArray = StorageCharacteristics.values();
            int n = storageCharacteristicsArray.length;
            int n2 = 0;
            while (n2 < n) {
                StorageCharacteristics val = storageCharacteristicsArray[n2];
                if (val.k == k) {
                    return val;
                }
                ++n2;
            }
            throw new RuntimeException("internal error: no characteristics found for k=" + k);
        }
    }
}

