/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.longs;

import ch.javasoft.util.Iterables;
import ch.javasoft.util.LongArray;
import ch.javasoft.util.Unsigned;
import ch.javasoft.util.longs.AbstractExactMembershipLongSet;
import ch.javasoft.util.longs.LongIterable;
import ch.javasoft.util.longs.LongIterator;
import java.util.Arrays;

public class ExactMembershipAllCountLongSet
extends AbstractExactMembershipLongSet {
    private final StorageCharacteristics characteristics;
    private final AbstractExactMembershipLongSet.Storage storage;

    public ExactMembershipAllCountLongSet(long[] values) {
        this(values, values.length);
    }

    public ExactMembershipAllCountLongSet(long[] values, int n) {
        if (n < values.length) {
            throw new IllegalArgumentException("n must be at least the length of the values array: " + n + "<" + values.length);
        }
        int negStart = Unsigned.sort(values);
        this.characteristics = StorageCharacteristics.getStorageCharacteristics(n);
        this.storage = this.characteristics.createStorage(values, negStart);
    }

    private ExactMembershipAllCountLongSet(AbstractExactMembershipLongSet.Storage storage) {
        this.characteristics = StorageCharacteristics.getStorageCharacteristics(storage);
        this.storage = storage;
    }

    protected AbstractExactMembershipLongSet.Storage getStorage() {
        return this.storage;
    }

    public ExactMembershipAllCountLongSet intersect(AbstractExactMembershipLongSet with) {
        AbstractExactMembershipLongSet.Storage storage = this.getStorage().intersect(with.getStorage());
        return new ExactMembershipAllCountLongSet(storage);
    }

    private static abstract class AbstractHighLowStorage
    extends AbstractExactMembershipLongSet.AbstractStorage {
        protected final int length;
        protected final int[] counts;

        public AbstractHighLowStorage(int k, int negStart, int len) {
            super(k, negStart);
            int notK = 64 - k;
            int clen = 1 << notK;
            this.length = len;
            this.counts = new int[clen];
        }

        protected void makeCumSum() {
            int clen = this.counts.length;
            int i = 1;
            while (i < clen) {
                int n = i;
                this.counts[n] = this.counts[n] + this.counts[i - 1];
                ++i;
            }
        }

        public long get(int index) {
            return this.getHighOrderBits(index) | this.getLowOrderBits(index);
        }

        protected long getHighOrderBits(int index) {
            int len = this.counts.length;
            int k = this.getK();
            int cindex = Arrays.binarySearch(this.counts, index);
            if (cindex < 0) {
                cindex = -cindex - 1;
            }
            while (cindex < len && this.counts[cindex] == index) {
                ++cindex;
            }
            return (long)cindex << k;
        }

        protected abstract long getLowOrderBits(int var1);

        private int indexOfLowOrderBits(long key, int start, int end) {
            int low = start;
            int high = end - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                long midVal = this.getLowOrderBits(mid);
                int cmp = Unsigned.compare(midVal, key);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(low + 1);
        }

        public int indexOf(long value) {
            int k = this.getK();
            long high = value >>> k;
            long low = value & (-1L << k ^ 0xFFFFFFFFFFFFFFFFL);
            int cind = (int)high;
            int end = this.counts[cind];
            int start = cind > 0 ? this.counts[cind - 1] : 0;
            return this.indexOfLowOrderBits(low, start, end);
        }

        public AbstractExactMembershipLongSet.Storage intersect(AbstractExactMembershipLongSet.Storage with) {
            if (with.getClass().equals(this.getClass())) {
                AbstractHighLowStorage other = (AbstractHighLowStorage)with;
                int k = this.getK();
                LongArray inter = new LongArray();
                int curFirstNeg = this.indexOfFirstNegativeValue();
                int myprev = 0;
                int otprev = 0;
                int newFirstNeg = -1;
                int c = 0;
                while (c < this.counts.length) {
                    int mycnt = this.counts[c];
                    int otcnt = other.counts[c];
                    int i = myprev;
                    int j = otprev;
                    while (i < mycnt && j < otcnt) {
                        long ot;
                        long me = this.getLowOrderBits(i);
                        int cmp = Unsigned.compare(me, ot = other.getLowOrderBits(j));
                        if (cmp < 0) {
                            ++i;
                            continue;
                        }
                        if (cmp > 0) {
                            ++j;
                            continue;
                        }
                        if (newFirstNeg < 0 && i >= curFirstNeg) {
                            newFirstNeg = inter.length();
                        }
                        inter.add((long)c << k | me);
                        ++i;
                        ++j;
                    }
                    myprev = mycnt;
                    otprev = otcnt;
                    ++c;
                }
                return StorageCharacteristics.getStorageCharacteristics(inter.length()).createStorage(inter.toArray(), newFirstNeg);
            }
            throw new IllegalArgumentException("must be same storage class: " + this.getClass().getName() + " is not " + with.getClass().getName());
        }
    }

    private static class Storage40
    extends AbstractHighLowStorage {
        private final int[] y0to31;
        private final byte[] y32to39;

        public Storage40(long[] sorted, int negStart) {
            super(40, negStart, sorted.length);
            int len = sorted.length;
            this.y0to31 = new int[len];
            this.y32to39 = new byte[len];
            int i = 0;
            while (i < len) {
                long index = sorted[i] >>> 40;
                int n = (int)index;
                this.counts[n] = this.counts[n] + 1;
                this.y0to31[i] = (int)sorted[i];
                this.y32to39[i] = (byte)(sorted[i] >> 32);
                ++i;
            }
            this.makeCumSum();
        }

        public Storage40(LongIterable sorted, int negStart) {
            super(40, negStart, Iterables.iterableSize(sorted));
            int len = this.length;
            this.y0to31 = new int[len];
            this.y32to39 = new byte[len];
            LongIterator it = sorted.iterator();
            int i = 0;
            while (i < len) {
                long value = it.nextLong();
                long index = value >>> 40;
                int n = (int)index;
                this.counts[n] = this.counts[n] + 1;
                this.y0to31[i] = (int)value;
                this.y32to39[i] = (byte)(value >> 32);
                ++i;
            }
            this.makeCumSum();
        }

        public int size() {
            return this.y0to31.length;
        }

        protected long getLowOrderBits(int index) {
            return 0xFFFFFFFFL & (long)this.y0to31[index] | (0xFFL & (long)this.y32to39[index]) << 32;
        }

        public long bytesSize() {
            return 4L * (long)this.counts.length + 4L * (long)this.y0to31.length + (long)this.y32to39.length;
        }
    }

    private static class Storage48
    extends AbstractHighLowStorage {
        private final int[] y0to31;
        private final short[] y32to47;

        public Storage48(long[] sorted, int negStart) {
            super(48, negStart, sorted.length);
            int len = sorted.length;
            this.y0to31 = new int[len];
            this.y32to47 = new short[len];
            int i = 0;
            while (i < len) {
                long index = sorted[i] >>> 48;
                int n = (int)index;
                this.counts[n] = this.counts[n] + 1;
                this.y0to31[i] = (int)sorted[i];
                this.y32to47[i] = (short)(sorted[i] >>> 32);
                ++i;
            }
            this.makeCumSum();
        }

        public Storage48(LongIterable sorted, int negStart) {
            super(48, negStart, Iterables.iterableSize(sorted));
            int len = this.length;
            this.y0to31 = new int[len];
            this.y32to47 = new short[len];
            LongIterator it = sorted.iterator();
            int i = 0;
            while (i < len) {
                long value = it.nextLong();
                long index = value >>> 48;
                int n = (int)index;
                this.counts[n] = this.counts[n] + 1;
                this.y0to31[i] = (int)value;
                this.y32to47[i] = (short)(value >>> 32);
                ++i;
            }
            this.makeCumSum();
        }

        public int size() {
            return this.y0to31.length;
        }

        protected long getLowOrderBits(int index) {
            return 0xFFFFFFFFL & (long)this.y0to31[index] | (0xFFFFL & (long)this.y32to47[index]) << 32;
        }

        public long bytesSize() {
            return 4L * (long)this.counts.length + 4L * (long)this.y0to31.length + 2L * (long)this.y32to47.length;
        }
    }

    private static class Storage56
    extends AbstractHighLowStorage {
        private final int[] y0to31;
        private final short[] y32to47;
        private final byte[] y48to55;

        public Storage56(long[] sorted, int negStart) {
            super(56, negStart, sorted.length);
            int len = sorted.length;
            this.y0to31 = new int[len];
            this.y32to47 = new short[len];
            this.y48to55 = new byte[len];
            int i = 0;
            while (i < len) {
                long index = sorted[i] >>> 56;
                int n = (int)index;
                this.counts[n] = this.counts[n] + 1;
                this.y0to31[i] = (int)sorted[i];
                this.y32to47[i] = (short)(sorted[i] >>> 32);
                this.y48to55[i] = (byte)(sorted[i] >>> 48);
                ++i;
            }
            this.makeCumSum();
        }

        public Storage56(LongIterable sorted, int negStart) {
            super(56, negStart, Iterables.iterableSize(sorted));
            int len = this.length;
            this.y0to31 = new int[len];
            this.y32to47 = new short[len];
            this.y48to55 = new byte[len];
            LongIterator it = sorted.iterator();
            int i = 0;
            while (i < len) {
                long value = it.nextLong();
                long index = value >>> 56;
                int n = (int)index;
                this.counts[n] = this.counts[n] + 1;
                this.y0to31[i] = (int)value;
                this.y32to47[i] = (short)(value >>> 32);
                this.y48to55[i] = (byte)(value >>> 48);
                ++i;
            }
            this.makeCumSum();
        }

        public int size() {
            return this.y0to31.length;
        }

        protected long getLowOrderBits(int index) {
            return 0xFFFFFFFFL & (long)this.y0to31[index] | (0xFFFFL & (long)this.y32to47[index]) << 32 | (0xFFL & (long)this.y48to55[index]) << 48;
        }

        public long bytesSize() {
            return 4L * (long)this.counts.length + 4L * (long)this.y0to31.length + 2L * (long)this.y32to47.length + (long)this.y48to55.length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum StorageCharacteristics {
        K64(10, 64){

            public AbstractExactMembershipLongSet.Storage createStorage(long[] sorted, int negStart) {
                return new AbstractExactMembershipLongSet.Storage64(sorted, negStart);
            }

            public AbstractExactMembershipLongSet.Storage createStorage(LongIterable sorted, int negStart) {
                return new AbstractExactMembershipLongSet.Storage64(sorted, negStart);
            }
        }
        ,
        K56(18, 56){

            public AbstractExactMembershipLongSet.Storage createStorage(long[] sorted, int negStart) {
                return new Storage56(sorted, negStart);
            }

            public AbstractExactMembershipLongSet.Storage createStorage(LongIterable sorted, int negStart) {
                return new Storage56(sorted, negStart);
            }
        }
        ,
        K48(26, 48){

            public AbstractExactMembershipLongSet.Storage createStorage(long[] sorted, int negStart) {
                return new Storage48(sorted, negStart);
            }

            public AbstractExactMembershipLongSet.Storage createStorage(LongIterable sorted, int negStart) {
                return new Storage48(sorted, negStart);
            }
        }
        ,
        K40(34, 40){

            public AbstractExactMembershipLongSet.Storage createStorage(long[] sorted, int negStart) {
                return new Storage40(sorted, negStart);
            }

            public AbstractExactMembershipLongSet.Storage createStorage(LongIterable sorted, int negStart) {
                return new Storage40(sorted, negStart);
            }
        };

        public final int upper;
        public final int k;

        private StorageCharacteristics(int upper, int k) {
            this.upper = upper;
            this.k = k;
        }

        public abstract AbstractExactMembershipLongSet.Storage createStorage(long[] var1, int var2);

        public abstract AbstractExactMembershipLongSet.Storage createStorage(LongIterable var1, int var2);

        public static StorageCharacteristics getStorageCharacteristics(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("n must be non-negative: " + n);
            }
            StorageCharacteristics[] storageCharacteristicsArray = StorageCharacteristics.values();
            int n2 = storageCharacteristicsArray.length;
            int n3 = 0;
            while (n3 < n2) {
                StorageCharacteristics val = storageCharacteristicsArray[n3];
                if (1L << val.upper > (long)n) {
                    return val;
                }
                ++n3;
            }
            throw new RuntimeException("internal error: no characteristics found for n=" + n);
        }

        public static StorageCharacteristics getStorageCharacteristics(AbstractExactMembershipLongSet.Storage storage) {
            int k = storage.getK();
            StorageCharacteristics[] storageCharacteristicsArray = StorageCharacteristics.values();
            int n = storageCharacteristicsArray.length;
            int n2 = 0;
            while (n2 < n) {
                StorageCharacteristics val = storageCharacteristicsArray[n2];
                if (val.k == k) {
                    return val;
                }
                ++n2;
            }
            throw new RuntimeException("internal error: no characteristics found for k=" + k);
        }
    }
}

