/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.longs;

import ch.javasoft.util.ints.IntCollection;
import ch.javasoft.util.ints.IntIterator;
import ch.javasoft.util.longs.LongCollection;
import ch.javasoft.util.longs.LongIterator;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLongCollection
implements LongCollection {
    protected transient int mod;

    public AbstractLongCollection() {
    }

    public AbstractLongCollection(IntCollection set) {
        this.addAll(set);
    }

    public AbstractLongCollection(LongCollection set) {
        this.addAll(set);
    }

    public AbstractLongCollection(int[] values) {
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int val = nArray[n2];
            this.addLong(val);
            ++n2;
        }
    }

    public AbstractLongCollection(long[] values) {
        long[] lArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            long val = lArray[n2];
            this.addLong(val);
            ++n2;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsLong(long value) {
        LongIterator it = this.iterator();
        while (it.hasNext()) {
            if (value != it.nextLong()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Long || o instanceof Integer || o instanceof Short || o instanceof Byte) {
            return this.containsLong(((Number)o).longValue());
        }
        return false;
    }

    public Integer[] toArray() {
        return this.toArrayInternal(new Integer[this.size()], false);
    }

    @Override
    public <T> T[] toArray(T[] arr) {
        return this.toArrayInternal(arr, true);
    }

    protected <T> T[] toArrayInternal(T[] arr, boolean checkSize) {
        int size;
        if (checkSize && arr.length < (size = this.size())) {
            arr = (Object[])Array.newInstance(arr.getClass().getComponentType(), size);
        }
        int index = 0;
        LongIterator it = this.iterator();
        while (it.hasNext()) {
            arr[index++] = it.nextLong();
        }
        return arr;
    }

    @Override
    public boolean add(Long o) {
        return this.addLong(o);
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Long || o instanceof Integer || o instanceof Short || o instanceof Byte) {
            return this.removeLong(((Number)o).longValue());
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object obj : c) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Long> c) {
        if (c instanceof LongCollection) {
            return this.addAll((LongCollection)c);
        }
        boolean any = false;
        for (Long l : c) {
            any |= this.add(l);
        }
        return any;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean any = false;
        LongIterator it = this.iterator();
        while (it.hasNext()) {
            if (c.contains(it.next())) continue;
            it.remove();
            any = true;
        }
        return any;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean any = false;
        for (Object obj : c) {
            any |= this.remove(obj);
        }
        return any;
    }

    public boolean addAll(IntCollection coll) {
        boolean any = false;
        IntIterator it = coll.iterator();
        while (it.hasNext()) {
            any |= this.addLong(it.nextInt());
        }
        return any;
    }

    @Override
    public boolean addAll(LongCollection coll) {
        boolean any = false;
        LongIterator it = coll.iterator();
        while (it.hasNext()) {
            any |= this.addLong(it.nextLong());
        }
        return any;
    }

    @Override
    public boolean addAll(long ... values) {
        if (values.length == 0) {
            return false;
        }
        boolean any = false;
        int i = 0;
        while (i < values.length) {
            any |= this.addLong(values[i]);
            ++i;
        }
        return any;
    }

    @Override
    public long[] toLongArray() {
        return this.toLongArrayInternal(new long[this.size()], false);
    }

    @Override
    public long[] toLongArray(long[] arr) {
        return this.toLongArrayInternal(arr, true);
    }

    protected long[] toLongArrayInternal(long[] arr, boolean checkSize) {
        int size;
        if (checkSize && arr.length < (size = this.size())) {
            arr = new long[size];
        }
        int index = 0;
        LongIterator it = this.iterator();
        while (it.hasNext()) {
            arr[index++] = it.nextLong();
        }
        return arr;
    }

    public long firstLong() {
        return this.iterator().nextLong();
    }

    public Long first() {
        return this.firstLong();
    }

    public long lastLong() {
        LongIterator it = this.iterator();
        if (!it.hasNext()) {
            throw new NoSuchElementException();
        }
        long val = it.nextLong();
        while (it.hasNext()) {
            val = it.nextLong();
        }
        return val;
    }

    public Long last() {
        return this.lastLong();
    }

    public AbstractLongCollection clone() {
        AbstractLongCollection clone;
        try {
            clone = (AbstractLongCollection)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
        clone.mod = 0;
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof Collection) {
            Collection col = (Collection)obj;
            if (this.size() != col.size()) {
                return false;
            }
            LongIterator thisIt = this.iterator();
            Iterator otherIt = col.iterator();
            while (thisIt.hasNext()) {
                long val = thisIt.nextLong();
                if (otherIt instanceof LongIterator) {
                    if (val == ((LongIterator)otherIt).nextLong()) continue;
                    return false;
                }
                Object oval = otherIt.next();
                if (oval == null) {
                    return false;
                }
                if (!(oval instanceof Long)) {
                    return false;
                }
                if ((Long)oval == val) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        LongIterator it = this.iterator();
        while (it.hasNext()) {
            long val = it.nextLong();
            hash ^= (int)val;
            hash ^= (int)(val >>> 32);
        }
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        LongIterator it = this.iterator();
        while (it.hasNext()) {
            sb.append(sb.length() > 0 ? ", " : "[");
            sb.append(it.nextLong());
        }
        return sb.append("]").toString();
    }
}

