/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.logging;

import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogWriter
extends Writer {
    private final Logger mLogger;
    private final Level mLevel;
    private final ThreadLocal<StringBuilder> mLineBuffer = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder();
        }
    };
    private static final String NL = System.getProperty("line.separator");

    public LogWriter(String loggerName, Level level) {
        this(Logger.getLogger(loggerName), level);
    }

    public LogWriter(Logger logger, Level level) {
        this.mLogger = logger;
        this.mLevel = level;
    }

    public void write(char[] cbuf, int off, int len) {
        String nl = this.newLine();
        int end = off + len;
        int ii = off;
        while (ii < end) {
            int jj = 0;
            while (jj >= 0 && jj < nl.length() && ii + jj < end) {
                if (cbuf[ii + jj] == nl.charAt(jj)) {
                    ++jj;
                    continue;
                }
                jj = -1;
            }
            if (jj != -1) {
                this.mLineBuffer.get().append(cbuf, off, ii - off);
                this.flush();
                int restLen = len - (ii - off + nl.length());
                if (restLen > 0) {
                    this.write(cbuf, ii + nl.length(), restLen);
                }
                return;
            }
            ++ii;
        }
        this.mLineBuffer.get().append(cbuf, off, len);
    }

    protected String newLine() {
        return NL;
    }

    public void flush() {
        StringBuilder buf = this.mLineBuffer.get();
        if (buf.length() > 0) {
            this.mLogger.log(this.mLevel, buf.toString());
            buf.delete(0, buf.length());
        }
    }

    public void close() {
        this.flush();
    }
}

