/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.ints;

import ch.javasoft.util.ints.AbstractSortedIntSet;
import ch.javasoft.util.ints.DefaultIntList;
import ch.javasoft.util.ints.IntCollection;
import ch.javasoft.util.ints.IntIterator;
import ch.javasoft.util.ints.IntSet;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIntSet
extends AbstractSortedIntSet
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -2690840135359345024L;
    private final DefaultIntList values;

    public DefaultIntSet() {
        this(7);
    }

    public DefaultIntSet(int initialCapacity) {
        this.values = new DefaultIntList(initialCapacity);
    }

    public DefaultIntSet(IntSet set) {
        this(set.size());
        this.addAll(set);
    }

    public DefaultIntSet(int[] values) {
        this(values.length);
        this.values.addAll(values);
        this.values.sort(true);
    }

    public static DefaultIntSet create(int ... values) {
        return new DefaultIntSet(values);
    }

    protected DefaultIntSet(DefaultIntList values) {
        this.values = values;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean containsInt(int o) {
        return this.values.binarySearchInt(o) >= 0;
    }

    @Override
    protected <T> T[] toArrayInternal(T[] arr, boolean checkSize) {
        int size;
        if (checkSize && arr.length < (size = this.size())) {
            arr = (Object[])Array.newInstance(arr.getClass().getComponentType(), size);
        }
        int i = 0;
        while (i < this.values.size()) {
            arr[i] = this.values.getInt(i);
            ++i;
        }
        return arr;
    }

    @Override
    public void clear() {
        this.values.clear();
        ++this.mod;
    }

    @Override
    public boolean addInt(int value) {
        if (this.containsInt(value)) {
            return false;
        }
        this.values.addIntToSorted(value);
        ++this.mod;
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> coll) {
        if (coll.isEmpty()) {
            return false;
        }
        if (coll instanceof IntCollection) {
            return this.addAll((IntCollection)coll);
        }
        DefaultIntList sorted = new DefaultIntList(coll.size());
        Iterator<? extends Integer> it = coll.iterator();
        while (it.hasNext()) {
            int val = it.next();
            if (this.containsInt(val)) continue;
            sorted.addInt(val);
        }
        sorted.sort(true);
        this.values.mergeSorted(sorted);
        return true;
    }

    @Override
    public boolean addAll(IntCollection coll) {
        if (coll.isEmpty()) {
            return false;
        }
        DefaultIntList sorted = new DefaultIntList(coll.size());
        IntIterator intIt = coll.iterator();
        while (intIt.hasNext()) {
            int val = intIt.nextInt();
            if (this.containsInt(val)) continue;
            sorted.addInt(val);
        }
        sorted.sort(true);
        this.values.mergeSorted(sorted);
        return true;
    }

    @Override
    public boolean addAll(int ... values) {
        if (values.length == 0) {
            return false;
        }
        DefaultIntList sorted = new DefaultIntList(values.length);
        int i = 0;
        while (i < values.length) {
            if (!this.containsInt(values[i])) {
                sorted.addInt(values[i]);
            }
            ++i;
        }
        sorted.sort(true);
        this.values.mergeSorted(sorted);
        return true;
    }

    @Override
    public boolean removeInt(int value) {
        int index = this.values.binarySearchInt(value);
        if (index >= 0) {
            this.values.remove(value);
            ++this.mod;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.retainOrRemove(c, true);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.retainOrRemove(c, false);
    }

    private boolean retainOrRemove(Collection<?> c, boolean remove) {
        DefaultIntList arr;
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            if (remove) {
                return false;
            }
            this.clear();
            return true;
        }
        if (c instanceof IntCollection) {
            arr = new DefaultIntList((IntCollection)c);
        } else {
            arr = new DefaultIntList();
            for (Object o : c) {
                if (!(o instanceof Integer)) continue;
                arr.addInt((Integer)o);
            }
        }
        arr.sort(true);
        int len = this.values.size();
        int src = 0;
        int dst = 0;
        while (src < len) {
            int val = this.values.getInt(src);
            if (remove == arr.binarySearchInt(val) < 0) {
                this.values.setInt(dst, val);
                ++dst;
            }
            ++src;
        }
        return this.values.removeFromTail(len - dst);
    }

    @Override
    public IntIterator iterator() {
        return this.values.iterator();
    }

    @Override
    public Comparator<? super Integer> comparator() {
        return null;
    }

    @Override
    public int firstInt() {
        if (this.values.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.values.firstInt();
    }

    @Override
    public int lastInt() {
        if (this.values.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.values.lastInt();
    }

    @Override
    public DefaultIntSet subSet(int fromElement, int toElement) {
        if (fromElement > toElement) {
            throw new IllegalArgumentException("fromElement > toElement: " + fromElement + " > " + toElement);
        }
        int fromIndex = this.values.binarySearchInt(fromElement);
        int toIndex = this.values.binarySearchInt(toElement);
        if (fromIndex < 0) {
            fromIndex = -fromIndex;
        }
        if (toIndex < 0) {
            toIndex = -toIndex + 1;
        }
        return new DefaultIntSet(this.values.subList(fromIndex, toIndex));
    }

    @Override
    public DefaultIntSet clone() {
        return new DefaultIntSet(this.values.clone());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DefaultIntSet) {
            return this.values.equals(((DefaultIntSet)obj).values);
        }
        return super.equals(obj);
    }

    @Override
    public String toString() {
        return this.values.toString();
    }
}

