/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.ints;

import ch.javasoft.util.IntArray;
import ch.javasoft.util.Iterables;
import ch.javasoft.util.ints.AbstractIntList;
import ch.javasoft.util.ints.DefaultIntListIterator;
import ch.javasoft.util.ints.IntCollection;
import ch.javasoft.util.ints.IntList;
import ch.javasoft.util.ints.IntListIterator;
import java.io.Serializable;
import java.util.ConcurrentModificationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIntList
extends AbstractIntList
implements IntList,
Serializable,
Cloneable {
    private static final long serialVersionUID = -4806359511537837653L;
    private final IntArray array;

    public DefaultIntList() {
        this(new IntArray());
    }

    public DefaultIntList(int initialCapacity) {
        this(new IntArray(initialCapacity));
    }

    public DefaultIntList(int[] initialValues) {
        this(new IntArray(initialValues));
    }

    public DefaultIntList(IntArray array) {
        this.array = array;
    }

    public DefaultIntList(Iterable<Integer> values) {
        this(Iterables.iterableSize(values));
        for (Integer value : values) {
            this.add(value);
        }
    }

    public DefaultIntList(DefaultIntList copy) {
        this(copy.array.clone());
    }

    public DefaultIntList(IntCollection coll) {
        this(coll.size());
        this.addAll(coll);
    }

    @Override
    public DefaultIntList clone() {
        return new DefaultIntList(this);
    }

    @Override
    public int size() {
        return this.array.length();
    }

    @Override
    public boolean isEmpty() {
        return this.array.isEmpty();
    }

    @Override
    public int getInt(int index) throws IndexOutOfBoundsException {
        return this.array.get(index);
    }

    @Override
    public int setInt(int index, int value) throws IndexOutOfBoundsException {
        int old = this.array.set(index, value);
        ++this.mod;
        return old;
    }

    public void setOrAddInt(int index, int value) {
        this.array.set(index, value);
        ++this.mod;
    }

    public int addIntToSorted(int value) {
        int pos = this.binarySearchInt(value);
        if (pos < 0) {
            pos = -(pos + 1);
        }
        this.addInt(pos, value);
        return pos;
    }

    public void mergeSorted(IntList sorted) {
        if (sorted.size() <= 2) {
            int i = 0;
            while (i < sorted.size()) {
                this.array.addToSorted(sorted.getInt(i));
                ++i;
            }
            ++this.mod;
            return;
        }
        int curlen = this.array.length();
        int addlen = sorted.size();
        int[] newarr = new int[curlen + addlen];
        int curind = 0;
        int addind = 0;
        int newind = 0;
        while (curind < curlen && addind < addlen) {
            int addval;
            int curval = this.array.get(curind);
            if (curval <= (addval = sorted.getInt(addind))) {
                newarr[newind++] = curval;
                ++curind;
                continue;
            }
            newarr[newind++] = addval;
            ++addind;
        }
        while (curind < curlen) {
            newarr[newind++] = this.array.get(curind);
            ++curind;
        }
        while (addind < addlen) {
            newarr[newind++] = sorted.getInt(addind);
            ++addind;
        }
        this.array.clear();
        this.array.addAll(newarr);
        ++this.mod;
    }

    @Override
    public boolean addInt(int value) {
        this.array.add(value);
        ++this.mod;
        return true;
    }

    @Override
    public boolean addInt(int index, int value) {
        this.array.add(index, value);
        ++this.mod;
        return true;
    }

    @Override
    public boolean addAll(IntCollection coll) {
        if (coll instanceof DefaultIntList) {
            this.array.addAll(((DefaultIntList)coll).array);
            ++this.mod;
            return true;
        }
        return super.addAll(coll);
    }

    @Override
    public boolean addAll(int ... values) {
        this.array.addAll(values);
        ++this.mod;
        return true;
    }

    public int removeLastInt() {
        int old = this.array.removeLast();
        ++this.mod;
        return old;
    }

    /*
     * Unable to fully structure code
     */
    public boolean removeFromTail(int n) {
        if (n == 0) {
            return false;
        }
        if (n < 0) {
            throw new IllegalArgumentException("negative length argument");
        }
        if (this.array.length() >= n) ** GOTO lbl10
        throw new IndexOutOfBoundsException("cannot remove " + n + " elements, only " + this.array.length() + " left");
lbl-1000:
        // 1 sources

        {
            this.array.removeLast();
            --n;
lbl10:
            // 2 sources

            ** while (n > 0)
        }
lbl11:
        // 1 sources

        ++this.mod;
        return true;
    }

    @Override
    public int removeIntAt(int index) {
        int old = this.array.remove(index);
        ++this.mod;
        return old;
    }

    @Override
    public void clear() {
        this.array.clear();
        ++this.mod;
    }

    @Override
    public int firstInt() {
        return this.array.first();
    }

    @Override
    public int lastInt() {
        return this.array.last();
    }

    @Override
    public DefaultIntList subList(int fromIndex, int toIndex) {
        return new DefaultIntList(this.array.subRange(fromIndex, toIndex));
    }

    @Override
    public IntListIterator listIterator(int index) {
        return new DefaultIntListIterator(index, this){
            int ref;
            {
                this.ref = DefaultIntList.this.mod;
            }

            public void addInt(int value) {
                this.checkMod();
                super.addInt(value);
                this.ref = DefaultIntList.this.mod;
            }

            public int nextInt() {
                this.checkMod();
                return super.nextInt();
            }

            public int previousInt() {
                this.checkMod();
                return super.previousInt();
            }

            public void setInt(int value) {
                this.checkMod();
                super.setInt(value);
                this.ref = DefaultIntList.this.mod;
            }

            public void remove() {
                this.checkMod();
                super.remove();
                this.ref = DefaultIntList.this.mod;
            }

            private void checkMod() {
                if (DefaultIntList.this.mod != this.ref) {
                    throw new ConcurrentModificationException();
                }
            }
        };
    }

    public void swap(int indexA, int indexB) {
        this.array.swap(indexA, indexB);
        ++this.mod;
    }

    @Override
    public int[] toIntArray() {
        return this.array.toArray();
    }

    public int[] yieldIntArray() {
        return this.array.yieldArray();
    }

    public void trimToLength() {
        this.array.trimToLength();
        ++this.mod;
    }

    public void sort(boolean ascending) {
        this.array.sort(ascending);
        ++this.mod;
    }

    public void sort(boolean ascending, int start, int end) {
        this.array.sort(ascending, start, end);
        ++this.mod;
    }

    public int binarySearchInt(int key) throws IllegalStateException {
        return this.array.binarySearch(key);
    }

    public int binarySearchInt(int key, int fromIndex, int toIndex) throws IllegalStateException {
        return this.array.binarySearch(key, fromIndex, toIndex);
    }

    @Override
    public String toString() {
        return this.array.toString();
    }
}

