/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.intcoll;

import ch.javasoft.util.intcoll.DefaultIntList;
import ch.javasoft.util.intcoll.IntCollection;
import ch.javasoft.util.intcoll.IntHashMap;
import ch.javasoft.util.intcoll.IntIterator;
import ch.javasoft.util.intcoll.IntList;
import ch.javasoft.util.intcoll.IntListIterator;
import ch.javasoft.util.intcoll.IntMap;
import ch.javasoft.util.intcoll.IntSet;
import ch.javasoft.util.intcoll.RangeIntSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntCollections {
    public static final IntList EMPTY_LIST = IntCollections.unmodifiableList(new DefaultIntList(0));
    public static final IntSet EMPTY_SET = new RangeIntSet(0, 0);
    public static final IntMap EMPTY_MAP = IntCollections.unmodifiableMap(new IntHashMap(0));

    public static <V> IntMap<V> emptyMap() {
        return EMPTY_MAP;
    }

    public static IntCollection unmodifiableCollection(IntCollection coll) {
        return new UnmodifiableCollection(coll);
    }

    public static IntList unmodifiableList(IntList list) {
        return new UnmodifiableList(list);
    }

    public static IntSet unmodifiableSet(IntSet set) {
        return new UnmodifiableSet(set);
    }

    public static <V> IntMap<V> unmodifiableMap(IntMap<V> map) {
        return new UnmodifiableMap<V>(map);
    }

    private IntCollections() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableCollection
    implements IntCollection,
    Serializable {
        private static final long serialVersionUID = -433391395372897314L;
        public final IntCollection delegate;

        public UnmodifiableCollection(IntCollection delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean addAll(Collection<? extends Integer> c) {
            throw new UnsupportedOperationException("unmodifiable collection");
        }

        @Override
        public boolean addInt(int value) {
            throw new UnsupportedOperationException("unmodifiable collection");
        }

        @Override
        public boolean addAll(int ... values) {
            throw new UnsupportedOperationException("unmodifiable collection");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("unmodifiable collection");
        }

        @Override
        public IntIterator intIterator() {
            return this.delegate.intIterator();
        }

        @Override
        public boolean removeInt(int value) {
            throw new UnsupportedOperationException("unmodifiable collection");
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean addAll(IntCollection coll) {
            throw new UnsupportedOperationException("unmodifiable collection");
        }

        @Override
        public boolean containsInt(int value) {
            return this.delegate.containsInt(value);
        }

        @Override
        public int[] toIntArray() {
            return this.delegate.toIntArray();
        }

        @Override
        public int[] toIntArray(int[] arr) {
            return this.delegate.toIntArray(arr);
        }

        @Override
        public boolean add(Integer e) {
            throw new UnsupportedOperationException("unmodifiable collection");
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.delegate.containsAll(c);
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public Iterator<Integer> iterator() {
            return this.delegate.iterator();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("unmodifiable collection");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException("unmodifiable collection");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException("unmodifiable collection");
        }

        @Override
        public Object[] toArray() {
            return this.delegate.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.delegate.toArray(a);
        }

        @Override
        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableList
    extends UnmodifiableCollection
    implements IntList {
        private static final long serialVersionUID = 4237546197267546981L;

        public UnmodifiableList(IntList delegate) {
            super(delegate);
        }

        private IntList delegate() {
            return (IntList)this.delegate;
        }

        @Override
        public boolean addInt(int index, int value) {
            throw new UnsupportedOperationException("unmodifiable collection");
        }

        @Override
        public int getInt(int index) {
            return this.delegate().getInt(index);
        }

        @Override
        public IntListIterator listIterator(int index) {
            return this.delegate().listIterator(index);
        }

        @Override
        public int removeIntAt(int index) {
            throw new UnsupportedOperationException("unmodifiable collection");
        }

        @Override
        public int setInt(int index, int value) {
            throw new UnsupportedOperationException("unmodifiable collection");
        }

        @Override
        public IntList subList(int fromIndex, int toIndex) {
            return this.delegate().subList(fromIndex, toIndex);
        }

        @Override
        public void add(int index, Integer element) {
            throw new UnsupportedOperationException("unmodifiable collection");
        }

        @Override
        public boolean addAll(int index, Collection<? extends Integer> c) {
            throw new UnsupportedOperationException("unmodifiable collection");
        }

        @Override
        public Integer get(int index) {
            return (Integer)this.delegate().get(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.delegate().indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.delegate().lastIndexOf(o);
        }

        @Override
        public ListIterator<Integer> listIterator() {
            return this.delegate().listIterator();
        }

        @Override
        public Integer remove(int index) {
            throw new UnsupportedOperationException("unmodifiable collection");
        }

        @Override
        public Integer set(int index, Integer element) {
            throw new UnsupportedOperationException("unmodifiable collection");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableMap<V>
    implements IntMap<V>,
    Serializable {
        private static final long serialVersionUID = 6693490793775078679L;
        public final IntMap<V> delegate;

        public UnmodifiableMap(IntMap<V> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean containsKey(int key) {
            return this.delegate.containsKey(key);
        }

        @Override
        public Set<Map.Entry<Integer, V>> entrySet() {
            return this.delegate.entrySet();
        }

        @Override
        public V get(int key) {
            return this.delegate.get(key);
        }

        @Override
        public Set<IntMap.IntEntry<V>> intEntrySet() {
            return this.delegate.intEntrySet();
        }

        @Override
        public IntSet keySet() {
            return this.delegate.keySet();
        }

        @Override
        public V put(int key, V value) {
            throw new UnsupportedOperationException("unmodifiable collection");
        }

        @Override
        public void putAll(IntMap map) {
            throw new UnsupportedOperationException("unmodifiable collection");
        }

        @Override
        public V remove(int key) {
            throw new UnsupportedOperationException("unmodifiable collection");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("unmodifiable collection");
        }

        @Override
        public boolean containsKey(Object key) {
            return this.delegate.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.delegate.containsValue(value);
        }

        @Override
        public V get(Object key) {
            return this.delegate.get(key);
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public V put(Integer key, V value) {
            throw new UnsupportedOperationException("unmodifiable collection");
        }

        @Override
        public void putAll(Map<? extends Integer, ? extends V> m) {
            throw new UnsupportedOperationException("unmodifiable collection");
        }

        @Override
        public V remove(Object key) {
            throw new UnsupportedOperationException("unmodifiable collection");
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public Collection<V> values() {
            return this.delegate.values();
        }

        @Override
        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    private static class UnmodifiableSet
    extends UnmodifiableCollection
    implements IntSet {
        private static final long serialVersionUID = -2230494147377307651L;

        public UnmodifiableSet(IntSet delegate) {
            super(delegate);
        }
    }
}

