/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.genarr;

import ch.javasoft.util.genarr.AbstractGenericArray;
import ch.javasoft.util.genarr.CloneableTyped;
import ch.javasoft.util.genarr.GenericArray;
import ch.javasoft.util.genarr.GenericDynamicArray;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericFixSizeArray<T>
extends AbstractGenericArray<T>
implements CloneableTyped<GenericFixSizeArray<T>> {
    private final T[] mArray;

    public static <T> GenericFixSizeArray empty() {
        return new GenericFixSizeArray<Object>(EMPTY);
    }

    public GenericFixSizeArray() {
        this(0);
    }

    public GenericFixSizeArray(int length) {
        this.mArray = length == 0 ? EMPTY : this.newArray(length);
    }

    public GenericFixSizeArray(T ... arr) {
        this.mArray = (Object[])arr.clone();
    }

    public GenericFixSizeArray(GenericFixSizeArray<? extends T> fixSizeArray) {
        this.mArray = (Object[])fixSizeArray.mArray.clone();
    }

    public GenericFixSizeArray(GenericArray<? extends T> genericArray) {
        this.mArray = this.newArray(genericArray.length());
        genericArray.toArray((TT[])this.mArray);
    }

    public GenericFixSizeArray(Iterable<? extends T> iterable) {
        int size;
        if (iterable instanceof List) {
            size = ((List)iterable).size();
        } else {
            size = 0;
            for (T el : iterable) {
                ++size;
            }
        }
        this.mArray = this.newArray(size);
        int index = 0;
        for (T el : iterable) {
            this.mArray[index++] = el;
        }
    }

    @Override
    public int length() {
        return this.mArray.length;
    }

    @Override
    public boolean isEmpty() {
        return this.mArray.length == 0;
    }

    @Override
    public <TT> TT[] toArray(TT[] a) {
        int size = this.length();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        System.arraycopy(this.mArray, 0, a, 0, size);
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public <TT> TT[] toArray(Class<TT> componentType) {
        int size = this.length();
        Object[] arr = (Object[])Array.newInstance(componentType, size);
        System.arraycopy(this.mArray, 0, arr, 0, size);
        return arr;
    }

    @Override
    public void copyFrom(GenericArray<? extends T> src, int srcPos, int dstPos, int length) {
        if (src instanceof GenericDynamicArray) {
            this.copyFrom((GenericFixSizeArray)src, srcPos, dstPos, length);
        } else {
            src.copyTo(this, srcPos, dstPos, length);
        }
    }

    @Override
    public void copyTo(GenericArray<? super T> dst, int srcPos, int dstPos, int length) {
        if (dst instanceof GenericDynamicArray) {
            this.copyTo((GenericFixSizeArray)dst, srcPos, dstPos, length);
        } else {
            dst.set(dstPos, this.mArray, srcPos, length);
        }
    }

    @Override
    public void copyFrom(GenericFixSizeArray<? extends T> src, int srcPos, int dstPos, int length) {
        this.set(dstPos, src.mArray, srcPos, length);
    }

    @Override
    public void copyTo(GenericFixSizeArray<? super T> dst, int srcPos, int dstPos, int length) {
        dst.set(dstPos, this.mArray, srcPos, length);
    }

    @Override
    public void set(int offset, T[] arr, int srcOffset, int length) throws IndexOutOfBoundsException {
        if (offset < 0) {
            throw new IllegalArgumentException("illegal negative offset: " + offset);
        }
        if (srcOffset < 0) {
            throw new IllegalArgumentException("illegal negative src offset: " + srcOffset);
        }
        if (length < 0) {
            throw new IllegalArgumentException("illegal negative length: " + length);
        }
        if (srcOffset + length > arr.length) {
            throw new IndexOutOfBoundsException("not enough source entries: " + srcOffset + " + " + length + " > " + arr.length);
        }
        if (offset + length > this.mArray.length) {
            throw new IndexOutOfBoundsException("not enough destination space: " + offset + " + " + length + " > " + this.mArray.length);
        }
        System.arraycopy(arr, srcOffset, this.mArray, offset, length);
    }

    @Override
    public void set(int offset, Iterable<? extends T> iterable) throws IndexOutOfBoundsException {
        if (iterable instanceof GenericArray) {
            this.copyFrom((GenericArray)iterable, 0, offset, ((GenericArray)iterable).length());
        } else {
            ArrayList<T> list;
            if (iterable instanceof List) {
                list = (ArrayList<T>)iterable;
            } else {
                list = new ArrayList<T>();
                for (T el : iterable) {
                    list.add(el);
                }
            }
            if (this.mArray.length < offset + list.size()) {
                throw new IndexOutOfBoundsException("not enough target space, " + (offset + list.size()) + " > " + this.mArray.length);
            }
            Iterator it = list.iterator();
            int ii = 0;
            while (ii < this.mArray.length) {
                this.mArray[ii] = it.next();
                ++ii;
            }
        }
    }

    @Override
    public T get(int index) throws IndexOutOfBoundsException {
        return this.mArray[index];
    }

    @Override
    public T set(int index, T element) {
        T old = this.mArray[index];
        this.mArray[index] = element;
        return old;
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.length() || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("[" + fromIndex + ", " + toIndex + "] out of bounds [0, " + this.length() + "] or fromIndex > toIndex");
        }
        T[] arr = this.newArray(toIndex - fromIndex);
        System.arraycopy(this.mArray, fromIndex, arr, 0, toIndex - fromIndex);
        return new GenericFixSizeArray(arr);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public GenericFixSizeArray<T> clone() {
        GenericFixSizeArray<T> clone = new GenericFixSizeArray<T>(this.mArray.length);
        clone.copyFrom(this, 0, 0, this.mArray.length);
        return clone;
    }
}

