/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.smx.ops.matrix;

import ch.javasoft.math.BigFraction;
import ch.javasoft.math.NumberOperations;
import ch.javasoft.math.ops.BigIntegerOperations;
import ch.javasoft.smx.iface.ReadableBigIntegerRationalMatrix;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.smx.iface.ReadableVector;
import ch.javasoft.smx.iface.WritableMatrix;
import ch.javasoft.smx.iface.WritableVector;
import ch.javasoft.smx.impl.DefaultBigIntegerMatrix;
import ch.javasoft.smx.ops.Add;
import ch.javasoft.smx.ops.ExtendedMatrixOperations;
import ch.javasoft.smx.ops.Gauss;
import ch.javasoft.smx.ops.MatrixOperations;
import ch.javasoft.smx.ops.Mul;
import ch.javasoft.smx.ops.Neg;
import ch.javasoft.smx.ops.ScalarOps;
import ch.javasoft.smx.ops.Sub;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigIntegerMatrixOperations
implements MatrixOperations<BigInteger>,
ExtendedMatrixOperations<BigInteger, BigFraction> {
    private static BigIntegerMatrixOperations sInstance;

    public static BigIntegerMatrixOperations instance() {
        if (sInstance == null) {
            sInstance = new BigIntegerMatrixOperations();
        }
        return sInstance;
    }

    public ReadableMatrix<BigInteger> createReadableMatrix(BigInteger[][] values, boolean rowsInFirstDim) {
        return new DefaultBigIntegerMatrix(values, rowsInFirstDim);
    }

    @Override
    public ReadableMatrix<BigInteger> createReadableMatrix(int rows, int cols) {
        return new DefaultBigIntegerMatrix(rows, cols);
    }

    public WritableMatrix<BigInteger> createWritableMatrix(BigInteger[][] values, boolean rowsInFirstDim) {
        return new DefaultBigIntegerMatrix(values, rowsInFirstDim);
    }

    @Override
    public WritableMatrix<BigInteger> createWritableMatrix(int rows, int cols) {
        return new DefaultBigIntegerMatrix(rows, cols);
    }

    public ReadableVector<BigInteger> createReadableVector(BigInteger[] values, boolean columnVector) {
        throw new RuntimeException("not implemented");
    }

    public WritableVector<BigInteger> createWritableVector(BigInteger[] values, boolean columnVector) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public ReadableVector<BigInteger> createReadableVector(int size, boolean columnVector) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public WritableVector<BigInteger> createWritableVector(int size, boolean columnVector) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public NumberOperations<BigInteger> getNumberOperations() {
        return BigIntegerOperations.instance();
    }

    @Override
    public ReadableMatrix<BigInteger> add(ReadableMatrix<BigInteger> mxA, BigInteger value) {
        return ScalarOps.addGeneric(mxA, value);
    }

    @Override
    public ReadableMatrix<BigInteger> add(ReadableMatrix<BigInteger> mxA, ReadableMatrix<BigInteger> mxB) {
        return Add.addGeneric(mxA, mxB);
    }

    @Override
    public ReadableMatrix<BigInteger> multiply(ReadableMatrix<BigInteger> mxA, BigInteger value) {
        return ScalarOps.scaleGeneric(mxA, value);
    }

    @Override
    public ReadableMatrix<BigInteger> multiply(ReadableMatrix<BigInteger> mxA, ReadableMatrix<BigInteger> mxB) {
        return Mul.multiplyGeneric(mxA, mxB);
    }

    @Override
    public ReadableMatrix<BigInteger> negate(ReadableMatrix<BigInteger> matrix) {
        return Neg.negateGeneric(matrix);
    }

    @Override
    public ReadableMatrix<BigInteger> subtract(ReadableMatrix<BigInteger> mxA, BigInteger value) {
        return ScalarOps.subtractGeneric(mxA, value);
    }

    @Override
    public ReadableMatrix<BigInteger> subtract(ReadableMatrix<BigInteger> mxA, ReadableMatrix<BigInteger> mxB) {
        return Sub.subtractGeneric(mxA, mxB);
    }

    @Override
    public ReadableMatrix<BigInteger> transpose(ReadableMatrix<BigInteger> matrix) {
        return matrix.transpose();
    }

    @Override
    public int rank(ReadableMatrix<BigInteger> mx) {
        if (mx instanceof ReadableBigIntegerRationalMatrix) {
            return Gauss.getRationalInstance().rank((ReadableBigIntegerRationalMatrix)mx);
        }
        throw new RuntimeException("unsupported matrix type: " + mx.getClass().getName());
    }

    @Override
    public int nullity(ReadableMatrix<BigInteger> mx) {
        if (mx instanceof ReadableBigIntegerRationalMatrix) {
            return Gauss.getRationalInstance().nullity((ReadableBigIntegerRationalMatrix)mx);
        }
        throw new RuntimeException("unsupported matrix type: " + mx.getClass().getName());
    }

    @Override
    public ReadableMatrix<BigFraction> invert(ReadableMatrix<BigInteger> mx) {
        if (mx instanceof ReadableBigIntegerRationalMatrix) {
            return Gauss.getRationalInstance().invert((ReadableBigIntegerRationalMatrix)mx);
        }
        throw new RuntimeException("unsupported matrix type: " + mx.getClass().getName());
    }

    @Override
    public ReadableMatrix<BigFraction> nullspace(ReadableMatrix<BigInteger> mx) {
        if (mx instanceof ReadableBigIntegerRationalMatrix) {
            return Gauss.getRationalInstance().nullspace((ReadableBigIntegerRationalMatrix)mx);
        }
        throw new RuntimeException("unsupported matrix type: " + mx.getClass().getName());
    }
}

