/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.smx.ops;

import ch.javasoft.smx.iface.DoubleMatrix;
import ch.javasoft.smx.iface.IntMatrix;
import ch.javasoft.smx.iface.IntRationalMatrix;
import ch.javasoft.smx.iface.LongMatrix;
import ch.javasoft.smx.iface.ReadableDoubleMatrix;
import ch.javasoft.smx.iface.ReadableIntMatrix;
import ch.javasoft.smx.iface.ReadableIntRationalMatrix;
import ch.javasoft.smx.iface.ReadableLongMatrix;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.smx.iface.WritableDoubleMatrix;
import ch.javasoft.smx.iface.WritableIntMatrix;
import ch.javasoft.smx.iface.WritableIntRationalMatrix;
import ch.javasoft.smx.iface.WritableLongMatrix;
import ch.javasoft.smx.iface.WritableMatrix;
import ch.javasoft.smx.impl.DefaultDoubleMatrix;
import ch.javasoft.smx.impl.DefaultIntMatrix;
import ch.javasoft.smx.impl.DefaultIntRationalMatrix;
import ch.javasoft.smx.impl.DefaultLongMatrix;
import ch.javasoft.smx.util.DimensionCheck;
import ch.javasoft.smx.util.SmxIntegerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Neg {
    public static IntMatrix negate(ReadableIntMatrix src) {
        DefaultIntMatrix dst = new DefaultIntMatrix(src.getRowCount(), src.getColumnCount());
        Neg.negate(src, dst);
        return dst;
    }

    public static void negate(ReadableIntMatrix src, WritableIntMatrix dst) {
        DimensionCheck.checkEqualDimensions(src, dst);
        int rows = src.getRowCount();
        int cols = src.getColumnCount();
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                long value = -((long)src.getIntValueAt(row, col));
                dst.setValueAt(row, col, SmxIntegerUtil.checkIntegerRange(value));
                ++col;
            }
            ++row;
        }
    }

    public static LongMatrix negate(ReadableLongMatrix src) {
        DefaultLongMatrix dst = new DefaultLongMatrix(src.getRowCount(), src.getColumnCount());
        Neg.negate(src, dst);
        return dst;
    }

    public static void negate(ReadableLongMatrix src, WritableLongMatrix dst) {
        DimensionCheck.checkEqualDimensions(src, dst);
        int rows = src.getRowCount();
        int cols = src.getColumnCount();
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                long value = -src.getLongValueAt(row, col);
                dst.setValueAt(row, col, value);
                ++col;
            }
            ++row;
        }
    }

    public static IntRationalMatrix negate(ReadableIntRationalMatrix src) {
        DefaultIntRationalMatrix dst = new DefaultIntRationalMatrix(src.getRowCount(), src.getColumnCount());
        Neg.negate(src, dst);
        return dst;
    }

    public static void negate(ReadableIntRationalMatrix src, WritableIntRationalMatrix dst) {
        DimensionCheck.checkEqualDimensions(src, dst);
        int rows = src.getRowCount();
        int cols = src.getColumnCount();
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                long dividend = -((long)src.getIntNumeratorAt(row, col));
                SmxIntegerUtil.checkIntegerRange(dividend);
                dst.setValueAt(row, col, (int)dividend, src.getIntDenominatorAt(row, col));
                ++col;
            }
            ++row;
        }
    }

    public static DoubleMatrix negate(ReadableDoubleMatrix src) {
        DefaultDoubleMatrix dst = new DefaultDoubleMatrix(src.getRowCount(), src.getColumnCount());
        Neg.negate(src, dst);
        return dst;
    }

    public static void negate(ReadableDoubleMatrix src, WritableDoubleMatrix dst) {
        DimensionCheck.checkEqualDimensions(src, dst);
        int rows = src.getRowCount();
        int cols = src.getColumnCount();
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                dst.setValueAt(row, col, -src.getDoubleValueAt(row, col));
                ++col;
            }
            ++row;
        }
    }

    public static <N extends Number> ReadableMatrix<N> negateGeneric(ReadableMatrix<N> src) {
        int rows = src.getRowCount();
        int cols = src.getColumnCount();
        WritableMatrix<N> res = src.newInstance(rows, cols);
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                res.negate(row, col);
                ++col;
            }
            ++row;
        }
        return res.toReadableMatrix(false);
    }

    private Neg() {
    }
}

