/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.smx.ops;

import ch.javasoft.smx.ops.Hsl;
import java.util.Arrays;
import java.util.BitSet;

public class HslGateway {
    public static Hsl.Result_mc66 callMc66(int m, int n, int[] irn, int[] jcn, int nblocks) {
        return HslGateway.callMc66(m, n, irn, jcn, nblocks, true, true);
    }

    public static Hsl.Result_mc66 callMc66(int m, int n, int[] irn, int[] jcn, int nblocks, boolean printOriginal, boolean printReordered) {
        try {
            Hsl.loadLibrary();
        }
        catch (UnsatisfiedLinkError err) {
            System.err.println(err);
            System.err.println("java.library.path = " + System.getProperty("java.library.path"));
            throw err;
        }
        Hsl.Result_mc66 result = Hsl.mc66(m, n, Math.min(irn.length, jcn.length), irn, jcn, nblocks, 0);
        if (result.info.isOk()) {
            HslGateway.resultOut(m, n, irn, jcn, result, printOriginal, printReordered);
        } else if (result.info.isWarning()) {
            System.out.println("WARNING:");
            System.out.println((Object)result.info);
            HslGateway.resultOut(m, n, irn, jcn, result, printOriginal, printReordered);
        } else {
            System.err.println("ERROR:");
            System.err.println((Object)result.info);
        }
        return result;
    }

    private static void resultOut(int m, int n, int[] irn, int[] jcn, Hsl.Result_mc66 result, boolean printOriginal, boolean printReordered) {
        int j;
        BitSet[] nz = new BitSet[m];
        int i = 0;
        while (i < m) {
            nz[i] = new BitSet();
            ++i;
        }
        i = 0;
        while (i < Math.min(irn.length, jcn.length)) {
            nz[irn[i] - 1].set(jcn[i] - 1);
            ++i;
        }
        if (printOriginal) {
            System.out.println("Original:");
            i = 0;
            while (i < m) {
                j = 0;
                while (j < n) {
                    System.out.print(nz[i].get(j) ? (char)'X' : '.');
                    ++j;
                }
                System.out.println();
                ++i;
            }
        }
        if (printReordered) {
            System.out.println("Reordered:");
            i = 0;
            while (i < m) {
                j = 0;
                while (j < n) {
                    System.out.print(nz[result.row_order[i] - 1].get(result.column_order[j] - 1) ? HslGateway.getBlockChar(i, j, result) : (char)'.');
                    ++j;
                }
                System.out.println();
                ++i;
            }
        }
        System.out.println("row-order:\t" + Arrays.toString(result.row_order));
        System.out.println("col-order:\t" + Arrays.toString(result.column_order));
        System.out.println("netcut:\t" + result.netcut);
        System.out.println("rowdiff:\t" + result.rowdiff);
        i = 0;
        while (i < result.kblocks) {
            System.out.println("block " + (char)(65 + i) + ":\t[" + result.rowptr[i] + ", " + result.colptr[i] + "] to [" + (result.rowptr[i + 1] - 1) + ", " + (result.colptr[i + 1] - 1) + "]");
            ++i;
        }
    }

    private static char getBlockChar(int i, int j, Hsl.Result_mc66 result) {
        int r = Arrays.binarySearch(result.rowptr, i + 1);
        int c = Arrays.binarySearch(result.colptr, j + 1);
        if (r < 0) {
            r = -(r + 1) - 1;
        }
        if (c < 0) {
            c = -(c + 1) - 1;
        }
        if (r >= result.rowptr.length - 1 || c >= result.colptr.length - 1) {
            return 'X';
        }
        if (r != c) {
            return 'Z';
        }
        return (char)(65 + r);
    }
}

