/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.smx.impl;

import ch.javasoft.smx.iface.ReadableDoubleMatrix;
import ch.javasoft.smx.impl.AbstractDoubleMatrix;
import ch.javasoft.smx.impl.SubDoubleMatrix;
import java.util.ArrayList;

public abstract class DynamicDoubleMatrix
extends AbstractDoubleMatrix {
    private ArrayList<double[]> mVectors = new ArrayList();

    protected DynamicDoubleMatrix() {
    }

    protected double[] getVector(int index) {
        return this.mVectors.get(index);
    }

    protected int getVectorCount() {
        return this.mVectors.size();
    }

    protected int getVectorSize() {
        if (this.getVectorCount() == 0) {
            return 0;
        }
        return this.getVector(0).length;
    }

    protected void swapVectors(int indexA, int indexB) {
        if (indexA == indexB) {
            return;
        }
        double[] vA = this.mVectors.set(indexA, this.mVectors.get(indexB));
        this.mVectors.set(indexB, vA);
    }

    protected void setVector(int index, double[] vector) {
        if (index == this.mVectors.size()) {
            this.mVectors.add(vector);
        } else {
            this.mVectors.set(index, vector);
        }
    }

    protected double[] removeVector(int index) {
        return this.mVectors.remove(index);
    }

    protected DynamicDoubleMatrix initClone(DynamicDoubleMatrix clone) {
        int size = this.mVectors.size();
        int ii = 0;
        while (ii < size) {
            clone.mVectors.add((double[])this.mVectors.get(ii).clone());
            ++ii;
        }
        return clone;
    }

    public static class DynamicColumns
    extends DynamicDoubleMatrix {
        public DynamicColumns() {
        }

        public DynamicColumns(ReadableDoubleMatrix src) {
            SubDoubleMatrix vCol = new SubDoubleMatrix(src.toDoubleMatrix(false), true, false);
            int cols = src.getColumnCount();
            int col = 0;
            while (col < cols) {
                if (col == 0) {
                    vCol.selectColumn(col);
                } else {
                    vCol.switchSelectedColumn(0, col);
                }
                this.setVector(col, vCol.toDoubleArray());
                ++col;
            }
        }

        public double[] getDoubleColumn(int col) {
            return (double[])this.getColumn(col).clone();
        }

        public double[] getColumn(int col) {
            return this.getVector(col);
        }

        public double[] addColumn() {
            double[] newCol = new double[this.getRowCount()];
            this.addColumn(newCol);
            return newCol;
        }

        public void addColumn(double[] newCol) {
            int rows = this.getRowCount();
            int cols = this.getColumnCount();
            if (cols > 0 && newCol.length != rows) {
                throw new IllegalArgumentException("new column was expected to have length " + rows + " but has length " + newCol.length);
            }
            this.setVector(cols, newCol);
        }

        public double[] removeColumn(int col) {
            return this.removeVector(col);
        }

        public DynamicColumns clone() {
            return (DynamicColumns)this.initClone(new DynamicColumns());
        }

        public DynamicColumns newInstance(int rows, int cols) {
            throw new RuntimeException("not implemented");
        }

        public DynamicColumns newInstance(Double[][] data, boolean rowsInDim1) {
            throw new RuntimeException("not implemented");
        }

        public int getRowCount() {
            return this.getVectorSize();
        }

        public int getColumnCount() {
            return this.getVectorCount();
        }

        public double getDoubleValueAt(int row, int col) {
            return this.getVector(col)[row];
        }

        public void setValueAt(int row, int col, double value) {
            this.getVector((int)col)[row] = value;
        }

        public void swapRows(int rowA, int rowB) {
            int cols = this.getColumnCount();
            int col = 0;
            while (col < cols) {
                double tmp = this.getDoubleValueAt(rowA, col);
                this.setValueAt(rowA, col, this.getDoubleValueAt(rowB, col));
                this.setValueAt(rowB, col, tmp);
                ++col;
            }
        }

        public DynamicColumns transpose() {
            DynamicColumns tr = new DynamicColumns();
            int i = 0;
            while (i < this.getVectorCount()) {
                double[] col = this.getVector(i);
                tr.addColumn((double[])col.clone());
                ++i;
            }
            return tr;
        }
    }

    public static class DynamicRows
    extends DynamicDoubleMatrix {
        public DynamicRows() {
        }

        public DynamicRows(ReadableDoubleMatrix src) {
            SubDoubleMatrix vRow = new SubDoubleMatrix(src.toDoubleMatrix(false), false, true);
            int rows = src.getRowCount();
            int row = 0;
            while (row < rows) {
                vRow.selectRow(row);
                this.setVector(row, vRow.toDoubleArray());
                vRow.unselectRow(row);
                ++row;
            }
        }

        public double[] getDoubleRow(int row) {
            return (double[])this.getRow(row).clone();
        }

        public double[] getRow(int row) {
            return this.getVector(row);
        }

        public double[] addRow() {
            double[] newRow = new double[this.getColumnCount()];
            this.addRow(newRow);
            return newRow;
        }

        public void addRow(double[] newRow) {
            int cols = this.getColumnCount();
            int rows = this.getRowCount();
            if (rows > 0 && newRow.length != cols) {
                throw new IllegalArgumentException("new row was expected to have length " + cols + " but has length " + newRow.length);
            }
            this.setVector(rows, newRow);
        }

        public double[] removeRow(int row) {
            return this.removeVector(row);
        }

        public DynamicRows clone() {
            return (DynamicRows)this.initClone(new DynamicRows());
        }

        public DynamicRows newInstance(int rows, int cols) {
            throw new RuntimeException("not implemented");
        }

        public DynamicRows newInstance(Double[][] data, boolean rowsInDim1) {
            throw new RuntimeException("not implemented");
        }

        public int getRowCount() {
            return this.getVectorCount();
        }

        public int getColumnCount() {
            return this.getVectorSize();
        }

        public double getDoubleValueAt(int row, int col) {
            return this.getVector(row)[col];
        }

        public void setValueAt(int row, int col, double value) {
            this.getVector((int)row)[col] = value;
        }

        public void swapRows(int rowA, int rowB) {
            this.swapVectors(rowA, rowB);
        }

        public DynamicRows transpose() {
            DynamicRows tr = new DynamicRows();
            int i = 0;
            while (i < this.getVectorCount()) {
                double[] col = this.getVector(i);
                tr.addRow((double[])col.clone());
                ++i;
            }
            return tr;
        }
    }
}

