/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.polco.parse;

import ch.javasoft.math.array.NumberArrayOperations;
import ch.javasoft.math.array.parse.MatrixData;
import ch.javasoft.math.array.parse.MatrixParser;
import ch.javasoft.polco.PolyhedralCone;
import ch.javasoft.polco.config.Arithmetic;
import ch.javasoft.polco.impl.DefaultInequalityCone;
import ch.javasoft.polco.impl.DefaultPolyhedralCone;
import ch.javasoft.polco.parse.LogPkg;
import ch.javasoft.polco.parse.util.ArithmeticConverter;
import ch.javasoft.polco.parse.util.SortUtil;
import ch.javasoft.util.numeric.Zero;
import java.io.IOException;
import java.io.InputStream;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextParser {
    public <N extends Number, A> PolyhedralCone<N, A> parse(Element config, Arithmetic<N, A> arithmetic, Zero zero, InputStream eq, InputStream ine) throws IOException {
        MatrixParser ineParser = new MatrixParser(ine);
        LogPkg.LOGGER.info("parsed inequality matrix " + ineParser);
        A[] ineMatrix = TextParser.convertMatrix(arithmetic, zero, ineParser.getData());
        SortUtil.sortMatrix(config, arithmetic, zero, ineMatrix);
        if (eq == null) {
            return new DefaultInequalityCone<N, A>(arithmetic.getLinAlgOperations(zero), ineMatrix);
        }
        MatrixParser eqParser = new MatrixParser(eq);
        LogPkg.LOGGER.info("parsed equality matrix " + eqParser);
        A[] eqMatrix = TextParser.convertMatrix(arithmetic, zero, eqParser.getData());
        SortUtil.sortMatrix(config, arithmetic, zero, eqMatrix);
        return new DefaultPolyhedralCone<N, A>(arithmetic.getLinAlgOperations(zero), eqMatrix, ineMatrix);
    }

    private static <N extends Number, A> A[] convertMatrix(Arithmetic<N, A> arithmetic, Zero zero, MatrixData matrixData) {
        NumberArrayOperations naops = arithmetic.getLinAlgOperations(zero).getNumberArrayOperations();
        try {
            return matrixData.getMatrixCast(naops.getNumberOperators().arrayClass());
        }
        catch (ClassCastException e) {
            return matrixData.getMatrixConverted(new ArithmeticConverter<N, A>(arithmetic, zero));
        }
    }
}

