/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.polco.parse;

import ch.javasoft.math.array.NumberArrayOperations;
import ch.javasoft.polco.PolyhedralCone;
import ch.javasoft.polco.config.Arithmetic;
import ch.javasoft.polco.impl.DefaultInequalityCone;
import ch.javasoft.polco.parse.InputStreamParser;
import ch.javasoft.polco.parse.LogPkg;
import ch.javasoft.polco.parse.util.ArithmeticConverter;
import ch.javasoft.polco.parse.util.SortUtil;
import ch.javasoft.util.numeric.Zero;
import java.io.IOException;
import java.io.InputStream;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CddParser
implements InputStreamParser {
    @Override
    public <N extends Number, A> PolyhedralCone<N, A> parse(Element config, Arithmetic<N, A> arithmetic, Zero zero, InputStream in) throws IOException {
        ch.javasoft.cdd.parser.CddParser parser = new ch.javasoft.cdd.parser.CddParser(in);
        LogPkg.LOGGER.info("parsed " + parser);
        A[] matrix = CddParser.getMatrix(arithmetic, zero, parser);
        SortUtil.sortMatrix(config, arithmetic, zero, matrix);
        return new DefaultInequalityCone<N, A>(arithmetic.getLinAlgOperations(zero), matrix);
    }

    private static <N extends Number, A> A[] getMatrix(Arithmetic<N, A> arithmetic, Zero zero, ch.javasoft.cdd.parser.CddParser parser) {
        NumberArrayOperations naops = arithmetic.getLinAlgOperations(zero).getNumberArrayOperations();
        try {
            return parser.getMatrixCast(naops.getNumberOperators().arrayClass());
        }
        catch (ClassCastException e) {
            return parser.getMatrixConverted(new ArithmeticConverter<N, A>(arithmetic, zero));
        }
    }
}

