/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.polco.metabolic;

import ch.javasoft.math.BigFraction;
import ch.javasoft.math.linalg.LinAlgOperations;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.efm.ElementaryFluxModes;
import ch.javasoft.metabolic.efm.output.CallbackGranularity;
import ch.javasoft.metabolic.impl.FractionNumberStoichMetabolicNetwork;
import ch.javasoft.polco.EqualityPolyhedralCone;
import ch.javasoft.polco.PolyhedralCone;
import ch.javasoft.polco.config.TypeConverter;
import ch.javasoft.polco.metabolic.EfmOutputCallbackToExtremeRayCallback;
import ch.javasoft.polco.metabolic.LogPkg;
import ch.javasoft.polco.transform.TransformedEqualityCone;
import ch.javasoft.polco.xenum.ExtremeRayCallback;
import ch.javasoft.polco.xenum.ExtremeRayEnumerator;
import ch.javasoft.smx.impl.DefaultBigIntegerRationalMatrix;
import ch.javasoft.util.logging.LogWriter;
import ch.javasoft.util.logging.Loggers;
import ch.javasoft.util.numeric.Zero;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EfmExtremeRayEnumerator
implements ExtremeRayEnumerator {
    private static final Logger LOG = LogPkg.LOGGER;
    private final Zero coreZero;
    private final boolean allowMatrixRowScaling;

    public EfmExtremeRayEnumerator(Zero coreZero, boolean allowMatrixRowScaling) {
        this.coreZero = coreZero;
        this.allowMatrixRowScaling = allowMatrixRowScaling;
    }

    @Override
    public <IN extends Number, IA, RN extends Number, RA> long enumerateExtremeRays(PolyhedralCone<IN, IA> polycone, ExtremeRayCallback<RN, RA> callback, LinAlgOperations<RN, RA> callbackOps) {
        TransformedEqualityCone<IN, IA> eqCone;
        LOG.info("input cone: " + polycone);
        if (polycone instanceof EqualityPolyhedralCone) {
            eqCone = (TransformedEqualityCone<IN, IA>)polycone;
        } else {
            if (Loggers.isLoggable(LOG, Level.FINER)) {
                polycone.writeToMultiline(new LogWriter(LOG, Level.FINER));
            }
            eqCone = new TransformedEqualityCone<IN, IA>(polycone);
            LOG.info("transformed cone: " + eqCone);
        }
        if (Loggers.isLoggable(LOG, Level.FINER)) {
            eqCone.writeToMultiline(new LogWriter(LOG, Level.FINER));
        }
        TypeConverter<IN, IA, RN, RA> converter = new TypeConverter<IN, IA, RN, RA>(polycone.getLinAlgOperations(), callbackOps, this.allowMatrixRowScaling);
        PolyhedralCone<RN, RA> outCone = converter.convertPolyhedralCone(eqCone);
        EfmOutputCallbackToExtremeRayCallback<RN, RA> efmCb = new EfmOutputCallbackToExtremeRayCallback<RN, RA>(outCone, callback, CallbackGranularity.DoubleUncompressed, false, this.coreZero);
        MetabolicNetwork metaNet = this.createMetabolicNetwork(eqCone);
        ElementaryFluxModes.calculateCallback(metaNet, efmCb);
        long rays = efmCb.getIndex();
        LOG.info(String.valueOf(rays) + " extreme rays");
        return rays;
    }

    private <Num extends Number, Arr> MetabolicNetwork createMetabolicNetwork(EqualityPolyhedralCone<Num, Arr> eqCone) {
        double tol = this.coreZero.mZeroPos;
        int rows = eqCone.getRowCountA();
        int cols = eqCone.getDimensions();
        DefaultBigIntegerRationalMatrix matrix = new DefaultBigIntegerRationalMatrix(rows, cols);
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                Object nval = eqCone.getA(row, col);
                BigFraction val = nval instanceof Double || nval instanceof Float ? BigFraction.valueOfAdjusted(((Number)nval).doubleValue(), tol) : BigFraction.valueOf(nval);
                matrix.setValueAt(row, col, val);
                ++col;
            }
            ++row;
        }
        return new FractionNumberStoichMetabolicNetwork(matrix, new boolean[cols]);
    }
}

