/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.polco.callback.hdf5;

import ch.javasoft.factory.ConfigException;
import ch.javasoft.polco.Numeric;
import ch.javasoft.polco.callback.hdf5.Hdf5Callback;
import ch.javasoft.polco.callback.hdf5.XmlElement;
import ch.javasoft.polco.config.Arithmetic;
import ch.javasoft.polco.config.NumericFactory;
import ch.javasoft.xml.config.ConstConfigParser;
import ch.javasoft.xml.config.FileConfigParser;
import ch.javasoft.xml.config.XmlConfigException;
import ch.javasoft.xml.config.XmlUtil;
import ch.javasoft.xml.factory.XmlConfiguredFactory;
import java.io.File;
import java.io.IOException;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hdf5CallbackFactory
implements NumericFactory {
    @Override
    public <Num extends Number, Arr> XmlConfiguredFactory<? extends Numeric<Num, Arr>> createTypedFactory(Arithmetic<Num, Arr> arithmetic) {
        return new XmlConfiguredFactory<Hdf5Callback<Num, Arr>>(){

            @Override
            public Hdf5Callback<Num, Arr> create(Element config) throws ConfigException {
                File file = null;
                try {
                    Element elFile = XmlUtil.getRequiredSingleChildElement(config, ch.javasoft.polco.config.XmlElement.file);
                    Element elGZip = XmlUtil.getRequiredSingleChildElement(config, XmlElement.gzip);
                    Element elChunk = XmlUtil.getRequiredSingleChildElement(config, XmlElement.chunk);
                    int gzipLevel = ConstConfigParser.parseIntConstant(elGZip);
                    int rowsPerChunk = ConstConfigParser.parseIntConstant(elChunk);
                    file = FileConfigParser.parseFile(elFile);
                    return new Hdf5Callback(file, gzipLevel, rowsPerChunk);
                }
                catch (XmlConfigException e) {
                    throw new ConfigException(e.getMessage(), e, e.getPath());
                }
                catch (IOException e) {
                    throw new ConfigException("cannot create file" + (file == null ? "" : " " + file.getAbsolutePath()) + ", e=" + e, e, XmlUtil.getElementPath(config, true));
                }
            }
        };
    }
}

