/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.polco.callback.hdf5;

import ch.javasoft.math.array.ArrayOperations;
import ch.javasoft.math.array.Converter;
import ch.javasoft.math.array.NumberArrayOperations;
import ch.javasoft.math.operator.impl.DoubleOperators;
import ch.javasoft.polco.EqualityPolyhedralCone;
import ch.javasoft.polco.InequalityPolyhedralCone;
import ch.javasoft.polco.PolyhedralCone;
import ch.javasoft.polco.xenum.ExtremeRayCallback;
import ch.javasoft.polco.xenum.ExtremeRayEvent;
import ch.javasoft.util.ExceptionUtil;
import ch.javasoft.util.numeric.Zero;
import java.io.File;
import java.io.IOException;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.h5.H5Datatype;
import ncsa.hdf.object.h5.H5File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hdf5Callback<Num extends Number, Arr>
implements ExtremeRayCallback<Num, Arr> {
    private final H5File file;
    private final int gzipLevel;
    private final int rowsPerChunk;
    private Dataset dataset;
    private Converter<Num, Arr, Double, double[]> converter;
    private double[] buffer;

    public Hdf5Callback(File file, int gzipLevel, int rowsPerChunk) throws IOException {
        if (file.exists()) {
            file.delete();
        }
        this.file = new H5File(file.getAbsolutePath(), HDF5Constants.H5F_ACC_TRUNC);
        this.gzipLevel = gzipLevel;
        this.rowsPerChunk = rowsPerChunk;
    }

    @Override
    public boolean initialize(ExtremeRayEvent<Num, Arr> event) throws IOException {
        PolyhedralCone<Num, Arr> cone = event.getPolyhedralCone();
        NumberArrayOperations naops = cone.getLinAlgOperations().getNumberArrayOperations();
        try {
            H5Datatype typeUInt32 = new H5Datatype(H5.H5Tcopy(HDF5Constants.H5T_STD_U32LE));
            H5Datatype typeMatrix = this.getH5MatrixType(naops.numberClass());
            this.converter = this.getDoubleConverter(naops);
            int dim = cone.getDimensions();
            long rays = event.getRayCount();
            long[] dim1 = new long[]{1L};
            long[] rDims = new long[]{rays, dim};
            this.buffer = new double[this.getBufferRows(cone, rays) * dim];
            long[] rChunk = this.getChunk(rays, dim);
            String desc = String.valueOf(cone.toString()) + " = { x = R' c , R:" + rDims[0] + "x" + rDims[1] + "   for some c >= 0 }";
            H5Datatype typeString = new H5Datatype(3, desc.length(), 0, 0);
            this.file.createScalarDS("description", null, typeString, dim1, null, null, 0, new String[]{desc});
            this.file.createScalarDS("dim", null, typeUInt32, dim1, null, null, 0, new int[]{cone.getDimensions()});
            if (!(cone instanceof InequalityPolyhedralCone)) {
                this.writeMatrix(typeMatrix, "A", cone.getA());
            }
            if (!(cone instanceof EqualityPolyhedralCone)) {
                this.writeMatrix(typeMatrix, "B", cone.getB());
            }
            this.dataset = this.file.createScalarDS("R", null, typeMatrix, rDims, rDims, rChunk, this.gzipLevel, null);
            this.dataset.init();
        }
        catch (Exception e) {
            throw ExceptionUtil.toRuntimeExceptionOr(IOException.class, e);
        }
        return true;
    }

    private int getBufferRows(PolyhedralCone<Num, Arr> cone, long rayCount) {
        long bufferRows = rayCount;
        if (!(cone instanceof InequalityPolyhedralCone)) {
            bufferRows = Math.max(bufferRows, (long)cone.getRowCountA());
        }
        if (!(cone instanceof EqualityPolyhedralCone)) {
            bufferRows = Math.max(bufferRows, (long)cone.getRowCountB());
        }
        return (int)Math.min(bufferRows, (long)this.rowsPerChunk);
    }

    private long[] getChunk(long rows, long cols) {
        return new long[]{Math.min(rows, (long)this.rowsPerChunk), cols};
    }

    private H5Datatype getH5MatrixType(Class<Num> numberClass) throws HDF5LibraryException {
        return new H5Datatype(H5.H5Tcopy(HDF5Constants.H5T_IEEE_F64LE));
    }

    private Converter<Num, Arr, Double, double[]> getDoubleConverter(NumberArrayOperations<Num, Arr> naops) {
        return new DoubleOperators(new Zero()).getNumberArrayOperations().getConverterFrom(naops);
    }

    private void writeConvertedBuffered(Dataset ds, Arr vec, long index, long count, int length) throws Exception {
        int offset = (int)(index % (long)this.rowsPerChunk * (long)length);
        this.converter.convertVector(vec, 0, this.buffer, offset, length);
        long rowsToWrite = index + 1L == count ? count % (long)this.rowsPerChunk : (offset + length < this.buffer.length ? 0L : (long)this.rowsPerChunk);
        if (rowsToWrite > 0L) {
            long[] start = ds.getStartDims();
            long[] stride = ds.getStride();
            long[] sizes = ds.getSelectedDims();
            start[0] = (long)this.rowsPerChunk * (index / (long)this.rowsPerChunk);
            start[1] = 0L;
            sizes[0] = rowsToWrite;
            sizes[1] = length;
            stride[0] = 1L;
            stride[1] = 1L;
            ds.write(this.buffer);
        }
    }

    private void writeMatrix(H5Datatype dataType, String varName, Arr[] matrix) throws Exception {
        ArrayOperations<Arr> aops = this.converter.getNumberArrayOperationsInput().getArrayOperations();
        int rows = aops.getRowCount(matrix);
        int cols = aops.getColumnCount(matrix);
        long[] dims = new long[]{rows, cols};
        long[] rChunk = this.getChunk(rows, cols);
        Dataset ds = this.file.createScalarDS(varName, null, dataType, dims, dims, rChunk, this.gzipLevel, null);
        ds.init();
        int r = 0;
        while (r < rows) {
            this.writeConvertedBuffered(ds, matrix[r], r, rows, cols);
            ++r;
        }
    }

    @Override
    public void outputExtremeRay(ExtremeRayEvent<Num, Arr> event, long index, Arr extremeRay) throws IOException {
        try {
            this.writeConvertedBuffered(this.dataset, extremeRay, index, event.getRayCount(), event.getPolyhedralCone().getDimensions());
        }
        catch (Exception e) {
            throw ExceptionUtil.toRuntimeExceptionOr(IOException.class, e);
        }
    }

    @Override
    public void terminate(ExtremeRayEvent<Num, Arr> event) throws IOException {
        try {
            this.file.close();
            this.buffer = null;
            this.dataset = null;
        }
        catch (HDF5Exception e) {
            throw ExceptionUtil.toRuntimeExceptionOr(IOException.class, e);
        }
    }
}

