/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.polco.adapter;

import ch.javasoft.math.array.ArrayOperations;
import ch.javasoft.polco.xenum.ExtremeRayCallback;
import ch.javasoft.polco.xenum.ExtremeRayEvent;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AdapterCallback<Num extends Number, Arr>
implements ExtremeRayCallback<Num, Arr> {
    private final ArrayOperations<Arr> arrayOps;
    private Arr[] extremeRays;

    public AdapterCallback(ArrayOperations<Arr> arrayOps) {
        this.arrayOps = arrayOps;
    }

    @Override
    public boolean initialize(ExtremeRayEvent<Num, Arr> event) throws IOException {
        long count = event.getRayCount();
        if (count > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException("too many extreme rays (out of int range): " + count);
        }
        this.extremeRays = this.arrayOps.newMatrix((int)count, event.getPolyhedralCone().getDimensions());
        return true;
    }

    @Override
    public void outputExtremeRay(ExtremeRayEvent<Num, Arr> event, long index, Arr extremeRay) throws IOException {
        this.extremeRays[(int)index] = extremeRay;
    }

    @Override
    public void terminate(ExtremeRayEvent<Num, Arr> event) throws IOException {
    }

    public Arr[] yield() {
        Arr[] rays = this.extremeRays;
        this.extremeRays = null;
        return rays;
    }
}

