/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.polco;

import ch.javasoft.metabolic.Norm;
import ch.javasoft.metabolic.compress.CompressionMethod;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.progress.ProgressType;
import ch.javasoft.polco.PolyhedralCone;
import ch.javasoft.polco.TestHelper;
import ch.javasoft.polco.callback.NullCallback;
import ch.javasoft.polco.config.Arithmetic;
import ch.javasoft.polco.config.ArithmeticCallback;
import ch.javasoft.polco.config.PolcoConfig;
import ch.javasoft.polco.metabolic.EfmExtremeRayEnumerator;
import ch.javasoft.polco.parse.CddParser;
import ch.javasoft.polco.xenum.ExtremeRayCallback;
import ch.javasoft.util.logging.Loggers;
import ch.javasoft.util.numeric.Zero;
import java.io.File;
import java.io.FileInputStream;
import java.util.logging.Level;
import junit.framework.TestCase;

public class CddExtTest
extends TestCase {
    private static final File FOLDER_EXT = new File("../cdd-data/ext");
    private static final ch.javasoft.metabolic.efm.config.Arithmetic arithmetic;

    static {
        CompressionMethod[] compression = CompressionMethod.NONE;
        arithmetic = ch.javasoft.metabolic.efm.config.Arithmetic.varint;
        if (Config.initForJUnitTest("pattern-tree-minzero", "MostZerosOrAbsLexMin", compression, false, arithmetic, Norm.min, 4, ProgressType.None)) {
            Loggers.getRootLogger().setLevel(Level.FINE);
        }
    }

    public void testCcp4() throws Exception {
        this.internalTestExt("ccp4.ext");
    }

    public void testCcp5() throws Exception {
        this.internalTestExt("ccp5.ext");
    }

    public void testCcp6() throws Exception {
        this.internalTestExt("ccp6.ext");
    }

    public void testCcp7() throws Exception {
        this.internalTestExt("ccp7.ext");
    }

    public void testCcp8() throws Exception {
        this.internalTestExt("ccp8.ext");
    }

    public void testCutPolytope4() throws Exception {
        this.internalTestExt("cutPolytope4.ext");
    }

    public void testCutPolytope5() throws Exception {
        this.internalTestExt("cutPolytope5.ext");
    }

    public void testCutPolytope6() throws Exception {
        this.internalTestExt("cutPolytope6.ext");
    }

    public void testCutPolytope7() throws Exception {
        this.internalTestExt("cutPolytope7.ext");
    }

    public void testCutPolytope8() throws Exception {
        this.internalTestExt("cutPolytope8.ext");
    }

    public void testCcc4() throws Exception {
        this.internalTestExt("ccc4.ext");
    }

    public void testCcc5() throws Exception {
        this.internalTestExt("ccc5.ext");
    }

    public void testCcc6() throws Exception {
        this.internalTestExt("ccc6.ext");
    }

    public void testCcc7() throws Exception {
        this.internalTestExt("ccc7.ext");
    }

    public void testCube6() throws Exception {
        this.internalTestExt("cube6.ext");
    }

    public void testCube8() throws Exception {
        this.internalTestExt("cube8.ext");
    }

    public void testCube10() throws Exception {
        this.internalTestExt("cube10.ext");
    }

    public void testCross6() throws Exception {
        this.internalTestExt("cross6.ext");
    }

    public void testCross8() throws Exception {
        this.internalTestExt("cross8.ext");
    }

    public void testCross10() throws Exception {
        this.internalTestExt("cross10.ext");
    }

    public void testCyclic10_4() throws Exception {
        this.internalTestExt("cyclic10-4.ext");
    }

    public void testCyclic12_6() throws Exception {
        this.internalTestExt("cyclic12-6.ext");
    }

    public void testCyclic14_8() throws Exception {
        this.internalTestExt("cyclic14-8.ext");
    }

    public void testCyclic16_10() throws Exception {
        this.internalTestExt("cyclic16-10.ext");
    }

    public void testCyclic18_12() throws Exception {
        this.internalTestExt("cyclic18-12.ext");
    }

    public void testCyclic20_14() throws Exception {
        this.internalTestExt("cyclic20-14.ext");
    }

    public void testCyclic30_16() throws Exception {
        this.internalTestExt("cyclic30-16.ext");
    }

    public void testProdmT62() throws Exception {
        this.internalTestExt("prodmT62.ext");
    }

    public void testTc7_30() throws Exception {
        this.internalTestExt("tc7-30.ext");
    }

    public void testTc8_38() throws Exception {
        this.internalTestExt("tc8-38.ext");
    }

    public void testTc9_48() throws Exception {
        this.internalTestExt("tc9-48.ext");
    }

    public void testTc10_83() throws Exception {
        this.internalTestExt("tc10-83.ext");
    }

    public void testTc11_106() throws Exception {
        this.internalTestExt("tc11-106.ext");
    }

    public void testTc12_152() throws Exception {
        this.internalTestExt("tc12-152.ext");
    }

    public void testTc13_254() throws Exception {
        this.internalTestExt("tc13-254.ext");
    }

    public void internalTestExt(String fileName) throws Exception {
        final File file = new File(FOLDER_EXT, fileName);
        final String testName = String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "{" + file.getAbsolutePath() + "}";
        TestHelper.getPolcoArithmetic(arithmetic).callback(new ArithmeticCallback<Void>(){

            @Override
            public <N extends Number, A> Void callback(Arithmetic<N, A> arithmetic) throws Exception {
                Zero zero = arithmetic.getDefaultZero();
                PolyhedralCone<N, A> cone = new CddParser().parse(null, arithmetic, zero, new FileInputStream(file));
                EfmExtremeRayEnumerator xray = new EfmExtremeRayEnumerator(zero, true);
                ExtremeRayCallback callback = NullCallback.instance();
                PolcoConfig.traceJunitConfig(arithmetic, zero, testName);
                xray.enumerateExtremeRays(cone, callback, arithmetic.getLinAlgOperations(zero));
                return null;
            }
        });
    }
}

