/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.polco;

import ch.javasoft.math.BigFraction;
import ch.javasoft.polco.adapter.Options;
import ch.javasoft.polco.adapter.PolcoAdapter;
import ch.javasoft.util.logging.Loggers;
import java.io.File;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.logging.Level;
import junit.framework.TestCase;

public class AdapterTest
extends TestCase {
    public void testMarcoScarnoDblDbl() throws Exception {
        double[][] iq = new double[][]{{-1.0, 1.0, 0.0}, {2.5, -1.0, -1.0}, {2.5, -1.0, 1.0}};
        this.internalTestDbl(null, null, iq);
    }

    public void testMarcoScarnoDblInt() throws Exception {
        double[][] iq = new double[][]{{-1.0, 1.0, 0.0}, {2.5, -1.0, -1.0}, {2.5, -1.0, 1.0}};
        this.internalTestInt(null, null, iq);
    }

    public void testMarcoScarnoDblFra() throws Exception {
        double[][] iq = new double[][]{{-1.0, 1.0, 0.0}, {2.5, -1.0, -1.0}, {2.5, -1.0, 1.0}};
        this.internalTestFra(null, null, iq);
    }

    public void testMarcoScarnoIntDbl() throws Exception {
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[3];
        nArray[0] = -1;
        nArray[1] = 1;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{5, -2, -2};
        nArrayArray[2] = new int[]{5, -2, 2};
        int[][] iq = nArrayArray;
        this.internalTestDbl((Options)null, (int[][])null, iq);
    }

    public void testMarcoScarnoIntInt() throws Exception {
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[3];
        nArray[0] = -1;
        nArray[1] = 1;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{5, -2, -2};
        nArrayArray[2] = new int[]{5, -2, 2};
        int[][] iq = nArrayArray;
        this.internalTestInt((Options)null, (int[][])null, iq);
    }

    public void testMarcoScarnoIntFra() throws Exception {
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[3];
        nArray[0] = -1;
        nArray[1] = 1;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{5, -2, -2};
        nArrayArray[2] = new int[]{5, -2, 2};
        int[][] iq = nArrayArray;
        this.internalTestFra((Options)null, (int[][])null, iq);
    }

    public void testMarcoScarnoLongDbl() throws Exception {
        long[][] lArrayArray = new long[3][];
        long[] lArray = new long[3];
        lArray[0] = -1L;
        lArray[1] = 1L;
        lArrayArray[0] = lArray;
        lArrayArray[1] = new long[]{5L, -2L, -2L};
        lArrayArray[2] = new long[]{5L, -2L, 2L};
        long[][] iq = lArrayArray;
        this.internalTestDbl((Options)null, (long[][])null, iq);
    }

    public void testMarcoScarnoLongInt() throws Exception {
        long[][] lArrayArray = new long[3][];
        long[] lArray = new long[3];
        lArray[0] = -1L;
        lArray[1] = 1L;
        lArrayArray[0] = lArray;
        lArrayArray[1] = new long[]{5L, -2L, -2L};
        lArrayArray[2] = new long[]{5L, -2L, 2L};
        long[][] iq = lArrayArray;
        this.internalTestInt((Options)null, (long[][])null, iq);
    }

    public void testMarcoScarnoLongFra() throws Exception {
        long[][] lArrayArray = new long[3][];
        long[] lArray = new long[3];
        lArray[0] = -1L;
        lArray[1] = 1L;
        lArrayArray[0] = lArray;
        lArrayArray[1] = new long[]{5L, -2L, -2L};
        lArrayArray[2] = new long[]{5L, -2L, 2L};
        long[][] iq = lArrayArray;
        this.internalTestFra((Options)null, (long[][])null, iq);
    }

    public void testMarcoScarnoFraDbl() throws Exception {
        BigFraction[][] iq = new BigFraction[][]{{BigFraction.valueOf(-1L), BigFraction.ONE, BigFraction.ZERO}, {BigFraction.valueOf(5L, 2L), BigFraction.valueOf(-1L), BigFraction.valueOf(-1L)}, {BigFraction.valueOf(5L, 2L), BigFraction.valueOf(-1L), BigFraction.valueOf(1L)}};
        this.internalTestDbl(null, null, iq);
    }

    public void testMarcoScarnoFraInt() throws Exception {
        BigFraction[][] iq = new BigFraction[][]{{BigFraction.valueOf(-1L), BigFraction.ONE, BigFraction.ZERO}, {BigFraction.valueOf(5L, 2L), BigFraction.valueOf(-1L), BigFraction.valueOf(-1L)}, {BigFraction.valueOf(5L, 2L), BigFraction.valueOf(-1L), BigFraction.valueOf(1L)}};
        this.internalTestInt(null, null, iq);
    }

    public void testMarcoScarnoFraFra() throws Exception {
        BigFraction[][] iq = new BigFraction[][]{{BigFraction.valueOf(-1L), BigFraction.ONE, BigFraction.ZERO}, {BigFraction.valueOf(5L, 2L), BigFraction.valueOf(-1L), BigFraction.valueOf(-1L)}, {BigFraction.valueOf(5L, 2L), BigFraction.valueOf(-1L), BigFraction.valueOf(1L)}};
        this.internalTestFra(null, null, iq);
    }

    public void testZeroConstraintsDblDbl() throws Exception {
        double[][] iq = new double[][]{{1.0, 0.0, 1.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 1.0, 1.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 1.0, 1.0}};
        this.internalTestDbl(null, null, iq);
    }

    public void testBinaryApproachDblDbl() throws Exception {
        double[][] eq = new double[][]{{1.0, -1.0, -1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, -1.0, -1.0, -1.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 1.0, -1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, -1.0}};
        double[][] iq = new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
        this.internalTestDbl(null, eq, iq);
    }

    public void testBinaryApproachIntDbl() throws Exception {
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[7];
        nArray[0] = 1;
        nArray[1] = -1;
        nArray[2] = -1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[7];
        nArray2[1] = 1;
        nArray2[3] = -1;
        nArray2[4] = -1;
        nArray2[5] = -1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[7];
        nArray3[2] = 1;
        nArray3[4] = 1;
        nArray3[5] = -1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[7];
        nArray4[5] = 1;
        nArray4[6] = -1;
        nArrayArray[3] = nArray4;
        int[][] eq = nArrayArray;
        int[][] nArrayArray2 = new int[6][];
        int[] nArray5 = new int[7];
        nArray5[0] = 1;
        nArrayArray2[0] = nArray5;
        int[] nArray6 = new int[7];
        nArray6[1] = 1;
        nArrayArray2[1] = nArray6;
        int[] nArray7 = new int[7];
        nArray7[2] = 1;
        nArrayArray2[2] = nArray7;
        int[] nArray8 = new int[7];
        nArray8[3] = 1;
        nArrayArray2[3] = nArray8;
        int[] nArray9 = new int[7];
        nArray9[5] = 1;
        nArrayArray2[4] = nArray9;
        int[] nArray10 = new int[7];
        nArray10[6] = 1;
        nArrayArray2[5] = nArray10;
        int[][] iq = nArrayArray2;
        this.internalTestDbl((Options)null, eq, iq);
    }

    public void testBinaryApproachLongDbl() throws Exception {
        long[][] lArrayArray = new long[4][];
        long[] lArray = new long[7];
        lArray[0] = 1L;
        lArray[1] = -1L;
        lArray[2] = -1L;
        lArrayArray[0] = lArray;
        long[] lArray2 = new long[7];
        lArray2[1] = 1L;
        lArray2[3] = -1L;
        lArray2[4] = -1L;
        lArray2[5] = -1L;
        lArrayArray[1] = lArray2;
        long[] lArray3 = new long[7];
        lArray3[2] = 1L;
        lArray3[4] = 1L;
        lArray3[5] = -1L;
        lArrayArray[2] = lArray3;
        long[] lArray4 = new long[7];
        lArray4[5] = 1L;
        lArray4[6] = -1L;
        lArrayArray[3] = lArray4;
        long[][] eq = lArrayArray;
        long[][] lArrayArray2 = new long[6][];
        long[] lArray5 = new long[7];
        lArray5[0] = 1L;
        lArrayArray2[0] = lArray5;
        long[] lArray6 = new long[7];
        lArray6[1] = 1L;
        lArrayArray2[1] = lArray6;
        long[] lArray7 = new long[7];
        lArray7[2] = 1L;
        lArrayArray2[2] = lArray7;
        long[] lArray8 = new long[7];
        lArray8[3] = 1L;
        lArrayArray2[3] = lArray8;
        long[] lArray9 = new long[7];
        lArray9[5] = 1L;
        lArrayArray2[4] = lArray9;
        long[] lArray10 = new long[7];
        lArray10[6] = 1L;
        lArrayArray2[5] = lArray10;
        long[][] iq = lArrayArray2;
        this.internalTestDbl((Options)null, eq, iq);
    }

    public void testBinaryApproachFraDbl() throws Exception {
        BigFraction[][] eq = new BigFraction[][]{{BigFraction.valueOf(1L), BigFraction.valueOf(-1L), BigFraction.valueOf(-1L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L)}, {BigFraction.valueOf(0L), BigFraction.valueOf(1L), BigFraction.valueOf(0L), BigFraction.valueOf(-1L), BigFraction.valueOf(-1L), BigFraction.valueOf(-1L), BigFraction.valueOf(0L)}, {BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(1L), BigFraction.valueOf(0L), BigFraction.valueOf(1L), BigFraction.valueOf(-1L), BigFraction.valueOf(0L)}, {BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(1L), BigFraction.valueOf(-1L)}};
        BigFraction[][] iq = new BigFraction[][]{{BigFraction.valueOf(1L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L)}, {BigFraction.valueOf(0L), BigFraction.valueOf(1L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L)}, {BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(1L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L)}, {BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(1L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L)}, {BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(1L), BigFraction.valueOf(0L)}, {BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(1L)}};
        this.internalTestDbl(null, eq, iq);
    }

    public void testBinaryApproachDblInt() throws Exception {
        double[][] eq = new double[][]{{1.0, -1.0, -1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, -1.0, -1.0, -1.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 1.0, -1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, -1.0}};
        double[][] iq = new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
        this.internalTestInt(null, eq, iq);
    }

    public void testBinaryApproachIntInt() throws Exception {
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[7];
        nArray[0] = 1;
        nArray[1] = -1;
        nArray[2] = -1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[7];
        nArray2[1] = 1;
        nArray2[3] = -1;
        nArray2[4] = -1;
        nArray2[5] = -1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[7];
        nArray3[2] = 1;
        nArray3[4] = 1;
        nArray3[5] = -1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[7];
        nArray4[5] = 1;
        nArray4[6] = -1;
        nArrayArray[3] = nArray4;
        int[][] eq = nArrayArray;
        int[][] nArrayArray2 = new int[6][];
        int[] nArray5 = new int[7];
        nArray5[0] = 1;
        nArrayArray2[0] = nArray5;
        int[] nArray6 = new int[7];
        nArray6[1] = 1;
        nArrayArray2[1] = nArray6;
        int[] nArray7 = new int[7];
        nArray7[2] = 1;
        nArrayArray2[2] = nArray7;
        int[] nArray8 = new int[7];
        nArray8[3] = 1;
        nArrayArray2[3] = nArray8;
        int[] nArray9 = new int[7];
        nArray9[5] = 1;
        nArrayArray2[4] = nArray9;
        int[] nArray10 = new int[7];
        nArray10[6] = 1;
        nArrayArray2[5] = nArray10;
        int[][] iq = nArrayArray2;
        this.internalTestInt((Options)null, eq, iq);
    }

    public void testBinaryApproachLongInt() throws Exception {
        long[][] lArrayArray = new long[4][];
        long[] lArray = new long[7];
        lArray[0] = 1L;
        lArray[1] = -1L;
        lArray[2] = -1L;
        lArrayArray[0] = lArray;
        long[] lArray2 = new long[7];
        lArray2[1] = 1L;
        lArray2[3] = -1L;
        lArray2[4] = -1L;
        lArray2[5] = -1L;
        lArrayArray[1] = lArray2;
        long[] lArray3 = new long[7];
        lArray3[2] = 1L;
        lArray3[4] = 1L;
        lArray3[5] = -1L;
        lArrayArray[2] = lArray3;
        long[] lArray4 = new long[7];
        lArray4[5] = 1L;
        lArray4[6] = -1L;
        lArrayArray[3] = lArray4;
        long[][] eq = lArrayArray;
        long[][] lArrayArray2 = new long[6][];
        long[] lArray5 = new long[7];
        lArray5[0] = 1L;
        lArrayArray2[0] = lArray5;
        long[] lArray6 = new long[7];
        lArray6[1] = 1L;
        lArrayArray2[1] = lArray6;
        long[] lArray7 = new long[7];
        lArray7[2] = 1L;
        lArrayArray2[2] = lArray7;
        long[] lArray8 = new long[7];
        lArray8[3] = 1L;
        lArrayArray2[3] = lArray8;
        long[] lArray9 = new long[7];
        lArray9[5] = 1L;
        lArrayArray2[4] = lArray9;
        long[] lArray10 = new long[7];
        lArray10[6] = 1L;
        lArrayArray2[5] = lArray10;
        long[][] iq = lArrayArray2;
        this.internalTestInt((Options)null, eq, iq);
    }

    public void testBinaryApproachFraInt() throws Exception {
        BigFraction[][] eq = new BigFraction[][]{{BigFraction.valueOf(1L), BigFraction.valueOf(-1L), BigFraction.valueOf(-1L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L)}, {BigFraction.valueOf(0L), BigFraction.valueOf(1L), BigFraction.valueOf(0L), BigFraction.valueOf(-1L), BigFraction.valueOf(-1L), BigFraction.valueOf(-1L), BigFraction.valueOf(0L)}, {BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(1L), BigFraction.valueOf(0L), BigFraction.valueOf(1L), BigFraction.valueOf(-1L), BigFraction.valueOf(0L)}, {BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(1L), BigFraction.valueOf(-1L)}};
        BigFraction[][] iq = new BigFraction[][]{{BigFraction.valueOf(1L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L)}, {BigFraction.valueOf(0L), BigFraction.valueOf(1L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L)}, {BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(1L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L)}, {BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(1L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L)}, {BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(1L), BigFraction.valueOf(0L)}, {BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(1L)}};
        this.internalTestInt(null, eq, iq);
    }

    public void testBinaryApproachDblFra() throws Exception {
        double[][] eq = new double[][]{{1.0, -1.0, -1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, -1.0, -1.0, -1.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 1.0, -1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, -1.0}};
        double[][] iq = new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
        this.internalTestFra(null, eq, iq);
    }

    public void testBinaryApproachIntFra() throws Exception {
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[7];
        nArray[0] = 1;
        nArray[1] = -1;
        nArray[2] = -1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[7];
        nArray2[1] = 1;
        nArray2[3] = -1;
        nArray2[4] = -1;
        nArray2[5] = -1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[7];
        nArray3[2] = 1;
        nArray3[4] = 1;
        nArray3[5] = -1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[7];
        nArray4[5] = 1;
        nArray4[6] = -1;
        nArrayArray[3] = nArray4;
        int[][] eq = nArrayArray;
        int[][] nArrayArray2 = new int[6][];
        int[] nArray5 = new int[7];
        nArray5[0] = 1;
        nArrayArray2[0] = nArray5;
        int[] nArray6 = new int[7];
        nArray6[1] = 1;
        nArrayArray2[1] = nArray6;
        int[] nArray7 = new int[7];
        nArray7[2] = 1;
        nArrayArray2[2] = nArray7;
        int[] nArray8 = new int[7];
        nArray8[3] = 1;
        nArrayArray2[3] = nArray8;
        int[] nArray9 = new int[7];
        nArray9[5] = 1;
        nArrayArray2[4] = nArray9;
        int[] nArray10 = new int[7];
        nArray10[6] = 1;
        nArrayArray2[5] = nArray10;
        int[][] iq = nArrayArray2;
        this.internalTestFra((Options)null, eq, iq);
    }

    public void testBinaryApproachLongFra() throws Exception {
        long[][] lArrayArray = new long[4][];
        long[] lArray = new long[7];
        lArray[0] = 1L;
        lArray[1] = -1L;
        lArray[2] = -1L;
        lArrayArray[0] = lArray;
        long[] lArray2 = new long[7];
        lArray2[1] = 1L;
        lArray2[3] = -1L;
        lArray2[4] = -1L;
        lArray2[5] = -1L;
        lArrayArray[1] = lArray2;
        long[] lArray3 = new long[7];
        lArray3[2] = 1L;
        lArray3[4] = 1L;
        lArray3[5] = -1L;
        lArrayArray[2] = lArray3;
        long[] lArray4 = new long[7];
        lArray4[5] = 1L;
        lArray4[6] = -1L;
        lArrayArray[3] = lArray4;
        long[][] eq = lArrayArray;
        long[][] lArrayArray2 = new long[6][];
        long[] lArray5 = new long[7];
        lArray5[0] = 1L;
        lArrayArray2[0] = lArray5;
        long[] lArray6 = new long[7];
        lArray6[1] = 1L;
        lArrayArray2[1] = lArray6;
        long[] lArray7 = new long[7];
        lArray7[2] = 1L;
        lArrayArray2[2] = lArray7;
        long[] lArray8 = new long[7];
        lArray8[3] = 1L;
        lArrayArray2[3] = lArray8;
        long[] lArray9 = new long[7];
        lArray9[5] = 1L;
        lArrayArray2[4] = lArray9;
        long[] lArray10 = new long[7];
        lArray10[6] = 1L;
        lArrayArray2[5] = lArray10;
        long[][] iq = lArrayArray2;
        this.internalTestFra((Options)null, eq, iq);
    }

    public void testBinaryApproachFraFra() throws Exception {
        BigFraction[][] eq = new BigFraction[][]{{BigFraction.valueOf(1L), BigFraction.valueOf(-1L), BigFraction.valueOf(-1L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L)}, {BigFraction.valueOf(0L), BigFraction.valueOf(1L), BigFraction.valueOf(0L), BigFraction.valueOf(-1L), BigFraction.valueOf(-1L), BigFraction.valueOf(-1L), BigFraction.valueOf(0L)}, {BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(1L), BigFraction.valueOf(0L), BigFraction.valueOf(1L), BigFraction.valueOf(-1L), BigFraction.valueOf(0L)}, {BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(1L), BigFraction.valueOf(-1L)}};
        BigFraction[][] iq = new BigFraction[][]{{BigFraction.valueOf(1L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L)}, {BigFraction.valueOf(0L), BigFraction.valueOf(1L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L)}, {BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(1L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L)}, {BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(1L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L)}, {BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(1L), BigFraction.valueOf(0L)}, {BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(0L), BigFraction.valueOf(1L)}};
        this.internalTestFra(null, eq, iq);
    }

    public void testBinaryApproachIntDblWithOpts() throws Exception {
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[7];
        nArray[0] = 1;
        nArray[1] = -1;
        nArray[2] = -1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[7];
        nArray2[1] = 1;
        nArray2[3] = -1;
        nArray2[4] = -1;
        nArray2[5] = -1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[7];
        nArray3[2] = 1;
        nArray3[4] = 1;
        nArray3[5] = -1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[7];
        nArray4[5] = 1;
        nArray4[6] = -1;
        nArrayArray[3] = nArray4;
        int[][] eq = nArrayArray;
        int[][] nArrayArray2 = new int[6][];
        int[] nArray5 = new int[7];
        nArray5[0] = 1;
        nArrayArray2[0] = nArray5;
        int[] nArray6 = new int[7];
        nArray6[1] = 1;
        nArrayArray2[1] = nArray6;
        int[] nArray7 = new int[7];
        nArray7[2] = 1;
        nArrayArray2[2] = nArray7;
        int[] nArray8 = new int[7];
        nArray8[3] = 1;
        nArrayArray2[3] = nArray8;
        int[] nArray9 = new int[7];
        nArray9[5] = 1;
        nArrayArray2[4] = nArray9;
        int[] nArray10 = new int[7];
        nArray10[6] = 1;
        nArrayArray2[5] = nArray10;
        int[][] iq = nArrayArray2;
        Options opts = new Options();
        opts.setLoglevel(Level.FINER);
        opts.setLogFormat(Options.LogFormat.plain);
        opts.setLogFile(new File(System.getProperty("java.io.tmpdir"), String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".log"));
        this.internalTestDbl(opts, eq, iq);
    }

    protected void internalTestDbl(Options opts, double[][] eq, double[][] iq) throws Exception {
        PolcoAdapter polco = opts == null ? new PolcoAdapter() : new PolcoAdapter(opts);
        double[][] rays = polco.getDoubleRays(eq, iq);
        int maxOut = 100;
        int i = 0;
        while (i < Math.min(100, rays.length)) {
            Loggers.getRootLogger().info("ray[" + i + "] = " + Arrays.toString(rays[i]));
            ++i;
        }
        if (rays.length > 100) {
            Loggers.getRootLogger().info("...");
        }
    }

    protected void internalTestDbl(Options opts, int[][] eq, int[][] iq) throws Exception {
        PolcoAdapter polco = opts == null ? new PolcoAdapter() : new PolcoAdapter(opts);
        double[][] rays = polco.getDoubleRays(eq, iq);
        int maxOut = 100;
        int i = 0;
        while (i < Math.min(100, rays.length)) {
            Loggers.getRootLogger().info("ray[" + i + "] = " + Arrays.toString(rays[i]));
            ++i;
        }
        if (rays.length > 100) {
            Loggers.getRootLogger().info("...");
        }
    }

    protected void internalTestDbl(Options opts, long[][] eq, long[][] iq) throws Exception {
        PolcoAdapter polco = opts == null ? new PolcoAdapter() : new PolcoAdapter(opts);
        double[][] rays = polco.getDoubleRays(eq, iq);
        int maxOut = 100;
        int i = 0;
        while (i < Math.min(100, rays.length)) {
            Loggers.getRootLogger().info("ray[" + i + "] = " + Arrays.toString(rays[i]));
            ++i;
        }
        if (rays.length > 100) {
            Loggers.getRootLogger().info("...");
        }
    }

    protected void internalTestDbl(Options opts, BigFraction[][] eq, BigFraction[][] iq) throws Exception {
        PolcoAdapter polco = opts == null ? new PolcoAdapter() : new PolcoAdapter(opts);
        double[][] rays = polco.getDoubleRays(eq, iq);
        int maxOut = 100;
        int i = 0;
        while (i < Math.min(100, rays.length)) {
            Loggers.getRootLogger().info("ray[" + i + "] = " + Arrays.toString(rays[i]));
            ++i;
        }
        if (rays.length > 100) {
            Loggers.getRootLogger().info("...");
        }
    }

    protected void internalTestInt(Options opts, double[][] eq, double[][] iq) throws Exception {
        PolcoAdapter polco = opts == null ? new PolcoAdapter() : new PolcoAdapter(opts);
        BigInteger[][] rays = polco.getBigIntegerRays(eq, iq);
        int maxOut = 100;
        int i = 0;
        while (i < Math.min(100, rays.length)) {
            Loggers.getRootLogger().info("ray[" + i + "] = " + Arrays.toString(rays[i]));
            ++i;
        }
        if (rays.length > 100) {
            Loggers.getRootLogger().info("...");
        }
    }

    protected void internalTestInt(Options opts, int[][] eq, int[][] iq) throws Exception {
        PolcoAdapter polco = opts == null ? new PolcoAdapter() : new PolcoAdapter(opts);
        BigInteger[][] rays = polco.getBigIntegerRays(eq, iq);
        int maxOut = 100;
        int i = 0;
        while (i < Math.min(100, rays.length)) {
            Loggers.getRootLogger().info("ray[" + i + "] = " + Arrays.toString(rays[i]));
            ++i;
        }
        if (rays.length > 100) {
            Loggers.getRootLogger().info("...");
        }
    }

    protected void internalTestInt(Options opts, long[][] eq, long[][] iq) throws Exception {
        PolcoAdapter polco = opts == null ? new PolcoAdapter() : new PolcoAdapter(opts);
        BigInteger[][] rays = polco.getBigIntegerRays(eq, iq);
        int maxOut = 100;
        int i = 0;
        while (i < Math.min(100, rays.length)) {
            Loggers.getRootLogger().info("ray[" + i + "] = " + Arrays.toString(rays[i]));
            ++i;
        }
        if (rays.length > 100) {
            Loggers.getRootLogger().info("...");
        }
    }

    protected void internalTestInt(Options opts, BigFraction[][] eq, BigFraction[][] iq) throws Exception {
        PolcoAdapter polco = opts == null ? new PolcoAdapter() : new PolcoAdapter(opts);
        BigInteger[][] rays = polco.getBigIntegerRays(eq, iq);
        int maxOut = 100;
        int i = 0;
        while (i < Math.min(100, rays.length)) {
            Loggers.getRootLogger().info("ray[" + i + "] = " + Arrays.toString(rays[i]));
            ++i;
        }
        if (rays.length > 100) {
            Loggers.getRootLogger().info("...");
        }
    }

    protected void internalTestFra(Options opts, double[][] eq, double[][] iq) throws Exception {
        PolcoAdapter polco = opts == null ? new PolcoAdapter() : new PolcoAdapter(opts);
        BigFraction[][] rays = polco.getBigFractionRays(eq, iq);
        int maxOut = 100;
        int i = 0;
        while (i < Math.min(100, rays.length)) {
            Loggers.getRootLogger().info("ray[" + i + "] = " + Arrays.toString(rays[i]));
            ++i;
        }
        if (rays.length > 100) {
            Loggers.getRootLogger().info("...");
        }
    }

    protected void internalTestFra(Options opts, int[][] eq, int[][] iq) throws Exception {
        PolcoAdapter polco = opts == null ? new PolcoAdapter() : new PolcoAdapter(opts);
        BigFraction[][] rays = polco.getBigFractionRays(eq, iq);
        int maxOut = 100;
        int i = 0;
        while (i < Math.min(100, rays.length)) {
            Loggers.getRootLogger().info("ray[" + i + "] = " + Arrays.toString(rays[i]));
            ++i;
        }
        if (rays.length > 100) {
            Loggers.getRootLogger().info("...");
        }
    }

    protected void internalTestFra(Options opts, long[][] eq, long[][] iq) throws Exception {
        PolcoAdapter polco = opts == null ? new PolcoAdapter() : new PolcoAdapter(opts);
        BigFraction[][] rays = polco.getBigFractionRays(eq, iq);
        int maxOut = 100;
        int i = 0;
        while (i < Math.min(100, rays.length)) {
            Loggers.getRootLogger().info("ray[" + i + "] = " + Arrays.toString(rays[i]));
            ++i;
        }
        if (rays.length > 100) {
            Loggers.getRootLogger().info("...");
        }
    }

    protected void internalTestFra(Options opts, BigFraction[][] eq, BigFraction[][] iq) throws Exception {
        PolcoAdapter polco = opts == null ? new PolcoAdapter() : new PolcoAdapter(opts);
        BigFraction[][] rays = polco.getBigFractionRays(eq, iq);
        int maxOut = 100;
        int i = 0;
        while (i < Math.min(100, rays.length)) {
            Loggers.getRootLogger().info("ray[" + i + "] = " + Arrays.toString(rays[i]));
            ++i;
        }
        if (rays.length > 100) {
            Loggers.getRootLogger().info("...");
        }
    }
}

