/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.numneric.varint;

import ch.javasoft.numeric.varint.VarInt;
import ch.javasoft.numeric.varint.VarIntFactory;
import ch.javasoft.numeric.varint.VarIntNumber;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;

public class VarIntTest
extends TestCase {
    private final Random rnd = new Random();
    private final boolean trace = false;
    private final int n_mixed = 100000;
    private final int n_compare = 100000;
    private final int maxbytelen = 50;

    public void testCreate() {
        this.outTyped(VarIntFactory.create(0L));
        this.outTyped(VarIntFactory.create(-1L));
        this.outTyped(VarIntFactory.create(1L));
        this.outTyped(VarIntFactory.create(10L));
        this.outTyped(VarIntFactory.create(-10L));
        this.outTyped(VarIntFactory.create(77L));
        this.outTyped(VarIntFactory.create(-77L));
        this.outTyped(VarIntFactory.create(Integer.MAX_VALUE));
        this.outTyped(VarIntFactory.create(Integer.MIN_VALUE));
        this.outTyped(VarIntFactory.create(Integer.MIN_VALUE).negate());
        this.outTyped(VarIntFactory.create(Long.MAX_VALUE));
        this.outTyped(VarIntFactory.create(Long.MIN_VALUE));
        this.outTyped(VarIntFactory.create(Long.MIN_VALUE).negate());
    }

    public void testBitLength() {
        this.doBitLength(0L);
        this.doBitLength(1L);
        this.doBitLength(2L);
        this.doBitLength(10L);
        this.doBitLength(77L);
        this.doBitLength(Integer.MAX_VALUE);
        this.doBitLength(Long.MAX_VALUE);
        this.doBitLength(-1L);
        this.doBitLength(-2L);
        this.doBitLength(-10L);
        this.doBitLength(-77L);
        this.doBitLength(Integer.MIN_VALUE);
        this.doBitLength(Long.MIN_VALUE);
    }

    private void doBitLength(long value) {
        VarIntNumber val = VarIntFactory.create(value);
        VarIntTest.assertEquals((int)val.toBigInteger().bitLength(), (int)val.bitLength());
    }

    public void testBitCount() {
        this.testBitCount(0L);
        this.testBitCount(1L);
        this.testBitCount(2L);
        this.testBitCount(10L);
        this.testBitCount(77L);
        this.testBitCount(Integer.MAX_VALUE);
        this.testBitCount(Long.MAX_VALUE);
        this.testBitCount(-1L);
        this.testBitCount(-2L);
        this.testBitCount(-10L);
        this.testBitCount(-77L);
        this.testBitCount(Integer.MIN_VALUE);
        this.testBitCount(Long.MIN_VALUE);
    }

    private void testBitCount(long value) {
        VarIntNumber val = VarIntFactory.create(value);
        VarIntTest.assertEquals((int)val.toBigInteger().bitCount(), (int)val.bitCount());
    }

    public void testToByteArray() throws IOException {
        this.doToByteArray(0L);
        this.doToByteArray(1L);
        this.doToByteArray(-1L);
        this.doToByteArray(2L);
        this.doToByteArray(-2L);
        this.doToByteArray(127L);
        this.doToByteArray(128L);
        this.doToByteArray(-127L);
        this.doToByteArray(-128L);
        this.doToByteArray(-129L);
        this.doToByteArray(Integer.MAX_VALUE);
        this.doToByteArray(0x80000000L);
        this.doToByteArray(Integer.MIN_VALUE);
        this.doToByteArray(-2147483649L);
        this.doToByteArray(Long.MAX_VALUE);
        this.doToByteArray(Long.MIN_VALUE);
        this.doToByteArray(Long.MIN_VALUE);
        this.doToByteArray(Long.MAX_VALUE);
    }

    public void doToByteArray(long value) throws IOException {
        VarIntNumber val1 = VarIntFactory.create(value);
        byte[] bytes = val1.toByteArray();
        VarIntNumber val2 = VarIntFactory.create(bytes);
        VarIntTest.assertEquals((Object)val1, (Object)val2);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        val1.writeTo(out);
        byte[] buf = out.toByteArray();
        VarIntNumber val3 = VarIntFactory.readFrom(new ByteArrayInputStream(buf));
        VarIntTest.assertEquals((Object)val1, (Object)val3);
        VarIntNumber val4 = VarIntFactory.readFrom(buf, null);
        VarIntTest.assertEquals((Object)val1, (Object)val4);
    }

    public void testIO() throws IOException {
        this.doIO(-1);
    }

    public void testIOInt() throws IOException {
        this.doIO(0);
    }

    public void testIOLong() throws IOException {
        this.doIO(1);
    }

    public void testIOBigInteger() throws IOException {
        this.doIO(2);
    }

    public void doIO(int type) throws IOException {
        VarInt[] vals = new VarInt[100000];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int i = 0;
        while (i < 100000) {
            VarInt val;
            vals[i] = val = this.randomValue(type);
            val.writeTo(out);
            ++i;
        }
        byte[] buf = out.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(buf);
        AtomicInteger pos = new AtomicInteger();
        int i2 = 0;
        while (i2 < 100000) {
            byte[] bytes = vals[i2].toByteArray();
            VarIntNumber read1 = VarIntFactory.create(bytes);
            VarIntNumber read2 = VarIntFactory.readFrom(in);
            VarIntNumber read3 = VarIntFactory.readFrom(buf, pos);
            VarIntTest.assertEquals((String)("val[" + i2 + "]"), (Object)vals[i2], (Object)read1);
            VarIntTest.assertEquals((String)("val[" + i2 + "]"), (Object)vals[i2], (Object)read2);
            VarIntTest.assertEquals((String)("val[" + i2 + "]"), (Object)vals[i2], (Object)read3);
            ++i2;
        }
    }

    public void testAdd() {
        this.doAddN(100000, -1);
    }

    public void testAddOverflow() {
        this.doAdd(Integer.MAX_VALUE, 1L);
        this.doAdd(Integer.MIN_VALUE, -1L);
        this.doAdd(Long.MAX_VALUE, 1L);
        this.doAdd(Long.MIN_VALUE, -1L);
    }

    public void testAddInt() {
        this.doAddN(100000, 0);
    }

    public void testAddLong() {
        this.doAddN(100000, 1);
    }

    public void testAddBigIngeger() {
        this.doAddN(100000, 2);
    }

    private void doAddN(int n, int type) {
        int i = 0;
        while (i < n) {
            this.doAdd(this.randomValue(type), this.randomValue(type));
            ++i;
        }
    }

    private void doAdd(long val1, long val2) {
        this.doAdd(VarIntFactory.create(val1), VarIntFactory.create(val2));
    }

    private void doAdd(VarInt val1, VarInt val2) {
        BigInteger exp = val1.toBigInteger().add(val2.toBigInteger());
        BigInteger act = val1.add(val2).toBigInteger();
        VarIntTest.assertEquals((String)(val1 + " + " + val2), (Object)exp, (Object)act);
    }

    public void testSub() {
        this.doSubN(100000, 0);
    }

    public void testSubOverflow() {
        this.doSub(0L, Integer.MIN_VALUE);
        this.doSub(Integer.MIN_VALUE, 1L);
        this.doSub(Integer.MAX_VALUE, -1L);
        this.doSub(0L, Long.MIN_VALUE);
        this.doSub(Long.MIN_VALUE, 1L);
        this.doSub(Long.MAX_VALUE, -1L);
    }

    public void testSubInt() {
        this.doSubN(100000, 0);
    }

    public void testSubLong() {
        this.doSubN(100000, 1);
    }

    public void testSubBigIngeger() {
        this.doSubN(100000, 2);
    }

    private void doSubN(int n, int type) {
        int i = 0;
        while (i < n) {
            this.doSub(this.randomValue(type), this.randomValue(type));
            ++i;
        }
    }

    private void doSub(long val1, long val2) {
        this.doAdd(VarIntFactory.create(val1), VarIntFactory.create(val2));
    }

    private void doSub(VarInt val1, VarInt val2) {
        BigInteger exp = val1.toBigInteger().subtract(val2.toBigInteger());
        BigInteger act = val1.subtract(val2).toBigInteger();
        VarIntTest.assertEquals((String)(val1 + " - " + val2), (Object)exp, (Object)act);
    }

    public void testMul() {
        this.doMulN(100000, -1);
    }

    public void testMulOverflow() {
        this.doMul(Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.doMul(Integer.MIN_VALUE, Integer.MIN_VALUE);
        this.doMul(Integer.MAX_VALUE, Integer.MIN_VALUE);
        this.doMul(Long.MAX_VALUE, Long.MAX_VALUE);
        this.doMul(Long.MIN_VALUE, Long.MIN_VALUE);
        this.doMul(Long.MAX_VALUE, Long.MIN_VALUE);
    }

    public void testMulInt() {
        this.doMulN(100000, 0);
    }

    public void testMulLong() {
        this.doMulN(100000, 1);
    }

    public void testMulBigIngeger() {
        this.doMulN(100000, 2);
    }

    private void doMulN(int n, int type) {
        int i = 0;
        while (i < n) {
            this.doMul(this.randomValue(type), this.randomValue(type));
            ++i;
        }
    }

    private void doMul(long val1, long val2) {
        this.doMul(VarIntFactory.create(val1), VarIntFactory.create(val2));
    }

    private void doMul(VarInt val1, VarInt val2) {
        BigInteger exp = val1.toBigInteger().multiply(val2.toBigInteger());
        BigInteger act = val1.multiply(val2).toBigInteger();
        VarIntTest.assertEquals((String)(val1 + " * " + val2), (Object)exp, (Object)act);
    }

    public void testDiv() {
        this.doDivN(100000, -1);
    }

    public void testDivOverflow() {
        this.doDiv(Integer.MIN_VALUE, -1L);
        this.doDiv(Long.MIN_VALUE, -1L);
    }

    public void testDivByZero() {
        this.doDiv(this.rnd.nextInt(), 0L);
        this.doDiv(this.rnd.nextLong(), 0L);
        this.doDiv(this.randomValue(-1), VarIntFactory.create(BigInteger.ZERO));
    }

    public void testDivRound() {
        VarInt[] nums = new VarInt[]{VarIntFactory.create(55L), VarIntFactory.create(25L), VarIntFactory.create(16L), VarIntFactory.create(11L), VarIntFactory.create(10L), VarIntFactory.create(-10L), VarIntFactory.create(-11L), VarIntFactory.create(-16L), VarIntFactory.create(-25L), VarIntFactory.create(-55L)};
        VarInt[][] varIntArrayArray = new VarInt[8][];
        varIntArrayArray[0] = new VarInt[]{VarIntFactory.create(6L), VarIntFactory.create(3L), VarIntFactory.create(2L), VarIntFactory.create(2L), VarIntFactory.create(1L), VarIntFactory.create(-1L), VarIntFactory.create(-2L), VarIntFactory.create(-2L), VarIntFactory.create(-3L), VarIntFactory.create(-6L)};
        varIntArrayArray[1] = new VarInt[]{VarIntFactory.create(5L), VarIntFactory.create(2L), VarIntFactory.create(1L), VarIntFactory.create(1L), VarIntFactory.create(1L), VarIntFactory.create(-1L), VarIntFactory.create(-1L), VarIntFactory.create(-1L), VarIntFactory.create(-2L), VarIntFactory.create(-5L)};
        varIntArrayArray[2] = new VarInt[]{VarIntFactory.create(6L), VarIntFactory.create(3L), VarIntFactory.create(2L), VarIntFactory.create(2L), VarIntFactory.create(1L), VarIntFactory.create(-1L), VarIntFactory.create(-1L), VarIntFactory.create(-1L), VarIntFactory.create(-2L), VarIntFactory.create(-5L)};
        varIntArrayArray[3] = new VarInt[]{VarIntFactory.create(5L), VarIntFactory.create(2L), VarIntFactory.create(1L), VarIntFactory.create(1L), VarIntFactory.create(1L), VarIntFactory.create(-1L), VarIntFactory.create(-2L), VarIntFactory.create(-2L), VarIntFactory.create(-3L), VarIntFactory.create(-6L)};
        varIntArrayArray[4] = new VarInt[]{VarIntFactory.create(6L), VarIntFactory.create(3L), VarIntFactory.create(2L), VarIntFactory.create(1L), VarIntFactory.create(1L), VarIntFactory.create(-1L), VarIntFactory.create(-1L), VarIntFactory.create(-2L), VarIntFactory.create(-3L), VarIntFactory.create(-6L)};
        varIntArrayArray[5] = new VarInt[]{VarIntFactory.create(5L), VarIntFactory.create(2L), VarIntFactory.create(2L), VarIntFactory.create(1L), VarIntFactory.create(1L), VarIntFactory.create(-1L), VarIntFactory.create(-1L), VarIntFactory.create(-2L), VarIntFactory.create(-2L), VarIntFactory.create(-5L)};
        varIntArrayArray[6] = new VarInt[]{VarIntFactory.create(6L), VarIntFactory.create(2L), VarIntFactory.create(2L), VarIntFactory.create(1L), VarIntFactory.create(1L), VarIntFactory.create(-1L), VarIntFactory.create(-1L), VarIntFactory.create(-2L), VarIntFactory.create(-2L), VarIntFactory.create(-6L)};
        VarInt[] varIntArray = new VarInt[10];
        varIntArray[4] = VarIntFactory.create(1L);
        varIntArray[5] = VarIntFactory.create(-1L);
        varIntArrayArray[7] = varIntArray;
        VarInt[][] results = varIntArrayArray;
        int i = 0;
        while (i < results.length) {
            RoundingMode mode = RoundingMode.values()[i];
            int j = 0;
            while (j < nums.length) {
                VarInt result = null;
                try {
                    result = nums[j].divide(VarInt.TEN, mode);
                }
                catch (ArithmeticException arithmeticException) {
                    // empty catch block
                }
                if (results[i][j] == null) {
                    VarIntTest.assertNull((String)(nums[j] + "/" + VarInt.TEN + " [" + (Object)((Object)mode) + "]"), (Object)result);
                } else {
                    VarIntTest.assertEquals((String)(nums[j] + "/" + VarInt.TEN + " [" + (Object)((Object)mode) + "]"), (Object)results[i][j], (Object)result);
                }
                ++j;
            }
            ++i;
        }
    }

    public void testDivInt() {
        this.doDivN(100000, 0);
    }

    public void testDivLong() {
        this.doDivN(100000, 1);
    }

    public void testDivBigIngeger() {
        this.doDivN(100000, 2);
    }

    private void doDivN(int n, int type) {
        int i = 0;
        while (i < n) {
            this.doDiv(this.randomValue(type), this.randomValue(type));
            ++i;
        }
    }

    private void doDiv(long val1, long val2) {
        this.doDiv(VarIntFactory.create(val1), VarIntFactory.create(val2));
    }

    private void doDiv(VarInt val1, VarInt val2) {
        if (val2.isZero()) {
            try {
                val1.toBigInteger().divide(val2.toBigInteger());
                VarIntTest.fail((String)("expected div by zero exception for " + val1 + " / " + val2));
            }
            catch (ArithmeticException arithmeticException) {}
        } else {
            BigInteger exp = val1.toBigInteger().divide(val2.toBigInteger());
            BigInteger act = val1.divide(val2).toBigInteger();
            VarIntTest.assertEquals((String)(val1 + " / " + val2), (Object)exp, (Object)act);
        }
    }

    private VarInt randomValue(int type) {
        if (type < 0) {
            type = this.rnd.nextInt(3);
        }
        if (type == 2) {
            byte[] bytes = new byte[1 + this.rnd.nextInt(49)];
            int i = 0;
            while (i < bytes.length) {
                bytes[i] = (byte)this.rnd.nextInt();
                ++i;
            }
            return VarIntFactory.create(new BigInteger(bytes));
        }
        if (type == 1) {
            return VarIntFactory.create(this.rnd.nextLong());
        }
        return VarIntFactory.create(this.rnd.nextInt());
    }

    private void outTyped(VarInt value) {
    }
}

