/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.numeric.varint.math;

import ch.javasoft.io.DataInputInputStream;
import ch.javasoft.io.DataOutputOutputStream;
import ch.javasoft.math.ops.AbstractNumberOps;
import ch.javasoft.numeric.varint.VarIntFactory;
import ch.javasoft.numeric.varint.VarIntNumber;
import ch.javasoft.numeric.varint.VarIntUtil;
import ch.javasoft.numeric.varint.array.VarIntOperators;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarIntOperations
extends AbstractNumberOps<VarIntNumber> {
    private static VarIntOperations sInstance;

    public static VarIntOperations instance() {
        if (sInstance == null) {
            sInstance = new VarIntOperations();
        }
        return sInstance;
    }

    @Override
    public Class<VarIntNumber> numberClass() {
        return VarIntNumber.class;
    }

    public VarIntNumber[] newArray(int size) {
        return new VarIntNumber[size];
    }

    public VarIntNumber[][] newArray(int rows, int cols) {
        return new VarIntNumber[rows][cols];
    }

    @Override
    public VarIntNumber valueOf(String s) {
        return VarIntFactory.create(s);
    }

    @Override
    public VarIntNumber valueOf(Number number) {
        return VarIntOperators.INTEGER_DIVISION_INSTANCE.converter().operate(number);
    }

    @Override
    public VarIntNumber valueOf(long value) {
        return VarIntFactory.create(value);
    }

    @Override
    public VarIntNumber valueOf(double value) {
        return this.valueOf(String.valueOf(value));
    }

    @Override
    public VarIntNumber abs(VarIntNumber number) {
        return number.abs();
    }

    @Override
    public VarIntNumber add(VarIntNumber numA, VarIntNumber numB) {
        return numA.add(numB);
    }

    @Override
    public VarIntNumber divide(VarIntNumber numA, VarIntNumber numB) {
        return numA.divide(numB);
    }

    @Override
    public VarIntNumber invert(VarIntNumber number) {
        return VarIntNumber.ONE.divide(number);
    }

    @Override
    public boolean isOne(VarIntNumber number) {
        return VarIntNumber.ONE.equals(number);
    }

    @Override
    public boolean isZero(VarIntNumber number) {
        return number.signum() == 0;
    }

    @Override
    public VarIntNumber multiply(VarIntNumber numA, VarIntNumber numB) {
        return numA.multiply(numB);
    }

    @Override
    public VarIntNumber negate(VarIntNumber number) {
        return number.negate();
    }

    @Override
    public VarIntNumber one() {
        return VarIntNumber.ONE;
    }

    @Override
    public VarIntNumber subtract(VarIntNumber numA, VarIntNumber numB) {
        return numA.subtract(numB);
    }

    @Override
    public VarIntNumber zero() {
        return VarIntNumber.ZERO;
    }

    @Override
    public int compare(VarIntNumber o1, VarIntNumber o2) {
        return o1.compareTo(o2);
    }

    @Override
    public VarIntNumber reduce(VarIntNumber number) {
        return number;
    }

    public VarIntNumber[] reduceVector(boolean cloneOnChange, VarIntNumber ... vector) {
        VarIntNumber gcd;
        if (vector.length > 0 && !this.isOne(gcd = VarIntUtil.gcd(vector).abs()) && gcd.signum() != 0) {
            if (cloneOnChange) {
                vector = (VarIntNumber[])vector.clone();
            }
            int i = 0;
            while (i < vector.length) {
                vector[i] = vector[i].divide(gcd);
                ++i;
            }
        }
        return vector;
    }

    @Override
    public int signum(VarIntNumber number) {
        return number.signum();
    }

    @Override
    public VarIntNumber pow(VarIntNumber numA, VarIntNumber numB) {
        int expSign = numB.signum();
        if (expSign == 0) {
            return VarIntNumber.ONE;
        }
        if (VarIntNumber.ONE.equals(numA)) {
            return VarIntNumber.ONE;
        }
        if (expSign < 0) {
            return VarIntNumber.ZERO;
        }
        if (numB.compareTo(VarIntFactory.create(Integer.MAX_VALUE)) > 0) {
            throw new ArithmeticException("exponent too large, only integer range supported: " + numB + " > " + Integer.MAX_VALUE);
        }
        return numA.pow(numB.intValue());
    }

    @Override
    public byte[] toByteArray(VarIntNumber number) {
        return number.toByteArray();
    }

    @Override
    public void writeTo(VarIntNumber number, DataOutput out) throws IOException {
        number.writeTo(out instanceof OutputStream ? (OutputStream)((Object)out) : new DataOutputOutputStream(out));
    }

    @Override
    public VarIntNumber fromByteArray(byte[] bytes) {
        return VarIntFactory.create(bytes);
    }

    @Override
    public VarIntNumber readFrom(DataInput in) throws IOException {
        return VarIntFactory.readFrom(in instanceof InputStream ? (InputStream)((Object)in) : new DataInputInputStream(in));
    }

    @Override
    public int byteLength() {
        return -1;
    }
}

