/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.numeric.varint;

import ch.javasoft.numeric.varint.BigIntegerVarInt;
import ch.javasoft.numeric.varint.DefaultVarIntCache;
import ch.javasoft.numeric.varint.IntVarInt;
import ch.javasoft.numeric.varint.LongVarInt;
import ch.javasoft.numeric.varint.VarInt;
import ch.javasoft.numeric.varint.VarIntCache;
import ch.javasoft.numeric.varint.VarIntNumber;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class VarIntFactory {
    public static final VarIntCache CACHE = DefaultVarIntCache.createCache();

    public static VarIntNumber create(long value) {
        if (Integer.MIN_VALUE <= value && value <= Integer.MAX_VALUE) {
            return IntVarInt.valueOf((int)value);
        }
        return LongVarInt.valueOf(value);
    }

    public static VarIntNumber create(BigInteger value) {
        int bitlen = value.bitLength();
        if (bitlen <= 31) {
            return IntVarInt.valueOf(value.intValue());
        }
        if (bitlen <= 63) {
            return LongVarInt.valueOf(value.longValue());
        }
        return BigIntegerVarInt.valueOf(value);
    }

    public static VarIntNumber create(Number value) {
        if (value instanceof VarIntNumber) {
            return (VarIntNumber)value;
        }
        if (value instanceof Integer || value instanceof Short || value instanceof Byte || value instanceof AtomicInteger) {
            return IntVarInt.valueOf(value.intValue());
        }
        if (value instanceof Long || value instanceof AtomicLong) {
            return VarIntFactory.create(value.longValue());
        }
        if (value instanceof BigInteger) {
            return VarIntFactory.create((BigInteger)value);
        }
        if (value instanceof VarInt) {
            return VarIntFactory.create(((VarInt)((Object)value)).toBigInteger());
        }
        if (value instanceof BigDecimal) {
            return VarIntFactory.create(((BigDecimal)value).toBigInteger());
        }
        return VarIntFactory.create(value.toString());
    }

    public static VarIntNumber convert(VarInt value) {
        return value instanceof VarIntNumber ? (VarIntNumber)value : VarIntFactory.create(value.toBigInteger());
    }

    public static VarIntNumber create(String val) {
        return VarIntFactory.create(val, 10);
    }

    public static VarIntNumber create(String val, int radix) {
        if (val.startsWith("+")) {
            val = val.substring(1);
        }
        double digitlen = val.length();
        double estimLen32 = 31.0 * Math.log(2.0) / Math.log(radix);
        double estimLen64 = 63.0 * Math.log(2.0) / Math.log(radix);
        if (digitlen < estimLen32) {
            return IntVarInt.valueOf(Integer.parseInt(val, radix));
        }
        if (digitlen < estimLen64) {
            return VarIntFactory.create(Long.parseLong(val, radix));
        }
        return VarIntFactory.create(new BigInteger(val, radix));
    }

    public static VarIntNumber create(byte[] bytes) {
        if (bytes.length == 0) {
            throw new NumberFormatException("zero lenth byte array");
        }
        if (bytes.length <= 4) {
            int value = 0xFF & bytes[0];
            int i = 1;
            while (i < bytes.length) {
                value <<= 8;
                value |= 0xFF & bytes[i];
                ++i;
            }
            int shift = 4 - bytes.length << 3;
            value = value << shift >> shift;
            return IntVarInt.valueOf(value);
        }
        if (bytes.length <= 8) {
            long value = 0xFF & bytes[0];
            int i = 1;
            while (i < bytes.length) {
                value <<= 8;
                value |= (long)(0xFF & bytes[i]);
                ++i;
            }
            int shift = 8 - bytes.length << 3;
            value = value << shift >> shift;
            return LongVarInt.valueOf(value);
        }
        return BigIntegerVarInt.valueOf(new BigInteger(bytes));
    }

    public static VarIntNumber readFrom(byte[] array, AtomicInteger offsetPtr) {
        int len;
        int header;
        if (offsetPtr == null) {
            offsetPtr = new AtomicInteger();
        }
        if (((header = 0xFF & array[offsetPtr.getAndIncrement()]) & 0x80) != 0) {
            int value = header << 25 >> 25;
            return IntVarInt.valueOf(value);
        }
        if (header == 0) {
            int byte0 = 0xFF & array[offsetPtr.getAndIncrement()];
            int byte1 = 0xFF & array[offsetPtr.getAndIncrement()];
            int byte2 = 0xFF & array[offsetPtr.getAndIncrement()];
            int byte3 = 0xFF & array[offsetPtr.getAndIncrement()];
            len = byte0 << 24 | byte1 << 16 | byte2 << 8 | byte3;
        } else {
            len = header;
        }
        if (len <= 4) {
            int value = 0xFF & array[offsetPtr.getAndIncrement()];
            int i = 1;
            while (i < len) {
                value <<= 8;
                value |= 0xFF & array[offsetPtr.getAndIncrement()];
                ++i;
            }
            int shift = 4 - len << 3;
            value = value << shift >> shift;
            return IntVarInt.valueOf(value);
        }
        if (len <= 8) {
            long value = 0xFF & array[offsetPtr.getAndIncrement()];
            int i = 1;
            while (i < len) {
                value <<= 8;
                value |= (long)(0xFF & array[offsetPtr.getAndIncrement()]);
                ++i;
            }
            long shift = 8 - len << 3;
            value = value << (int)shift >> (int)shift;
            return LongVarInt.valueOf(value);
        }
        byte[] bytes = new byte[len];
        System.arraycopy(array, offsetPtr.getAndAdd(len), bytes, 0, len);
        return BigIntegerVarInt.valueOf(new BigInteger(bytes));
    }

    public static VarIntNumber readFrom(InputStream in) throws IOException {
        int len;
        int header = VarIntFactory.readByte(in);
        if ((header & 0x80) != 0) {
            int value = header << 25 >> 25;
            return IntVarInt.valueOf(value);
        }
        if (header == 0) {
            int byte0 = VarIntFactory.readByte(in);
            int byte1 = VarIntFactory.readByte(in);
            int byte2 = VarIntFactory.readByte(in);
            int byte3 = VarIntFactory.readByte(in);
            len = byte0 << 24 | byte1 << 16 | byte2 << 8 | byte3;
        } else {
            len = header;
        }
        if (len <= 4) {
            int value = VarIntFactory.readByte(in);
            int i = 1;
            while (i < len) {
                value <<= 8;
                value |= VarIntFactory.readByte(in);
                ++i;
            }
            int shift = 4 - len << 3;
            value = value << shift >> shift;
            return IntVarInt.valueOf(value);
        }
        if (len <= 8) {
            long value = VarIntFactory.readByte(in);
            int i = 1;
            while (i < len) {
                value <<= 8;
                value |= (long)VarIntFactory.readByte(in);
                ++i;
            }
            long shift = 8 - len << 3;
            value = value << (int)shift >> (int)shift;
            return LongVarInt.valueOf(value);
        }
        byte[] bytes = new byte[len];
        in.read(bytes);
        return BigIntegerVarInt.valueOf(new BigInteger(bytes));
    }

    private static int readByte(InputStream in) throws IOException {
        int val = in.read();
        if (val == -1) {
            throw new IOException("unexpected end of stream");
        }
        return 0xFF & val;
    }

    static byte[] toByteArray(long value) {
        if (value < 0L) {
            if (value <= Integer.MIN_VALUE) {
                if (value <= -140737488355328L) {
                    if (value <= -36028797018963968L) {
                        return new byte[]{(byte)(value >> 56), (byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
                    }
                    return new byte[]{(byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
                }
                if (value <= -549755813888L) {
                    return new byte[]{(byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
                }
                return new byte[]{(byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
            }
            return VarIntFactory.toByteArray((int)value);
        }
        if (value >= Integer.MAX_VALUE) {
            if (value >= 0x7FFFFFFFFFFFL) {
                if (value >= 0x7FFFFFFFFFFFFFL) {
                    return new byte[]{(byte)(value >> 56), (byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
                }
                return new byte[]{(byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
            }
            if (value >= 0x7FFFFFFFFFL) {
                return new byte[]{(byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
            }
            return new byte[]{(byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
        }
        return VarIntFactory.toByteArray((int)value);
    }

    static byte[] toByteArray(int value) {
        if (value < 0) {
            if (value <= Short.MIN_VALUE) {
                if (value <= -8388608) {
                    return new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
                }
                return new byte[]{(byte)(value >> 16), (byte)(value >> 8), (byte)value};
            }
            if (value <= -128) {
                return new byte[]{(byte)(value >> 8), (byte)value};
            }
            return new byte[]{(byte)value};
        }
        if (value >= Short.MAX_VALUE) {
            if (value >= 0x7FFFFF) {
                return new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
            }
            return new byte[]{(byte)(value >> 16), (byte)(value >> 8), (byte)value};
        }
        if (value >= 127) {
            return new byte[]{(byte)(value >> 8), (byte)value};
        }
        return new byte[]{(byte)value};
    }

    private static boolean writeByteLength(OutputStream out, int length) throws IOException {
        if (length < 127) {
            out.write((byte)length);
        } else {
            out.write(0);
            out.write((byte)(length >>> 24));
            out.write((byte)(length >>> 16));
            out.write((byte)(length >>> 8));
            out.write((byte)length);
        }
        return true;
    }

    static void writeBytes(OutputStream out, byte[] bytes) throws IOException {
        if (bytes.length == 0) {
            out.write(128);
        } else if (bytes.length == 1 && 192 <= bytes[0] && bytes[0] <= 63) {
            out.write(0x80 | bytes[0]);
        } else {
            VarIntFactory.writeByteLength(out, bytes.length);
            int i = 0;
            while (i < bytes.length) {
                out.write(bytes[i]);
                ++i;
            }
        }
    }

    static void writeLong(OutputStream out, long value) throws IOException {
        boolean lenWritten = false;
        if (value < 0L) {
            if (value <= Integer.MIN_VALUE) {
                if (value <= -140737488355328L) {
                    if (value <= -36028797018963968L) {
                        lenWritten = lenWritten || VarIntFactory.writeByteLength(out, 8);
                        out.write((byte)(value >>> 56));
                    }
                    lenWritten = lenWritten || VarIntFactory.writeByteLength(out, 7);
                    out.write((byte)(value >>> 48));
                }
                if (value <= -549755813888L) {
                    lenWritten = lenWritten || VarIntFactory.writeByteLength(out, 6);
                    out.write((byte)(value >>> 40));
                }
                lenWritten = lenWritten || VarIntFactory.writeByteLength(out, 5);
                out.write((byte)(value >>> 32));
                out.write((byte)(value >>> 24));
                out.write((byte)(value >>> 16));
                out.write((byte)(value >>> 8));
                out.write((byte)value);
            } else {
                VarIntFactory.writeInt(out, (int)value, lenWritten);
            }
        } else if (value >= Integer.MAX_VALUE) {
            if (value >= 0x7FFFFFFFFFFFL) {
                if (value >= 0x7FFFFFFFFFFFFFL) {
                    lenWritten = lenWritten || VarIntFactory.writeByteLength(out, 8);
                    out.write((byte)(value >>> 56));
                }
                lenWritten = lenWritten || VarIntFactory.writeByteLength(out, 7);
                out.write((byte)(value >>> 48));
            }
            if (value >= 0x7FFFFFFFFFL) {
                lenWritten = lenWritten || VarIntFactory.writeByteLength(out, 6);
                out.write((byte)(value >>> 40));
            }
            lenWritten = lenWritten || VarIntFactory.writeByteLength(out, 5);
            out.write((byte)(value >>> 32));
            out.write((byte)(value >>> 24));
            out.write((byte)(value >>> 16));
            out.write((byte)(value >>> 8));
            out.write((byte)value);
        } else {
            VarIntFactory.writeInt(out, (int)value, lenWritten);
        }
    }

    static void writeInt(OutputStream out, int value) throws IOException {
        VarIntFactory.writeInt(out, value, false);
    }

    private static void writeInt(OutputStream out, int value, boolean lenWritten) throws IOException {
        if (value < 0) {
            if (value <= Short.MIN_VALUE) {
                if (value <= -8388608) {
                    lenWritten = lenWritten || VarIntFactory.writeByteLength(out, 4);
                    out.write((byte)(value >>> 24));
                }
                lenWritten = lenWritten || VarIntFactory.writeByteLength(out, 3);
                out.write((byte)(value >>> 16));
            }
            if (value <= -128) {
                lenWritten = lenWritten || VarIntFactory.writeByteLength(out, 2);
                out.write((byte)(value >>> 8));
            }
            if (!lenWritten && value >= -64) {
                out.write(0x80 | 0xFF & value);
            } else {
                lenWritten = lenWritten || VarIntFactory.writeByteLength(out, 1);
                out.write((byte)value);
            }
        } else {
            if (value >= Short.MAX_VALUE) {
                if (value >= 0x7FFFFF) {
                    lenWritten = lenWritten || VarIntFactory.writeByteLength(out, 4);
                    out.write((byte)(value >>> 24));
                }
                lenWritten = lenWritten || VarIntFactory.writeByteLength(out, 3);
                out.write((byte)(value >>> 16));
            }
            if (value >= 127) {
                lenWritten = lenWritten || VarIntFactory.writeByteLength(out, 2);
                out.write((byte)(value >>> 8));
            }
            if (!lenWritten && value <= 63) {
                out.write(0x80 | 0xFF & value);
            } else {
                lenWritten = lenWritten || VarIntFactory.writeByteLength(out, 1);
                out.write((byte)value);
            }
        }
    }
}

