/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.numeric.varint;

import ch.javasoft.numeric.varint.IntVarInt;
import ch.javasoft.numeric.varint.VarInt;
import ch.javasoft.numeric.varint.VarIntFactory;
import ch.javasoft.numeric.varint.VarIntNumber;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public class LongVarInt
extends VarIntNumber {
    private static final long serialVersionUID = -8576657559446387018L;
    protected final long value;

    protected LongVarInt(long value) {
        this.value = value;
    }

    protected static LongVarInt valueOf(long value) {
        return VarIntFactory.CACHE.cacheGet(value);
    }

    public VarIntNumber compact() {
        if (Integer.MIN_VALUE <= this.value && this.value <= Integer.MAX_VALUE) {
            return IntVarInt.valueOf((int)this.value);
        }
        return this;
    }

    public boolean isZero() {
        return this.value == 0L;
    }

    public boolean isOne() {
        return this.value == 1L;
    }

    public boolean isNegative() {
        return this.value < 0L;
    }

    public boolean isPositive() {
        return this.value > 0L;
    }

    public boolean isNonNegative() {
        return this.value >= 0L;
    }

    public boolean isNonPositive() {
        return this.value <= 0L;
    }

    public boolean isEven() {
        return 0L == (1L & this.value);
    }

    public boolean testBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        return 0L != (this.value & 1L << n);
    }

    public int bitCount() {
        return Long.bitCount(this.value >= 0L ? this.value : this.value ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public int bitLength() {
        return 64 - Long.numberOfLeadingZeros(this.value >= 0L ? this.value : this.value ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public double doubleValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public VarIntNumber abs() {
        if (this.value == Long.MIN_VALUE) {
            return VarIntFactory.create(BigInteger.valueOf(this.value).negate());
        }
        return this.value < 0L ? VarIntFactory.create(-this.value) : this;
    }

    public VarIntNumber add(VarInt val) {
        long other;
        if (val instanceof IntVarInt) {
            other = ((IntVarInt)val).value;
        } else if (val instanceof LongVarInt) {
            other = ((LongVarInt)val).value;
        } else {
            return VarIntFactory.create(this.toBigInteger().add(val.toBigInteger()));
        }
        long result = this.value + other;
        if (((this.value ^ result) & (other ^ result)) < 0L) {
            return VarIntFactory.create(this.toBigInteger().add(val.toBigInteger()));
        }
        return VarIntFactory.create(result);
    }

    public VarIntNumber divide(VarInt val) {
        if (val instanceof IntVarInt) {
            int div = ((IntVarInt)val).value;
            return div == -1 ? this.negate() : VarIntFactory.create(this.value / (long)div);
        }
        if (val instanceof LongVarInt) {
            long div = ((LongVarInt)val).value;
            return div == -1L ? this.negate() : VarIntFactory.create(this.value / div);
        }
        return VarIntFactory.create(this.toBigInteger().divide(val.toBigInteger()));
    }

    public VarIntNumber gcd(VarInt val) {
        if (val instanceof IntVarInt) {
            return LongVarInt.valueOf(LongVarInt.gcd(this.value, ((IntVarInt)val).value));
        }
        if (val instanceof LongVarInt) {
            return LongVarInt.valueOf(LongVarInt.gcd(this.value, ((LongVarInt)val).value));
        }
        return VarIntFactory.convert(val.gcd(this));
    }

    static long gcd(long iA, long iB) {
        iA = Math.abs(iA);
        iB = Math.abs(iB);
        if (iA < 0L || iB < 0L) {
            if (0L != ((iA | iB) & 1L)) {
                return 1L;
            }
            iA = Math.abs(iA >>> 1);
            iB = Math.abs(iB >>> 1);
        }
        if (iA == 0L) {
            return iB;
        }
        if (iB == 0L) {
            return iA;
        }
        long iMax = Math.max(iA, iB);
        long iMin = Math.min(iA, iB);
        while (iMax != iMin) {
            if (iMax % iMin == 0L) {
                return iMin;
            }
            long tmp = iMin;
            iMin = iMax - iMax / iMin * iMin;
            iMax = tmp;
        }
        return iMin;
    }

    public VarIntNumber max(VarInt val) {
        long other;
        if (val instanceof IntVarInt) {
            other = ((IntVarInt)val).value;
        } else if (val instanceof LongVarInt) {
            other = ((LongVarInt)val).value;
        } else {
            return VarIntFactory.convert(val.max(this));
        }
        return this.value >= other ? this : VarIntFactory.convert(val);
    }

    public VarIntNumber min(VarInt val) {
        long other;
        if (val instanceof IntVarInt) {
            other = ((IntVarInt)val).value;
        } else if (val instanceof LongVarInt) {
            other = ((LongVarInt)val).value;
        } else {
            return VarIntFactory.convert(val.min(this));
        }
        return this.value <= other ? this : VarIntFactory.convert(val);
    }

    public VarIntNumber mod(VarInt m) {
        long mod;
        if (m instanceof IntVarInt) {
            mod = ((IntVarInt)m).value;
        } else if (m instanceof LongVarInt) {
            mod = ((LongVarInt)m).value;
        } else {
            return VarIntFactory.create(this.toBigInteger().mod(m.toBigInteger()));
        }
        long rem = this.value % mod;
        return VarIntFactory.create(rem < 0L ? rem + mod : rem);
    }

    public VarIntNumber multiply(VarInt val) {
        long other;
        if (val instanceof IntVarInt) {
            other = ((IntVarInt)val).value;
        } else if (val instanceof LongVarInt) {
            other = ((LongVarInt)val).value;
        } else {
            return VarIntFactory.create(this.toBigInteger().multiply(val.toBigInteger()));
        }
        long result = this.value * other;
        boolean overflow = (this.value ^ other ^ result) < 0L;
        if (overflow |= other != 0L && result / other != this.value) {
            return VarIntFactory.create(this.toBigInteger().multiply(val.toBigInteger()));
        }
        return VarIntFactory.create(result);
    }

    public VarIntNumber negate() {
        if (this.value == Long.MIN_VALUE) {
            return VarIntFactory.create(BigInteger.valueOf(this.value).negate());
        }
        return VarIntFactory.create(-this.value);
    }

    public VarIntNumber pow(int exponent) {
        return VarIntFactory.create(this.toBigInteger().pow(exponent));
    }

    public VarIntNumber remainder(VarInt val) {
        if (val instanceof LongVarInt) {
            return LongVarInt.valueOf(this.value % ((LongVarInt)val).value);
        }
        if (val instanceof LongVarInt) {
            return VarIntFactory.create(this.value % ((LongVarInt)val).value);
        }
        return VarIntFactory.create(this.toBigInteger().remainder(val.toBigInteger()));
    }

    public VarIntNumber shiftLeft(int n) {
        if (n < 0) {
            return LongVarInt.valueOf(this.value >> -n);
        }
        int space = Long.numberOfLeadingZeros(this.value);
        if (n < space) {
            return LongVarInt.valueOf(this.value << n);
        }
        return VarIntFactory.create(this.toBigInteger().shiftLeft(n));
    }

    public VarIntNumber shiftRight(int n) {
        if (n < 0) {
            return this.shiftLeft(-n);
        }
        return LongVarInt.valueOf(this.value >> n);
    }

    public int signum() {
        return this.value == 0L ? 0 : (this.value < 0L ? -1 : 1);
    }

    public VarIntNumber subtract(VarInt val) {
        long other;
        if (val instanceof IntVarInt) {
            other = ((IntVarInt)val).value;
        } else if (val instanceof IntVarInt) {
            other = ((IntVarInt)val).value;
        } else {
            return VarIntFactory.create(this.toBigInteger().subtract(val.toBigInteger()));
        }
        long result = this.value - other;
        if ((this.value ^ other) >= 0L && (result ^ other) < 0L) {
            return VarIntFactory.create(this.toBigInteger().subtract(val.toBigInteger()));
        }
        return VarIntFactory.create(result);
    }

    public BigInteger toBigInteger() {
        return BigInteger.valueOf(this.value);
    }

    public byte[] toByteArray() {
        return VarIntFactory.toByteArray(this.value);
    }

    public void writeTo(OutputStream out) throws IOException {
        VarIntFactory.writeLong(out, this.value);
    }

    public String toString(int radix) {
        return Long.toString(this.value, radix);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int compareTo(VarInt o) {
        if (o instanceof LongVarInt) {
            long cmp = this.value - ((LongVarInt)o).value;
            return cmp == 0L ? 0 : (cmp < 0L ? -1 : 1);
        }
        return -o.compareTo(this);
    }

    public int hashCode() {
        return (int)(this.value >>> 32 ^ 0xFFFFFFFFL & this.value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof IntVarInt) {
            return this.value == (long)((IntVarInt)obj).value;
        }
        if (obj instanceof LongVarInt) {
            return this.value == ((LongVarInt)obj).value;
        }
        if (obj instanceof VarInt) {
            return ((VarInt)obj).equals(this);
        }
        return false;
    }
}

