/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.util;

import ch.javasoft.metabolic.FluxDistribution;
import ch.javasoft.util.numeric.Zero;
import java.util.BitSet;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluxComparatorPrec
implements Comparator<FluxDistribution> {
    private final Zero mZero;
    private final BitSet mIgnoreFluxes;

    public FluxComparatorPrec() {
        this(null);
    }

    public FluxComparatorPrec(Zero zero) {
        this(zero, new BitSet());
    }

    public FluxComparatorPrec(Zero zero, BitSet ignoreFluxes) {
        this.mZero = zero;
        this.mIgnoreFluxes = ignoreFluxes;
    }

    @Override
    public int compare(FluxDistribution f1, FluxDistribution f2) {
        double[] d1 = f1.getDoubleRates();
        double[] d2 = f2.getDoubleRates();
        if (this.mZero == null) {
            int ii = 0;
            while (ii < d1.length) {
                if (!this.mIgnoreFluxes.get(ii)) {
                    if (d1[ii] < d2[ii]) {
                        return -1;
                    }
                    if (d1[ii] > d2[ii]) {
                        return 1;
                    }
                }
                ++ii;
            }
        } else {
            int ii = 0;
            while (ii < d1.length) {
                int sgn;
                if (!this.mIgnoreFluxes.get(ii) && (sgn = this.mZero.sgn(d1[ii] - d2[ii])) != 0) {
                    return sgn;
                }
                ++ii;
            }
        }
        return 0;
    }
}

