/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.util;

import ch.javasoft.metabolic.FluxDistribution;
import java.util.BitSet;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluxComparatorPerc
implements Comparator<FluxDistribution> {
    private final float mPerc;
    private final BitSet mIgnoreFluxes;

    public FluxComparatorPerc(float perc) {
        this(perc, new BitSet());
    }

    public FluxComparatorPerc(float perc, BitSet ignoreFluxes) {
        this.mPerc = Math.abs(perc);
        this.mIgnoreFluxes = ignoreFluxes;
    }

    @Override
    public int compare(FluxDistribution f1, FluxDistribution f2) {
        double[] d1 = f1.getDoubleRates();
        double[] d2 = f2.getDoubleRates();
        int ii = 0;
        while (ii < d1.length) {
            double rDiff;
            double sum;
            if (!this.mIgnoreFluxes.get(ii) && (sum = Math.abs(d1[ii]) + Math.abs(d2[ii])) > 0.0 && Math.abs(rDiff = (d1[ii] - d2[ii]) / sum) > (double)this.mPerc) {
                if (d1[ii] < d2[ii]) {
                    return -1;
                }
                if (d1[ii] > d2[ii]) {
                    return 1;
                }
                throw new RuntimeException("internal error: should not get here");
            }
            ++ii;
        }
        return 0;
    }
}

