/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.parse;

import ch.javasoft.metabolic.impl.DefaultMetabolicNetwork;
import ch.javasoft.metabolic.parse.junit.AbstractParseTestCase;

public abstract class SmallTest
extends AbstractParseTestCase {
    public void testBinSampleCompact() throws Exception {
        double[][] values = new double[][]{{1.0, 0.0, -1.0, -1.0, -1.0}, {0.0, 1.0, 0.0, 1.0, -1.0}};
        boolean[] blArray = new boolean[5];
        blArray[3] = true;
        boolean[] reversible = blArray;
        String[] metaNames = new String[]{"B", "C"};
        String[] reacNames = new String[]{"R1c", "R2c", "R3c", "R4c", "R5c"};
        DefaultMetabolicNetwork net = new DefaultMetabolicNetwork(metaNames, reacNames, (double[][])values, reversible);
        this.internalTestOrDelegate(net, null);
    }

    public void testBinSample() throws Exception {
        double[][] values = new double[][]{{1.0, -1.0, -1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, -1.0, -1.0, -1.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 1.0, -1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, -1.0}};
        String[] metaNames = new String[]{"A", "B", "C", "D"};
        String[] reacNames = new String[]{"R1", "R2", "R3", "R4", "R5", "R6", "R7"};
        boolean[] blArray = new boolean[7];
        blArray[4] = true;
        boolean[] reversible = blArray;
        DefaultMetabolicNetwork net = new DefaultMetabolicNetwork(metaNames, reacNames, (double[][])values, reversible);
        this.internalTestOrDelegate(net, null);
    }

    public void testGeneratingSample() throws Exception {
        double[][] values = new double[][]{{1.0, -1.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 1.0, 0.0, -1.0}, {0.0, 0.0, -1.0, -1.0, 1.0, 0.0}};
        boolean[] blArray = new boolean[6];
        blArray[0] = true;
        blArray[1] = true;
        boolean[] reversible = blArray;
        String[] metaNames = new String[]{"A", "B", "C"};
        String[] reacNames = new String[]{"J1", "J2", "J3", "J4", "J5", "J6"};
        DefaultMetabolicNetwork net = new DefaultMetabolicNetwork(metaNames, reacNames, (double[][])values, reversible);
        this.internalTestOrDelegate(net, null);
    }

    public void testBookTiny() throws Exception {
        double[][] values = new double[][]{{1.0, -1.0, -1.0, 0.0}, {0.0, 1.0, 1.0, -1.0}};
        boolean[] reversible = new boolean[4];
        DefaultMetabolicNetwork net = new DefaultMetabolicNetwork(values, reversible);
        this.internalTestOrDelegate(net, null);
    }

    public void testSignProblem() throws Exception {
        double[][] stoich = new double[][]{{1.0, 0.0, -1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, -1.0, 1.0, -1.0, 0.0}, {0.0, 0.0, 1.0, -1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0, 0.0, -1.0}};
        String[] mnames = new String[]{"S", "E", "ES", "P"};
        String[] rnames = new String[]{"S_up", "E_up", "R_ES", "R_P", "E_ex", "P_ex"};
        boolean[] blArray = new boolean[6];
        blArray[1] = true;
        blArray[2] = true;
        boolean[] reversible = blArray;
        DefaultMetabolicNetwork net = new DefaultMetabolicNetwork(mnames, rnames, (double[][])stoich, reversible);
        this.internalTestOrDelegate(net, null);
    }

    public void testBookSample() throws Exception {
        double[][] values = new double[][]{{1.0, 0.0, 0.0, 0.0, -1.0, -1.0, -1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, -1.0, -1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, -1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, -1.0}, {0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0}};
        boolean[] blArray = new boolean[10];
        blArray[1] = true;
        blArray[7] = true;
        boolean[] reversible = blArray;
        DefaultMetabolicNetwork net = new DefaultMetabolicNetwork(values, reversible);
        this.internalTestOrDelegate(net, null);
    }

    public void testBookSampleRev() throws Exception {
        double[][] values = new double[][]{{1.0, 0.0, 0.0, 0.0, -1.0, -1.0, -1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, -1.0, -1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, -1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, -1.0}, {0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0}};
        boolean[] reversible = new boolean[]{true, true, true, true, true, true, true, true, true, true};
        DefaultMetabolicNetwork net = new DefaultMetabolicNetwork(values, reversible);
        this.internalTestOrDelegate(net, null);
    }

    public void testBookSampleRemRev() throws Exception {
        double[][] values = new double[][]{{1.0, 0.0, 0.0, 0.0, -1.0, -1.0, -1.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, -1.0, -1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, -1.0}, {0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0}};
        boolean[] blArray = new boolean[9];
        blArray[1] = true;
        boolean[] reversible = blArray;
        DefaultMetabolicNetwork net = new DefaultMetabolicNetwork(values, reversible);
        this.internalTestOrDelegate(net, null);
    }

    public void testBookMatrixCompressionA() throws Exception {
        double[][] values = new double[][]{{1.0, -1.0, 1.0, 0.0}, {0.0, -1.0, 0.0, 1.0}};
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        boolean[] reversible = blArray;
        String[] metaNames = new String[]{"C", "D"};
        String[] reacNames = new String[]{"R8", "R10", "R6", "R7"};
        DefaultMetabolicNetwork net = new DefaultMetabolicNetwork(metaNames, reacNames, (double[][])values, reversible);
        this.internalTestOrDelegate(net, null);
    }

    public void testBookMatrixCompressionB() throws Exception {
        double[][] values = new double[][]{{1.0, -1.0, 0.0, 0.0}, {1.0, 0.0, 1.0, -1.0}};
        String[] metaNames = new String[]{"E", "P"};
        String[] reacNames = new String[]{"R10", "R4", "R9", "R3"};
        boolean[] reversible = new boolean[4];
        DefaultMetabolicNetwork net = new DefaultMetabolicNetwork(metaNames, reacNames, (double[][])values, reversible);
        this.internalTestOrDelegate(net, null);
    }

    public void testNullspaceSampleIrrev() throws Exception {
        double[][] values = new double[][]{{0.0, 0.0, -1.0, -2.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 2.0}, {0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 1.0, -1.0, 0.0, 0.0, 1.0, 0.0, 0.0}, {1.0, 0.0, 0.0, 2.0, 0.0, 0.0, -1.0, 1.0, 0.0, -1.0, 0.0, 0.0, -2.0}, {0.0, 2.0, 0.0, 1.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.0, -1.0}, {0.0, 0.0, 1.0, -1.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, -1.0, 1.0}};
        boolean[] reversible = new boolean[13];
        DefaultMetabolicNetwork net = new DefaultMetabolicNetwork(values, reversible);
        this.internalTestOrDelegate(net, null);
    }
}

