/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.parse;

import ch.javasoft.metabolic.FluxDistribution;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Metabolite;
import ch.javasoft.metabolic.MetaboliteRatio;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.ReactionConstraints;
import ch.javasoft.metabolic.impl.DefaultFluxDistribution;
import ch.javasoft.metabolic.impl.DefaultMetabolicNetwork;
import ch.javasoft.metabolic.impl.DefaultMetabolite;
import ch.javasoft.metabolic.impl.DefaultMetaboliteRatio;
import ch.javasoft.metabolic.impl.DefaultReaction;
import ch.javasoft.metabolic.impl.DefaultReactionConstraints;
import ch.javasoft.metabolic.parse.LogPkg;
import ch.javasoft.metabolic.util.FluxNormalizer;
import ch.javasoft.util.genarr.ArrayIterable;
import ch.javasoft.util.genarr.GenericDynamicArray;
import ch.javasoft.util.numeric.Zero;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluxAnalyserParser {
    private static final Logger LOG = LogPkg.LOGGER;
    private static final String P_UINT = "[0-9]+";
    private static final String P_INT = "\\-?[0-9]+";
    private static final String P_FLOAT = "\\-?[0-9]+\\.?[0-9]*";
    private static final String P_RATE = "#|\\-?[0-9]+\\.?[0-9]*";
    private static final String P_RATEMINMAX = "Inf|-Inf|\\-?[0-9]+\\.?[0-9]*";
    private static final String P_NAME = "([\\w,_\\(\\)\\[\\]\\+'/&:-]+)";
    private static final String P_REACDEF = "(.*)[\\s]*=[\\s]*(.*)";
    private static final String P_REACCONST = "(#|\\-?[0-9]+\\.?[0-9]*)[\\s]+(Inf|-Inf|\\-?[0-9]+\\.?[0-9]*)[\\s]+(Inf|-Inf|\\-?[0-9]+\\.?[0-9]*).*";
    private static final String BIOMASS_REAC_NAME = "mue";

    public static MetabolicNetwork parse(File folder) throws IOException {
        if (!(folder.exists() && folder.isDirectory() && folder.canRead() && folder.canWrite())) {
            throw new IOException("cannot find, read or write directory: " + folder.getAbsolutePath());
        }
        return FluxAnalyserParser.parse(new File(folder, "reactions"), new File(folder, "macromolecules"), new File(folder, "macromolecule_synthesis"));
    }

    public static MetabolicNetwork parse(File reactionFile, File biomassFile, File macroReactionFile) throws IOException {
        return FluxAnalyserParser.parse(new FileReader(reactionFile), biomassFile == null ? null : new FileReader(biomassFile), macroReactionFile == null ? null : new FileReader(macroReactionFile));
    }

    public static MetabolicNetwork parse(InputStream reactionStream, InputStream biomassStream, InputStream macroReactionStream) throws IOException {
        return FluxAnalyserParser.parse(new InputStreamReader(reactionStream), biomassStream == null ? null : new InputStreamReader(biomassStream), macroReactionStream == null ? null : new InputStreamReader(macroReactionStream));
    }

    public static MetabolicNetwork parse(Reader reactionReader, Reader biomassReader, Reader macroReactionReader) throws IOException {
        return FluxAnalyserParser.parse(reactionReader instanceof BufferedReader ? (BufferedReader)reactionReader : new BufferedReader(reactionReader), biomassReader == null ? null : (biomassReader instanceof BufferedReader ? (BufferedReader)biomassReader : new BufferedReader(biomassReader)), macroReactionReader == null ? null : (macroReactionReader instanceof BufferedReader ? (BufferedReader)macroReactionReader : new BufferedReader(macroReactionReader)));
    }

    public static MetabolicNetwork parse(BufferedReader reactionReader, BufferedReader biomassReader, BufferedReader macroReactionReader) throws IOException {
        ParserSymbolTables tables = new ParserSymbolTables();
        FluxAnalyserParser.parseReaction(reactionReader, tables);
        if (biomassReader != null) {
            FluxAnalyserParser.parseBiomassRatio(biomassReader, tables);
        }
        if (macroReactionReader != null) {
            FluxAnalyserParser.parseMacroReaction(macroReactionReader, tables);
        }
        return tables.createMetabolicNetwork();
    }

    private static void parseReaction(BufferedReader reactionReader, ParserSymbolTables tables) throws IOException {
        Pattern muePattern = Pattern.compile("mue[\\s]*\\|[\\s]*(#|\\-?[0-9]+\\.?[0-9]*)[\\s]+(Inf|-Inf|\\-?[0-9]+\\.?[0-9]*)[\\s]+(Inf|-Inf|\\-?[0-9]+\\.?[0-9]*).*");
        Pattern reacPattern = Pattern.compile("([\\w,_\\(\\)\\[\\]\\+'/&:-]+)[\\s]+(.*)[\\s]*=[\\s]*(.*)[\\s]*\\|[\\s]*(#|\\-?[0-9]+\\.?[0-9]*)[\\s]+(Inf|-Inf|\\-?[0-9]+\\.?[0-9]*)[\\s]+(Inf|-Inf|\\-?[0-9]+\\.?[0-9]*).*");
        String line = reactionReader.readLine();
        int lineNum = 0;
        while (line != null) {
            ReactionConstraints cons;
            MetaboliteRatio[] rProducts;
            MetaboliteRatio[] rEducts;
            String upperBound;
            String lowerBound;
            String products;
            String educts;
            String reactionName;
            Matcher matcher = reacPattern.matcher(line);
            if (matcher.matches()) {
                reactionName = matcher.group(1);
                educts = matcher.group(2).trim();
                products = matcher.group(3).trim();
                lowerBound = matcher.group(5);
                upperBound = matcher.group(6);
            } else {
                matcher = muePattern.matcher(line);
                if (matcher.matches()) {
                    reactionName = BIOMASS_REAC_NAME;
                    educts = "";
                    products = "";
                    lowerBound = matcher.group(2);
                    upperBound = matcher.group(3);
                } else {
                    throw new IOException("syntax error at line [" + lineNum + "]: " + line);
                }
            }
            try {
                rEducts = FluxAnalyserParser.getMetaboliteRatios(tables, educts, true);
                rProducts = FluxAnalyserParser.getMetaboliteRatios(tables, products, false);
            }
            catch (IOException ioe) {
                throw new ParseException(ioe, lineNum);
            }
            GenericDynamicArray<MetaboliteRatio> rMetabolites = new GenericDynamicArray<MetaboliteRatio>(rEducts.length + rProducts.length);
            rMetabolites.set(0, (T[])rEducts);
            rMetabolites.set(rEducts.length, (T[])rProducts);
            try {
                cons = tables.getReactionConstraints(FluxAnalyserParser.parseConstraint(lowerBound), FluxAnalyserParser.parseConstraint(upperBound));
            }
            catch (NumberFormatException nex) {
                throw new ParseException("cannot parse constraints: " + lowerBound + "/" + upperBound, nex, lineNum);
            }
            tables.addReaction(new DefaultReaction(reactionName, rMetabolites, cons));
            ++lineNum;
            line = reactionReader.readLine();
        }
    }

    private static double parseConstraint(String constraint) throws NumberFormatException {
        return "Inf".equals(constraint) ? Double.POSITIVE_INFINITY : ("-Inf".equals(constraint) ? Double.NEGATIVE_INFINITY : Double.parseDouble(constraint));
    }

    private static void parseBiomassRatio(BufferedReader biomassReader, ParserSymbolTables tables) throws IOException {
        Pattern linePattern = Pattern.compile("([\\w,_\\(\\)\\[\\]\\+'/&:-]+)[\\s]+([\\w,_\\(\\)\\[\\]\\+'/&:-]+)[\\s]+(\\-?[0-9]+\\.?[0-9]*)[\\s]+(\\-?[0-9]+\\.?[0-9]*)[\\s]+(\\-?[0-9]+\\.?[0-9]*).*");
        String line = biomassReader.readLine();
        int lineNum = 0;
        while (line != null) {
            double ratio;
            Matcher matcher = linePattern.matcher(line);
            if (!matcher.matches()) {
                throw new IOException("syntax error at line [" + lineNum + "]: " + line);
            }
            String shortName = matcher.group(1);
            String macroMoleculeName = FluxAnalyserParser.getMacroMoleculeName(shortName);
            String ratePerc = matcher.group(3);
            try {
                ratio = Double.parseDouble(ratePerc);
            }
            catch (Exception ex) {
                throw new ParseException("cannot parse biomass ratio '" + ratePerc + " for " + shortName, ex, lineNum);
            }
            tables.setBiomassRatio(macroMoleculeName, ratio);
            ++lineNum;
            line = biomassReader.readLine();
        }
    }

    private static void parseMacroReaction(BufferedReader macroReactionReader, ParserSymbolTables tables) throws IOException {
        Pattern linePattern = Pattern.compile(P_REACDEF);
        String line = macroReactionReader.readLine();
        int lineNum = 0;
        while (line != null) {
            MetaboliteRatio[] rEducts;
            Matcher matcher = linePattern.matcher(line);
            if (!matcher.matches()) {
                throw new IOException("syntax error at line [" + lineNum + "]: " + line);
            }
            String reactionName = FluxAnalyserParser.getMacroSynthesisName(matcher.group(1).trim());
            String educts = matcher.group(2).trim();
            String product = FluxAnalyserParser.getMacroMoleculeName(matcher.group(1).trim());
            try {
                rEducts = FluxAnalyserParser.getMetaboliteRatios(tables, educts, true);
                MetaboliteRatio[] rBiomass = new MetaboliteRatio[]{tables.getBiomassRatio(product)};
                if (rBiomass[0] == null) {
                    throw new ParseException("no biomass ratio for molecule: " + product, lineNum);
                }
                if (rBiomass[0].getRatio() == 0.0) {
                    LOG.info("removing 0 biomass ratio for " + product);
                    tables.removeBiomassRatio(product);
                }
            }
            catch (ParseException pe) {
                throw pe;
            }
            catch (IOException ioe) {
                throw new ParseException(ioe, lineNum);
            }
            GenericDynamicArray<MetaboliteRatio> rMetabolites = new GenericDynamicArray<MetaboliteRatio>(rEducts.length + 1);
            rMetabolites.set(0, (T[])rEducts);
            rMetabolites.set(rEducts.length, new DefaultMetaboliteRatio(tables.getMetabolite(product), 1.0));
            tables.addReaction(new DefaultReaction(reactionName, rMetabolites, DefaultReactionConstraints.DEFAULT_IRREVERSIBLE));
            ++lineNum;
            line = macroReactionReader.readLine();
        }
    }

    private static MetaboliteRatio[] getMetaboliteRatios(ParserSymbolTables tables, String str, boolean educt) throws IOException {
        String[] stringArray;
        if (str.length() == 0) {
            return new MetaboliteRatio[0];
        }
        if (str.contains("+")) {
            stringArray = str.split("[\\s]*\\+[\\s]*");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = str;
        }
        String[] parts = stringArray;
        if (parts.length == 0) {
            throw new IOException("cannot parse metabolite string " + str);
        }
        MetaboliteRatio[] result = new MetaboliteRatio[parts.length];
        int ii = 0;
        while (ii < result.length) {
            String[] split = parts[ii].split("[\\s]+");
            if (split.length != 2 || split[0].length() == 0 || split[1].length() == 0) {
                throw new IOException("cannot parse metabolite string " + str);
            }
            Metabolite metabolite = tables.getMetabolite(split[1]);
            result[ii] = new DefaultMetaboliteRatio(metabolite, (educt ? -1.0 : 1.0) * Double.parseDouble(split[0]));
            ++ii;
        }
        return result;
    }

    public static ArrayIterable<FluxDistribution> parseEfms(MetabolicNetwork net, File file, int precision, boolean normalizeMax) throws IOException {
        return FluxAnalyserParser.parseEfms(net, new FileReader(file), precision, normalizeMax);
    }

    public static ArrayIterable<FluxDistribution> parseEfms(MetabolicNetwork net, InputStream in, int precision, boolean normalizeMax) throws IOException {
        return FluxAnalyserParser.parseEfms(net, new InputStreamReader(in), precision, normalizeMax);
    }

    public static ArrayIterable<FluxDistribution> parseEfms(MetabolicNetwork net, Reader reader, int precision, boolean normalizeMax) throws IOException {
        return FluxAnalyserParser.parseEfms(net, reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader), precision, normalizeMax);
    }

    public static ArrayIterable<FluxDistribution> parseEfms(MetabolicNetwork net, BufferedReader reader, int precision, boolean normalizeMax) throws IOException {
        Zero zero = new Zero(precision);
        GenericDynamicArray<FluxDistribution> result = new GenericDynamicArray<FluxDistribution>();
        HashMap<String, Integer> reactIndexByReactName = new HashMap<String, Integer>();
        ArrayIterable<? extends Reaction> reacts = net.getReactions();
        int index = 0;
        while (index < reacts.length()) {
            reactIndexByReactName.put(reacts.get(index).getName(), index);
            ++index;
        }
        int lineIndex = 0;
        String line = reader.readLine();
        ++lineIndex;
        String[] reactNames = null;
        while (line != null) {
            String[] parts = line.trim().split("[\\s]+");
            if (reactNames == null) {
                reactNames = parts;
            } else {
                if (reactNames.length != parts.length) {
                    throw new ParseException("not enough flux values, expected " + reactNames.length + " but found " + parts.length, lineIndex);
                }
                double[] values = new double[reacts.length()];
                int ii = 0;
                while (ii < parts.length) {
                    double value;
                    try {
                        value = Double.parseDouble(parts[ii]);
                    }
                    catch (NumberFormatException nex) {
                        throw new ParseException("cannot parse flux value '" + parts[ii] + "', e=" + nex, nex, lineIndex);
                    }
                    Integer index2 = (Integer)reactIndexByReactName.get(reactNames[ii]);
                    if (index2 == null) {
                        throw new ParseException("reaction not found: " + reactNames[ii], lineIndex);
                    }
                    values[index2.intValue()] = value;
                    ++ii;
                }
                FluxNormalizer.normalize(net, values, zero, normalizeMax);
                result.add(new DefaultFluxDistribution(net, values));
            }
            line = reader.readLine();
            ++lineIndex;
        }
        return result;
    }

    private static String getMacroMoleculeName(String macroMolecule) {
        return String.valueOf(macroMolecule) + "-M#";
    }

    private static String getMacroSynthesisName(String macroMolecule) {
        return String.valueOf(macroMolecule) + "-MS#";
    }

    private FluxAnalyserParser() {
    }

    private static class ParseException
    extends IOException {
        private static final long serialVersionUID = -6317078823123534799L;
        private Throwable mCause;

        public ParseException(String message, int lineNumber) {
            super("parse error at line [" + lineNumber + "]: " + message);
        }

        public ParseException(Throwable cause, int lineNumber) {
            this(cause.getMessage(), lineNumber);
            this.mCause = cause;
        }

        public ParseException(String message, Throwable cause, int lineNumber) {
            this(message, lineNumber);
            this.mCause = cause;
        }

        public Throwable getCause() {
            return this.mCause;
        }
    }

    private static class ParserSymbolTables {
        private final Map<String, Metabolite> mMetabolites = new HashMap<String, Metabolite>();
        private final Map<String, Reaction> mReactions = new HashMap<String, Reaction>();
        private final Map<ReactionConstraints, ReactionConstraints> mConstraintsCache = new HashMap<ReactionConstraints, ReactionConstraints>();
        private final Map<String, MetaboliteRatio> mBiomassRatios = new HashMap<String, MetaboliteRatio>();

        private ParserSymbolTables() {
        }

        public Metabolite getMetabolite(String name) {
            Metabolite meta = this.mMetabolites.get(name);
            if (meta == null) {
                meta = new DefaultMetabolite(name);
                this.mMetabolites.put(name, meta);
            }
            return meta;
        }

        public ReactionConstraints getReactionConstraints(double lowerBound, double upperBound) {
            DefaultReactionConstraints cons = new DefaultReactionConstraints(lowerBound, upperBound);
            ReactionConstraints res = this.mConstraintsCache.get(cons);
            if (res == null) {
                this.mConstraintsCache.put(cons, cons);
                res = cons;
            }
            return res;
        }

        public void addReaction(Reaction reaction) {
            this.mReactions.put(reaction.getName(), reaction);
        }

        private void establishBiomassRatios() {
            Reaction reac = this.mReactions.remove(FluxAnalyserParser.BIOMASS_REAC_NAME);
            if (reac == null) {
                return;
            }
            this.mReactions.put(FluxAnalyserParser.BIOMASS_REAC_NAME, new DefaultReaction(FluxAnalyserParser.BIOMASS_REAC_NAME, this.mBiomassRatios.values().toArray(new MetaboliteRatio[this.mBiomassRatios.size()]), reac.getConstraints()));
        }

        public MetabolicNetwork createMetabolicNetwork() {
            this.establishBiomassRatios();
            return new DefaultMetabolicNetwork(new GenericDynamicArray<Metabolite>(this.mMetabolites.values().toArray(new Metabolite[this.mMetabolites.size()])), new GenericDynamicArray<Reaction>(this.mReactions.values().toArray(new Reaction[this.mReactions.size()])));
        }

        public MetaboliteRatio getBiomassRatio(String macroMoleculeName) {
            return this.mBiomassRatios.get(macroMoleculeName);
        }

        public void setBiomassRatio(String macroMoleculeName, double ratio) {
            if (ratio == 0.0) {
                LOG.warning("WARNING: 0 biomass ratio for " + macroMoleculeName);
            }
            Metabolite meta = this.getMetabolite(macroMoleculeName);
            this.mBiomassRatios.put(macroMoleculeName, new DefaultMetaboliteRatio(meta, -ratio));
        }

        public void removeBiomassRatio(String macroMoleculeName) {
            this.mBiomassRatios.remove(macroMoleculeName);
        }
    }
}

