/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.parse;

import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Metabolite;
import ch.javasoft.metabolic.MetaboliteRatio;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.compartment.CompartmentReaction;
import ch.javasoft.metabolic.fa.FaConstants;
import ch.javasoft.metabolic.impl.AbstractMetabolicNetwork;
import ch.javasoft.metabolic.impl.DefaultMetabolicNetwork;
import ch.javasoft.metabolic.impl.DefaultMetaboliteRatio;
import ch.javasoft.metabolic.impl.DefaultReaction;
import ch.javasoft.metabolic.impl.FilteredMetabolicNetwork;
import ch.javasoft.metabolic.parse.FluxAnalyserParser;
import ch.javasoft.metabolic.parse.LogPkg;
import ch.javasoft.metabolic.parse.PalssonParser;
import ch.javasoft.metabolic.parse.junit.AbstractParseTestCase;
import ch.javasoft.metabolic.util.MetabolicNetworkUtil;
import ch.javasoft.metabolic.util.Output;
import ch.javasoft.util.Arrays;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FaColiTest
extends AbstractParseTestCase {
    protected FaConstants.SubNet mSubNet;
    protected FaConstants.SuperNet mSuperNet;

    protected void setUp() throws Exception {
        this.mSubNet = null;
        this.mSuperNet = null;
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.mSubNet = null;
        this.mSuperNet = null;
        super.tearDown();
    }

    public void testSuperAll() throws Exception {
        this.internalTest(FaConstants.SUPERALL_UP_AMINO_EX_SUCC);
    }

    public void testSuperXXX() throws Exception {
        this.internalTest(FaConstants.SUPERXXX_UP_ASP_GLU_SER_THR_TRP_EX_SUCC);
    }

    public void testSuperXXTrp() throws Exception {
        this.internalTest(FaConstants.SUPERXX_UP_ASP_GLU_SER_TRP_EX_SUCC);
    }

    public void testSuperXXThr() throws Exception {
        this.internalTest(FaConstants.SUPERXX_UP_ASP_GLU_SER_THR_EX_SUCC);
    }

    public void testSuperX() throws Exception {
        this.internalTest(FaConstants.SUPERX_UP_ASP_GLU_SER_EX_SUCC);
    }

    public void testSuper() throws Exception {
        this.internalTest(FaConstants.SUPER_UP_ASP_EX_SUCC);
    }

    public void testAll() throws Exception {
        this.internalTest(FaConstants.SUBNET_ALL);
    }

    public void testAllAccumulate() throws Exception {
        this.internalTest(this.allowMetaboliteAccumulation(FaConstants.SUBNET_ALL));
    }

    public void testAllX() throws Exception {
        this.internalTest(FaConstants.SUPER_EX_SUCC);
    }

    public void testAc() throws Exception {
        this.internalTest(FaConstants.SUBNET_AC);
    }

    public void testAcAccumulate() throws Exception {
        this.internalTest(this.allowMetaboliteAccumulation(FaConstants.SUBNET_AC));
    }

    public void testNoEx() throws Exception {
        this.internalTest(FaConstants.SUBNET_NOEX);
    }

    public void testAce() throws Exception {
        this.internalTest(FaConstants.SUBNET_ACE);
    }

    public void testAceAccumulate() throws Exception {
        this.internalTest(this.allowMetaboliteAccumulation(FaConstants.SUBNET_ACE));
    }

    public void testGl() throws Exception {
        this.internalTest(FaConstants.SUBNET_GL);
    }

    public void testGl(String amino) throws Exception {
        FaConstants.SuperNet superNet = new FaConstants.SuperNet("glpts_" + amino, new String[][]{FaConstants.SUCC_EX, this.findAmino(amino)}, FaConstants.GL_PTS_UP_ALL_AMINO_EX_SUCC.excludeReactions);
        this.internalTest(superNet);
    }

    public void testGlX() throws Exception {
        this.internalTest(FaConstants.GL_EX_SUCC);
    }

    public void testGlX_MTHF_forward_only() throws Exception {
        FaConstants.SuperNet net = new FaConstants.SuperNet("glx", new String[][]{FaConstants.SUCC_EX, {"MTHF_Synth", "ATP + NADPH --> MTHF"}}, new String[]{"Succ_up", "Glyc_up", "Ac_up", "MTHF_Synth"});
        this.internalTest(net);
    }

    public void testGlX(String amino) throws Exception {
        FaConstants.SuperNet superNet = new FaConstants.SuperNet("glx_" + amino, new String[][]{FaConstants.SUCC_EX, this.findAmino(amino)}, FaConstants.GL_UP_ALL_AMINO_EX_SUCC.excludeReactions);
        this.internalTest(superNet);
    }

    private String[] findAmino(String amino) {
        int i = 0;
        while (i < FaConstants.AMINO.length) {
            if (FaConstants.AMINO[i][0].startsWith(amino)) {
                return FaConstants.AMINO[i];
            }
            ++i;
        }
        throw new IllegalArgumentException("no such amino acid: " + amino);
    }

    public void testGlXXAmino_AlaAspGluHisPheSerThr() throws Exception {
        this.internalTest(FaConstants.GL_UP_ALA_ASP_GLU_HIS_PHE_SER_THR_EX_SUCC);
    }

    public void testGlXAmino_AlaAspGluHisPheSer() throws Exception {
        this.internalTest(FaConstants.GL_UP_ALA_ASP_GLU_HIS_PHE_SER_EX_SUCC);
    }

    public void testGlAmino_AlaAspGluPheSer() throws Exception {
        this.internalTest(FaConstants.GL_UP_ALA_ASP_GLU_PHE_SER_EX_SUCC);
    }

    public void testGlPtsXXXAmino_AlaAspGluHisPheSerThrVal() throws Exception {
        this.internalTest(FaConstants.GL_PTS_UP_ALA_ASP_GLU_HIS_PHE_SER_THR_VAL_EX_SUCC);
    }

    public void testGlPtsXXAmino_AlaAspGluHisPheSerThr() throws Exception {
        this.internalTest(FaConstants.GL_PTS_UP_ALA_ASP_GLU_HIS_PHE_SER_THR_EX_SUCC);
    }

    public void testGlPtsXAmino_AlaAspGluHisPheSer() throws Exception {
        this.internalTest(FaConstants.GL_PTS_UP_ALA_ASP_GLU_HIS_PHE_SER_EX_SUCC);
    }

    public void testGlPtsAmino_AlaAspGluPheSer() throws Exception {
        this.internalTest(FaConstants.GL_PTS_UP_ALA_ASP_GLU_PHE_SER_EX_SUCC);
    }

    public void testGly() throws Exception {
        this.internalTest(FaConstants.SUBNET_GLY);
    }

    public void testStandard() throws Exception {
        this.internalTest(FaConstants.SUBNET_STANDARD);
    }

    public void testStandardAccumulate() throws Exception {
        this.internalTest(this.allowMetaboliteAccumulation(FaConstants.SUBNET_STANDARD));
    }

    public void testSuc() throws Exception {
        this.internalTest(FaConstants.SUBNET_SUC);
    }

    private FaConstants.SubNet allowMetaboliteAccumulation(FaConstants.SubNet subNet) {
        return new FaConstants.SubNet(String.valueOf(subNet.name) + "-accumulate", subNet.excludeReactions, true);
    }

    private void internalTest(FaConstants.SuperNet superNet) throws Exception {
        CompartmentReaction[] addReacts;
        MetabolicNetwork net = FluxAnalyserParser.parse(FaConstants.COLI_FOLDER);
        CompartmentReaction[] compartmentReactionArray = addReacts = new PalssonParser(false).parseReactions(new StringReader(superNet.toString()));
        int n = addReacts.length;
        int n2 = 0;
        while (n2 < n) {
            CompartmentReaction reac = compartmentReactionArray[n2];
            for (MetaboliteRatio metaboliteRatio : reac.getMetaboliteRatios()) {
                String metaName = metaboliteRatio.getMetabolite().getName();
                if (net.getMetabolite(metaName) != null) continue;
                new Output(System.err).printMetabolites(net, true, true);
                throw new RuntimeException("metabolite " + metaName + " not found in network.");
            }
            ++n2;
        }
        Reaction[] reacts = new Reaction[net.getReactions().length() + addReacts.length];
        net.getReactions().toArray(reacts);
        System.arraycopy(addReacts, 0, reacts, net.getReactions().length(), addReacts.length);
        AbstractMetabolicNetwork supNet = new DefaultMetabolicNetwork(reacts);
        if (superNet.excludeReactions.length > 0) {
            FilteredMetabolicNetwork fNet = new FilteredMetabolicNetwork(supNet);
            fNet.excludeReactions(superNet.excludeReactions);
            supNet = fNet;
        }
        this.mSuperNet = superNet;
        this.internalTest(supNet, null);
    }

    private void internalTest(FaConstants.SubNet subNet) throws Exception {
        MetabolicNetwork net = FluxAnalyserParser.parse(FaConstants.COLI_FOLDER);
        if (subNet.allowMetaboliteAccumulation) {
            HashSet<String> hasEx = new HashSet<String>();
            for (Reaction reaction : net.getReactions()) {
                if (!reaction.isExtract() || reaction.getMetaboliteRatios().length() != 1) continue;
                hasEx.add(reaction.getMetaboliteRatios().get(0).getMetabolite().getName());
            }
            ArrayList<DefaultReaction> arrayList = new ArrayList<DefaultReaction>();
            for (Metabolite metabolite : net.getMetabolites()) {
                arrayList.add(new DefaultReaction(String.valueOf(metabolite.getName()) + "_ex", new MetaboliteRatio[]{new DefaultMetaboliteRatio(metabolite, -1.0)}, false));
            }
            Reaction[] reactionArray = new Reaction[net.getReactions().length() + arrayList.size()];
            net.getReactions().toArray(reactionArray);
            System.arraycopy(arrayList.toArray(), 0, reactionArray, net.getReactions().length(), arrayList.size());
            net = new DefaultMetabolicNetwork(reactionArray);
        }
        Set<String> suppressedReacs = Arrays.asSet(subNet.excludeReactions);
        this.mSubNet = subNet;
        this.internalTest(net, suppressedReacs);
    }

    protected void internalTest(MetabolicNetwork network, Set<String> suppressedReactions) throws Exception {
        LogPkg.LOGGER.finer("original network:     " + MetabolicNetworkUtil.getReactionNamesString(network));
        LogPkg.LOGGER.finer("suppressed reactions: " + suppressedReactions);
        this.internalTestOrDelegate(network, suppressedReactions);
    }
}

