/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.parse;

import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.compartment.CompartmentReaction;
import ch.javasoft.metabolic.impl.DefaultMetabolicNetwork;
import ch.javasoft.metabolic.parse.ExcelParser;
import ch.javasoft.metabolic.parse.LogPkg;
import ch.javasoft.metabolic.parse.PalssonParser;
import ch.javasoft.metabolic.parse.junit.AbstractParseTestCase;
import ch.javasoft.metabolic.util.Output;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.regex.Pattern;

public abstract class ExcelTest
extends AbstractParseTestCase {
    public static final String VERSION_ROBERT_COLI = "v03";
    public static final String VERSION_ROBERT_SUBTILIS = "v05";
    private static final File FOLDER = new File("../metabolic-data/excel");
    private static final File FILE_ROBERT_COLI = new File(FOLDER, "Coli-robert-v03.xls");
    private static final String WORKSHEET_ROBERT_COLI = "Sheet1";
    private static final File FILE_ROBERT_SUBTILIS = new File(FOLDER, "Subtilis-robert-v05.xls");
    private static final String WORKSHEET_ROBERT_SUBTILIS = "stoichiometry";

    public void test_coli_Robert() throws Exception {
        Pattern externalPattern = Pattern.compile(".*xt|BM");
        this.internalTestExcel(FILE_ROBERT_COLI, WORKSHEET_ROBERT_COLI, 3, 4, 2, externalPattern, new String[0]);
    }

    public void test_coli_Robert_glc() throws Exception {
        Pattern externalPattern = Pattern.compile(".*xt|BM");
        this.internalTestExcel(FILE_ROBERT_COLI, WORKSHEET_ROBERT_COLI, 3, 4, 2, externalPattern, new String[]{"Transporter GLCN", "Transporter NO3", "Transporter NO2", "Galactose ABC transporter", "ex_ETHxt", "ex_ACxt"}, new String[][]{{"ETH extract", "ETHxt -->"}, {"AC extract", "ACxt -->"}});
    }

    public void test_coli_Robert_gk() throws Exception {
        Pattern externalPattern = Pattern.compile(".*xt|BM");
        this.internalTestExcel(FILE_ROBERT_COLI, WORKSHEET_ROBERT_COLI, 3, 4, 2, externalPattern, new String[]{"Glucokinase"});
    }

    public void test_coli_Robert_pyrGk() throws Exception {
        Pattern externalPattern = Pattern.compile(".*xt|BM");
        this.internalTestExcel(FILE_ROBERT_COLI, WORKSHEET_ROBERT_COLI, 3, 4, 2, externalPattern, new String[]{"ex_PYRxt", "Glucokinase"});
    }

    public void test_coli_Robert_reduced() throws Exception {
        Pattern externalPattern = Pattern.compile(".*xt|BM");
        this.internalTestExcel(FILE_ROBERT_COLI, WORKSHEET_ROBERT_COLI, 3, 4, 2, externalPattern, new String[]{"ex_SUCCxt", "ex_PYRxt", "Glucokinase"});
    }

    public void test_coli_Robert_exclPyrGlcn() throws Exception {
        Pattern externalPattern = Pattern.compile(".*xt|BM");
        this.internalTestExcel(FILE_ROBERT_COLI, WORKSHEET_ROBERT_COLI, 3, 4, 2, externalPattern, new String[]{"ex_PYRxt", "ex_GLCNxt", "Glucokinase", "Glucose dehydrogenase", "Gluconokinase I", "Gluconokinase II", "Galactose ABC transporter"});
    }

    public void test_coli_Robert_reference() throws Exception {
        Pattern externalPattern = Pattern.compile(".*xt|BM");
        this.internalTestExcel(FILE_ROBERT_COLI, WORKSHEET_ROBERT_COLI, 3, 4, 2, externalPattern, new String[]{"ex_SUCCxt", "ex_PYRxt", "ex_GLCNxt", "ex_FORxt", "ex_LACxt", "Glucokinase", "Glucose dehydrogenase", "Gluconokinase I", "Gluconokinase II", "Galactose ABC transporter"});
    }

    public void test_subtilis_Robert() throws Exception {
        Pattern externalPattern = Pattern.compile(".*xt|BM");
        this.internalTestExcel(FILE_ROBERT_SUBTILIS, WORKSHEET_ROBERT_SUBTILIS, 3, 8, 3, externalPattern, new String[0]);
    }

    public void test_subtilis_Robert_pyrGk() throws Exception {
        Pattern externalPattern = Pattern.compile(".*xt|BM");
        this.internalTestExcel(FILE_ROBERT_SUBTILIS, WORKSHEET_ROBERT_SUBTILIS, 3, 8, 3, externalPattern, new String[]{"ex_PYRxt", "Glucokinase"});
    }

    public void test_subtilis_Robert_reduced() throws Exception {
        Pattern externalPattern = Pattern.compile(".*xt|BM");
        this.internalTestExcel(FILE_ROBERT_SUBTILIS, WORKSHEET_ROBERT_SUBTILIS, 3, 8, 3, externalPattern, new String[]{"ex_SUCCxt", "ex_PYRxt", "Glucokinase"});
    }

    public void test_subtilis_Robert_glc() throws Exception {
        Pattern externalPattern = Pattern.compile(".*xt|BM");
        this.internalTestExcel(FILE_ROBERT_SUBTILIS, WORKSHEET_ROBERT_SUBTILIS, 3, 8, 3, externalPattern, new String[]{"gluconate uptake", "lactate permease (lactate transporter)", "dicarboxylate uptake", "Acetoin uptake R1", "Acetate uptake R2", "ribose uptake"});
    }

    public void test_subtilis_Robert_reference() throws Exception {
        Pattern externalPattern = Pattern.compile(".*xt|BM");
        this.internalTestExcel(FILE_ROBERT_SUBTILIS, WORKSHEET_ROBERT_SUBTILIS, 3, 8, 3, externalPattern, new String[]{"ex_SUCCxt", "ex_PYRxt", "ex_GLCNxt", "ex_LACxt", "Glucokinase"});
    }

    public void test_subtilis_Robert_csbexc() throws Exception {
        Pattern externalPattern = Pattern.compile(".*xt|BM");
        this.internalTestExcel(FILE_ROBERT_SUBTILIS, WORKSHEET_ROBERT_SUBTILIS, 3, 8, 3, externalPattern, new String[]{"ex_SUCCxt", "ex_PYRxt", "ex_GLCNxt", "ex_LACxt", "ex_DACxt", "ex_GLCxt", "ex_ACExt"});
    }

    public void test_subtilis_Robert_GLCup() throws Exception {
        Pattern externalPattern = Pattern.compile(".*xt|BM");
        this.internalTestExcel(FILE_ROBERT_SUBTILIS, WORKSHEET_ROBERT_SUBTILIS, 3, 8, 3, externalPattern, new String[]{"Transporter GLCN", "gluconate uptake", "lactate permease (lactate transporter)", "dicarboxylate uptake", "Acetoin uptake R1", "ribose uptake"});
    }

    public void test_subtilis_Robert_GLCMALup() throws Exception {
        Pattern externalPattern = Pattern.compile(".*xt|BM");
        this.internalTestExcel(FILE_ROBERT_SUBTILIS, WORKSHEET_ROBERT_SUBTILIS, 3, 8, 3, externalPattern, new String[]{"Ribose transport system permease protein rbsC", "Proton glutamate symport protein"});
    }

    private void internalTestExcel(File file, String worksheetName, int reactionColumn, int reactionNameColumn, int headerRows, Pattern externalPattern, String[] excludeReactions) throws Exception {
        this.internalTestExcel(file, worksheetName, reactionColumn, reactionNameColumn, headerRows, externalPattern, excludeReactions, null);
    }

    private void internalTestExcel(File file, String worksheetName, int reactionColumn, int reactionNameColumn, int headerRows, Pattern externalPattern, String[] excludeReactions, String[][] additionalReactions) throws Exception {
        ExcelParser parser = worksheetName == null ? new ExcelParser(file) : new ExcelParser(file, worksheetName);
        MetabolicNetwork metaNet = externalPattern == null ? parser.parse(reactionColumn, reactionNameColumn, headerRows) : parser.parse(reactionColumn, reactionNameColumn, headerRows, externalPattern);
        Output log = new Output(LogPkg.LOGGER, Level.INFO);
        log.printNetworkSize("parsed network: ", metaNet);
        if (additionalReactions != null) {
            metaNet = this.addReactions(metaNet, additionalReactions);
        }
        LinkedHashSet<String> excl = excludeReactions == null ? null : new LinkedHashSet<String>(Arrays.asList(excludeReactions));
        this.internalTestOrDelegate(metaNet, excl);
    }

    private MetabolicNetwork addReactions(MetabolicNetwork original, String[][] additionalReactions) throws IOException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String[][] stringArray = additionalReactions;
        int n = additionalReactions.length;
        int n2 = 0;
        while (n2 < n) {
            String[] reac = stringArray[n2];
            pw.println("\"" + reac[0] + "\"\t\"" + reac[0] + "\"\t\"" + reac[1] + "\"");
            ++n2;
        }
        pw.flush();
        CompartmentReaction[] add = new PalssonParser().parseReactions(new StringReader(sw.toString()));
        Reaction[] all = new Reaction[original.getReactions().length() + add.length];
        original.getReactions().toArray(all);
        System.arraycopy(add, 0, all, original.getReactions().length(), add.length);
        return new DefaultMetabolicNetwork(all);
    }
}

