/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.parse;

import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.impl.DefaultMetabolicNetwork;
import ch.javasoft.metabolic.parse.PalssonParser;
import ch.javasoft.metabolic.parse.junit.AbstractParseTestCase;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;

public abstract class AnneMatthias
extends AbstractParseTestCase {
    private static final File FOLDER_DATA = new File("../metabolic-data/anne_matth/");

    public void testDirectionsDefault() throws Exception {
        this.internalTestPalsson(new File(FOLDER_DATA, "reactions.txt"), new File(FOLDER_DATA, "directionsdefault.txt"));
    }

    public void testDirectionsQuinone() throws Exception {
        this.internalTestPalsson(new File(FOLDER_DATA, "reactions.txt"), new File(FOLDER_DATA, "directionsquinone.txt"));
    }

    private void internalTestPalsson(File reactionsFile, File directionsFile) throws Exception {
        String directLine;
        String reactLine;
        String[] symbols = new String[]{"<--", "<==>", "-->"};
        BufferedReader reactReader = new BufferedReader(new FileReader(reactionsFile));
        BufferedReader direcReader = new BufferedReader(new FileReader(directionsFile));
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(byteOut);
        int lineIndex = 0;
        while ((reactLine = reactReader.readLine()) != null && (directLine = direcReader.readLine()) != null) {
            ++lineIndex;
            int curDirIndex = -1;
            int index = -1;
            int i = 0;
            while (i < symbols.length) {
                index = reactLine.indexOf(symbols[i]);
                if (index >= 0) {
                    curDirIndex = i;
                    break;
                }
                ++i;
            }
            if (index == -1) {
                throw new IOException("no symbol matched at line " + lineIndex + ": " + reactLine);
            }
            int defDirIndex = Integer.parseInt(directLine) + 1;
            String fixedLine = curDirIndex == defDirIndex ? reactLine : String.valueOf(reactLine.substring(0, index)) + symbols[defDirIndex] + reactLine.substring(index + symbols[curDirIndex].length());
            pw.println("\"r" + lineIndex + "\"\t\"r" + lineIndex + "\"\t\"" + fixedLine + "\"");
        }
        pw.flush();
        if (reactReader.readLine() != null) {
            throw new IOException("expected end of react file");
        }
        if (direcReader.readLine() != null) {
            throw new IOException("expected end of direct file");
        }
        Reaction[] reacts = new PalssonParser().parseReactions(new ByteArrayInputStream(byteOut.toByteArray()));
        DefaultMetabolicNetwork metaNet = new DefaultMetabolicNetwork(reacts);
        System.out.println("parsed network: " + AnneMatthias.netSize(metaNet));
        this.internalTestOrDelegate(metaNet, null);
    }

    private static String netSize(MetabolicNetwork net) {
        return String.valueOf(net.getMetabolites().length()) + " metabolites, " + net.getReactions().length() + " reactions";
    }
}

