/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.impl;

import ch.javasoft.metabolic.MetabolicNetworkVisitor;
import ch.javasoft.metabolic.ReactionConstraints;

public class DefaultReactionConstraints
implements ReactionConstraints {
    private final double mLower;
    private final double mUpper;
    public static final ReactionConstraints DEFAULT_REVERSIBLE = new DefaultReactionConstraints(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    public static final ReactionConstraints DEFAULT_IRREVERSIBLE = new DefaultReactionConstraints(0.0, Double.POSITIVE_INFINITY);

    public DefaultReactionConstraints(double lower, double upper) {
        if (lower > upper) {
            throw new IllegalArgumentException("lower bound > upper bound: " + lower + " > " + upper);
        }
        if ((lower == Double.NEGATIVE_INFINITY || lower < 0.0) && upper == 0.0) {
            throw new IllegalArgumentException("reverse irreversible reactions not supported: [" + lower + ", " + upper + "]");
        }
        this.mLower = lower;
        this.mUpper = upper;
    }

    public boolean isReversible() {
        return (this.mLower == Double.NEGATIVE_INFINITY || this.mLower < 0.0) && (this.mUpper == Double.POSITIVE_INFINITY || this.mUpper > 0.0);
    }

    public double getLowerBound() {
        return this.mLower;
    }

    public double getUpperBound() {
        return this.mUpper;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.mLower);
        int code = (int)(bits ^ bits >>> 32);
        bits = Double.doubleToLongBits(this.mUpper);
        return code ^= (int)(bits ^ bits >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ReactionConstraints) {
            ReactionConstraints cons = (ReactionConstraints)obj;
            return this.mLower == cons.getLowerBound() && this.mUpper == cons.getUpperBound();
        }
        return false;
    }

    public String toString() {
        return "[" + this.mLower + " .. " + this.mUpper + "]";
    }

    public void accept(MetabolicNetworkVisitor visitor) {
        visitor.visitReactionConstraints(this);
    }
}

