/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.impl;

import ch.javasoft.metabolic.Annotateable;
import ch.javasoft.metabolic.AnnotateableMetabolicNetwork;
import ch.javasoft.metabolic.MetabolicNetworkVisitor;
import ch.javasoft.metabolic.Metabolite;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.util.genarr.ArrayIterable;
import ch.javasoft.util.genarr.GenericDynamicArray;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMetabolicNetwork
implements AnnotateableMetabolicNetwork {
    protected Map<Annotateable, Map<String, Object>> mAnnotations;

    @Override
    public Metabolite getMetabolite(String name) {
        for (Metabolite metabolite : this.getMetabolites()) {
            if (!metabolite.getName().equals(name)) continue;
            return metabolite;
        }
        throw new IllegalArgumentException("no such metabolite: " + name);
    }

    @Override
    public ArrayIterable<? extends Reaction> getReactions(Metabolite metabolite) {
        ArrayIterable<? extends Reaction> reacts = this.getReactions();
        GenericDynamicArray<Reaction> result = new GenericDynamicArray<Reaction>();
        int ii = 0;
        while (ii < reacts.length()) {
            Reaction reaction = reacts.get(ii);
            if (reaction.isMetaboliteParticipating(metabolite)) {
                result.add(reaction);
            }
            ++ii;
        }
        return result;
    }

    @Override
    public Reaction getReaction(String name) {
        for (Reaction reaction : this.getReactions()) {
            if (!reaction.getName().equals(name)) continue;
            return reaction;
        }
        throw new IllegalArgumentException("no such reaction: " + name);
    }

    @Override
    public int getMetaboliteIndex(String name) {
        int index = 0;
        for (Metabolite metabolite : this.getMetabolites()) {
            if (metabolite.getName().equals(name)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public int getReactionIndex(String name) {
        int index = 0;
        for (Reaction reaction : this.getReactions()) {
            if (reaction.getName().equals(name)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public void accept(MetabolicNetworkVisitor visitor) {
        visitor.visitMetabolicNetwork(this);
    }

    @Override
    public String toString() {
        return this.getReactions().toString();
    }

    @Override
    public String toStringVerbose() {
        StringBuilder sb = new StringBuilder();
        for (Reaction reaction : this.getReactions()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(String.valueOf(reaction.getName()) + ": " + reaction);
        }
        return "[" + sb.toString() + "]";
    }

    @Override
    public String[] getMetaboliteNames() {
        String[] names = new String[this.getMetabolites().length()];
        int i = 0;
        while (i < names.length) {
            names[i] = this.getMetabolites().get(i).getName();
            ++i;
        }
        return names;
    }

    @Override
    public String[] getReactionNames() {
        String[] names = new String[this.getReactions().length()];
        int i = 0;
        while (i < names.length) {
            names[i] = this.getReactions().get(i).getName();
            ++i;
        }
        return names;
    }

    @Override
    public boolean[] getReactionReversibilities() {
        boolean[] revs = new boolean[this.getReactions().length()];
        int i = 0;
        while (i < revs.length) {
            revs[i] = this.getReactions().get(i).getConstraints().isReversible();
            ++i;
        }
        return revs;
    }

    @Override
    public void addAnnotation(Annotateable element, String name, Object value) {
        Map<String, Object> annots = this.getAnnotationMap(element, value != null);
        if (value == null) {
            annots.remove(name);
        } else {
            annots.put(name, value);
        }
    }

    @Override
    public Object getAnnotation(Annotateable element, String name) {
        Map<String, Object> annots = this.getAnnotationMap(element, false);
        return annots == null ? null : annots.get(name);
    }

    @Override
    public Iterable<Map.Entry<String, Object>> getAnnotations(Annotateable element) {
        Map<String, Object> annots = this.getAnnotationMap(element, false);
        if (annots == null) {
            return Collections.emptySet();
        }
        return annots.entrySet();
    }

    protected Map<String, Object> getAnnotationMap(Annotateable element, boolean createIfNeeded) {
        Map<String, Object> annotationMap;
        if (this.mAnnotations == null) {
            if (createIfNeeded) {
                this.mAnnotations = new LinkedHashMap<Annotateable, Map<String, Object>>();
            } else {
                return null;
            }
        }
        if ((annotationMap = this.mAnnotations.get(element)) == null && createIfNeeded) {
            annotationMap = new LinkedHashMap<String, Object>();
            this.mAnnotations.put(element, annotationMap);
        }
        return annotationMap;
    }
}

