/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.generate;

import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Metabolite;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.util.StoichiometricMatrices;
import java.io.PrintWriter;

public class MatlabGenerator {
    public static final String STRUCTURE_NAME_DEFAULT = "mnet";
    private final String mStructureName;
    private final String mModelName;

    public MatlabGenerator() {
        this(null);
    }

    public MatlabGenerator(String modelName) {
        this(STRUCTURE_NAME_DEFAULT, modelName);
    }

    public MatlabGenerator(String structureName, String modelName) {
        this.mStructureName = structureName;
        this.mModelName = modelName;
    }

    public String getStructureName() {
        return this.mStructureName;
    }

    public String getModelName() {
        return this.mModelName;
    }

    protected void writeMatrix(double[][] mx, String mxName, PrintWriter pw, boolean sparse) {
        int cols;
        int rows = mx.length;
        int n = cols = mx.length > 0 ? mx[0].length : 0;
        if (sparse) {
            pw.printf(String.valueOf(this.getStructureName()) + "." + mxName + " = sparse(%d, %d);", rows, cols);
            pw.println();
            int row = 0;
            while (row < rows) {
                boolean first = true;
                int col = 0;
                while (col < mx[row].length) {
                    double val = mx[row][col];
                    if (val != 0.0) {
                        if (first) {
                            first = false;
                        } else {
                            pw.print(" ");
                        }
                        pw.printf(String.valueOf(this.getStructureName()) + "." + mxName + "(%d, %d)=%s;", row + 1, col + 1, String.valueOf(val));
                    }
                    ++col;
                }
                if (!first) {
                    pw.println();
                }
                ++row;
            }
        } else {
            pw.print(String.valueOf(this.getStructureName()) + "." + mxName + "=[");
            int row = 0;
            while (row < rows) {
                int col = 0;
                while (col < cols) {
                    if (col == 0) {
                        pw.println();
                    } else {
                        pw.print(", ");
                    }
                    pw.print(mx[row][col]);
                    ++col;
                }
                ++row;
            }
            pw.println("];");
        }
    }

    public void writeStoich(MetabolicNetwork net, PrintWriter pw, boolean expandReversible, boolean sparse) {
        int cols;
        double[][] stoich = expandReversible ? StoichiometricMatrices.createStoichiometricMatrixExpandReversible(net) : StoichiometricMatrices.createStoichiometricMatrix(net);
        int rows = stoich.length;
        int n = cols = stoich.length > 0 ? stoich[0].length : 0;
        if (sparse) {
            pw.printf(String.valueOf(this.mStructureName) + ".stoich = sparse(%d, %d);", rows, cols);
            pw.println();
            int col = 0;
            while (col < stoich[0].length) {
                boolean first = true;
                int row = 0;
                while (row < stoich.length) {
                    double val = stoich[row][col];
                    if (val != 0.0) {
                        if (first) {
                            first = false;
                        } else {
                            pw.print(" ");
                        }
                        pw.printf(String.valueOf(this.mStructureName) + ".stoich(%d, %d)=%s;", row + 1, col + 1, String.valueOf(val));
                    }
                    ++row;
                }
                if (!first) {
                    if (expandReversible) {
                        pw.println();
                    } else {
                        Reaction reac = net.getReactions().get(col);
                        pw.println(" % " + reac.getName() + ": " + reac);
                    }
                }
                ++col;
            }
        } else {
            this.writeMatrix(stoich, "stoich", pw, sparse);
        }
    }

    public void writeLowerBounds(MetabolicNetwork net, PrintWriter pw) {
        boolean first = true;
        pw.print(String.valueOf(this.mStructureName) + ".reactionLowerBounds=[");
        for (Reaction reaction : net.getReactions()) {
            if (first) {
                first = false;
            } else {
                pw.print(", ");
            }
            if (reaction.getConstraints().isReversible()) {
                pw.print("-Inf");
                continue;
            }
            pw.print("0");
        }
        pw.println("];");
    }

    public void writeUpperBounds(MetabolicNetwork net, PrintWriter pw) {
        boolean first = true;
        pw.print(String.valueOf(this.mStructureName) + ".reactionUpperBounds=[");
        for (Reaction reaction : net.getReactions()) {
            if (first) {
                first = false;
            } else {
                pw.print(", ");
            }
            pw.print("Inf");
        }
        pw.println("];");
    }

    public void writeMetaNames(MetabolicNetwork net, PrintWriter pw) {
        boolean anyDesc = false;
        boolean first = true;
        pw.print(String.valueOf(this.mStructureName) + ".metaboliteNames={");
        for (Metabolite metabolite : net.getMetabolites()) {
            if (first) {
                first = false;
            } else {
                pw.print(", ");
            }
            pw.print('\'');
            pw.print(this.escape(metabolite.getName()));
            pw.print('\'');
            anyDesc |= metabolite.getDescription() != null;
        }
        pw.println("};");
        if (anyDesc) {
            first = true;
            pw.print(String.valueOf(this.mStructureName) + ".metaboliteDescriptions={");
            for (Metabolite metabolite : net.getMetabolites()) {
                String desc = metabolite.getDescription();
                if (first) {
                    first = false;
                } else {
                    pw.print(", ");
                }
                pw.print('\'');
                pw.print(desc == null ? "" : this.escape(desc));
                pw.print('\'');
            }
            pw.println("};");
        }
    }

    public void writeReactionNames(MetabolicNetwork net, PrintWriter pw) {
        boolean first = true;
        pw.print(String.valueOf(this.mStructureName) + ".reactionNames={");
        for (Reaction reaction : net.getReactions()) {
            if (first) {
                first = false;
            } else {
                pw.print(", ");
            }
            pw.print('\'');
            pw.print(this.escape(reaction.getName()));
            pw.print('\'');
        }
        pw.println("};");
    }

    public void writeReactionFormulas(MetabolicNetwork net, PrintWriter pw) {
        boolean first = true;
        pw.print(String.valueOf(this.mStructureName) + ".reactionFormulas={");
        for (Reaction reaction : net.getReactions()) {
            if (first) {
                first = false;
            } else {
                pw.print(", ");
            }
            pw.print('\'');
            pw.print(this.escape(reaction.toString()));
            pw.print('\'');
        }
        pw.println("};");
    }

    public void writeAll(MetabolicNetwork net, PrintWriter pw) {
        this.writeAll(net, pw, false, true);
    }

    public void writeModelName(MetabolicNetwork net, PrintWriter pw) {
        if (this.mModelName != null) {
            pw.println(String.valueOf(this.mStructureName) + ".modelName='" + this.mModelName + "';");
        }
    }

    public void writeAll(MetabolicNetwork net, PrintWriter pw, boolean expandReversible, boolean sparse) {
        this.writeModelName(net, pw);
        this.writeMetaNames(net, pw);
        this.writeReactionNames(net, pw);
        this.writeReactionFormulas(net, pw);
        this.writeLowerBounds(net, pw);
        this.writeUpperBounds(net, pw);
        this.writeStoich(net, pw, expandReversible, sparse);
        pw.flush();
    }

    private String escape(String str) {
        return str.replace("'", "''");
    }
}

